/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.jaxws.framework.jaxrpc;

import com.sun.istack.NotNull;
import com.sun.xml.ws.addressing.model.InvalidAddressingHeaderException;
import com.sun.xml.ws.api.Component;
import com.sun.xml.ws.api.SOAPVersion;
import com.sun.xml.ws.api.WSBinding;
import com.sun.xml.ws.api.addressing.AddressingVersion;
import com.sun.xml.ws.api.addressing.WSEndpointReference;
import com.sun.xml.ws.api.client.ServiceCreationInterceptor;
import com.sun.xml.ws.api.message.Header;
import com.sun.xml.ws.api.message.HeaderList;
import com.sun.xml.ws.api.message.Message;
import com.sun.xml.ws.api.message.Messages;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.pipe.ClientTubeAssemblerContext;
import com.sun.xml.ws.api.pipe.Fiber;
import com.sun.xml.ws.api.pipe.NextAction;
import com.sun.xml.ws.api.pipe.ServerTubeAssemblerContext;
import com.sun.xml.ws.api.pipe.Tube;
import com.sun.xml.ws.api.pipe.TubeCloner;
import com.sun.xml.ws.api.pipe.helper.AbstractFilterTubeImpl;
import com.sun.xml.ws.api.pipe.helper.AbstractTubeImpl;
import com.sun.xml.ws.api.server.WSEndpoint;
import com.sun.xml.ws.binding.BindingImpl;
import com.sun.xml.ws.developer.WSBindingProvider;
import com.sun.xml.ws.message.RelatesToHeader;
import com.sun.xml.ws.message.StringHeader;
import java.util.Arrays;
import java.util.Collections;
import javax.xml.namespace.QName;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.handler.Handler;
import javax.xml.rpc.handler.HandlerInfo;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.rpc.soap.SOAPFaultException;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;
import javax.xml.ws.Binding;
import javax.xml.ws.ProtocolException;
import javax.xml.ws.WebServiceException;
import weblogic.jws.jaxws.client.ClientIdentityFeature;
import weblogic.management.runtime.WseePortRuntimeMBean;
import weblogic.management.runtime.WseeV2RuntimeMBean;
import weblogic.wsee.handler.HandlerException;
import weblogic.wsee.jaxrpc.soapfault.SOAPFaultUtil;
import weblogic.wsee.jaxws.EndpointCreationInterceptor;
import weblogic.wsee.jaxws.WLSContainer;
import weblogic.wsee.jaxws.framework.jaxrpc.EnvironmentFactory;
import weblogic.wsee.jaxws.framework.jaxrpc.JAXRPCEnvironmentFeature;
import weblogic.wsee.jaxws.framework.jaxrpc.SOAPMessageContext;
import weblogic.wsee.jaxws.framework.jaxrpc.SOAPMessageRefactor;
import weblogic.wsee.jaxws.spi.ClientIdentityRegistry;
import weblogic.wsee.jaxws.tubeline.FlowControl;
import weblogic.wsee.jaxws.tubeline.FlowControlAware;
import weblogic.wsee.jaxws.tubeline.FlowControlRequired;
import weblogic.wsee.message.WlMessageContext;
import weblogic.wsee.monitoring.WseeClientRuntimeData;
import weblogic.wsee.monitoring.WseeClientRuntimeMBeanImpl;
import weblogic.wsee.monitoring.WsspStats;

public class TubeFactory
implements weblogic.wsee.jaxws.tubeline.TubeFactory {
    public static final String PRE_THROW_CONTEXT_PROPERTY = "weblogic.wsee.jaxws.framework.jaxrpc.PreThrowContext";
    private HandlerInfo info;

    public TubeFactory(HandlerInfo handlerInfo) {
        this.info = handlerInfo;
    }

    public Tube createClient(Tube tube, ClientTubeAssemblerContext clientTubeAssemblerContext) {
        EnvironmentFactory environmentFactory = this.getEnvironmentFactory(clientTubeAssemblerContext);
        try {
            return new JAXRPCTube(environmentFactory, this.newHandler(), tube);
        }
        catch (HandlerException handlerException) {
            throw new WebServiceException((Throwable)handlerException);
        }
    }

    public Tube createServer(Tube tube, ServerTubeAssemblerContext serverTubeAssemblerContext) {
        if (serverTubeAssemblerContext.getEndpoint().getContainer() instanceof WLSContainer) {
            EnvironmentFactory environmentFactory = this.getEnvironmentFactory(serverTubeAssemblerContext.getEndpoint());
            try {
                return new ServerJAXRPCTube(environmentFactory, this.newHandler(), tube);
            }
            catch (HandlerException handlerException) {
                throw new WebServiceException((Throwable)handlerException);
            }
        }
        return tube;
    }

    HandlerInfo getHandlerInfo() {
        return this.info;
    }

    protected EnvironmentFactory getEnvironmentFactory(ClientTubeAssemblerContext clientTubeAssemblerContext) {
        return JAXRPCEnvironmentFeature.getFactory(clientTubeAssemblerContext);
    }

    protected EnvironmentFactory getEnvironmentFactory(WSEndpoint wSEndpoint) {
        return JAXRPCEnvironmentFeature.getFactory(wSEndpoint);
    }

    private Handler newHandler() throws HandlerException {
        Class clazz = this.info.getHandlerClass();
        try {
            Handler handler = (Handler)clazz.newInstance();
            handler.init(this.info);
            return handler;
        }
        catch (InstantiationException instantiationException) {
            throw new HandlerException("Exception in handler:" + clazz.getName(), instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new AssertionError((Object)illegalAccessException);
        }
    }

    private class ServerJAXRPCTube
    extends JAXRPCTube {
        public ServerJAXRPCTube(EnvironmentFactory environmentFactory, Handler handler, Tube tube) {
            super(environmentFactory, handler, tube);
        }

        protected ServerJAXRPCTube(ServerJAXRPCTube serverJAXRPCTube, TubeCloner tubeCloner) {
            super(serverJAXRPCTube, tubeCloner);
        }

        public AbstractTubeImpl copy(TubeCloner tubeCloner) {
            return new ServerJAXRPCTube(this, tubeCloner);
        }

        protected Packet createThrowablePacket(Packet packet, Throwable throwable) {
            return packet.createServerResponse(this.createThrowableMessage(throwable), packet.endpoint.getPort(), null, packet.endpoint.getBinding());
        }

        private void _populateAddressingHeaders(Packet packet) {
            String string;
            AddressingVersion addressingVersion = packet.getBinding().getAddressingVersion();
            SOAPVersion sOAPVersion = packet.getBinding().getSOAPVersion();
            HeaderList headerList = packet.getMessage().getHeaders();
            WSEndpointReference wSEndpointReference = packet.supports((Object)"com.sun.xml.ws.addressing.WsaPropertyBag.ReplyToFromRequest") ? (WSEndpointReference)packet.get((Object)"com.sun.xml.ws.addressing.WsaPropertyBag.ReplyToFromRequest") : null;
            WSEndpointReference wSEndpointReference2 = packet.supports((Object)"com.sun.xml.ws.addressing.WsaPropertyBag.FaultToFromRequest") ? (WSEndpointReference)packet.get((Object)"com.sun.xml.ws.addressing.WsaPropertyBag.FaultToFromRequest") : null;
            String string2 = packet.supports((Object)"com.sun.xml.ws.addressing.WsaPropertyBag.MessageIdFromRequest") ? (String)packet.get((Object)"com.sun.xml.ws.addressing.WsaPropertyBag.MessageIdFromRequest") : null;
            boolean bl = false;
            try {
                string = headerList.getTo(addressingVersion, sOAPVersion);
                if (string == null || addressingVersion.anonymousUri.equals(string)) {
                    WSEndpointReference wSEndpointReference3;
                    WSEndpointReference wSEndpointReference4 = wSEndpointReference3 = packet.getMessage().isFault() ? wSEndpointReference2 : wSEndpointReference;
                    if (wSEndpointReference3 != null && !wSEndpointReference3.isAnonymous()) {
                        bl = true;
                        headerList.add((Header)new StringHeader(addressingVersion.toTag, wSEndpointReference3.getAddress()));
                    }
                }
            }
            catch (InvalidAddressingHeaderException invalidAddressingHeaderException) {
                // empty catch block
            }
            if (headerList.getAction(addressingVersion, sOAPVersion) == null) {
                string = null;
                if (packet.getMessage().isFault()) {
                    string = addressingVersion.getDefaultFaultAction();
                } else {
                    string = packet.soapAction;
                    if (string == null || "".equals(string) || "\"\"".equals(string)) {
                        string = "http://jax-ws.dev.java.net/addressing/output-action-not-set";
                    } else if (string.startsWith("\"") && string.endsWith("\"")) {
                        string = string.substring(1, string.length() - 1);
                    }
                }
                headerList.add((Header)new StringHeader(addressingVersion.actionTag, string));
            }
            if (headerList.getMessageID(addressingVersion, sOAPVersion) == null) {
                headerList.add((Header)new StringHeader(addressingVersion.messageIDTag, packet.getMessage().getID(addressingVersion, sOAPVersion)));
            }
            if (headerList.getRelatesTo(addressingVersion, sOAPVersion) == null && string2 != null) {
                headerList.add((Header)new RelatesToHeader(addressingVersion.relatesToTag, string2));
            }
            if (bl) {
                if (packet.getMessage().isFault()) {
                    string = wSEndpointReference2;
                    if (string == null) {
                        string = wSEndpointReference;
                    }
                } else {
                    string = wSEndpointReference;
                }
                if (string != null) {
                    string.addReferenceParameters(headerList);
                }
            }
        }

        private void populateAddressingHeaders(Packet packet) {
            SOAPMessageRefactor sOAPMessageRefactor = new SOAPMessageRefactor();
            sOAPMessageRefactor.init(packet.getMessage());
            this._populateAddressingHeaders(packet);
            packet.setMessage(sOAPMessageRefactor.refator(packet.getMessage()));
        }

        private boolean isAddressingRequired(Packet packet) {
            String string;
            WSBinding wSBinding = this.fac.getBinding();
            AddressingVersion addressingVersion = wSBinding.getAddressingVersion();
            if (addressingVersion == null) {
                return false;
            }
            String string2 = string = packet.supports((Object)"com.sun.xml.ws.addressing.WsaPropertyBag.MessageIdFromRequest") ? (String)packet.get((Object)"com.sun.xml.ws.addressing.WsaPropertyBag.MessageIdFromRequest") : null;
            if (string == null) {
                return false;
            }
            return packet.getMessage() != null;
        }

        protected void processReturn(Packet packet) {
            if (this.isAddressingRequired(packet)) {
                this.populateAddressingHeaders(packet);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class JAXRPCTube
    extends AbstractFilterTubeImpl
    implements ServiceCreationInterceptor,
    EndpointCreationInterceptor,
    FlowControlAware {
        protected EnvironmentFactory fac;
        private Handler handler;

        public JAXRPCTube(EnvironmentFactory environmentFactory, Handler handler, Tube tube) {
            super(tube);
            this.fac = environmentFactory;
            this.handler = handler;
            QName[] qNameArray = handler.getHeaders();
            if (qNameArray != null) {
                Collections.addAll(((BindingImpl)environmentFactory.getBinding()).getKnownHeaders(), qNameArray);
            }
        }

        protected JAXRPCTube(JAXRPCTube jAXRPCTube, TubeCloner tubeCloner) {
            super((AbstractFilterTubeImpl)jAXRPCTube, tubeCloner);
            this.fac = jAXRPCTube.fac;
            this.handler = jAXRPCTube.handler;
        }

        @Override
        public boolean isFlowControlRequired() {
            return this.handler instanceof FlowControlRequired;
        }

        public void preDestroy() {
            try {
                this.handler.destroy();
            }
            catch (JAXRPCException jAXRPCException) {
                throw new WebServiceException((Throwable)jAXRPCException);
            }
            super.preDestroy();
        }

        protected Message createThrowableMessage(Throwable throwable) {
            return Messages.create((Throwable)throwable, (SOAPVersion)this.fac.getBinding().getSOAPVersion());
        }

        protected Packet createThrowablePacket(Packet packet, Throwable throwable) {
            return packet.createClientResponse(this.createThrowableMessage(throwable));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public NextAction processException(Throwable throwable) {
            if (!(throwable instanceof ProtocolException)) {
                return this.doThrow(throwable);
            }
            try {
                Packet packet = Fiber.current().getPacket();
                SOAPMessageContext sOAPMessageContext = this.fac.getContext(packet);
                Packet packet2 = this.createThrowablePacket(packet, throwable);
                SOAPMessageContext sOAPMessageContext2 = this.fac.getContext(packet2);
                sOAPMessageContext2.setFault(throwable, false);
                sOAPMessageContext2.setProperty(TubeFactory.PRE_THROW_CONTEXT_PROPERTY, sOAPMessageContext);
                try {
                    FlowControl flowControl;
                    if (!this.handler.handleFault((MessageContext)sOAPMessageContext2) && (flowControl = (FlowControl)Fiber.current().getSPI(FlowControl.class)) != null) {
                        flowControl.doSkip();
                    }
                    Object var8_11 = null;
                    sOAPMessageContext2.updatePacket();
                }
                catch (Throwable throwable2) {
                    Object var8_12 = null;
                    sOAPMessageContext2.updatePacket();
                    sOAPMessageContext2.removeProperty(TubeFactory.PRE_THROW_CONTEXT_PROPERTY);
                    throw throwable2;
                }
                sOAPMessageContext2.removeProperty(TubeFactory.PRE_THROW_CONTEXT_PROPERTY);
                return this.doReturnWith(packet2);
            }
            catch (SOAPFaultException sOAPFaultException) {
                FlowControl flowControl = (FlowControl)Fiber.current().getSPI(FlowControl.class);
                if (flowControl != null) {
                    flowControl.doSkip();
                }
                throw new javax.xml.ws.soap.SOAPFaultException(this.createSOAPFault(sOAPFaultException));
            }
            catch (JAXRPCException jAXRPCException) {
                FlowControl flowControl = (FlowControl)Fiber.current().getSPI(FlowControl.class);
                if (flowControl != null) {
                    flowControl.doSkip();
                }
                throw new WebServiceException((Throwable)jAXRPCException);
            }
        }

        private SOAPFault createSOAPFault(SOAPFaultException sOAPFaultException) {
            try {
                SOAPFault sOAPFault = this.fac.getBinding().getSOAPVersion().getSOAPFactory().createFault();
                SOAPFaultUtil.fillFault(sOAPFault, sOAPFaultException);
                return sOAPFault;
            }
            catch (SOAPException sOAPException) {
                throw new WebServiceException((Throwable)sOAPException);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public NextAction processRequest(Packet packet) {
            SOAPMessageContext sOAPMessageContext = this.fac.getContext(packet);
            this.setupWsspStats(packet.component, packet.getBinding(), sOAPMessageContext);
            try {
                try {
                    try {
                        if (this.handler.handleRequest((MessageContext)sOAPMessageContext)) {
                            NextAction nextAction = this.doInvoke(this.next, packet);
                            Object var5_7 = null;
                            sOAPMessageContext.updatePacket();
                            return nextAction;
                        }
                        Object var5_8 = null;
                        sOAPMessageContext.updatePacket();
                    }
                    catch (Throwable throwable) {
                        Object var5_9 = null;
                        sOAPMessageContext.updatePacket();
                        throw throwable;
                    }
                    this.processReturn(packet);
                    return this.processResponse(packet);
                }
                catch (SOAPFaultException sOAPFaultException) {
                    throw new javax.xml.ws.soap.SOAPFaultException(this.createSOAPFault(sOAPFaultException));
                }
                catch (JAXRPCException jAXRPCException) {
                    throw new WebServiceException((Throwable)jAXRPCException);
                }
            }
            catch (WebServiceException webServiceException) {
                return this.processException(webServiceException);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public NextAction processResponse(Packet packet) {
            if (packet.getMessage() == null) {
                return this.doReturnWith(packet);
            }
            try {
                FlowControl flowControl;
                boolean bl;
                SOAPMessageContext sOAPMessageContext = this.fac.getContext(packet);
                try {
                    bl = sOAPMessageContext.hasFault() ? this.handler.handleFault((MessageContext)sOAPMessageContext) : this.handler.handleResponse((MessageContext)sOAPMessageContext);
                    Object var5_8 = null;
                    sOAPMessageContext.updatePacket();
                }
                catch (Throwable throwable) {
                    Object var5_9 = null;
                    sOAPMessageContext.updatePacket();
                    throw throwable;
                }
                if (!bl && (flowControl = (FlowControl)Fiber.current().getSPI(FlowControl.class)) != null) {
                    flowControl.doSkip();
                }
                return this.doReturnWith(packet);
            }
            catch (SOAPFaultException sOAPFaultException) {
                FlowControl flowControl = (FlowControl)Fiber.current().getSPI(FlowControl.class);
                if (flowControl != null) {
                    flowControl.doSkip();
                }
                throw new javax.xml.ws.soap.SOAPFaultException(this.createSOAPFault(sOAPFaultException));
            }
            catch (JAXRPCException jAXRPCException) {
                FlowControl flowControl = (FlowControl)Fiber.current().getSPI(FlowControl.class);
                if (flowControl != null) {
                    flowControl.doSkip();
                }
                throw new WebServiceException((Throwable)jAXRPCException);
            }
        }

        protected void processReturn(Packet packet) {
        }

        public AbstractTubeImpl copy(TubeCloner tubeCloner) {
            return new JAXRPCTube(this, tubeCloner);
        }

        private void setupWsspStats(Component component, WSBinding wSBinding, SOAPMessageContext sOAPMessageContext) {
            WseeV2RuntimeMBean wseeV2RuntimeMBean = component != null ? (WseeV2RuntimeMBean)component.getSPI(WseeV2RuntimeMBean.class) : null;
            WlMessageContext wlMessageContext = WlMessageContext.narrow(sOAPMessageContext);
            if (wseeV2RuntimeMBean != null && wlMessageContext != null) {
                if (wlMessageContext.getDispatcher().getWsPort().getWsspStats() == null) {
                    for (WseePortRuntimeMBean wseePortRuntimeMBean : wseeV2RuntimeMBean.getPorts()) {
                        if (!wseePortRuntimeMBean.getName().equals(wlMessageContext.getDispatcher().getWsdlPort().getName().getLocalPart())) continue;
                        wlMessageContext.getDispatcher().getWsPort().setWsspStats((WsspStats)((Object)wseePortRuntimeMBean.getPortPolicy()));
                        break;
                    }
                }
            } else {
                WseeClientRuntimeMBeanImpl wseeClientRuntimeMBeanImpl;
                ClientIdentityFeature clientIdentityFeature = null;
                if (wSBinding != null) {
                    clientIdentityFeature = (ClientIdentityFeature)wSBinding.getFeature(ClientIdentityFeature.class);
                }
                if (clientIdentityFeature != null && (wseeClientRuntimeMBeanImpl = ClientIdentityRegistry.getClientRuntimeMBean(clientIdentityFeature.getClientId())) != null && wseeClientRuntimeMBeanImpl.getData() != null && ((WseeClientRuntimeData)wseeClientRuntimeMBeanImpl.getData()).getPort() != null) {
                    wlMessageContext.getDispatcher().getWsPort().setWsspStats((WsspStats)((Object)wseeClientRuntimeMBeanImpl.getPort().getPortPolicy()));
                }
            }
        }

        public void postCreateProxy(@NotNull WSBindingProvider wSBindingProvider, @NotNull Class<?> clazz) {
            this.addKnownHeadersToBinding(wSBindingProvider.getBinding());
        }

        public void postCreateDispatch(@NotNull WSBindingProvider wSBindingProvider) {
            this.addKnownHeadersToBinding(wSBindingProvider.getBinding());
        }

        @Override
        public void postCreateEndpoint(WSEndpoint wSEndpoint) {
            wSEndpoint.getBinding();
        }

        private void addKnownHeadersToBinding(Binding binding) {
            QName[] qNameArray = this.handler.getHeaders();
            if (qNameArray != null && binding instanceof BindingImpl) {
                ((BindingImpl)binding).getKnownHeaders().addAll(Arrays.asList(qNameArray));
            }
        }

        public String toString() {
            return super.toString() + "[" + this.handler.toString() + "]";
        }
    }
}

