/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.jaxws.framework.jaxrpc;

import com.sun.xml.ws.api.BindingID;
import com.sun.xml.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.ws.api.pipe.ClientTubeAssemblerContext;
import com.sun.xml.ws.api.pipe.ServerTubeAssemblerContext;
import java.util.Set;
import javax.xml.ws.WebServiceException;
import weblogic.wsee.jaxws.framework.jaxrpc.EnvironmentFactory;
import weblogic.wsee.jaxws.framework.jaxrpc.HandlerList;
import weblogic.wsee.jaxws.framework.jaxrpc.JAXRPCEnvironmentFeature;
import weblogic.wsee.jaxws.framework.jaxrpc.ListenerUsage;
import weblogic.wsee.jaxws.tubeline.TubelineAssemblerItem;
import weblogic.wsee.ws.init.WsDeploymentContext;
import weblogic.wsee.ws.init.WsDeploymentException;
import weblogic.wsee.ws.init.WsDeploymentListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TubelineDeploymentListener
implements weblogic.wsee.jaxws.tubeline.TubelineDeploymentListener {
    private WsDeploymentListener listener;
    private Class<? extends WsDeploymentListener> listenerClass;
    private ListenerUsage usage;

    public TubelineDeploymentListener(Class<? extends WsDeploymentListener> clazz) {
        this(clazz, ListenerUsage.BOTH);
    }

    public TubelineDeploymentListener(Class<? extends WsDeploymentListener> clazz, ListenerUsage listenerUsage) {
        this.listenerClass = clazz;
        this.usage = listenerUsage;
    }

    @Override
    public void createClient(ClientTubeAssemblerContext clientTubeAssemblerContext, Set<TubelineAssemblerItem> set) {
        BindingID bindingID = clientTubeAssemblerContext.getBinding().getBindingId();
        if (!(bindingID.equals((Object)BindingID.SOAP11_HTTP) || bindingID.equals((Object)BindingID.SOAP12_HTTP) || bindingID.equals((Object)BindingID.SOAP11_HTTP_MTOM) || bindingID.equals((Object)BindingID.SOAP12_HTTP_MTOM) || bindingID.equals((Object)BindingID.X_SOAP12_HTTP))) {
            return;
        }
        if (ListenerUsage.SERVER_ONLY.equals((Object)this.usage)) {
            return;
        }
        WSDLPort wSDLPort = clientTubeAssemblerContext.getWsdlModel();
        if (wSDLPort == null) {
            return;
        }
        EnvironmentFactory environmentFactory = this.getEnvironmentFactory(clientTubeAssemblerContext);
        WsDeploymentContext wsDeploymentContext = environmentFactory.getDeploymentContext();
        try {
            HandlerList handlerList = environmentFactory.buildClientHandlerList(set);
            String string = wSDLPort.getName().getLocalPart();
            wsDeploymentContext.getWsService().getPort(string).setInternalHandlerList(handlerList);
            this.getListener().process(wsDeploymentContext);
        }
        catch (WsDeploymentException wsDeploymentException) {
            throw new WebServiceException((Throwable)wsDeploymentException);
        }
    }

    @Override
    public void createServer(ServerTubeAssemblerContext serverTubeAssemblerContext, Set<TubelineAssemblerItem> set) {
        BindingID bindingID = serverTubeAssemblerContext.getEndpoint().getBinding().getBindingId();
        if (!((bindingID.equals((Object)BindingID.SOAP11_HTTP) || bindingID.equals((Object)BindingID.SOAP12_HTTP) || bindingID.equals((Object)BindingID.SOAP11_HTTP_MTOM) || bindingID.equals((Object)BindingID.SOAP12_HTTP_MTOM) || bindingID.equals((Object)BindingID.X_SOAP12_HTTP)) && serverTubeAssemblerContext.getWsdlModel() != null)) {
            return;
        }
        if (ListenerUsage.CLIENT_ONLY.equals((Object)this.usage)) {
            return;
        }
        EnvironmentFactory environmentFactory = this.getEnvironmentFactory(serverTubeAssemblerContext);
        WsDeploymentContext wsDeploymentContext = environmentFactory.getDeploymentContext();
        try {
            HandlerList handlerList = environmentFactory.buildServerHandlerList(set);
            String string = serverTubeAssemblerContext.getWsdlModel().getName().getLocalPart();
            wsDeploymentContext.getWsService().getPort(string).setInternalHandlerList(handlerList);
            this.getListener().process(wsDeploymentContext);
        }
        catch (WsDeploymentException wsDeploymentException) {
            throw new WebServiceException((Throwable)wsDeploymentException);
        }
    }

    protected EnvironmentFactory getEnvironmentFactory(ClientTubeAssemblerContext clientTubeAssemblerContext) {
        EnvironmentFactory environmentFactory = JAXRPCEnvironmentFeature.getFactory(clientTubeAssemblerContext);
        return environmentFactory;
    }

    protected EnvironmentFactory getEnvironmentFactory(ServerTubeAssemblerContext serverTubeAssemblerContext) {
        EnvironmentFactory environmentFactory = JAXRPCEnvironmentFeature.getFactory(serverTubeAssemblerContext.getEndpoint());
        return environmentFactory;
    }

    private WsDeploymentListener getListener() {
        if (this.listener == null) {
            try {
                this.listener = this.listenerClass.newInstance();
            }
            catch (Exception exception) {
                throw new WebServiceException((Throwable)exception);
            }
        }
        return this.listener;
    }
}

