/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.jaxws.framework.jaxrpc.client;

import com.sun.xml.ws.api.WSBinding;
import com.sun.xml.ws.api.WSService;
import com.sun.xml.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.ws.api.pipe.ClientTubeAssemblerContext;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.ws.WebServiceException;
import weblogic.jws.jaxws.ClientPolicyFeature;
import weblogic.jws.jaxws.policy.PolicySource;
import weblogic.wsee.jaxws.framework.jaxrpc.EnvironmentFactory;
import weblogic.wsee.policy.deployment.WsdlPolicySubject;
import weblogic.wsee.policy.framework.NormalizedExpression;
import weblogic.wsee.policy.framework.PolicyException;
import weblogic.wsee.policy.framework.PolicyMath;
import weblogic.wsee.policy.framework.PolicyStatement;
import weblogic.wsee.policy.runtime.PolicyFinder;
import weblogic.wsee.security.policy.SecurityPolicyCustomizer;
import weblogic.wsee.security.policy.WssPolicyContext;
import weblogic.wsee.util.Pair;
import weblogic.wsee.ws.WsMethod;
import weblogic.wsee.ws.WsPort;
import weblogic.wsee.wsdl.WsdlDefinitions;

public class ClientEnvironmentFactory
extends EnvironmentFactory {
    private WSService service;
    private Map<Pair<PolicySource, String>, NormalizedExpression> policyCache = new HashMap<Pair<PolicySource, String>, NormalizedExpression>();

    public ClientEnvironmentFactory(ClientTubeAssemblerContext clientTubeAssemblerContext) {
        this(clientTubeAssemblerContext.getBinding(), clientTubeAssemblerContext.getService(), clientTubeAssemblerContext.getWsdlModel());
    }

    public ClientEnvironmentFactory(WSBinding wSBinding, WSService wSService, WSDLPort wSDLPort) {
        super(wSBinding, wSDLPort, null);
        this.service = wSService;
    }

    public WSService getWSService() {
        return this.service;
    }

    protected void initPolicyContext(EnvironmentFactory.SingletonService singletonService) {
        WsdlDefinitions wsdlDefinitions = this.getWsdlDef();
        if (wsdlDefinitions != null) {
            WsdlPolicySubject wsdlPolicySubject = new WsdlPolicySubject(wsdlDefinitions);
            WssPolicyContext wssPolicyContext = new WssPolicyContext(false);
            wssPolicyContext.getPolicyServer().addPolicyFinder(new PolicyFinder(){

                private URL resolveURL(URL uRL, String string) {
                    try {
                        String string2;
                        int n;
                        URL uRL2 = "jar".equals(uRL.getProtocol()) || "zip".equals(uRL.getProtocol()) ? ((n = (string2 = uRL.toString()).indexOf(33)) > 0 ? new URL(string2.substring(0, n + 1) + new URI(string2.substring(n + 1)).resolve(new URI(string)).toString()) : new URL(string)) : uRL.toURI().resolve(new URI(string)).toURL();
                        return uRL2;
                    }
                    catch (URISyntaxException uRISyntaxException) {
                        throw new WebServiceException((Throwable)uRISyntaxException);
                    }
                    catch (MalformedURLException malformedURLException) {
                        throw new WebServiceException((Throwable)malformedURLException);
                    }
                }

                public PolicyStatement findPolicy(String string, String string2) throws PolicyException {
                    string = 1.checkFileExtension(string);
                    URL uRL = ClientEnvironmentFactory.this.service.getWSDLDocumentLocation();
                    if (uRL != null) {
                        URL uRL2 = this.resolveURL(uRL, string);
                        if (uRL2 != null) {
                            try {
                                return 1.readPolicyFromStream(string, uRL2.openStream(), true);
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                        if ((uRL2 = this.resolveURL(uRL, "policies/" + string)) != null) {
                            try {
                                return 1.readPolicyFromStream(string, uRL2.openStream(), true);
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                    }
                    return null;
                }
            });
            wssPolicyContext.getPolicyServer().addPolicies(wsdlPolicySubject.getPolicies());
            singletonService.setWssPolicyContext(wssPolicyContext);
            this.loadClientSidePolicy(singletonService);
        }
    }

    private void loadClientSidePolicy(EnvironmentFactory.SingletonService singletonService) {
        ClientPolicyFeature clientPolicyFeature = (ClientPolicyFeature)this.getBinding().getFeature(ClientPolicyFeature.class);
        if (clientPolicyFeature != null) {
            try {
                String string = this.getPort().getName().getLocalPart();
                singletonService.setUsingPolicy(true);
                WsPort wsPort = singletonService.getPort(string);
                Iterator iterator = wsPort.getEndpoint().getMethods();
                while (iterator.hasNext()) {
                    WsMethod wsMethod = (WsMethod)iterator.next();
                    wsMethod.setCachedEffectiveInboundPolicy(this.getInputPolicyForOperation(clientPolicyFeature, string, wsMethod.getOperationName()));
                    wsMethod.setCachedEffectiveOutboundPolicy(this.getOutputPolicyForOperation(clientPolicyFeature, string, wsMethod.getOperationName()));
                }
            }
            catch (Exception exception) {
                throw new WebServiceException((Throwable)exception);
            }
        }
    }

    private NormalizedExpression getPolicy(PolicySource policySource, String string) {
        Pair<PolicySource, String> pair = new Pair<PolicySource, String>(policySource, string);
        NormalizedExpression normalizedExpression = this.policyCache.get(pair);
        if (normalizedExpression == null) {
            Collection collection = policySource.getPolicy(string);
            if (collection.size() > 0) {
                Iterator iterator = collection.iterator();
                if (iterator.hasNext()) {
                    normalizedExpression = ClientEnvironmentFactory.getNormalizedPolicy(string, (InputStream)iterator.next());
                }
                while (iterator.hasNext()) {
                    normalizedExpression = PolicyMath.merge(normalizedExpression, ClientEnvironmentFactory.getNormalizedPolicy(string, (InputStream)iterator.next()));
                }
            }
            this.policyCache.put(pair, normalizedExpression);
        }
        return normalizedExpression;
    }

    private static NormalizedExpression getNormalizedPolicy(String string, InputStream inputStream) {
        PolicyStatement policyStatement = null;
        try {
            policyStatement = PolicyFinder.readPolicyFromStream(string, inputStream, true);
            if (SecurityPolicyCustomizer.isSecurityPolicyAbstract(string, policyStatement)) {
                throw new WebServiceException("Abstract policy can not be attached to client dynamically.");
            }
            return policyStatement.normalize();
        }
        catch (PolicyException policyException) {
            throw new WebServiceException((Throwable)policyException);
        }
    }

    public NormalizedExpression getInputPolicyForOperation(ClientPolicyFeature clientPolicyFeature, String string, QName qName) {
        PolicySource policySource;
        PolicySource policySource2;
        PolicySource policySource3;
        NormalizedExpression normalizedExpression = null;
        PolicySource policySource4 = clientPolicyFeature.getEffectivePolicy();
        if (policySource4 != null) {
            normalizedExpression = this.merge(normalizedExpression, this.getPolicy(policySource4, string));
        }
        if ((policySource3 = clientPolicyFeature.getEffectivePolicyForInputMessage()) != null) {
            normalizedExpression = this.merge(normalizedExpression, this.getPolicy(policySource3, string));
        }
        if ((policySource2 = clientPolicyFeature.getEffectivePolicyForOperation(qName)) != null) {
            normalizedExpression = this.merge(normalizedExpression, this.getPolicy(policySource2, string));
        }
        if ((policySource = clientPolicyFeature.getEffectivePolicyForInputMessage(qName)) != null) {
            normalizedExpression = this.merge(normalizedExpression, this.getPolicy(policySource, string));
        }
        return normalizedExpression;
    }

    public NormalizedExpression getOutputPolicyForOperation(ClientPolicyFeature clientPolicyFeature, String string, QName qName) {
        PolicySource policySource;
        PolicySource policySource2;
        PolicySource policySource3;
        NormalizedExpression normalizedExpression = null;
        PolicySource policySource4 = clientPolicyFeature.getEffectivePolicy();
        if (policySource4 != null) {
            normalizedExpression = this.merge(normalizedExpression, this.getPolicy(policySource4, string));
        }
        if ((policySource3 = clientPolicyFeature.getEffectivePolicyForOutputMessage()) != null) {
            normalizedExpression = this.merge(normalizedExpression, this.getPolicy(policySource3, string));
        }
        if ((policySource2 = clientPolicyFeature.getEffectivePolicyForOperation(qName)) != null) {
            normalizedExpression = this.merge(normalizedExpression, this.getPolicy(policySource2, string));
        }
        if ((policySource = clientPolicyFeature.getEffectivePolicyForOutputMessage(qName)) != null) {
            normalizedExpression = this.merge(normalizedExpression, this.getPolicy(policySource, string));
        }
        return normalizedExpression;
    }

    private NormalizedExpression merge(NormalizedExpression normalizedExpression, NormalizedExpression normalizedExpression2) {
        if (normalizedExpression == null) {
            return normalizedExpression2;
        }
        if (normalizedExpression2 == null) {
            return normalizedExpression;
        }
        return PolicyMath.merge(normalizedExpression, normalizedExpression2);
    }
}

