/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.jaxws.framework.jaxrpc.server;

import com.sun.xml.ws.api.server.BoundEndpoint;
import com.sun.xml.ws.api.server.Container;
import com.sun.xml.ws.api.server.Module;
import com.sun.xml.ws.api.server.WSEndpoint;
import java.net.URL;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.xml.namespace.QName;
import javax.xml.ws.WebServiceException;
import weblogic.application.utils.ApplicationVersionUtils;
import weblogic.j2ee.descriptor.wl.WebservicePolicyRefBean;
import weblogic.jws.security.WssConfiguration;
import weblogic.management.runtime.RuntimeMBean;
import weblogic.management.runtime.WseeV2RuntimeMBean;
import weblogic.wsee.deploy.DeployInfo;
import weblogic.wsee.jaxws.WLSContainer;
import weblogic.wsee.jaxws.WLSServletAdapter;
import weblogic.wsee.jaxws.framework.jaxrpc.EnvironmentFactory;
import weblogic.wsee.jaxws.framework.policy.PolicyMap;
import weblogic.wsee.jws.VisitableJWS;
import weblogic.wsee.jws.VisitableJWSBuilder;
import weblogic.wsee.monitoring.WsspStats;
import weblogic.wsee.policy.deployment.PolicyBeanVisitor;
import weblogic.wsee.policy.deployment.PolicyDeployUtils;
import weblogic.wsee.policy.deployment.WsdlPolicySubject;
import weblogic.wsee.policy.runtime.PolicyFinder;
import weblogic.wsee.policy.runtime.PolicyServer;
import weblogic.wsee.security.policy.WssPolicyContext;
import weblogic.wsee.ws.WsEndpoint;
import weblogic.wsee.ws.WsMethod;
import weblogic.wsee.wsdl.WsdlDefinitions;
import weblogic.wsee.wsdl.WsdlOperation;
import weblogic.wsee.wsdl.WsdlPort;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerEnvironmentFactory
extends EnvironmentFactory {
    private WSEndpoint<?> endpoint;
    private WsdlDefinitions wsdlDef;

    public ServerEnvironmentFactory(WSEndpoint<?> wSEndpoint) {
        super(wSEndpoint.getBinding(), wSEndpoint.getPort(), wSEndpoint.getContainer());
        this.endpoint = wSEndpoint;
    }

    @Override
    protected void initPolicyContext(EnvironmentFactory.SingletonService singletonService) {
        Container container = this.getContainer();
        DeployInfo deployInfo = container != null ? (DeployInfo)container.getSPI(DeployInfo.class) : null;
        WssPolicyContext wssPolicyContext = null;
        WsdlDefinitions wsdlDefinitions = null;
        if (deployInfo != null) {
            wssPolicyContext = deployInfo.getWssPolicyContext();
            if (deployInfo.getWsdlDef() == null) {
                wsdlDefinitions = this.getWsdlDef();
            } else {
                this.attachAnnotationPolicyForStartFromWSDLEndpoint();
            }
            this.attachPolicyForProviderBasedEndpoint(deployInfo);
        } else {
            wssPolicyContext = this.buildWssPolicyContextForProviderBasedEndpoint(container);
            wsdlDefinitions = this.getWsdlDef();
            this.attachAnnotationPolicyForStartFromWSDLEndpoint();
        }
        if (wsdlDefinitions != null) {
            wssPolicyContext.getPolicyServer().addPolicies(new WsdlPolicySubject(wsdlDefinitions).getPolicies());
        }
        singletonService.setWssPolicyContext(wssPolicyContext);
    }

    private WssPolicyContext buildWssPolicyContextForProviderBasedEndpoint(Container container) {
        String string = "default_wss";
        WssConfiguration wssConfiguration = this.endpoint.getImplementationClass().getAnnotation(WssConfiguration.class);
        if (wssConfiguration != null) {
            string = wssConfiguration.value();
        }
        WssPolicyContext wssPolicyContext = new WssPolicyContext(string);
        PolicyServer policyServer = wssPolicyContext.getPolicyServer();
        try {
            PolicyFinder.loadPolicies(Thread.currentThread().getContextClassLoader().getResource("policies"), policyServer);
            ServletContext servletContext = (ServletContext)container.getSPI(ServletContext.class);
            if (servletContext != null) {
                URL uRL = servletContext.getResource("/WEB-INF/policies");
                PolicyFinder.loadPolicies(uRL, policyServer);
            }
        }
        catch (Exception exception) {
            throw new WebServiceException((Throwable)exception);
        }
        return wssPolicyContext;
    }

    private void attachAnnotationPolicyForStartFromWSDLEndpoint() {
        PolicyMap policyMap = new PolicyMap(this.endpoint.getContainer(), this.endpoint.getSEIModel(), this.endpoint.getBinding(), this.endpoint.getPortName(), this.endpoint.getImplementationClass());
        policyMap.updateWSDLModel(this.endpoint.getPort());
    }

    public WSEndpoint<?> getEndpoint() {
        return this.endpoint;
    }

    @Override
    public String[] getServiceUris() {
        String[] stringArray = super.getServiceUris();
        if (stringArray != null) {
            return stringArray;
        }
        Container container = this.getContainer();
        if (container instanceof WLSContainer) {
            return new String[]{((WLSServletAdapter)((WLSContainer)container).getBoundEndpoint(this.endpoint)).getServiceUri()};
        }
        return null;
    }

    @Override
    public String getContextPath() {
        String string = super.getContextPath();
        if (string != null) {
            return string;
        }
        ServletContext servletContext = (ServletContext)this.getContainer().getSPI(ServletContext.class);
        return servletContext != null ? servletContext.getContextPath() : null;
    }

    @Override
    public String getServiceName() {
        String string = super.getServiceName();
        if (string != null) {
            return string;
        }
        return this.endpoint.getServiceName().getLocalPart();
    }

    private void attachPolicyForProviderBasedEndpoint(DeployInfo deployInfo) {
        if (deployInfo == null && this.wsdlDef != null) {
            PolicyBeanVisitor policyBeanVisitor = new PolicyBeanVisitor();
            VisitableJWS visitableJWS = VisitableJWSBuilder.jaxws().impl(this.endpoint.getImplementationClass()).portName(this.endpoint.getPortName()).build();
            visitableJWS.accept(policyBeanVisitor);
            WebservicePolicyRefBean webservicePolicyRefBean = policyBeanVisitor.getPolicyRefBean();
            WsdlPort wsdlPort = this.wsdlDef.getPorts().get(this.endpoint.getPortName());
            if (wsdlPort == null) {
                throw new WebServiceException("Error encountered while deploying WebService  '" + this.endpoint.getImplementationClass().getName() + "'. " + "'  - wsdl port:" + this.endpoint.getPortName() + " is not found in wsdl.");
            }
            if (webservicePolicyRefBean != null) {
                PolicyDeployUtils.attachPolicy(webservicePolicyRefBean, this.wsdlDef, wsdlPort, null);
            }
        }
    }

    @Override
    protected String getCurrentVersionId() {
        return ApplicationVersionUtils.getCurrentVersionId();
    }

    @Override
    protected EnvironmentFactory.SimulatedWsMethod createSimulatedWsMethod(WsdlOperation wsdlOperation) {
        return new ServerSimulatedWsMethod(wsdlOperation);
    }

    @Override
    protected EnvironmentFactory.SimulatedWsEndpoint createSimulatedWsEndpoint(Map<String, WsMethod> map, QName qName) {
        return new ServerSimulatedWsEndpoint(map, qName);
    }

    @Override
    protected EnvironmentFactory.SimulatedWsPort createSimulatedWsPort(WsEndpoint wsEndpoint, QName qName) {
        return new ServerSimulatedWsPort(wsEndpoint, qName);
    }

    protected class ServerSimulatedWsPort
    extends EnvironmentFactory.SimulatedWsPort {
        private WsspStats stats;

        protected ServerSimulatedWsPort(WsEndpoint wsEndpoint, QName qName) {
            super(wsEndpoint, qName);
        }

        public RuntimeMBean getRuntimeMBean() {
            Module module;
            Container container = ServerEnvironmentFactory.this.getContainer();
            if (container != null && (module = (Module)container.getSPI(Module.class)) != null) {
                List list = module.getBoundEndpoints();
                for (BoundEndpoint boundEndpoint : list) {
                    if (ServerEnvironmentFactory.this.endpoint != boundEndpoint.getEndpoint()) continue;
                    return (RuntimeMBean)boundEndpoint.getSPI(WseeV2RuntimeMBean.class);
                }
            }
            return null;
        }

        public WsspStats getWsspStats() {
            return this.stats;
        }

        public void setWsspStats(WsspStats wsspStats) {
            this.stats = wsspStats;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ServerSimulatedWsEndpoint
    extends EnvironmentFactory.SimulatedWsEndpoint {
        protected ServerSimulatedWsEndpoint(Map<String, WsMethod> map, QName qName) {
            super(map, qName);
        }

        @Override
        public Class getJwsClass() {
            return ServerEnvironmentFactory.this.endpoint.getImplementationClass();
        }
    }

    protected class ServerSimulatedWsMethod
    extends EnvironmentFactory.SimulatedWsMethod {
        public ServerSimulatedWsMethod(WsdlOperation wsdlOperation) {
            super(wsdlOperation);
        }

        public String getMethodName() {
            return ServerEnvironmentFactory.this.endpoint.getSEIModel().getJavaMethod(this.getOperationName()).getMethod().getName();
        }
    }
}

