/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.jaxws.framework.policy;

import com.sun.xml.ws.api.server.WSEndpoint;
import com.sun.xml.ws.api.streaming.XMLStreamWriterFactory;
import com.sun.xml.ws.wsdl.parser.WSDLConstants;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import weblogic.jws.Policy;
import weblogic.wsee.jaxws.framework.policy.PolicyMap;

class PatchFilter
implements XMLStreamWriter,
XMLStreamWriterFactory.RecycleAware {
    protected XMLStreamWriter inner;
    private PolicyMap policyMap;
    private QName currentElement = null;
    private List<QName> context = new ArrayList<QName>();
    private String defaultNamespace = "";
    private QName portName;
    private QName bindingName;
    private String targetNamespace = "";
    private QName currentOperation = null;
    private QName currentBinding = null;
    private boolean wssutilFlag = false;
    private boolean wspFlag = false;

    public PatchFilter(WSEndpoint wSEndpoint, XMLStreamWriter xMLStreamWriter) {
        this.inner = xMLStreamWriter;
        this.portName = wSEndpoint.getPort().getName();
        this.bindingName = wSEndpoint.getPort().getBinding().getName();
        this.policyMap = new PolicyMap(wSEndpoint.getContainer(), wSEndpoint.getSEIModel(), wSEndpoint.getBinding(), this.portName, wSEndpoint.getImplementationClass());
    }

    public void close() throws XMLStreamException {
        this.onCurrentChange();
        this.inner.close();
    }

    public void flush() throws XMLStreamException {
        this.inner.flush();
    }

    public NamespaceContext getNamespaceContext() {
        return this.inner.getNamespaceContext();
    }

    public String getPrefix(String string) throws XMLStreamException {
        return this.inner.getPrefix(string);
    }

    public Object getProperty(String string) throws IllegalArgumentException {
        return this.inner.getProperty(string);
    }

    public void setDefaultNamespace(String string) throws XMLStreamException {
        this.inner.setDefaultNamespace(string);
        this.defaultNamespace = string;
    }

    public void setNamespaceContext(NamespaceContext namespaceContext) throws XMLStreamException {
        this.inner.setNamespaceContext(namespaceContext);
    }

    public void setPrefix(String string, String string2) throws XMLStreamException {
        this.inner.setPrefix(string, string2);
    }

    public void writeAttribute(String string, String string2) throws XMLStreamException {
        this.checkAttribute(null, string, string2);
        this.inner.writeAttribute(string, string2);
    }

    public void writeAttribute(String string, String string2, String string3) throws XMLStreamException {
        this.checkAttribute(string, string2, string3);
        this.inner.writeAttribute(string, string2, string3);
    }

    public void writeAttribute(String string, String string2, String string3, String string4) throws XMLStreamException {
        this.checkAttribute(string2, string3, string4);
        this.inner.writeAttribute(string, string2, string3, string4);
    }

    public void writeCData(String string) throws XMLStreamException {
        this.onCurrentChange();
        this.inner.writeCData(string);
    }

    public void writeCharacters(char[] cArray, int n, int n2) throws XMLStreamException {
        this.onCurrentChange();
        this.inner.writeCharacters(cArray, n, n2);
    }

    public void writeCharacters(String string) throws XMLStreamException {
        this.onCurrentChange();
        this.inner.writeCharacters(string);
    }

    public void writeComment(String string) throws XMLStreamException {
        this.inner.writeComment(string);
    }

    public void writeDefaultNamespace(String string) throws XMLStreamException {
        this.inner.writeDefaultNamespace(string);
        this.defaultNamespace = string;
    }

    public void writeDTD(String string) throws XMLStreamException {
        this.onCurrentChange();
        this.inner.writeDTD(string);
    }

    public void writeEmptyElement(String string) throws XMLStreamException {
        this.onCurrentChange();
        this.inner.writeEmptyElement(string);
    }

    public void writeEmptyElement(String string, String string2) throws XMLStreamException {
        this.onCurrentChange();
        this.inner.writeEmptyElement(string, string2);
    }

    public void writeEmptyElement(String string, String string2, String string3) throws XMLStreamException {
        this.onCurrentChange();
        this.inner.writeEmptyElement(string, string2, string3);
    }

    public void writeEndDocument() throws XMLStreamException {
        this.onCurrentChange();
        this.inner.writeEndDocument();
    }

    public void writeEndElement() throws XMLStreamException {
        this.onCurrentChange();
        this.context.remove(this.context.size() - 1);
        this.inner.writeEndElement();
    }

    public void writeEntityRef(String string) throws XMLStreamException {
        this.onCurrentChange();
        this.inner.writeEntityRef(string);
    }

    public void writeNamespace(String string, String string2) throws XMLStreamException {
        if (this.isIgnorablePrefix(string)) {
            return;
        }
        this.inner.writeNamespace(string, string2);
    }

    private boolean isIgnorablePrefix(String string) {
        if (WSDLConstants.QNAME_DEFINITIONS.equals(this.currentElement)) {
            if ("wsp".equals(string)) {
                if (this.wspFlag) {
                    return true;
                }
                this.wspFlag = true;
            }
            if ("wssutil".equals(string)) {
                if (this.wssutilFlag) {
                    return true;
                }
                this.wssutilFlag = true;
            }
        }
        return false;
    }

    public void writeProcessingInstruction(String string) throws XMLStreamException {
        this.onCurrentChange();
        this.inner.writeProcessingInstruction(string);
    }

    public void writeProcessingInstruction(String string, String string2) throws XMLStreamException {
        this.onCurrentChange();
        this.inner.writeProcessingInstruction(string, string2);
    }

    public void writeStartDocument() throws XMLStreamException {
        this.inner.writeStartDocument();
    }

    public void writeStartDocument(String string) throws XMLStreamException {
        this.inner.writeStartDocument(string);
    }

    public void writeStartDocument(String string, String string2) throws XMLStreamException {
        this.inner.writeStartDocument(string, string2);
    }

    public void writeStartElement(String string) throws XMLStreamException {
        this.onCurrentChange();
        this.inner.writeStartElement(string);
        this.currentElement = new QName(this.defaultNamespace, string);
    }

    public void writeStartElement(String string, String string2) throws XMLStreamException {
        this.onCurrentChange();
        this.inner.writeStartElement(string, string2);
        this.currentElement = new QName(string, string2);
    }

    public void writeStartElement(String string, String string2, String string3) throws XMLStreamException {
        this.onCurrentChange();
        this.inner.writeStartElement(string, string2, string3);
        this.currentElement = new QName(string3, string2, string);
    }

    private void checkAttribute(String string, String string2, String string3) {
        if (this.currentElement != null) {
            if (string == null && "targetNamespace".equals(string2) && this.currentElement.equals(WSDLConstants.QNAME_DEFINITIONS)) {
                this.targetNamespace = string3;
            } else if (string == null && "name".equals(string2) && this.currentElement.equals(WSDLConstants.QNAME_OPERATION)) {
                this.currentOperation = new QName(this.targetNamespace, string3);
            } else if (string == null && "name".equals(string2) && this.currentElement.equals(WSDLConstants.QNAME_BINDING)) {
                this.currentBinding = new QName(this.targetNamespace, string3);
            }
        }
    }

    private void onCurrentChange() {
        if (this.currentElement != null) {
            if (this.currentElement.equals(WSDLConstants.QNAME_DEFINITIONS)) {
                this.policyMap.addDefinitionsExtension(this.inner, this.wssutilFlag, this.wspFlag);
                this.wspFlag = true;
                this.wssutilFlag = true;
            } else if (this.currentElement.equals(WSDLConstants.QNAME_BINDING) && this.bindingName.equals(this.currentBinding)) {
                this.policyMap.addApplicablePolicyReferences(this.portName, null, this.inner);
            }
            if (!this.context.isEmpty() && this.bindingName.equals(this.currentBinding)) {
                QName qName;
                QName qName2 = this.context.get(this.context.size() - 1);
                if (qName2.equals(WSDLConstants.QNAME_BINDING)) {
                    if (this.currentElement.equals(WSDLConstants.QNAME_OPERATION) && this.currentOperation != null) {
                        this.policyMap.addApplicablePolicyReferences(this.currentOperation, Policy.Direction.both, this.inner);
                    }
                } else if (qName2.equals(WSDLConstants.QNAME_OPERATION) && this.context.size() > 1 && (qName = this.context.get(this.context.size() - 2)).equals(WSDLConstants.QNAME_BINDING)) {
                    if (this.currentElement.equals(WSDLConstants.QNAME_INPUT)) {
                        if (this.currentOperation != null) {
                            this.policyMap.addApplicablePolicyReferences(this.currentOperation, Policy.Direction.inbound, this.inner);
                        }
                    } else if (this.currentElement.equals(WSDLConstants.QNAME_OUTPUT) && this.currentOperation != null) {
                        this.policyMap.addApplicablePolicyReferences(this.currentOperation, Policy.Direction.outbound, this.inner);
                    }
                }
            }
            this.context.add(this.currentElement);
            this.currentElement = null;
        }
    }

    public void onRecycled() {
        XMLStreamWriterFactory.recycle((XMLStreamWriter)this.inner);
        this.inner = null;
    }
}

