/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.jaxws.framework.policy;

import com.sun.xml.txw2.TypedXmlWriter;
import com.sun.xml.txw2.annotation.XmlAttribute;
import com.sun.xml.txw2.annotation.XmlElement;
import com.sun.xml.ws.api.WSBinding;
import com.sun.xml.ws.api.model.SEIModel;
import com.sun.xml.ws.api.model.wsdl.WSDLBoundPortType;
import com.sun.xml.ws.api.model.wsdl.WSDLExtensible;
import com.sun.xml.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.ws.api.server.Container;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.WebServiceFeature;
import javax.xml.ws.WebServiceProvider;
import org.w3c.dom.Element;
import weblogic.j2ee.descriptor.wl.PortPolicyBean;
import weblogic.j2ee.descriptor.wl.WebservicePolicyRefBean;
import weblogic.j2ee.descriptor.wl.WsPolicyBean;
import weblogic.jws.Policy;
import weblogic.jws.jaxws.AggregatePolicyFeature;
import weblogic.jws.jaxws.BasePolicyFeature;
import weblogic.jws.jaxws.PoliciesFeature;
import weblogic.jws.jaxws.PolicyFeature;
import weblogic.wsee.deploy.DeployInfo;
import weblogic.wsee.jaxws.framework.jaxrpc.WsdlExtensibleHolder;
import weblogic.wsee.jaxws.framework.policy.WSDLParserExtension;
import weblogic.wsee.jaxws.util.WriterUtil;
import weblogic.wsee.policy.deployment.PolicyWsdlExtension;
import weblogic.wsee.policy.framework.PolicyException;
import weblogic.wsee.policy.framework.PolicyStatement;
import weblogic.wsee.policy.runtime.PolicyServer;
import weblogic.wsee.util.StringUtil;
import weblogic.wsee.util.Verbose;
import weblogic.wsee.wsdl.WsdlExtensible;
import weblogic.wsee.wstx.wsat.TransactionalFeature;
import weblogic.wsee.wstx.wsat.policy.ATAssertionBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PolicyMap {
    private static boolean verbose = Verbose.isVerbose(PolicyMap.class);
    private Map<String, PolicyStatement> policies = new HashMap<String, PolicyStatement>();
    private Map<QName, List<PolicyFeature>> targets = new HashMap<QName, List<PolicyFeature>>();
    private PolicyServer policyServer = null;

    public PolicyMap(Container container, SEIModel sEIModel, WSBinding wSBinding, QName qName, Class clazz) {
        QName qName2;
        Object object;
        Map.Entry entry2;
        HashMap<String, PolicyStatement> hashMap;
        boolean bl;
        this.policies.clear();
        this.targets.clear();
        PolicyServer policyServer = this.policyServer = container != null ? (PolicyServer)container.getSPI(PolicyServer.class) : null;
        if (this.policyServer == null) {
            this.policyServer = new PolicyServer();
        }
        AggregatePolicyFeature aggregatePolicyFeature = (AggregatePolicyFeature)wSBinding.getFeature(AggregatePolicyFeature.class);
        DeployInfo deployInfo = container != null ? (DeployInfo)container.getSPI(DeployInfo.class) : null;
        WebservicePolicyRefBean webservicePolicyRefBean = deployInfo != null ? deployInfo.getPolicyRef() : null;
        TransactionalFeature transactionalFeature = (TransactionalFeature)wSBinding.getFeature(TransactionalFeature.class);
        if (aggregatePolicyFeature == null && webservicePolicyRefBean == null && transactionalFeature == null) {
            return;
        }
        HashMap<QName, BasePolicyFeature> hashMap2 = new HashMap<QName, BasePolicyFeature>();
        boolean bl2 = bl = clazz.getAnnotation(WebServiceProvider.class) != null;
        if (aggregatePolicyFeature != null && (sEIModel != null || bl)) {
            hashMap = aggregatePolicyFeature.getMap();
            for (Map.Entry entry2 : hashMap.entrySet()) {
                if (entry2.getKey() instanceof Method && !bl) {
                    object = (Method)entry2.getKey();
                    if (((Method)object).getDeclaringClass() != clazz && ((Method)object).getDeclaringClass().isAssignableFrom(clazz)) {
                        try {
                            object = clazz.getMethod(((Method)object).getName(), ((Method)object).getParameterTypes());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if ((qName2 = sEIModel.getJavaMethod((Method)object)) == null) continue;
                    hashMap2.put(new QName(qName.getNamespaceURI(), qName2.getOperationName()), (BasePolicyFeature)entry2.getValue());
                    continue;
                }
                hashMap2.put(qName, (BasePolicyFeature)entry2.getValue());
            }
        }
        if (webservicePolicyRefBean != null) {
            this.updatePolicyMap(qName, webservicePolicyRefBean, hashMap2, deployInfo.getLinkName());
        }
        hashMap = new HashMap<String, PolicyStatement>();
        if (transactionalFeature != null) {
            ATAssertionBuilder.buildPolicyMap(qName.getNamespaceURI(), hashMap, hashMap2, transactionalFeature);
        }
        this.policies.putAll(hashMap);
        this.policyServer.addPolicies(hashMap);
        Set set = hashMap2.entrySet();
        entry2 = set.iterator();
        while (entry2.hasNext()) {
            object = (Map.Entry)entry2.next();
            qName2 = (QName)object.getKey();
            WebServiceFeature webServiceFeature = (WebServiceFeature)object.getValue();
            if (webServiceFeature instanceof PolicyFeature) {
                this.addPolicyToMap(this.policies, this.targets, qName2, (PolicyFeature)webServiceFeature);
                continue;
            }
            if (webServiceFeature instanceof PoliciesFeature) {
                List list = ((PoliciesFeature)webServiceFeature).getPolicies();
                for (PolicyFeature policyFeature : list) {
                    this.addPolicyToMap(this.policies, this.targets, qName2, policyFeature);
                }
                continue;
            }
            throw new IllegalStateException("Unexpected feature type: " + webServiceFeature.getClass().getName());
        }
    }

    private void updatePolicyMap(QName qName, WebservicePolicyRefBean webservicePolicyRefBean, Map<QName, BasePolicyFeature> map, String string) {
        PortPolicyBean[] portPolicyBeanArray;
        PortPolicyBean[] portPolicyBeanArray2 = webservicePolicyRefBean.getPortPolicy();
        if (portPolicyBeanArray2 != null) {
            portPolicyBeanArray = portPolicyBeanArray2;
            int n = portPolicyBeanArray.length;
            for (int i = 0; i < n; ++i) {
                WsPolicyBean[] wsPolicyBeanArray;
                PortPolicyBean portPolicyBean = portPolicyBeanArray[i];
                if (!qName.getLocalPart().equals(portPolicyBean.getPortName()) || (wsPolicyBeanArray = portPolicyBean.getWsPolicy()) == null) continue;
                for (WsPolicyBean wsPolicyBean : wsPolicyBeanArray) {
                    if (!wsPolicyBean.getStatus().equals("enabled")) continue;
                    Policy.Direction direction = wsPolicyBean.getDirection() != null ? Policy.Direction.valueOf((String)wsPolicyBean.getDirection()) : Policy.Direction.both;
                    WsPolicyBean wsPolicyBean2 = new PolicyFeature(wsPolicyBean.getUri(), direction);
                    this.addPolicyFeature(map, (PolicyFeature)wsPolicyBean2, qName);
                }
                this.removePolicyFeature(map, qName, wsPolicyBeanArray, Policy.Direction.both);
                this.removePolicyFeature(map, qName, wsPolicyBeanArray, Policy.Direction.inbound);
                this.removePolicyFeature(map, qName, wsPolicyBeanArray, Policy.Direction.outbound);
            }
        }
        if ((portPolicyBeanArray = webservicePolicyRefBean.getOperationPolicy()) != null) {
            for (PortPolicyBean portPolicyBean : portPolicyBeanArray) {
                QName qName2 = new QName(qName.getNamespaceURI(), portPolicyBean.getOperationName());
                WsPolicyBean[] wsPolicyBeanArray = portPolicyBean.getWsPolicy();
                if (wsPolicyBeanArray == null) continue;
                for (WsPolicyBean wsPolicyBean2 : wsPolicyBeanArray) {
                    String string2 = portPolicyBean.getServiceLink();
                    if (!wsPolicyBean2.getStatus().equals("enabled") || !StringUtil.isEmpty(string2) && (StringUtil.isEmpty(string2) || !string2.equals(string))) continue;
                    PolicyFeature policyFeature = new PolicyFeature(wsPolicyBean2.getUri(), Policy.Direction.valueOf((String)wsPolicyBean2.getDirection()));
                    this.addPolicyFeature(map, policyFeature, qName2);
                }
                this.removePolicyFeature(map, qName2, wsPolicyBeanArray, Policy.Direction.both);
                this.removePolicyFeature(map, qName2, wsPolicyBeanArray, Policy.Direction.inbound);
                this.removePolicyFeature(map, qName2, wsPolicyBeanArray, Policy.Direction.outbound);
            }
        }
    }

    private void removePolicyFeature(Map<QName, BasePolicyFeature> map, QName qName, WsPolicyBean[] wsPolicyBeanArray, Policy.Direction direction) {
        List<String> list = this.getPolicies(map, qName, direction);
        if (list != null) {
            ArrayList<String> arrayList = new ArrayList<String>(list);
            for (String string : arrayList) {
                for (int i = 0; i < wsPolicyBeanArray.length; ++i) {
                    WsPolicyBean wsPolicyBean = wsPolicyBeanArray[i];
                    if (!PolicyMap.urisEquivalent(wsPolicyBean.getUri(), string.toString())) continue;
                    if (direction.equals((Object)Policy.Direction.both)) {
                        if (wsPolicyBean.getStatus().equals("enabled")) continue;
                        PolicyMap.removePolicy(map, qName, string);
                        continue;
                    }
                    if (!wsPolicyBean.getStatus().equals("enabled")) {
                        if (!direction.equals((Object)Policy.Direction.valueOf((String)wsPolicyBean.getDirection()))) continue;
                        PolicyMap.removePolicy(map, qName, string, direction);
                        continue;
                    }
                    if (direction.equals((Object)Policy.Direction.valueOf((String)wsPolicyBean.getDirection()))) continue;
                    PolicyMap.removePolicy(map, qName, string, direction);
                }
            }
        }
    }

    private static void removePolicy(Map<QName, BasePolicyFeature> map, QName qName, String string) {
        PolicyMap.removePolicy(map, qName, string, null);
    }

    private static void removePolicy(Map<QName, BasePolicyFeature> map, QName qName, String string, Policy.Direction direction) {
        BasePolicyFeature basePolicyFeature = map.get(qName);
        if (basePolicyFeature != null) {
            if (basePolicyFeature instanceof PolicyFeature) {
                if (((PolicyFeature)basePolicyFeature).getUri().equals(string) && (direction == null || direction.equals((Object)((PolicyFeature)basePolicyFeature).getDirection()))) {
                    map.remove(qName);
                }
            } else if (basePolicyFeature instanceof PoliciesFeature) {
                List list = ((PoliciesFeature)basePolicyFeature).getPolicies();
                ArrayList arrayList = new ArrayList(list);
                for (PolicyFeature policyFeature : arrayList) {
                    if (!policyFeature.getUri().equals(string) || direction != null && !direction.equals((Object)policyFeature.getDirection())) continue;
                    list.remove(policyFeature);
                }
            }
        }
    }

    private List<String> getPolicies(Map<QName, BasePolicyFeature> map, QName qName, Policy.Direction direction) {
        ArrayList<String> arrayList = new ArrayList<String>();
        BasePolicyFeature basePolicyFeature = map.get(qName);
        if (basePolicyFeature != null) {
            if (basePolicyFeature instanceof PolicyFeature) {
                if (((PolicyFeature)basePolicyFeature).getDirection().equals((Object)direction)) {
                    arrayList.add(((PolicyFeature)basePolicyFeature).getUri());
                }
            } else if (basePolicyFeature instanceof PoliciesFeature) {
                List list = ((PoliciesFeature)basePolicyFeature).getPolicies();
                for (PolicyFeature policyFeature : list) {
                    if (!policyFeature.getDirection().equals((Object)direction)) continue;
                    arrayList.add(policyFeature.getUri());
                }
            }
        }
        return arrayList;
    }

    private static boolean urisEquivalent(String string, String string2) {
        String string3;
        if (string.equals(string2)) {
            return true;
        }
        return string.endsWith(".xml") && (string3 = string.substring(0, string.length() - 4)).equals(string2);
    }

    private void addPolicyFeature(Map<QName, BasePolicyFeature> map, PolicyFeature policyFeature, QName qName) {
        BasePolicyFeature basePolicyFeature = map.get(qName);
        if (basePolicyFeature == null) {
            basePolicyFeature = new PoliciesFeature(new PolicyFeature[0]);
        } else if (basePolicyFeature instanceof PolicyFeature) {
            basePolicyFeature = new PoliciesFeature(new PolicyFeature[]{(PolicyFeature)basePolicyFeature});
        }
        PoliciesFeature policiesFeature = (PoliciesFeature)basePolicyFeature;
        if (policiesFeature.getPolicies() != null && policiesFeature.getPolicies().size() == 0) {
            policiesFeature.getPolicies().add(policyFeature);
        } else {
            boolean bl = false;
            for (PolicyFeature policyFeature2 : policiesFeature.getPolicies()) {
                if (!policyFeature2.getUri().equals(policyFeature.getUri())) continue;
                bl = true;
                break;
            }
            if (!bl) {
                policiesFeature.getPolicies().add(policyFeature);
            }
        }
        map.put(qName, basePolicyFeature);
    }

    private void addPolicyToMap(Map<String, PolicyStatement> map, Map<QName, List<PolicyFeature>> map2, QName qName, PolicyFeature policyFeature) {
        String string;
        PolicyStatement policyStatement;
        if (verbose) {
            Verbose.log("PROCESSING POLICY FEATURE");
            Verbose.log("AnnotatedElement: " + qName.getClass().getCanonicalName());
            Verbose.log("Feature ID: " + policyFeature.getID());
            Verbose.log("Feature Enabled: " + policyFeature.isEnabled());
            Verbose.log("Policy URI: " + policyFeature.getUri());
            Verbose.log("Policy Direction: " + policyFeature.getDirection());
            Verbose.log("Policy Attach WSDL: " + policyFeature.isAttachToWsdl());
        }
        if ((policyStatement = this.policyServer.lookupPolicy(string = policyFeature.getUri())) == null && verbose) {
            Verbose.log("Couldn't find policy for '" + string + "'");
        }
        map.put(string, policyStatement);
        List<PolicyFeature> list = map2.get(qName);
        if (list == null) {
            list = new LinkedList<PolicyFeature>();
            map2.put(qName, list);
        }
        list.add(policyFeature);
    }

    public void addApplicablePolicyReferences(QName qName, Policy.Direction direction, TypedXmlWriter typedXmlWriter) {
        this.addApplicablePolicyReferences(qName, direction, (Object)typedXmlWriter);
    }

    public void addApplicablePolicyReferences(QName qName, Policy.Direction direction, XMLStreamWriter xMLStreamWriter) {
        this.addApplicablePolicyReferences(qName, direction, (Object)xMLStreamWriter);
    }

    private void addApplicablePolicyReferences(QName qName, Policy.Direction direction, Object object) {
        if (qName == null) {
            return;
        }
        List<PolicyFeature> list = this.targets.get(qName);
        if (list == null) {
            return;
        }
        for (PolicyFeature policyFeature : list) {
            String string = policyFeature.getUri();
            PolicyStatement policyStatement = this.policies.get(string);
            if (policyStatement != null) {
                string = "#" + policyStatement.getId();
            }
            if (direction != null && !policyFeature.getDirection().equals((Object)direction)) continue;
            this.writePolicyReference(object, string);
        }
    }

    public void updateWSDLModel(WSDLPort wSDLPort) {
        Serializable serializable;
        Object object;
        if (wSDLPort == null) {
            return;
        }
        WSDLBoundPortType wSDLBoundPortType = wSDLPort.getBinding();
        List<PolicyFeature> list = this.targets.get(wSDLPort.getName());
        ArrayList<PolicyFeature> arrayList = new ArrayList<PolicyFeature>();
        if (list != null) {
            for (PolicyFeature policyFeature : list) {
                object = policyFeature.getUri();
                serializable = this.policies.get(object);
                if (serializable == null) continue;
                if (policyFeature.getDirection() == Policy.Direction.both || policyFeature.getDirection() == null) {
                    this.addPolicyReference((WSDLExtensible)wSDLBoundPortType, (PolicyStatement)serializable);
                    continue;
                }
                arrayList.add(policyFeature);
            }
        }
        for (PolicyFeature policyFeature : wSDLBoundPortType.getBindingOperations()) {
            object = new ArrayList(arrayList);
            serializable = policyFeature.getName();
            List<PolicyFeature> list2 = this.targets.get(serializable);
            if (list2 != null) {
                object.addAll(list2);
            }
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                PolicyFeature policyFeature2 = (PolicyFeature)iterator.next();
                String string = policyFeature2.getUri();
                PolicyStatement policyStatement = this.policies.get(string);
                if (policyStatement == null) continue;
                PolicyFeature policyFeature3 = policyFeature;
                if (Policy.Direction.inbound.equals((Object)policyFeature2.getDirection())) {
                    policyFeature3 = (WSDLExtensible)policyFeature.getExtension(WSDLParserExtension.PseudoBoundInputExtensible.class);
                } else if (Policy.Direction.outbound.equals((Object)policyFeature2.getDirection())) {
                    policyFeature3 = (WSDLExtensible)policyFeature.getExtension(WSDLParserExtension.PseudoBoundOutputExtensible.class);
                }
                if (policyFeature3 == null) continue;
                this.addPolicyReference((WSDLExtensible)policyFeature3, policyStatement);
            }
        }
    }

    private void addPolicyReference(WSDLExtensible wSDLExtensible, PolicyStatement policyStatement) {
        WsdlExtensible wsdlExtensible = WsdlExtensibleHolder.get(wSDLExtensible);
        PolicyWsdlExtension policyWsdlExtension = (PolicyWsdlExtension)wsdlExtensible.getExtension("Policy");
        if (policyWsdlExtension == null) {
            policyWsdlExtension = new PolicyWsdlExtension();
            wsdlExtensible.putExtension(policyWsdlExtension);
        }
        policyWsdlExtension.addPolicy(policyStatement);
    }

    private void writePolicyReference(Object object, String string) {
        if (object instanceof TypedXmlWriter) {
            PolicyReferenceElement policyReferenceElement = (PolicyReferenceElement)((TypedXmlWriter)object)._element(PolicyReferenceElement.class);
            policyReferenceElement.URI(string);
        } else {
            try {
                XMLStreamWriter xMLStreamWriter = (XMLStreamWriter)object;
                xMLStreamWriter.writeStartElement("http://schemas.xmlsoap.org/ws/2004/09/policy", "PolicyReference");
                xMLStreamWriter.writeAttribute("URI", string);
                xMLStreamWriter.writeEndElement();
            }
            catch (XMLStreamException xMLStreamException) {
                throw new WebServiceException((Throwable)xMLStreamException);
            }
        }
    }

    public void addDefinitionsExtension(TypedXmlWriter typedXmlWriter) {
        this.addDefinitionsExtension((Object)typedXmlWriter);
    }

    protected void addDefinitionsExtension(XMLStreamWriter xMLStreamWriter, boolean bl, boolean bl2) {
        this.addDefinitionsExtension((Object)xMLStreamWriter, bl, bl2);
    }

    private void addDefinitionsExtension(Object object) {
        this.addDefinitionsExtension(object, false, false);
    }

    private void addDefinitionsExtension(Object object, boolean bl, boolean bl2) {
        if (!this.policies.isEmpty()) {
            Object object2;
            if (!bl2) {
                WriterUtil.writeNamespace(object, "http://schemas.xmlsoap.org/ws/2004/09/policy", "wsp");
            }
            if (!bl) {
                WriterUtil.writeNamespace(object, "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "wssutil");
            }
            if (object instanceof TypedXmlWriter) {
                object2 = (UsingPolicyElement)((TypedXmlWriter)object)._element(UsingPolicyElement.class);
                object2.Required(true);
            } else {
                try {
                    object2 = (XMLStreamWriter)object;
                    object2.writeStartElement("http://schemas.xmlsoap.org/ws/2004/09/policy", "UsingPolicy");
                    object2.writeAttribute("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Required", "true");
                    object2.writeEndElement();
                }
                catch (XMLStreamException xMLStreamException) {
                    throw new WebServiceException((Throwable)xMLStreamException);
                }
            }
        }
        for (PolicyStatement policyStatement : this.policies.values()) {
            this.writePolicy(policyStatement, object);
        }
    }

    public boolean isEmpty() {
        return this.policies.isEmpty();
    }

    private void writePolicy(PolicyStatement policyStatement, Object object) {
        block3: {
            if (policyStatement != null) {
                try {
                    Element element = policyStatement.toXML();
                    String string = policyStatement.getId();
                    WriterUtil.writeElement(element, string, object);
                }
                catch (PolicyException policyException) {
                    if (!verbose) break block3;
                    Verbose.log("Couldn't convert policy to XML!");
                }
            }
        }
    }

    @XmlElement(ns="http://schemas.xmlsoap.org/ws/2004/09/policy", value="PolicyReference")
    private static interface PolicyReferenceElement
    extends TypedXmlWriter {
        @XmlAttribute
        public void URI(String var1);
    }

    @XmlElement(ns="http://schemas.xmlsoap.org/ws/2004/09/policy", value="UsingPolicy")
    private static interface UsingPolicyElement
    extends TypedXmlWriter {
        @XmlAttribute(ns="http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd")
        public void Required(boolean var1);
    }
}

