/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.jaxws.framework.policy;

import com.sun.xml.ws.api.model.wsdl.WSDLBoundOperation;
import com.sun.xml.ws.api.model.wsdl.WSDLBoundPortType;
import com.sun.xml.ws.api.model.wsdl.WSDLExtensible;
import com.sun.xml.ws.api.model.wsdl.WSDLExtension;
import com.sun.xml.ws.api.model.wsdl.WSDLMessage;
import com.sun.xml.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.ws.api.model.wsdl.WSDLPortType;
import com.sun.xml.ws.api.model.wsdl.WSDLService;
import com.sun.xml.ws.api.wsdl.parser.WSDLParserExtensionContext;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.ws.WebServiceException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.Locator;
import weblogic.wsee.jaxws.framework.jaxrpc.WsdlExtensibleHolder;
import weblogic.wsee.jaxws.framework.policy.PolicyReferencedByAttributeWsdlExtension;
import weblogic.wsee.policy.deployment.PolicyLoader;
import weblogic.wsee.policy.deployment.PolicyReferenceWsdlExtension;
import weblogic.wsee.policy.deployment.PolicyWsdlExtension;
import weblogic.wsee.policy.deployment.ProviderRegistry;
import weblogic.wsee.policy.deployment.UsingPolicy;
import weblogic.wsee.policy.framework.DOMUtils;
import weblogic.wsee.policy.framework.PolicyConstants;
import weblogic.wsee.policy.framework.PolicyException;
import weblogic.wsee.policy.framework.PolicyStatement;
import weblogic.wsee.policy.runtime.PolicyServer;
import weblogic.wsee.util.StringUtil;
import weblogic.wsee.wsdl.WsdlExtensible;
import weblogic.wsee.wsdl.WsdlExtension;

public class WSDLParserExtension
extends com.sun.xml.ws.api.wsdl.parser.WSDLParserExtension {
    private PolicyLoader loader;
    private WSDLParserExtensionContext context;
    private Map<WSDLBoundOperation, WSDLExtensible> opInputs = new HashMap<WSDLBoundOperation, WSDLExtensible>();
    private Map<WSDLBoundOperation, WSDLExtensible> opOutputs = new HashMap<WSDLBoundOperation, WSDLExtensible>();

    public boolean bindingElements(WSDLBoundPortType wSDLBoundPortType, XMLStreamReader xMLStreamReader) {
        return this.checkPolicyReferenceAndPolicy(xMLStreamReader, (WSDLExtensible)wSDLBoundPortType);
    }

    public void portTypeAttributes(WSDLPortType wSDLPortType, XMLStreamReader xMLStreamReader) {
        this.checkPolicyReferencedByAttributes(xMLStreamReader, (WSDLExtensible)wSDLPortType);
    }

    public boolean bindingOperationElements(WSDLBoundOperation wSDLBoundOperation, XMLStreamReader xMLStreamReader) {
        return this.checkPolicyReferenceAndPolicy(xMLStreamReader, (WSDLExtensible)wSDLBoundOperation);
    }

    public void bindingOperationAttributes(WSDLBoundOperation wSDLBoundOperation, XMLStreamReader xMLStreamReader) {
        WSDLExtension wSDLExtension = wSDLBoundOperation.getExtension(PseudoBoundInputExtensible.class);
        if (wSDLExtension == null) {
            wSDLExtension = new PseudoBoundInputExtensible();
            wSDLBoundOperation.addExtension(wSDLExtension);
        }
        if ((wSDLExtension = wSDLBoundOperation.getExtension(PseudoBoundOutputExtensible.class)) == null) {
            wSDLExtension = new PseudoBoundOutputExtensible();
            wSDLBoundOperation.addExtension(wSDLExtension);
        }
    }

    public boolean bindingOperationInputElements(WSDLBoundOperation wSDLBoundOperation, XMLStreamReader xMLStreamReader) {
        WSDLExtension wSDLExtension = wSDLBoundOperation.getExtension(PseudoBoundInputExtensible.class);
        return this.checkPolicyReferenceAndPolicy(xMLStreamReader, (WSDLExtensible)wSDLExtension);
    }

    public boolean bindingOperationOutputElements(WSDLBoundOperation wSDLBoundOperation, XMLStreamReader xMLStreamReader) {
        WSDLExtension wSDLExtension = wSDLBoundOperation.getExtension(PseudoBoundOutputExtensible.class);
        return this.checkPolicyReferenceAndPolicy(xMLStreamReader, (WSDLExtensible)wSDLExtension);
    }

    public void finished(WSDLParserExtensionContext wSDLParserExtensionContext) {
        WsdlExtensible wsdlExtensible;
        WsdlExtensible wsdlExtensible2;
        for (Map.Entry<WSDLBoundOperation, WSDLExtensible> entry : this.opInputs.entrySet()) {
            wsdlExtensible2 = WsdlExtensibleHolder.get(entry.getValue());
            wsdlExtensible = WsdlExtensibleHolder.get((WSDLExtensible)entry.getKey().getOperation().getInput());
            for (List<WsdlExtension> list : wsdlExtensible2.getExtensions().values()) {
                for (WsdlExtension wsdlExtension : list) {
                    wsdlExtensible.putExtension(wsdlExtension);
                }
            }
        }
        for (Map.Entry<WSDLBoundOperation, WSDLExtensible> entry : this.opOutputs.entrySet()) {
            wsdlExtensible2 = WsdlExtensibleHolder.get(entry.getValue());
            wsdlExtensible = WsdlExtensibleHolder.get((WSDLExtensible)entry.getKey().getOperation().getOutput());
            for (List<WsdlExtension> list : wsdlExtensible2.getExtensions().values()) {
                for (WsdlExtension wsdlExtension : list) {
                    wsdlExtensible.putExtension(wsdlExtension);
                }
            }
        }
    }

    private boolean checkUsingPolicy(XMLStreamReader xMLStreamReader, WSDLExtensible wSDLExtensible) {
        if ("UsingPolicy".equals(xMLStreamReader.getLocalName()) && ("http://schemas.xmlsoap.org/ws/2004/09/policy".equals(xMLStreamReader.getNamespaceURI()) || "http://www.w3.org/ns/ws-policy".equals(xMLStreamReader.getNamespaceURI()))) {
            String string = xMLStreamReader.getAttributeValue(PolicyConstants.WSDL_NAMESPACE_URI, "Required");
            boolean bl = "true".equalsIgnoreCase(string);
            WsdlExtensibleHolder.get(wSDLExtensible).putExtension(new UsingPolicy(bl));
        }
        return false;
    }

    private boolean isPolicy(XMLStreamReader xMLStreamReader) {
        return "Policy".equals(xMLStreamReader.getLocalName()) && ("http://schemas.xmlsoap.org/ws/2004/09/policy".equals(xMLStreamReader.getNamespaceURI()) || "http://www.w3.org/ns/ws-policy".equals(xMLStreamReader.getNamespaceURI()));
    }

    private boolean isPolicyReference(XMLStreamReader xMLStreamReader) {
        return "PolicyReference".equals(xMLStreamReader.getLocalName()) && ("http://schemas.xmlsoap.org/ws/2004/09/policy".equals(xMLStreamReader.getNamespaceURI()) || "http://www.w3.org/ns/ws-policy".equals(xMLStreamReader.getNamespaceURI()));
    }

    private String getPolicyReferenceUri(XMLStreamReader xMLStreamReader) {
        String string = xMLStreamReader.getAttributeValue("http://schemas.xmlsoap.org/ws/2004/09/policy", "PolicyURIs");
        if (string == null) {
            string = xMLStreamReader.getAttributeValue("http://www.w3.org/ns/ws-policy", "PolicyURIs");
        }
        return string;
    }

    private void checkPolicyReferencedByAttributes(XMLStreamReader xMLStreamReader, WSDLExtensible wSDLExtensible) {
        String string = this.getPolicyReferenceUri(xMLStreamReader);
        if (string != null && string.trim().length() > 0) {
            WsdlExtensible wsdlExtensible = WsdlExtensibleHolder.get(wSDLExtensible);
            PolicyReferencedByAttributeWsdlExtension policyReferencedByAttributeWsdlExtension = null;
            try {
                policyReferencedByAttributeWsdlExtension = new PolicyReferencedByAttributeWsdlExtension(string);
                wsdlExtensible.putExtension(policyReferencedByAttributeWsdlExtension);
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new WebServiceException((Throwable)uRISyntaxException);
            }
        }
    }

    private boolean checkPolicy(XMLStreamReader xMLStreamReader, WSDLExtensible wSDLExtensible) {
        if (this.isPolicy(xMLStreamReader)) {
            WsdlExtensible wsdlExtensible = WsdlExtensibleHolder.get(wSDLExtensible);
            PolicyWsdlExtension policyWsdlExtension = (PolicyWsdlExtension)wsdlExtensible.getExtension("Policy");
            if (policyWsdlExtension == null) {
                policyWsdlExtension = new PolicyWsdlExtension();
                wsdlExtensible.putExtension(policyWsdlExtension);
            }
            policyWsdlExtension.addPolicy(this.parsePolicy(xMLStreamReader));
            return true;
        }
        return false;
    }

    private boolean checkPolicyReferenceAndPolicy(XMLStreamReader xMLStreamReader, WSDLExtensible wSDLExtensible) {
        if (this.isPolicyReference(xMLStreamReader)) {
            WsdlExtensible wsdlExtensible = WsdlExtensibleHolder.get(wSDLExtensible);
            PolicyReferenceWsdlExtension policyReferenceWsdlExtension = (PolicyReferenceWsdlExtension)wsdlExtensible.getExtension("PolicyReference");
            if (policyReferenceWsdlExtension == null) {
                policyReferenceWsdlExtension = new PolicyReferenceWsdlExtension();
                wsdlExtensible.putExtension(policyReferenceWsdlExtension);
            }
            try {
                policyReferenceWsdlExtension.addURI(new URI(xMLStreamReader.getAttributeValue(null, "URI")));
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new WebServiceException((Throwable)uRISyntaxException);
            }
            return false;
        }
        if (this.isPolicy(xMLStreamReader)) {
            WsdlExtensible wsdlExtensible = WsdlExtensibleHolder.get(wSDLExtensible);
            PolicyWsdlExtension policyWsdlExtension = (PolicyWsdlExtension)wsdlExtensible.getExtension("Policy");
            if (policyWsdlExtension == null) {
                policyWsdlExtension = new PolicyWsdlExtension();
                wsdlExtensible.putExtension(policyWsdlExtension);
            }
            Node node = this.parseNode(xMLStreamReader);
            NodeList nodeList = node.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node2 = nodeList.item(i);
                if (node2.getNodeType() != 1 || !DOMUtils.equalsQName(node2, PolicyConstants.POLICY_INCLUDE) && !DOMUtils.equalsQName(node2, PolicyConstants.POLICY_INCLUDE_15)) continue;
                PolicyReferenceWsdlExtension policyReferenceWsdlExtension = (PolicyReferenceWsdlExtension)wsdlExtensible.getExtension("PolicyReference");
                if (policyReferenceWsdlExtension == null) {
                    policyReferenceWsdlExtension = new PolicyReferenceWsdlExtension();
                    wsdlExtensible.putExtension(policyReferenceWsdlExtension);
                }
                try {
                    policyReferenceWsdlExtension.addURI(DOMUtils.getAttributeValueAsURI((Element)node2, PolicyConstants.POLICY_INCLUDE_URI_REF_ATTRIBUTE));
                    continue;
                }
                catch (URISyntaxException uRISyntaxException) {
                    throw new WebServiceException((Throwable)uRISyntaxException);
                }
            }
            policyWsdlExtension.addPolicy(this.parsePolicy(node));
            return true;
        }
        return false;
    }

    public boolean definitionsElements(XMLStreamReader xMLStreamReader) {
        if (this.checkUsingPolicy(xMLStreamReader, (WSDLExtensible)this.context.getWSDLModel())) {
            return true;
        }
        return this.checkPolicy(xMLStreamReader, (WSDLExtensible)this.context.getWSDLModel());
    }

    public boolean messageElements(WSDLMessage wSDLMessage, XMLStreamReader xMLStreamReader) {
        return this.checkPolicyReferenceAndPolicy(xMLStreamReader, (WSDLExtensible)wSDLMessage);
    }

    public boolean portElements(WSDLPort wSDLPort, XMLStreamReader xMLStreamReader) {
        return this.checkPolicyReferenceAndPolicy(xMLStreamReader, (WSDLExtensible)wSDLPort);
    }

    public boolean serviceElements(WSDLService wSDLService, XMLStreamReader xMLStreamReader) {
        return this.checkPolicyReferenceAndPolicy(xMLStreamReader, (WSDLExtensible)wSDLService);
    }

    public void start(WSDLParserExtensionContext wSDLParserExtensionContext) {
        this.context = wSDLParserExtensionContext;
        try {
            this.loader = new PolicyLoader(ProviderRegistry.getTheRegistry(), (PolicyServer)wSDLParserExtensionContext.getContainer().getSPI(PolicyServer.class));
        }
        catch (PolicyException policyException) {
            throw new WebServiceException((Throwable)policyException);
        }
    }

    private PolicyStatement parsePolicy(XMLStreamReader xMLStreamReader) {
        return this.parsePolicy(this.parseNode(xMLStreamReader));
    }

    private PolicyStatement parsePolicy(Node node) {
        try {
            return this.loader.load(node);
        }
        catch (PolicyException policyException) {
            throw new WebServiceException((Throwable)policyException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Node parseNode(XMLStreamReader xMLStreamReader) {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            documentBuilderFactory.setValidating(false);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            Element element = document.createElementNS(xMLStreamReader.getNamespaceURI(), xMLStreamReader.getLocalName());
            this.parseNamespaces(xMLStreamReader, element);
            this.parseAttributes(xMLStreamReader, element);
            ArrayList<Element> arrayList = new ArrayList<Element>();
            arrayList.add(element);
            int n = 1;
            StringBuffer stringBuffer = null;
            do {
                xMLStreamReader.next();
                Element element2 = (Element)arrayList.get(arrayList.size() - 1);
                switch (xMLStreamReader.getEventType()) {
                    case 1: {
                        ++n;
                        Element element3 = document.createElementNS(xMLStreamReader.getNamespaceURI(), xMLStreamReader.getLocalName());
                        element2.appendChild(element3);
                        arrayList.add(element3);
                        this.parseNamespaces(xMLStreamReader, element3);
                        this.parseAttributes(xMLStreamReader, element3);
                        break;
                    }
                    case 13: {
                        this.parseNamespaces(xMLStreamReader, element2);
                        break;
                    }
                    case 10: {
                        this.parseAttributes(xMLStreamReader, element2);
                        break;
                    }
                    case 2: {
                        if (stringBuffer != null) {
                            element2.appendChild(document.createTextNode(stringBuffer.toString()));
                            stringBuffer = null;
                        }
                        if (--n == 0) {
                            return element;
                        }
                        arrayList.remove(arrayList.size() - 1);
                        break;
                    }
                    case 4: {
                        if (stringBuffer == null) {
                            stringBuffer = new StringBuffer();
                        }
                        stringBuffer.append(xMLStreamReader.getText());
                    }
                }
            } while (xMLStreamReader.hasNext());
            return element;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new WebServiceException((Throwable)parserConfigurationException);
        }
        catch (XMLStreamException xMLStreamException) {
            throw new WebServiceException((Throwable)xMLStreamException);
        }
    }

    private void parseAttributes(XMLStreamReader xMLStreamReader, Element element) {
        for (int i = 0; i < xMLStreamReader.getAttributeCount(); ++i) {
            Attr attr = element.getOwnerDocument().createAttributeNS(xMLStreamReader.getAttributeNamespace(i), xMLStreamReader.getAttributeLocalName(i));
            attr.setValue(xMLStreamReader.getAttributeValue(i));
            element.setAttributeNodeNS(attr);
        }
    }

    private void parseNamespaces(XMLStreamReader xMLStreamReader, Element element) {
        for (int i = 0; i < xMLStreamReader.getNamespaceCount(); ++i) {
            String string = xMLStreamReader.getNamespacePrefix(i);
            String string2 = !StringUtil.isEmpty(string) ? "xmlns:" + string : "xmlns";
            Attr attr = element.getOwnerDocument().createAttributeNS("http://www.w3.org/2000/xmlns/", string2);
            attr.setValue(xMLStreamReader.getNamespaceURI(i));
            element.setAttributeNodeNS(attr);
        }
    }

    public static class PseudoBoundOutputExtensible
    extends PseudoExtensible
    implements WSDLExtension {
        public QName getName() {
            return null;
        }
    }

    public static class PseudoBoundInputExtensible
    extends PseudoExtensible
    implements WSDLExtension {
        public QName getName() {
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PseudoExtensible
    implements WSDLExtensible {
        private final Set<WSDLExtension> extensions = new HashSet<WSDLExtension>();

        private PseudoExtensible() {
        }

        public void addExtension(WSDLExtension wSDLExtension) {
            this.extensions.add(wSDLExtension);
        }

        public <T extends WSDLExtension> T getExtension(Class<T> clazz) {
            for (WSDLExtension wSDLExtension : this.extensions) {
                if (!clazz.isInstance(wSDLExtension)) continue;
                return (T)((WSDLExtension)clazz.cast(wSDLExtension));
            }
            return null;
        }

        public Iterable<WSDLExtension> getExtensions() {
            return this.extensions;
        }

        public <T extends WSDLExtension> Iterable<T> getExtensions(Class<T> clazz) {
            ArrayList<T> arrayList = new ArrayList<T>(this.extensions.size());
            for (WSDLExtension wSDLExtension : this.extensions) {
                if (!clazz.isInstance(wSDLExtension)) continue;
                arrayList.add(clazz.cast(wSDLExtension));
            }
            return arrayList;
        }

        public Locator getLocation() {
            throw new UnsupportedOperationException();
        }
    }
}

