/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.jaxws.framework.policy.advertisementimpl;

import com.sun.xml.ws.addressing.W3CAddressingConstants;
import com.sun.xml.ws.addressing.v200408.MemberSubmissionAddressingConstants;
import com.sun.xml.ws.api.server.DocumentAddressResolver;
import com.sun.xml.ws.api.server.PortAddressResolver;
import com.sun.xml.ws.api.server.SDDocument;
import com.sun.xml.ws.api.server.WSEndpoint;
import com.sun.xml.ws.api.streaming.XMLStreamReaderFactory;
import com.sun.xml.ws.api.streaming.XMLStreamWriterFactory;
import com.sun.xml.ws.server.SDDocumentImpl;
import com.sun.xml.ws.server.ServiceDefinitionImpl;
import com.sun.xml.ws.server.WSEndpointImpl;
import com.sun.xml.ws.transport.http.WSHTTPConnection;
import com.sun.xml.ws.util.ByteArrayBuffer;
import com.sun.xml.ws.util.JAXWSUtils;
import com.sun.xml.ws.util.RuntimeVersion;
import com.sun.xml.ws.util.ServiceFinder;
import com.sun.xml.ws.util.xml.XMLStreamReaderToXMLStreamWriter;
import com.sun.xml.ws.wsdl.parser.WSDLConstants;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.ws.WebServiceException;
import org.xml.sax.InputSource;
import weblogic.wsee.jaxws.WLSServletAdapter;
import weblogic.wsee.jaxws.framework.policy.EnvironmentMetadataFactory;
import weblogic.wsee.jaxws.framework.policy.PolicyAdvertisementFilter;
import weblogic.wsee.jaxws.framework.policy.PolicySubjectBinding;
import weblogic.wsee.jaxws.framework.policy.advertisementimpl.AdvertisementHelper;
import weblogic.wsee.jws.jaxws.owsm.PolicySubjectBindingFeature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdvertisementHelperImpl
implements AdvertisementHelper {
    static final String WSDLFACTORY_CLASS_NAME = "javax.wsdl.factory.WSDLFactory";
    static final String ADDRESSINGEXTREG_CLASS_NAME = "oracle.j2ee.ws.wsdl.extensions.addressing.AddressingExtensionRegistry";
    static final String PARTNERLINKEXTREG_CLASS_NAME = "oracle.j2ee.ws.wsdl.extensions.partnerlink.PartnerLinkExtensionRegistry";
    static final String SCHEMAEXTREG_CLASS_NAME = "oracle.j2ee.ws.wsdl.extensions.oracle.schema.SchemaExtension";
    static final String JMSEXTREG_CLASS_NAME = "oracle.j2ee.ws.wsdl.extensions.jms.JMSExtensions";
    static final String DIMEEXTREG_CLASS_NAME = "oracle.j2ee.ws.wsdl.extensions.oracle.dime.DimeExtension";
    static final String STREAMATTACHMENTSEXTREG_CLASS_NAME = "oracle.j2ee.ws.wsdl.extensions.oracle.streaming.StreamAttachmentsExtension";
    static final String JAVAEXTREG_CLASS_NAME = "oracle.j2ee.ws.wsdl.extensions.wsif.java.JavaExtensionRegistry";
    static final String EJBEXTREG_CLASS_NAME = "oracle.j2ee.ws.wsdl.extensions.wsif.ejb.EJBExtensionRegistry";
    static final String FORMATEXTREG_CLASS_NAME = "oracle.j2ee.ws.wsdl.extensions.wsif.format.FormatExtensionRegistry";
    static final String POLICYEXTREG_CLASS_NAME = "oracle.wsm.policy.wsdl.extensions.PolicyExtensionRegistry";
    private static final String VERSION_COMMENT = " Published by JAX-WS RI at http://jax-ws.dev.java.net. RI's version is " + RuntimeVersion.VERSION + ". ";
    private static final Logger logger = Logger.getLogger(AdvertisementHelperImpl.class.getName());

    @Override
    public boolean hasPolicyAdvertisementFilter() {
        PolicyAdvertisementFilter policyAdvertisementFilter = this.getPolicyAdvertisementFilter();
        return policyAdvertisementFilter != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean handleAdvertisementRequest(SDDocument sDDocument, WSEndpoint<?> wSEndpoint, WSHTTPConnection wSHTTPConnection, PortAddressResolver portAddressResolver, DocumentAddressResolver documentAddressResolver) throws IOException {
        PolicySubjectBindingFeature policySubjectBindingFeature;
        PolicyAdvertisementFilter.MetadataType metadataType;
        PolicyAdvertisementFilter policyAdvertisementFilter = this.getPolicyAdvertisementFilter();
        if (policyAdvertisementFilter != null && (metadataType = this.getMetadataType(wSHTTPConnection.getQueryString())) != null && (policySubjectBindingFeature = (PolicySubjectBindingFeature)wSEndpoint.getBinding().getFeature(PolicySubjectBindingFeature.class)) != null && policySubjectBindingFeature.hasPolicyReferences()) {
            policyAdvertisementFilter.setEnvironmentMetadata(EnvironmentMetadataFactory.getEnvironmentMetadata());
            ArrayList<PolicySubjectBinding> arrayList = new ArrayList<PolicySubjectBinding>();
            arrayList.add(policySubjectBindingFeature.getPolicySubjectBinding());
            policyAdvertisementFilter.setPolicySubjectBindings(arrayList);
            InputStream inputStream = null;
            OutputStream outputStream = null;
            try {
                Object object;
                InputSource inputSource = null;
                String string = null;
                boolean bl = false;
                URL uRL = JAXWSUtils.getEncodedURL((String)((SDDocumentImpl)sDDocument).getSystemId().toExternalForm());
                inputStream = this.getWsdlFrom(uRL);
                if (inputStream != null) {
                    inputSource = new InputSource(inputStream);
                    string = uRL.toExternalForm();
                    bl = true;
                } else {
                    object = new ByteArrayBuffer();
                    sDDocument.writeTo(portAddressResolver, documentAddressResolver, (OutputStream)object);
                    inputSource = new InputSource(object.newInputStream());
                    string = sDDocument.getURL().toExternalForm();
                }
                object = AdvertisementHelperImpl.queryParametersToMap(wSHTTPConnection.getQueryString());
                object.put("oracle.wsm.dont.remove.existing.policies", "true");
                Object object2 = this.readWSDL(inputSource, string);
                Class clazz = this.getDefinitionClass(policyAdvertisementFilter.getClass().getClassLoader());
                this.invokeMethod(policyAdvertisementFilter, "advertise", new Class[]{clazz, String.class, Map.class}, new Object[]{object2, metadataType.name(), object});
                this.dumpDefinition(object2, "after WSM advertisement");
                wSHTTPConnection.setStatus(200);
                wSHTTPConnection.setContentTypeResponseHeader("text/xml;charset=\"utf-8\"");
                Object object3 = outputStream = wSHTTPConnection.getProtocol().contains("1.1") ? wSHTTPConnection.getOutput() : new Http10OutputStream(wSHTTPConnection);
                if (bl) {
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    this.writeWSDL(object2, byteArrayOutputStream);
                    this.postProcessWSDL(sDDocument, wSEndpoint, portAddressResolver, documentAddressResolver, new ByteArrayInputStream(byteArrayOutputStream.toByteArray()), outputStream);
                } else {
                    this.writeWSDL(object2, outputStream);
                }
                boolean bl2 = true;
                return bl2;
            }
            finally {
                if (inputStream != null) {
                    inputStream.close();
                }
                if (outputStream != null) {
                    outputStream.close();
                }
            }
        }
        return false;
    }

    @Override
    public Object readWSDL(URL uRL, InputSource inputSource) throws IOException {
        if (inputSource != null) {
            return this.readWSDL(inputSource, uRL.toExternalForm());
        }
        logger.warning("readWSDL; cannot proceed the wsdl parameter is null.");
        return null;
    }

    private PolicyAdvertisementFilter getPolicyAdvertisementFilter() {
        PolicyAdvertisementFilter policyAdvertisementFilter = null;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Iterator iterator = ServiceFinder.find(PolicyAdvertisementFilter.class, (ClassLoader)classLoader).iterator();
        if (iterator.hasNext()) {
            policyAdvertisementFilter = (PolicyAdvertisementFilter)iterator.next();
            if (iterator.hasNext()) {
                throw new WebServiceException("More than one Filter for OWSM Policy Advertisement found.");
            }
        }
        return policyAdvertisementFilter;
    }

    private PolicyAdvertisementFilter.MetadataType getMetadataType(String string) {
        try {
            String string2 = WLSServletAdapter.getRequestCmd(string);
            if (string2 != null) {
                return PolicyAdvertisementFilter.MetadataType.valueOf(string2.toUpperCase(Locale.ENGLISH));
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return null;
    }

    private Object readWSDL(InputSource inputSource, String string) throws IOException {
        Object object = this.getWSDLFactory();
        Object object2 = this.invokeMethod(object, "newPopulatedExtensionRegistry", null, null);
        this.registerExtension(ADDRESSINGEXTREG_CLASS_NAME, object2);
        this.registerExtension(PARTNERLINKEXTREG_CLASS_NAME, object2);
        try {
            this.registerExtension(SCHEMAEXTREG_CLASS_NAME, object2);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.registerExtension(JMSEXTREG_CLASS_NAME, object2);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.registerExtension(DIMEEXTREG_CLASS_NAME, object2);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.registerExtension(STREAMATTACHMENTSEXTREG_CLASS_NAME, object2);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.registerExtension(JAVAEXTREG_CLASS_NAME, object2);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.registerExtension(EJBEXTREG_CLASS_NAME, object2);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.registerExtension(FORMATEXTREG_CLASS_NAME, object2);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.registerExtension(POLICYEXTREG_CLASS_NAME, object2, Level.FINE);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        Object object3 = this.invokeMethod(object, "newWSDLReader", null, null);
        this.invokeMethod(object3, "setExtensionRegistry", new Class[]{object2.getClass()}, new Object[]{object2});
        this.invokeMethod(object3, "setFeature", new Class[]{String.class, Boolean.TYPE}, new Object[]{"javax.wsdl.verbose", false});
        this.invokeMethod(object3, "setFeature", new Class[]{String.class, Boolean.TYPE}, new Object[]{"javax.wsdl.importDocuments", false});
        Object object4 = this.invokeMethod(object3, "readWSDL", new Class[]{String.class, InputSource.class}, new Object[]{string, inputSource});
        this.dumpDefinition(object4, "after reading from source");
        return object4;
    }

    private void dumpDefinition(Object object, String string) {
        if (logger.isLoggable(Level.FINE)) {
            if (object == null) {
                logger.fine("AdvertisementHelper: dumping Definition " + string + "; null");
            } else {
                try {
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    this.writeWSDL(object, byteArrayOutputStream);
                    logger.fine("AdvertisementHelper: dumping Definition " + string + "; " + byteArrayOutputStream.toString());
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
        }
    }

    private InputStream getWsdlFrom(URL uRL) {
        InputStream inputStream = null;
        try {
            inputStream = uRL.openStream();
        }
        catch (Throwable throwable) {
            inputStream = null;
        }
        return inputStream;
    }

    private void postProcessWSDL(SDDocument sDDocument, WSEndpoint<?> wSEndpoint, PortAddressResolver portAddressResolver, DocumentAddressResolver documentAddressResolver, InputStream inputStream, OutputStream outputStream) throws IOException {
        XMLStreamReader xMLStreamReader = XMLStreamReaderFactory.create(null, (InputStream)inputStream, (String)"UTF-8", (boolean)false);
        XMLStreamWriter xMLStreamWriter = null;
        try {
            xMLStreamWriter = XMLStreamWriterFactory.create((OutputStream)outputStream, (String)"UTF-8");
            xMLStreamWriter.writeStartDocument("UTF-8", "1.0");
            xMLStreamWriter.writeComment(VERSION_COMMENT);
            new DefnPatcher((WSEndpointImpl)wSEndpoint, (SDDocumentImpl)sDDocument, portAddressResolver, documentAddressResolver).bridge(xMLStreamReader, xMLStreamWriter);
            xMLStreamWriter.writeEndDocument();
        }
        catch (XMLStreamException xMLStreamException) {
            IOException iOException = new IOException(xMLStreamException.getMessage());
            iOException.initCause(xMLStreamException);
            throw iOException;
        }
        finally {
            try {
                if (xMLStreamReader != null) {
                    xMLStreamReader.close();
                }
            }
            catch (XMLStreamException xMLStreamException) {
                IOException iOException = new IOException(xMLStreamException.getMessage());
                iOException.initCause(xMLStreamException);
                throw iOException;
            }
            try {
                if (xMLStreamWriter != null) {
                    xMLStreamWriter.close();
                }
            }
            catch (XMLStreamException xMLStreamException) {
                IOException iOException = new IOException(xMLStreamException.getMessage());
                iOException.initCause(xMLStreamException);
                throw iOException;
            }
        }
    }

    private Class getDefinitionClass(ClassLoader classLoader) {
        Class<?> clazz = null;
        try {
            if (classLoader == null) {
                logger.fine("ClassLoader argument is null, will use my classloader.");
                classLoader = this.getClass().getClassLoader();
            }
            if (classLoader != null) {
                clazz = classLoader.loadClass("javax.wsdl.Definition");
            } else {
                logger.warning("Unable to load javax.wsdl.Definition, ClassLoader is null.");
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new WebServiceException((Throwable)classNotFoundException);
        }
        return clazz;
    }

    private void registerExtension(String string, Object object) {
        this.registerExtension(string, object, Level.WARNING);
    }

    private void registerExtension(String string, Object object, Level level) {
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            Class<?> clazz = classLoader.loadClass(string);
            Method method = clazz.getMethod("registerSerializersAndTypes", object.getClass());
            method.invoke(null, object);
        }
        catch (Exception exception) {
            logger.log(level, "Registering " + string + " extension failed; " + exception.getClass().getName() + ": " + exception.getMessage());
            throw new WebServiceException((Throwable)exception);
        }
    }

    @Override
    public void writeWSDL(Object object, OutputStream outputStream) throws IOException {
        Object object2 = this.getWSDLFactory();
        Object object3 = this.invokeMethod(object2, "newWSDLWriter", null, null);
        Class clazz = this.getDefinitionClass(object.getClass().getClassLoader());
        if (clazz != null) {
            this.invokeMethod(object3, "writeWSDL", new Class[]{clazz, OutputStream.class}, new Object[]{object, outputStream});
        }
    }

    @Override
    public String getDocumentBaseUriFromWSDL(Object object) {
        Object[] objectArray;
        Class[] classArray;
        Object object2;
        if (object == null) {
            return null;
        }
        Class clazz = this.getDefinitionClass(object.getClass().getClassLoader());
        if (clazz != null && (object2 = this.invokeMethod(object, "getDocumentBaseURI", classArray = new Class[0], objectArray = new Object[0])) != null) {
            return object2.toString();
        }
        return null;
    }

    private static Map<String, String> queryParametersToMap(String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String[] stringArray = string.split("&");
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            int n = string2.indexOf(61);
            String string3 = null;
            String string4 = null;
            if (n > -1) {
                string3 = string2.substring(0, n);
                string4 = string2.substring(n + 1);
            } else {
                string3 = string2;
            }
            hashMap.put(string3, string4);
        }
        return hashMap;
    }

    private Object getWSDLFactory() {
        Object object = null;
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            Class<?> clazz = classLoader.loadClass(WSDLFACTORY_CLASS_NAME);
            Method method = clazz.getMethod("newInstance", null);
            object = method.invoke(null, (Object[])null);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new WebServiceException((Throwable)noSuchMethodException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new WebServiceException((Throwable)illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new WebServiceException((Throwable)invocationTargetException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new WebServiceException((Throwable)classNotFoundException);
        }
        return object;
    }

    private Object invokeMethod(Object object, String string, Class[] classArray, Object[] objectArray) {
        try {
            Method method = object.getClass().getMethod(string, classArray);
            return method.invoke(object, objectArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new WebServiceException((Throwable)noSuchMethodException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new WebServiceException((Throwable)illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new WebServiceException((Throwable)invocationTargetException);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class DefnPatcher
    extends XMLStreamReaderToXMLStreamWriter {
        private static final String NS_XSD = "http://www.w3.org/2001/XMLSchema";
        private static final QName SCHEMA_INCLUDE_QNAME = new QName("http://www.w3.org/2001/XMLSchema", "include");
        private static final QName SCHEMA_IMPORT_QNAME = new QName("http://www.w3.org/2001/XMLSchema", "import");
        private static final QName SCHEMA_REDEFINE_QNAME = new QName("http://www.w3.org/2001/XMLSchema", "redefine");
        private static final Logger logger = Logger.getLogger(DefnPatcher.class.getName());
        private final WSEndpointImpl<?> endpoint;
        private final SDDocumentImpl current;
        private final DocumentAddressResolver resolver;
        private final PortAddressResolver portAddressResolver;
        private String targetNamespace;
        private QName serviceName;
        private QName portName;
        private String portAddress;
        private EPR_ADDRESS_STATE eprAddressState = EPR_ADDRESS_STATE.OUT;

        public DefnPatcher(WSEndpointImpl<?> wSEndpointImpl, SDDocumentImpl sDDocumentImpl, PortAddressResolver portAddressResolver, DocumentAddressResolver documentAddressResolver) {
            this.endpoint = wSEndpointImpl;
            this.current = sDDocumentImpl;
            this.portAddressResolver = portAddressResolver;
            this.resolver = documentAddressResolver;
        }

        protected void handleAttribute(int n) throws XMLStreamException {
            QName qName = this.in.getName();
            String string = this.in.getAttributeLocalName(n);
            if (qName.equals(SCHEMA_INCLUDE_QNAME) && string.equals("schemaLocation") || qName.equals(SCHEMA_IMPORT_QNAME) && string.equals("schemaLocation") || qName.equals(SCHEMA_REDEFINE_QNAME) && string.equals("schemaLocation") || qName.equals(WSDLConstants.QNAME_IMPORT) && string.equals("location")) {
                String string2 = this.in.getAttributeValue(n);
                String string3 = this.getPatchedImportLocation(string2);
                if (string3 == null) {
                    return;
                }
                logger.fine("Fixing the relative location:" + string2 + " with absolute location:" + string3);
                this.writeAttribute(n, string3);
                return;
            }
            if ((qName.equals(WSDLConstants.NS_SOAP_BINDING_ADDRESS) || qName.equals(WSDLConstants.NS_SOAP12_BINDING_ADDRESS)) && string.equals("location")) {
                this.portAddress = this.in.getAttributeValue(n);
                String string4 = this.getAddressLocation();
                if (string4 != null) {
                    logger.fine("Service:" + this.serviceName + " port:" + this.portName + " current address " + this.portAddress + " Patching it with " + string4);
                    this.writeAttribute(n, string4);
                    return;
                }
            }
            super.handleAttribute(n);
        }

        private void writeAttribute(int n, String string) throws XMLStreamException {
            String string2 = this.in.getAttributeNamespace(n);
            if (string2 != null) {
                this.out.writeAttribute(this.in.getAttributePrefix(n), string2, this.in.getAttributeLocalName(n), string);
            } else {
                this.out.writeAttribute(this.in.getAttributeLocalName(n), string);
            }
        }

        protected void handleStartElement() throws XMLStreamException {
            QName qName = this.in.getName();
            if (qName.equals(WSDLConstants.QNAME_DEFINITIONS)) {
                String string = this.in.getAttributeValue(null, "targetNamespace");
                if (string != null) {
                    this.targetNamespace = string;
                }
            } else if (qName.equals(WSDLConstants.QNAME_SERVICE)) {
                String string = this.in.getAttributeValue(null, "name");
                if (string != null) {
                    this.serviceName = new QName(this.targetNamespace, string);
                }
            } else if (qName.equals(WSDLConstants.QNAME_PORT)) {
                String string = this.in.getAttributeValue(null, "name");
                if (string != null) {
                    this.portName = new QName(this.targetNamespace, string);
                }
            } else if (qName.equals(W3CAddressingConstants.WSA_ADDRESS_QNAME) || qName.equals(MemberSubmissionAddressingConstants.WSA_ADDRESS_QNAME)) {
                this.eprAddressState = EPR_ADDRESS_STATE.IN;
            }
            super.handleStartElement();
        }

        protected void handleEndElement() throws XMLStreamException {
            QName qName = this.in.getName();
            if (qName.equals(W3CAddressingConstants.WSA_ADDRESS_QNAME) || qName.equals(MemberSubmissionAddressingConstants.WSA_ADDRESS_QNAME)) {
                this.eprAddressState = EPR_ADDRESS_STATE.OUT;
            }
            super.handleEndElement();
        }

        protected void handleCharacters() throws XMLStreamException {
            String string;
            if (this.eprAddressState == EPR_ADDRESS_STATE.IN && (string = this.getAddressLocation()) != null) {
                logger.fine("Fixing EPR Address for service:" + this.serviceName + " port:" + this.portName + " address with " + string);
                this.out.writeCharacters(string);
                this.eprAddressState = EPR_ADDRESS_STATE.DONE;
            }
            if (this.eprAddressState != EPR_ADDRESS_STATE.DONE) {
                super.handleCharacters();
            }
        }

        private String getPatchedImportLocation(String string) {
            try {
                ServiceDefinitionImpl serviceDefinitionImpl = this.endpoint.getServiceDefinition();
                assert (serviceDefinitionImpl != null);
                URL uRL = new URL(this.current.getURL(), string);
                SDDocument sDDocument = serviceDefinitionImpl.getBySystemId(uRL);
                if (sDDocument == null) {
                    return string;
                }
                return this.resolver.getRelativeAddressFor((SDDocument)this.current, sDDocument);
            }
            catch (MalformedURLException malformedURLException) {
                return null;
            }
        }

        private String getAddressLocation() {
            return this.portAddressResolver == null || this.portName == null ? null : this.portAddressResolver.getAddressFor(this.serviceName, this.portName.getLocalPart(), this.portAddress);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static enum EPR_ADDRESS_STATE {
            IN,
            OUT,
            DONE;

        }
    }

    private static final class Http10OutputStream
    extends ByteArrayBuffer {
        private final WSHTTPConnection con;

        Http10OutputStream(WSHTTPConnection wSHTTPConnection) {
            this.con = wSHTTPConnection;
        }

        public void close() throws IOException {
            super.close();
            this.con.setContentLengthResponseHeader(this.size());
            OutputStream outputStream = this.con.getOutput();
            this.writeTo(outputStream);
            outputStream.close();
        }
    }
}

