/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.jaxws.handler;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.ws.handler.Handler;
import javax.xml.ws.handler.HandlerResolver;
import javax.xml.ws.handler.PortInfo;
import weblogic.j2ee.descriptor.ServiceRefHandlerBean;
import weblogic.j2ee.descriptor.ServiceRefHandlerChainBean;
import weblogic.j2ee.descriptor.ServiceRefHandlerChainsBean;
import weblogic.wsee.jaxws.PortInfoImpl;
import weblogic.wsee.jaxws.handler.HandlerChain;
import weblogic.wsee.jaxws.injection.ObjectFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientHandlerChainsResolver
implements HandlerResolver {
    private Map<PortInfo, List<Handler>> portHandlers = new HashMap<PortInfo, List<Handler>>();
    private ObjectFactory objectFactory;

    public ClientHandlerChainsResolver(QName qName, Iterator<QName> iterator, ServiceRefHandlerChainsBean serviceRefHandlerChainsBean, ObjectFactory objectFactory) throws Exception {
        this.objectFactory = objectFactory;
        this.loadHandlers(qName, iterator, serviceRefHandlerChainsBean);
    }

    private void loadHandlers(QName qName, Iterator<QName> iterator, ServiceRefHandlerChainsBean serviceRefHandlerChainsBean) throws Exception {
        if (serviceRefHandlerChainsBean != null) {
            while (iterator.hasNext()) {
                QName qName2 = iterator.next();
                for (ServiceRefHandlerChainBean serviceRefHandlerChainBean : serviceRefHandlerChainsBean.getHandlerChains()) {
                    HandlerChain handlerChain = new HandlerChain(serviceRefHandlerChainBean.getServiceNamePattern(), serviceRefHandlerChainBean.getPortNamePattern(), serviceRefHandlerChainBean.getProtocolBindings());
                    if (!handlerChain.isMatch(qName, qName2, null)) continue;
                    for (String string : handlerChain.getApplicableProtocols()) {
                        PortInfoImpl portInfoImpl = new PortInfoImpl(string, qName2, qName);
                        this.registerHandlers(portInfoImpl, serviceRefHandlerChainBean);
                    }
                }
            }
        }
    }

    private void registerHandlers(PortInfo portInfo, ServiceRefHandlerChainBean serviceRefHandlerChainBean) throws Exception {
        List<Handler> list = this.initHandlerChain(portInfo);
        for (ServiceRefHandlerBean serviceRefHandlerBean : serviceRefHandlerChainBean.getHandlers()) {
            if (!this.isMatchingPort(serviceRefHandlerBean.getPortNames(), portInfo.getPortName().getLocalPart())) continue;
            Handler handler = (Handler)this.objectFactory.newInstance(serviceRefHandlerBean.getHandlerClass());
            list.add(handler);
        }
    }

    private boolean isMatchingPort(String[] stringArray, String string) {
        if (stringArray == null || stringArray.length == 0) {
            return true;
        }
        return Arrays.asList(stringArray).contains(string);
    }

    private List<Handler> initHandlerChain(PortInfo portInfo) {
        List<Handler> list = this.portHandlers.get(portInfo);
        if (list == null) {
            list = new ArrayList<Handler>();
            this.portHandlers.put(portInfo, list);
        }
        return list;
    }

    public List<Handler> getHandlerChain(PortInfo portInfo) {
        PortInfoImpl portInfoImpl = new PortInfoImpl(portInfo.getBindingID(), portInfo.getPortName(), portInfo.getServiceName());
        List<Handler> list = this.portHandlers.get(portInfoImpl);
        if (list == null) {
            list = new ArrayList<Handler>();
        }
        return list;
    }
}

