/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.jaxws.handler;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;
import weblogic.wsee.jaxws.handler.BindingIdTranslator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class HandlerChain {
    private final String serviceNamePattern;
    private final String portNamePattern;
    private final List<String> protocolBindings;

    HandlerChain(String string, String string2, String string3) {
        this.serviceNamePattern = string;
        this.portNamePattern = string2;
        this.protocolBindings = string3 == null ? null : Arrays.asList(string3.split("\\s"));
    }

    private static boolean isMatch(QName qName, String string) {
        if (qName == null || string == null) {
            return true;
        }
        QName qName2 = QName.valueOf(string);
        if (qName2.getNamespaceURI().equals(qName.getNamespaceURI()) || qName2.getNamespaceURI().equals("")) {
            String string2 = qName2.getLocalPart().replaceAll("\\*", ".*");
            return Pattern.matches(string2, qName.getLocalPart());
        }
        return false;
    }

    private static boolean isMatch(String string, List<String> list) {
        if (string == null || list == null) {
            return true;
        }
        for (String string2 : list) {
            if (!BindingIdTranslator.translate(string2).equals(string)) continue;
            return true;
        }
        return false;
    }

    public boolean isMatch(QName qName, QName qName2, String string) {
        if (!HandlerChain.isMatch(qName, this.serviceNamePattern)) {
            return false;
        }
        if (!HandlerChain.isMatch(qName2, this.portNamePattern)) {
            return false;
        }
        return HandlerChain.isMatch(string, this.protocolBindings);
    }

    public Set<String> getApplicableProtocols() {
        HashSet<String> hashSet = new HashSet<String>();
        if (this.protocolBindings == null) {
            hashSet.add("http://www.w3.org/2004/08/wsdl/http");
            hashSet.add("http://schemas.xmlsoap.org/wsdl/soap/http");
            hashSet.add("http://www.w3.org/2003/05/soap/bindings/HTTP/");
            hashSet.add("http://schemas.xmlsoap.org/wsdl/soap/http?mtom=true");
            hashSet.add("http://www.w3.org/2003/05/soap/bindings/HTTP/?mtom=true");
        } else {
            for (String string : this.protocolBindings) {
                hashSet.add(BindingIdTranslator.translate(string));
            }
        }
        return hashSet;
    }
}

