/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.jaxws.handler;

import com.sun.xml.ws.api.WSBinding;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.ws.handler.Handler;
import javax.xml.ws.soap.SOAPBinding;
import weblogic.j2ee.descriptor.HandlerChainBean;
import weblogic.j2ee.descriptor.HandlerChainsBean;
import weblogic.j2ee.descriptor.PortComponentHandlerBean;
import weblogic.wsee.jaxws.handler.HandlerChain;
import weblogic.wsee.jaxws.injection.ObjectFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerHandlerChainsResolver {
    private final QName serviceName;
    private final QName portName;
    private final String protocolBinding;
    private final List<PortComponentHandlerBean> matchingHandlers;

    public ServerHandlerChainsResolver(QName qName, QName qName2, String string, HandlerChainsBean handlerChainsBean) {
        this.serviceName = qName;
        this.portName = qName2;
        this.protocolBinding = string;
        this.matchingHandlers = this.resolveHandlers(handlerChainsBean);
    }

    private List<PortComponentHandlerBean> resolveHandlers(HandlerChainsBean handlerChainsBean) {
        ArrayList<PortComponentHandlerBean> arrayList = new ArrayList<PortComponentHandlerBean>();
        if (handlerChainsBean != null) {
            for (HandlerChainBean handlerChainBean : handlerChainsBean.getHandlerChains()) {
                HandlerChain handlerChain = new HandlerChain(handlerChainBean.getServiceNamePattern(), handlerChainBean.getPortNamePattern(), handlerChainBean.getProtocolBindings());
                if (!handlerChain.isMatch(this.serviceName, this.portName, this.protocolBinding)) continue;
                for (PortComponentHandlerBean portComponentHandlerBean : handlerChainBean.getHandlers()) {
                    arrayList.add(portComponentHandlerBean);
                }
            }
        }
        return arrayList;
    }

    public List<PortComponentHandlerBean> getMatchingHandlers() {
        return this.matchingHandlers;
    }

    public void configureHandlers(WSBinding wSBinding, ObjectFactory objectFactory) throws IllegalAccessException, InstantiationException, ClassNotFoundException {
        ArrayList<Handler> arrayList = new ArrayList<Handler>();
        HashSet<String> hashSet = new HashSet<String>();
        for (PortComponentHandlerBean portComponentHandlerBean : this.matchingHandlers) {
            Handler handler = (Handler)objectFactory.newInstance(portComponentHandlerBean.getHandlerClass());
            arrayList.add(handler);
            String[] stringArray = portComponentHandlerBean.getSoapRoles();
            if (stringArray == null) continue;
            for (String string : stringArray) {
                hashSet.add(string);
            }
        }
        wSBinding.setHandlerChain(arrayList);
        if (wSBinding instanceof SOAPBinding) {
            ((SOAPBinding)wSBinding).setRoles(hashSet);
        }
    }
}

