/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.jaxws.management;

import com.sun.istack.NotNull;
import com.sun.xml.ws.api.BindingID;
import com.sun.xml.ws.api.model.JavaMethod;
import com.sun.xml.ws.api.model.SEIModel;
import com.sun.xml.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.ws.api.server.Container;
import com.sun.xml.ws.api.server.ContainerResolver;
import com.sun.xml.ws.api.server.SDDocumentSource;
import com.sun.xml.ws.api.wsdl.parser.WSDLParserExtension;
import com.sun.xml.ws.api.wsdl.parser.XMLEntityResolver;
import com.sun.xml.ws.model.RuntimeModeler;
import com.sun.xml.ws.model.wsdl.WSDLModelImpl;
import com.sun.xml.ws.model.wsdl.WSDLPortImpl;
import com.sun.xml.ws.resources.ServerMessages;
import com.sun.xml.ws.server.ServerRtException;
import com.sun.xml.ws.util.ServiceConfigurationError;
import com.sun.xml.ws.util.ServiceFinder;
import com.sun.xml.ws.wsdl.parser.RuntimeWSDLParser;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.jws.WebService;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.WebServiceFeature;
import javax.xml.ws.WebServiceProvider;
import org.xml.sax.SAXException;
import weblogic.security.service.WebServiceResource;
import weblogic.wsee.jaxws.handler.BindingIdTranslator;
import weblogic.wsee.util.StringUtil;
import weblogic.wsee.util.Verbose;
import weblogic.wsee.wsdl.WsdlDefinitions;
import weblogic.wsee.wsdl.WsdlImport;
import weblogic.wsee.wsdl.WsdlSchema;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManagementUtils {
    static boolean verbose = Verbose.isVerbose(ManagementUtils.class);

    public static WSDLPort generateWSDL(WsdlDefinitions wsdlDefinitions, @NotNull QName qName, @NotNull QName qName2) {
        String string = null;
        List<Object> list = new ArrayList();
        if (wsdlDefinitions != null) {
            string = wsdlDefinitions.getWsdlLocation();
            list = ManagementUtils.getImportedWsdlsAndSchemas(wsdlDefinitions);
        }
        SDDocumentSource sDDocumentSource = ManagementUtils.createSDDocumentSource(string);
        return ManagementUtils.generateWSDL(sDDocumentSource, list, qName, qName2);
    }

    public static WSDLPort generateWSDL(SDDocumentSource sDDocumentSource, List<? extends SDDocumentSource> list, @NotNull QName qName, @NotNull QName qName2) {
        URL uRL = sDDocumentSource.getSystemId();
        try {
            WSDLModelImpl wSDLModelImpl = RuntimeWSDLParser.parse((XMLEntityResolver.Parser)new XMLEntityResolver.Parser(sDDocumentSource), (XMLEntityResolver)new EntityResolverImpl(list), (boolean)false, (Container)ContainerResolver.getInstance().getContainer(), (WSDLParserExtension[])((WSDLParserExtension[])ServiceFinder.find(WSDLParserExtension.class).toArray()));
            WSDLPortImpl wSDLPortImpl = wSDLModelImpl.getService(qName).get(qName2);
            if (wSDLPortImpl == null) {
                throw new ServerRtException(ServerMessages.localizableRUNTIME_PARSER_WSDL_INCORRECTSERVICEPORT((Object)qName, (Object)qName2, (Object)uRL));
            }
            return wSDLPortImpl;
        }
        catch (IOException iOException) {
            throw new ServerRtException("runtime.parser.wsdl", new Object[]{uRL, iOException});
        }
        catch (XMLStreamException xMLStreamException) {
            throw new ServerRtException("runtime.saxparser.exception", new Object[]{xMLStreamException.getMessage(), xMLStreamException.getLocation(), xMLStreamException});
        }
        catch (SAXException sAXException) {
            throw new ServerRtException("runtime.parser.wsdl", new Object[]{uRL, sAXException});
        }
        catch (ServiceConfigurationError serviceConfigurationError) {
            throw new ServerRtException("runtime.parser.wsdl", new Object[]{uRL, serviceConfigurationError});
        }
    }

    public static BindingID parseBindingId(String string) {
        if (StringUtil.isEmpty(string = BindingIdTranslator.translate(string))) {
            string = "http://schemas.xmlsoap.org/wsdl/soap/http";
        }
        return BindingID.parse((String)string);
    }

    public static SEIModel generateModel(WSDLPort wSDLPort, Class<?> clazz, @NotNull QName qName, @NotNull QName qName2, BindingID bindingID) {
        if (clazz.getAnnotation(WebService.class) != null && clazz.getAnnotation(WebServiceProvider.class) == null) {
            RuntimeModeler runtimeModeler = wSDLPort == null ? new RuntimeModeler(clazz, qName, bindingID) : new RuntimeModeler(clazz, qName, (WSDLPortImpl)wSDLPort, new WebServiceFeature[0]);
            runtimeModeler.setPortName(qName2);
            runtimeModeler.setClassLoader(clazz.getClassLoader());
            return runtimeModeler.buildRuntimeModel();
        }
        return null;
    }

    public static Map<JavaMethod, WebServiceResource> generateResources(String string, String string2, SEIModel sEIModel) {
        HashMap<JavaMethod, WebServiceResource> hashMap = new HashMap<JavaMethod, WebServiceResource>();
        if (sEIModel != null) {
            String string3 = sEIModel.getPortName().getLocalPart();
            for (JavaMethod javaMethod : sEIModel.getJavaMethods()) {
                Method method = javaMethod.getMethod();
                String string4 = method.getName();
                Class<?>[] classArray = method.getParameterTypes();
                String[] stringArray = new String[classArray.length];
                for (int i = 0; i < classArray.length; ++i) {
                    stringArray[i] = classArray[i].getCanonicalName();
                }
                hashMap.put(javaMethod, new WebServiceResource(string, string2, string3, string4, stringArray));
            }
        }
        return hashMap;
    }

    private static List<SDDocumentSource> getImportedWsdlsAndSchemas(WsdlDefinitions wsdlDefinitions) {
        HashSet<SDDocumentSource> hashSet = new HashSet<SDDocumentSource>();
        ManagementUtils.buildImportedWsdls(wsdlDefinitions, hashSet);
        ManagementUtils.buildImportedSchemas(wsdlDefinitions, hashSet);
        return new ArrayList<SDDocumentSource>(hashSet);
    }

    private static void buildImportedSchemas(WsdlDefinitions wsdlDefinitions, Collection<SDDocumentSource> collection) {
        if (wsdlDefinitions.getTypes() != null && wsdlDefinitions.getTypes().getImportedWsdlSchemas() != null) {
            List<? extends WsdlSchema> list = wsdlDefinitions.getTypes().getImportedWsdlSchemas();
            for (WsdlSchema wsdlSchema : list) {
                SDDocumentSource sDDocumentSource = ManagementUtils.createSDDocumentSource(wsdlSchema.getLocationUrl());
                if (sDDocumentSource == null) continue;
                collection.add(sDDocumentSource);
            }
        }
    }

    private static void buildImportedWsdls(WsdlDefinitions wsdlDefinitions, Collection<SDDocumentSource> collection) {
        List<? extends WsdlImport> list = wsdlDefinitions.getImports();
        for (WsdlImport wsdlImport : list) {
            String string = wsdlImport.getDefinitions().getWsdlLocation();
            SDDocumentSource sDDocumentSource = ManagementUtils.createSDDocumentSource(string);
            if (sDDocumentSource == null) continue;
            collection.add(sDDocumentSource);
        }
    }

    private static SDDocumentSource createSDDocumentSource(String string) {
        SDDocumentSource sDDocumentSource = null;
        URL uRL = null;
        if (string != null) {
            try {
                uRL = new URL(string);
            }
            catch (MalformedURLException malformedURLException) {
                throw new WebServiceException((Throwable)malformedURLException);
            }
        }
        if (verbose) {
            Verbose.log("Constructing SDDocumentSource :" + uRL);
        }
        if (uRL != null) {
            sDDocumentSource = SDDocumentSource.create((URL)uRL);
        }
        return sDDocumentSource;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class EntityResolverImpl
    implements XMLEntityResolver {
        private Map<String, SDDocumentSource> metadata = new HashMap<String, SDDocumentSource>();

        public EntityResolverImpl(List<? extends SDDocumentSource> list) {
            for (SDDocumentSource sDDocumentSource : list) {
                this.metadata.put(sDDocumentSource.getSystemId().toExternalForm(), sDDocumentSource);
            }
        }

        public XMLEntityResolver.Parser resolveEntity(String string, String string2) throws IOException, XMLStreamException {
            SDDocumentSource sDDocumentSource;
            if (string2 != null && (sDDocumentSource = this.metadata.get(string2)) != null) {
                return new XMLEntityResolver.Parser(sDDocumentSource);
            }
            return null;
        }
    }
}

