/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.jaxws.owsm;

import com.sun.xml.ws.api.WSBinding;
import com.sun.xml.ws.api.pipe.ClientTubeAssemblerContext;
import com.sun.xml.ws.binding.WebServiceFeatureList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.rpc.handler.HandlerInfo;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.WebServiceFeature;
import weblogic.j2ee.descriptor.wl.OwsmPolicyBean;
import weblogic.j2ee.descriptor.wl.PortInfoBean;
import weblogic.j2ee.descriptor.wl.PropertyNamevalueBean;
import weblogic.jws.jaxws.PoliciesFeature;
import weblogic.jws.jaxws.PolicyFeature;
import weblogic.wsee.jaxws.framework.ConfigUtil;
import weblogic.wsee.jaxws.framework.jaxrpc.EnvironmentFactory;
import weblogic.wsee.jaxws.framework.jaxrpc.ListenerUsage;
import weblogic.wsee.jaxws.owsm.ClientEnvironmentFactory;
import weblogic.wsee.jaxws.owsm.ClientEnvironmentFeature;
import weblogic.wsee.jaxws.owsm.SecurityPolicyHandler;
import weblogic.wsee.jaxws.owsm.TubelineDeploymentListener;
import weblogic.wsee.jaxws.tubeline.TubelineAssemblerItem;
import weblogic.wsee.jws.jaxws.owsm.SecurityPoliciesFeature;
import weblogic.wsee.jws.jaxws.owsm.SecurityPolicyFeature;
import weblogic.wsee.mtom.internal.MtomXopClientHandler;
import weblogic.wsee.policy.deployment.WseePolicyReferenceInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientTubelineDeploymentListener
extends TubelineDeploymentListener {
    private static Class handlerClass;
    private static final String ENABLED = "enabled";
    private List<String> preceding = Collections.singletonList("PRE_INVOKE_HANDLER");
    private List<String> following = new ArrayList<String>();

    public ClientTubelineDeploymentListener() {
        super(ClientTubelineDeploymentListener.class, ListenerUsage.CLIENT_ONLY);
        this.following.add("ADDRESSING_HANDLER");
        this.following.add("POLICY_CLIENT_RT_HANDLER");
        this.following.add("RELIABILITY_HANDLER");
        this.following.add("ASYNC_HANDLER");
    }

    @Override
    public void createClient(ClientTubeAssemblerContext clientTubeAssemblerContext, Set<TubelineAssemblerItem> set) {
        if (this.hasSecurityPolicyAnnotation(clientTubeAssemblerContext) || this.hasDDPolicy(clientTubeAssemblerContext)) {
            if (this.hasPolicyFeature(clientTubeAssemblerContext)) {
                throw new WebServiceException("SecurityPolicyFeature and PolicyFeature can not be set simultaneously.");
            }
            handlerClass = this.getHandler(clientTubeAssemblerContext).getClass();
            this.setClient(clientTubeAssemblerContext);
            super.createClient(clientTubeAssemblerContext, set);
        }
    }

    private boolean hasPolicyFeature(ClientTubeAssemblerContext clientTubeAssemblerContext) {
        WSBinding wSBinding = clientTubeAssemblerContext.getBinding();
        PoliciesFeature policiesFeature = (PoliciesFeature)wSBinding.getFeature(PoliciesFeature.class);
        PolicyFeature policyFeature = (PolicyFeature)wSBinding.getFeature(PolicyFeature.class);
        return policiesFeature != null || policyFeature != null;
    }

    private boolean hasSecurityPolicyAnnotation(ClientTubeAssemblerContext clientTubeAssemblerContext) {
        WSBinding wSBinding = clientTubeAssemblerContext.getBinding();
        SecurityPoliciesFeature securityPoliciesFeature = (SecurityPoliciesFeature)wSBinding.getFeature(SecurityPoliciesFeature.class);
        SecurityPolicyFeature securityPolicyFeature = (SecurityPolicyFeature)wSBinding.getFeature(SecurityPolicyFeature.class);
        return securityPoliciesFeature != null && securityPoliciesFeature.isEnabled() || securityPolicyFeature != null && securityPolicyFeature.isEnabled();
    }

    private boolean hasDDPolicy(ClientTubeAssemblerContext clientTubeAssemblerContext) {
        PortInfoBean portInfoBean = ConfigUtil.getPortInfoBeanForClient(clientTubeAssemblerContext);
        if (portInfoBean == null) {
            return false;
        }
        OwsmPolicyBean[] owsmPolicyBeanArray = portInfoBean.getOwsmPolicy();
        return owsmPolicyBeanArray != null && owsmPolicyBeanArray.length > 0;
    }

    private void setDDPolicies(EnvironmentFactory environmentFactory, List<String> list) {
        PortInfoBean portInfoBean = ((ClientEnvironmentFactory)environmentFactory).getPortBean();
        if (portInfoBean == null) {
            return;
        }
        OwsmPolicyBean[] owsmPolicyBeanArray = portInfoBean.getOwsmPolicy();
        if (owsmPolicyBeanArray != null && owsmPolicyBeanArray.length > 0) {
            for (OwsmPolicyBean owsmPolicyBean : owsmPolicyBeanArray) {
                if (owsmPolicyBean.getStatus().equals(ENABLED)) {
                    list.add(owsmPolicyBean.getUri());
                    continue;
                }
                list.remove(owsmPolicyBean.getUri());
            }
        }
    }

    private void setDDPoliciesInfos(EnvironmentFactory environmentFactory, List<WseePolicyReferenceInfo> list) {
        PortInfoBean portInfoBean = ((ClientEnvironmentFactory)environmentFactory).getPortBean();
        if (portInfoBean == null) {
            return;
        }
        OwsmPolicyBean[] owsmPolicyBeanArray = portInfoBean.getOwsmPolicy();
        if (owsmPolicyBeanArray != null && owsmPolicyBeanArray.length > 0) {
            for (OwsmPolicyBean owsmPolicyBean : owsmPolicyBeanArray) {
                if (owsmPolicyBean.getStatus().equals(ENABLED)) {
                    list.add(new WseePolicyReferenceInfo("owsm-security", owsmPolicyBean.getUri(), owsmPolicyBean.getStatus(), ClientTubelineDeploymentListener.getOverrides(owsmPolicyBean)));
                    continue;
                }
                list.remove(owsmPolicyBean.getUri());
            }
        }
    }

    private static Map<String, String> getOverrides(OwsmPolicyBean owsmPolicyBean) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        PropertyNamevalueBean[] propertyNamevalueBeanArray = owsmPolicyBean.getSecurityConfigurationProperties();
        if (propertyNamevalueBeanArray != null) {
            for (PropertyNamevalueBean propertyNamevalueBean : propertyNamevalueBeanArray) {
                hashMap.put(propertyNamevalueBean.getName(), propertyNamevalueBean.getValue());
            }
        }
        return hashMap;
    }

    private SecurityPolicyHandler getHandler(ClientTubeAssemblerContext clientTubeAssemblerContext) throws WebServiceException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        return this.loadHandler(classLoader);
    }

    private void setClient(ClientTubeAssemblerContext clientTubeAssemblerContext) {
        WSBinding wSBinding = clientTubeAssemblerContext.getBinding();
        ClientEnvironmentFeature clientEnvironmentFeature = new ClientEnvironmentFeature();
        ((WebServiceFeatureList)wSBinding.getFeatures()).add((WebServiceFeature)clientEnvironmentFeature);
    }

    @Override
    Class getHandlerClass() {
        return handlerClass;
    }

    @Override
    List getPrecedingHandlers() {
        return this.preceding;
    }

    @Override
    List getFollowingHandlers() {
        return this.following;
    }

    @Override
    protected void setProperties(EnvironmentFactory environmentFactory, Map map) {
        boolean bl;
        WSBinding wSBinding = environmentFactory.getBinding();
        List<String> list = this.getSecurityPolicyFeatureURIs(environmentFactory);
        ArrayList<WseePolicyReferenceInfo> arrayList = new ArrayList();
        boolean bl2 = bl = list.size() == 0;
        if (bl) {
            this.setDDPolicies(environmentFactory, list);
            this.setDDPoliciesInfos(environmentFactory, arrayList);
        } else {
            arrayList = this.getWseeReferenceInfos(list);
        }
        map.put("weblogic.wsee.jaxws.owsm.SecurityPolicyURIList", list);
        if (wSBinding.getFeature(ClientEnvironmentFeature.class) != null) {
            map.put("weblogic.wsee.jaxws.owsm.Client", true);
        }
        this.setAdditionalOwsmPropertiesWithOverrides(environmentFactory, map, arrayList, true);
    }

    private List<WseePolicyReferenceInfo> getWseeReferenceInfos(List<String> list) {
        ArrayList<WseePolicyReferenceInfo> arrayList = new ArrayList<WseePolicyReferenceInfo>();
        if (list != null) {
            for (String string : list) {
                arrayList.add(new WseePolicyReferenceInfo("owsm-security", string));
            }
        }
        return arrayList;
    }

    @Override
    List getFollowingXopHandlers() {
        return Collections.singletonList("OWSM_SECURITY_POLICY_HANDLER");
    }

    @Override
    List getPrecedingXopHandlers() {
        return Collections.singletonList("CONNECTION_HANDLER");
    }

    @Override
    HandlerInfo getXopHandlerInfo() {
        return new HandlerInfo(MtomXopClientHandler.class, new HashMap(), null);
    }
}

