/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.jaxws.owsm;

import com.sun.xml.ws.api.WSBinding;
import com.sun.xml.ws.api.message.Packet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.ws.handler.MessageContext;
import weblogic.j2ee.descriptor.wl.OwsmPolicyBean;
import weblogic.j2ee.descriptor.wl.OwsmSecurityPolicyBean;
import weblogic.j2ee.descriptor.wl.PortInfoBean;
import weblogic.j2ee.descriptor.wl.PortPolicyBean;
import weblogic.j2ee.descriptor.wl.WebservicePolicyRefBean;
import weblogic.wsee.deploy.DeployInfo;
import weblogic.wsee.jaxws.framework.jaxrpc.AbstractPropertyConverter;
import weblogic.wsee.jaxws.framework.jaxrpc.EnvironmentFactory;
import weblogic.wsee.jaxws.framework.jaxrpc.PropertyConverter;
import weblogic.wsee.jaxws.framework.policy.EnvironmentMetadata;
import weblogic.wsee.jaxws.framework.policy.EnvironmentMetadataFactory;
import weblogic.wsee.jaxws.framework.policy.PolicySubjectBinding;
import weblogic.wsee.jaxws.owsm.ClientEnvironmentFactory;
import weblogic.wsee.jaxws.owsm.ClientEnvironmentFeature;
import weblogic.wsee.jaxws.owsm.ServerEnvironmentFeature;
import weblogic.wsee.jws.jaxws.owsm.PolicySubjectBindingFeature;
import weblogic.wsee.jws.jaxws.owsm.SecurityPoliciesFeature;
import weblogic.wsee.jws.jaxws.owsm.SecurityPolicyFeature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyConverters {
    private static final String ENABLED = "enabled";
    private Map<String, PropertyConverter> jaxrpcConverters;
    private EnvironmentFactory environment;
    private PortInfoBean portBean = null;

    public PropertyConverters(EnvironmentFactory environmentFactory) {
        this.environment = environmentFactory;
        if (this.environment instanceof ClientEnvironmentFactory) {
            this.portBean = ((ClientEnvironmentFactory)this.environment).getPortBean();
        }
    }

    public Map getConverters() {
        if (this.jaxrpcConverters == null) {
            this.initializeConverters();
        }
        return this.jaxrpcConverters;
    }

    private void initializeConverters() {
        this.jaxrpcConverters = new HashMap<String, PropertyConverter>();
        this.jaxrpcConverters.put("weblogic.wsee.jaxws.owsm.SecurityPolicyURIList", new AbstractPropertyConverter(){

            public Object convertToJAXRPC(Packet packet, MessageContext messageContext) {
                return PropertyConverters.this.getSecurityPolicyURIs(PropertyConverters.this.environment.getBinding());
            }
        });
        this.jaxrpcConverters.put("weblogic.wsee.jaxws.owsm.Server", new AbstractPropertyConverter(){

            public Object convertToJAXRPC(Packet packet, MessageContext messageContext) {
                return PropertyConverters.this.environment.getBinding().getFeature(ServerEnvironmentFeature.class) != null;
            }
        });
        this.jaxrpcConverters.put("weblogic.wsee.jaxws.owsm.Client", new AbstractPropertyConverter(){

            public Object convertToJAXRPC(Packet packet, MessageContext messageContext) {
                return PropertyConverters.this.environment.getBinding().getFeature(ClientEnvironmentFeature.class) != null;
            }
        });
        this.jaxrpcConverters.put("weblogic.wsee.jaxws.framework.policy.PolicySubjectBinding", new AbstractPropertyConverter(){

            public Object convertToJAXRPC(Packet packet, MessageContext messageContext) {
                return PropertyConverters.this.getPolicySubjectBinding(PropertyConverters.this.environment.getBinding());
            }
        });
        this.jaxrpcConverters.put("weblogic.wsee.jaxws.framework.policy.EnvironmentMetadata", new AbstractPropertyConverter(){

            public Object convertToJAXRPC(Packet packet, MessageContext messageContext) {
                return PropertyConverters.this.getEnvironmentMetadata(PropertyConverters.this.environment.getBinding());
            }
        });
    }

    private PolicySubjectBinding getPolicySubjectBinding(WSBinding wSBinding) {
        PolicySubjectBindingFeature policySubjectBindingFeature = (PolicySubjectBindingFeature)wSBinding.getFeature(PolicySubjectBindingFeature.class);
        if (policySubjectBindingFeature != null) {
            return policySubjectBindingFeature.getPolicySubjectBinding();
        }
        return null;
    }

    private EnvironmentMetadata getEnvironmentMetadata(WSBinding wSBinding) {
        if (wSBinding.getFeature(ServerEnvironmentFeature.class) != null) {
            return EnvironmentMetadataFactory.getEnvironmentMetadata();
        }
        return null;
    }

    private List<String> getSecurityPolicyURIs(WSBinding wSBinding) {
        Object object;
        ArrayList<String> arrayList = new ArrayList<String>();
        SecurityPoliciesFeature securityPoliciesFeature = (SecurityPoliciesFeature)wSBinding.getFeature(SecurityPoliciesFeature.class);
        if (securityPoliciesFeature != null && securityPoliciesFeature.isEnabled()) {
            object = securityPoliciesFeature.getPolicies().iterator();
            while (object.hasNext()) {
                SecurityPolicyFeature securityPolicyFeature = (SecurityPolicyFeature)object.next();
                arrayList.add(securityPolicyFeature.getUri());
            }
        }
        if ((object = (SecurityPolicyFeature)wSBinding.getFeature(SecurityPolicyFeature.class)) != null && object.isEnabled()) {
            arrayList.add(object.getUri());
        }
        this.addDDPolicies(arrayList);
        return arrayList;
    }

    private void addDDPolicies(List<String> list) {
        if (this.environment.getContainer() == null) {
            this.addClientDDPolicies(list);
        } else {
            this.addServerDDPolicies(list);
        }
    }

    private void addServerDDPolicies(List<String> list) {
        WebservicePolicyRefBean webservicePolicyRefBean;
        DeployInfo deployInfo = (DeployInfo)this.environment.getContainer().getSPI(DeployInfo.class);
        WebservicePolicyRefBean webservicePolicyRefBean2 = webservicePolicyRefBean = deployInfo != null ? deployInfo.getPolicyRef() : null;
        if (webservicePolicyRefBean == null) {
            return;
        }
        if (webservicePolicyRefBean != null) {
            String string = this.environment.getPort().getName().getLocalPart();
            PortPolicyBean[] portPolicyBeanArray = webservicePolicyRefBean.getPortPolicy();
            if (portPolicyBeanArray != null) {
                for (PortPolicyBean portPolicyBean : portPolicyBeanArray) {
                    OwsmSecurityPolicyBean[] owsmSecurityPolicyBeanArray;
                    if (!string.equals(portPolicyBean.getPortName()) || (owsmSecurityPolicyBeanArray = portPolicyBean.getOwsmSecurityPolicy()) == null) continue;
                    for (OwsmSecurityPolicyBean owsmSecurityPolicyBean : owsmSecurityPolicyBeanArray) {
                        if (owsmSecurityPolicyBean.getStatus().equals(ENABLED)) {
                            list.add(owsmSecurityPolicyBean.getUri());
                            continue;
                        }
                        list.remove(owsmSecurityPolicyBean.getUri());
                    }
                }
            }
        }
    }

    private void addClientDDPolicies(List<String> list) {
        if (this.portBean == null) {
            return;
        }
        OwsmPolicyBean[] owsmPolicyBeanArray = this.portBean.getOwsmPolicy();
        if (owsmPolicyBeanArray != null && owsmPolicyBeanArray.length > 0) {
            for (OwsmPolicyBean owsmPolicyBean : owsmPolicyBeanArray) {
                if (owsmPolicyBean.getStatus().equals(ENABLED)) {
                    list.add(owsmPolicyBean.getUri());
                    continue;
                }
                list.remove(owsmPolicyBean.getUri());
            }
        }
    }
}

