/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.jaxws.owsm;

import com.sun.xml.ws.api.WSBinding;
import com.sun.xml.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.ws.api.pipe.ServerTubeAssemblerContext;
import com.sun.xml.ws.binding.WebServiceFeatureList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.rpc.handler.HandlerInfo;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.WebServiceFeature;
import weblogic.j2ee.descriptor.wl.OwsmSecurityPolicyBean;
import weblogic.j2ee.descriptor.wl.PortPolicyBean;
import weblogic.j2ee.descriptor.wl.WebservicePolicyRefBean;
import weblogic.webservice.WebServiceLogger;
import weblogic.wsee.deploy.DeployInfo;
import weblogic.wsee.jaxws.framework.jaxrpc.EnvironmentFactory;
import weblogic.wsee.jaxws.framework.jaxrpc.ListenerUsage;
import weblogic.wsee.jaxws.owsm.SecurityPolicyHandler;
import weblogic.wsee.jaxws.owsm.ServerEnvironmentFeature;
import weblogic.wsee.jaxws.owsm.TubelineDeploymentListener;
import weblogic.wsee.jaxws.tubeline.TubelineAssemblerItem;
import weblogic.wsee.mtom.internal.MtomXopServerHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerTubelineDeploymentListener
extends TubelineDeploymentListener {
    private static Class handlerClass;
    private static final String ENABLED = "enabled";
    private List<String> preceding = Collections.singletonList("PRE_INVOKE_HANDLER");
    private List<String> following = Collections.singletonList("CONNECTION_HANDLER");

    public ServerTubelineDeploymentListener() {
        super(ServerTubelineDeploymentListener.class, ListenerUsage.SERVER_ONLY);
    }

    @Override
    public void createServer(ServerTubeAssemblerContext serverTubeAssemblerContext, Set<TubelineAssemblerItem> set) {
        if (this.hasSecurityPolicy(serverTubeAssemblerContext)) {
            if (serverTubeAssemblerContext.getWsdlModel() == null) {
                String string = WebServiceLogger.logOWSMPolicyWithNoWsdlLoggable().getMessage();
                throw new IllegalStateException(string);
            }
            handlerClass = this.getHandler(serverTubeAssemblerContext).getClass();
            this.setServer(serverTubeAssemblerContext);
            super.createServer(serverTubeAssemblerContext, set);
        }
    }

    protected boolean hasSecurityPolicy(ServerTubeAssemblerContext serverTubeAssemblerContext) {
        EnvironmentFactory environmentFactory = this.getEnvironmentFactory(serverTubeAssemblerContext);
        List<String> list = this.getSecurityPolicyURIs(environmentFactory);
        return list != null && !list.isEmpty();
    }

    protected SecurityPolicyHandler getHandler(ServerTubeAssemblerContext serverTubeAssemblerContext) throws WebServiceException {
        ClassLoader classLoader = serverTubeAssemblerContext.getEndpoint().getImplementationClass().getClassLoader();
        return this.loadHandler(classLoader);
    }

    private void setServer(ServerTubeAssemblerContext serverTubeAssemblerContext) {
        WSBinding wSBinding = serverTubeAssemblerContext.getEndpoint().getBinding();
        ServerEnvironmentFeature serverEnvironmentFeature = new ServerEnvironmentFeature();
        ((WebServiceFeatureList)wSBinding.getFeatures()).add((WebServiceFeature)serverEnvironmentFeature);
    }

    @Override
    Class getHandlerClass() {
        return handlerClass;
    }

    @Override
    protected List<String> getPrecedingHandlers() {
        return this.preceding;
    }

    @Override
    protected List<String> getFollowingHandlers() {
        return this.following;
    }

    @Override
    protected void setProperties(EnvironmentFactory environmentFactory, Map map) {
        WSBinding wSBinding = environmentFactory.getBinding();
        List<String> list = this.getSecurityPolicyURIs(environmentFactory);
        map.put("weblogic.wsee.jaxws.owsm.SecurityPolicyURIList", list);
        if (wSBinding.getFeature(ServerEnvironmentFeature.class) != null) {
            map.put("weblogic.wsee.jaxws.owsm.Server", true);
        }
        this.setAdditionalOwsmProperties(environmentFactory, map, list, false);
    }

    private List<String> getSecurityPolicyURIs(EnvironmentFactory environmentFactory) {
        List<String> list = this.getSecurityPolicyFeatureURIs(environmentFactory);
        this.addDDPolicies(environmentFactory, list);
        return list;
    }

    private void addDDPolicies(EnvironmentFactory environmentFactory, List<String> list) {
        WebservicePolicyRefBean webservicePolicyRefBean;
        DeployInfo deployInfo = (DeployInfo)environmentFactory.getContainer().getSPI(DeployInfo.class);
        WebservicePolicyRefBean webservicePolicyRefBean2 = webservicePolicyRefBean = deployInfo != null ? deployInfo.getPolicyRef() : null;
        if (webservicePolicyRefBean == null) {
            return;
        }
        WSDLPort wSDLPort = environmentFactory.getPort();
        if (wSDLPort == null) {
            return;
        }
        String string = environmentFactory.getPort().getName().getLocalPart();
        PortPolicyBean[] portPolicyBeanArray = webservicePolicyRefBean.getPortPolicy();
        if (portPolicyBeanArray != null) {
            for (PortPolicyBean portPolicyBean : portPolicyBeanArray) {
                OwsmSecurityPolicyBean[] owsmSecurityPolicyBeanArray;
                if (!string.equals(portPolicyBean.getPortName()) || (owsmSecurityPolicyBeanArray = portPolicyBean.getOwsmSecurityPolicy()) == null) continue;
                for (OwsmSecurityPolicyBean owsmSecurityPolicyBean : owsmSecurityPolicyBeanArray) {
                    if (owsmSecurityPolicyBean.getStatus().equals(ENABLED)) {
                        list.add(owsmSecurityPolicyBean.getUri());
                        continue;
                    }
                    list.remove(owsmSecurityPolicyBean.getUri());
                }
            }
        }
    }

    @Override
    List getFollowingXopHandlers() {
        return Collections.singletonList("CONNECTION_HANDLER");
    }

    @Override
    List getPrecedingXopHandlers() {
        return Collections.singletonList("OWSM_SECURITY_POLICY_HANDLER");
    }

    @Override
    HandlerInfo getXopHandlerInfo() {
        return new HandlerInfo(MtomXopServerHandler.class, new HashMap(), null);
    }
}

