/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.jaxws.owsm;

import com.sun.xml.ws.api.WSBinding;
import com.sun.xml.ws.api.pipe.ClientTubeAssemblerContext;
import com.sun.xml.ws.api.pipe.ServerTubeAssemblerContext;
import com.sun.xml.ws.api.server.ContainerResolver;
import com.sun.xml.ws.binding.WebServiceFeatureList;
import com.sun.xml.ws.util.ServiceFinder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.xml.namespace.QName;
import javax.xml.rpc.handler.HandlerInfo;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.WebServiceFeature;
import weblogic.application.ApplicationContextInternal;
import weblogic.j2ee.ComponentRuntimeMBeanImpl;
import weblogic.kernel.KernelStatus;
import weblogic.management.runtime.ComponentRuntimeMBean;
import weblogic.management.runtime.EJBComponentRuntimeMBean;
import weblogic.management.runtime.WebAppComponentRuntimeMBean;
import weblogic.servlet.internal.WebAppServletContext;
import weblogic.wsee.deploy.DeployInfo;
import weblogic.wsee.deploy.EJBDeployInfo;
import weblogic.wsee.handler.HandlerException;
import weblogic.wsee.handler.HandlerList;
import weblogic.wsee.jaxws.framework.jaxrpc.EnvironmentFactory;
import weblogic.wsee.jaxws.framework.jaxrpc.JAXRPCEnvironmentFeature;
import weblogic.wsee.jaxws.framework.jaxrpc.ListenerUsage;
import weblogic.wsee.jaxws.framework.policy.EnvironmentMetadataFactory;
import weblogic.wsee.jaxws.framework.policy.PolicySubjectMetadata;
import weblogic.wsee.jaxws.framework.policy.PolicySubjectMetadataImpl;
import weblogic.wsee.jaxws.owsm.ClientEnvironmentFactory;
import weblogic.wsee.jaxws.owsm.DeploymentContext;
import weblogic.wsee.jaxws.owsm.SecurityPolicyHandler;
import weblogic.wsee.jaxws.owsm.ServerEnvironmentFactory;
import weblogic.wsee.jaxws.tubeline.standard.ClientContainerUtil;
import weblogic.wsee.jws.jaxws.owsm.PolicySubjectBindingFeature;
import weblogic.wsee.jws.jaxws.owsm.SecurityPoliciesFeature;
import weblogic.wsee.jws.jaxws.owsm.SecurityPolicyFeature;
import weblogic.wsee.policy.deployment.WseePolicyReferenceInfo;
import weblogic.wsee.runtime.owsm.PolicySubjectUtil;
import weblogic.wsee.util.StringUtil;
import weblogic.wsee.ws.WsPort;
import weblogic.wsee.ws.WsService;
import weblogic.wsee.ws.init.WsDeploymentContext;
import weblogic.wsee.ws.init.WsDeploymentException;
import weblogic.wsee.ws.init.WsDeploymentListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TubelineDeploymentListener
extends weblogic.wsee.jaxws.framework.jaxrpc.TubelineDeploymentListener
implements WsDeploymentListener {
    protected static String HANDLER_NAME = "OWSM_SECURITY_POLICY_HANDLER";
    protected Map config = new HashMap();

    public TubelineDeploymentListener(Class clazz, ListenerUsage listenerUsage) {
        super(clazz, listenerUsage);
    }

    protected HandlerInfo getHandlerInfo(Class clazz) {
        return new HandlerInfo(clazz, this.config, null);
    }

    protected List<String> getSecurityPolicyFeatureURIs(EnvironmentFactory environmentFactory) {
        Object object;
        WSBinding wSBinding = environmentFactory.getBinding();
        ArrayList<String> arrayList = new ArrayList<String>();
        SecurityPoliciesFeature securityPoliciesFeature = (SecurityPoliciesFeature)wSBinding.getFeature(SecurityPoliciesFeature.class);
        if (securityPoliciesFeature != null && securityPoliciesFeature.isEnabled()) {
            object = securityPoliciesFeature.getPolicies().iterator();
            while (object.hasNext()) {
                SecurityPolicyFeature securityPolicyFeature = (SecurityPolicyFeature)object.next();
                arrayList.add(securityPolicyFeature.getUri());
            }
        }
        if ((object = (SecurityPolicyFeature)wSBinding.getFeature(SecurityPolicyFeature.class)) != null && object.isEnabled()) {
            arrayList.add(object.getUri());
        }
        return arrayList;
    }

    abstract Class getHandlerClass();

    abstract List getPrecedingHandlers();

    abstract List getFollowingHandlers();

    abstract HandlerInfo getXopHandlerInfo();

    abstract List getPrecedingXopHandlers();

    abstract List getFollowingXopHandlers();

    @Override
    public void process(WsDeploymentContext wsDeploymentContext) throws WsDeploymentException {
        WsService wsService = wsDeploymentContext.getWsService();
        Iterator<WsPort> iterator = wsService.getPorts();
        while (iterator.hasNext()) {
            WsPort wsPort = iterator.next();
            HandlerList handlerList = wsPort.getInternalHandlerList();
            if (handlerList.contains(HANDLER_NAME)) {
                return;
            }
            try {
                assert (wsDeploymentContext instanceof DeploymentContext);
                DeploymentContext deploymentContext = (DeploymentContext)wsDeploymentContext;
                EnvironmentFactory environmentFactory = deploymentContext.getEnvFactory();
                HandlerInfo handlerInfo = this.getHandlerInfo(this.getHandlerClass());
                this.setProperties(environmentFactory, handlerInfo.getHandlerConfig());
                this.removeHandlers(handlerList);
                handlerList.lenientInsert(HANDLER_NAME, handlerInfo, this.getFollowingHandlers(), this.getPrecedingHandlers());
                handlerList.insert("NORMAL_XOP_HANDLER", this.getXopHandlerInfo(), this.getFollowingXopHandlers(), this.getPrecedingXopHandlers());
            }
            catch (HandlerException handlerException) {
                throw new WsDeploymentException(handlerException);
            }
        }
    }

    private void removeHandlers(HandlerList handlerList) {
        handlerList.remove("WS_SECURITY_1.1");
        handlerList.remove("PRE_WS_SECURITY_POLICY_1.2");
        handlerList.remove("POST_WS_SECURITY_POLICY_1.2");
        handlerList.remove("NORMAL_XOP_HANDLER");
    }

    protected SecurityPolicyHandler loadHandler(ClassLoader classLoader) {
        Iterator iterator = ServiceFinder.find(SecurityPolicyHandler.class, (ClassLoader)classLoader).iterator();
        if (!iterator.hasNext()) {
            throw new WebServiceException("No Handler for OWSM Security Policy found.");
        }
        SecurityPolicyHandler securityPolicyHandler = (SecurityPolicyHandler)iterator.next();
        if (iterator.hasNext()) {
            throw new WebServiceException("More than one Handler for OWSM Security Policy found.");
        }
        return securityPolicyHandler;
    }

    protected abstract void setProperties(EnvironmentFactory var1, Map var2);

    @Override
    protected EnvironmentFactory getEnvironmentFactory(ClientTubeAssemblerContext clientTubeAssemblerContext) {
        ClientEnvironmentFactory clientEnvironmentFactory = new ClientEnvironmentFactory(clientTubeAssemblerContext);
        WSBinding wSBinding = clientTubeAssemblerContext.getBinding();
        JAXRPCEnvironmentFeature jAXRPCEnvironmentFeature = (JAXRPCEnvironmentFeature)wSBinding.getFeature(JAXRPCEnvironmentFeature.class);
        jAXRPCEnvironmentFeature.setFactory(clientEnvironmentFactory);
        return clientEnvironmentFactory;
    }

    @Override
    protected EnvironmentFactory getEnvironmentFactory(ServerTubeAssemblerContext serverTubeAssemblerContext) {
        ServerEnvironmentFactory serverEnvironmentFactory = new ServerEnvironmentFactory(serverTubeAssemblerContext.getEndpoint());
        return serverEnvironmentFactory;
    }

    protected void setAdditionalOwsmProperties(EnvironmentFactory environmentFactory, Map map, List<String> list, boolean bl) {
        PolicySubjectMetadata policySubjectMetadata = this.initializePolicySubjectMetadata(environmentFactory, bl);
        PolicySubjectBindingFeature policySubjectBindingFeature = PolicySubjectBindingFeature.create(list, policySubjectMetadata);
        WSBinding wSBinding = environmentFactory.getBinding();
        ((WebServiceFeatureList)wSBinding.getFeatures()).add((WebServiceFeature)policySubjectBindingFeature);
        map.put("weblogic.wsee.jaxws.framework.policy.PolicySubjectBinding", policySubjectBindingFeature.getPolicySubjectBinding());
        if (!bl) {
            map.put("weblogic.wsee.jaxws.framework.policy.EnvironmentMetadata", EnvironmentMetadataFactory.getEnvironmentMetadata());
        }
    }

    protected void setAdditionalOwsmPropertiesWithOverrides(EnvironmentFactory environmentFactory, Map map, List<WseePolicyReferenceInfo> list, boolean bl) {
        PolicySubjectMetadata policySubjectMetadata = this.initializePolicySubjectMetadata(environmentFactory, bl);
        PolicySubjectBindingFeature policySubjectBindingFeature = PolicySubjectBindingFeature.createFeature(list, policySubjectMetadata);
        WSBinding wSBinding = environmentFactory.getBinding();
        ((WebServiceFeatureList)wSBinding.getFeatures()).add((WebServiceFeature)policySubjectBindingFeature);
        map.put("weblogic.wsee.jaxws.framework.policy.PolicySubjectBinding", policySubjectBindingFeature.getPolicySubjectBinding());
        if (!bl) {
            map.put("weblogic.wsee.jaxws.framework.policy.EnvironmentMetadata", EnvironmentMetadataFactory.getEnvironmentMetadata());
        }
    }

    protected PolicySubjectMetadata initializePolicySubjectMetadata(EnvironmentFactory environmentFactory, boolean bl) {
        ComponentRuntimeMBeanImpl componentRuntimeMBeanImpl = ClientContainerUtil.getContainingComponentRuntimeByModuleName(ContainerResolver.getInstance().getContainer().getSPI(DeployInfo.class) == null ? null : ((DeployInfo)ContainerResolver.getInstance().getContainer().getSPI(DeployInfo.class)).getModuleName());
        DeployInfo deployInfo = null;
        ServletContext servletContext = null;
        if (environmentFactory.getContainer() != null) {
            deployInfo = (DeployInfo)environmentFactory.getContainer().getSPI(DeployInfo.class);
            servletContext = (ServletContext)environmentFactory.getContainer().getSPI(ServletContext.class);
        }
        String string = this.getApplicationName(deployInfo, servletContext);
        String string2 = this.getModuleName(deployInfo, servletContext, componentRuntimeMBeanImpl);
        PolicySubjectMetadata.ModuleType moduleType = this.getModuleType(deployInfo, componentRuntimeMBeanImpl);
        QName qName = null;
        if (environmentFactory.getPort().getOwner() != null) {
            qName = environmentFactory.getPort().getOwner().getName();
        }
        if (qName == null && environmentFactory.getService().getWsdlService() != null) {
            qName = environmentFactory.getService().getWsdlService().getName();
        }
        QName qName2 = environmentFactory.getPort().getName();
        String string3 = null;
        string3 = bl ? PolicySubjectUtil.formatReferencedPortResourcePattern(qName2.getLocalPart(), qName.getLocalPart()) : PolicySubjectUtil.formatEndpointPortResourcePattern(qName2.getLocalPart(), qName.getLocalPart(), string2);
        return new PolicySubjectMetadataImpl(string, string2, moduleType, qName2, qName.getLocalPart(), bl ? PolicySubjectMetadata.Type.REFERENCE : PolicySubjectMetadata.Type.SERVICE, string3);
    }

    private String getApplicationName(DeployInfo deployInfo, ServletContext servletContext) {
        String string = null;
        if (deployInfo != null) {
            string = deployInfo.getApplication();
        } else if (servletContext instanceof WebAppServletContext) {
            try {
                ApplicationContextInternal applicationContextInternal = ((WebAppServletContext)servletContext).getApplicationContext();
                string = applicationContextInternal.getApplicationId();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (StringUtil.isEmpty(string) && ClientContainerUtil.getContainingApplicationRuntime() != null) {
            string = ClientContainerUtil.getContainingApplicationRuntime().getApplicationName();
        }
        return string;
    }

    private String getModuleName(DeployInfo deployInfo, ServletContext servletContext, ComponentRuntimeMBean componentRuntimeMBean) {
        String string = null;
        if (deployInfo != null) {
            string = deployInfo.getModuleName();
        } else if (servletContext instanceof WebAppServletContext) {
            string = ((WebAppServletContext)servletContext).getName();
        }
        if (StringUtil.isEmpty(string)) {
            String string2 = string = componentRuntimeMBean instanceof WebAppComponentRuntimeMBean ? ((WebAppComponentRuntimeMBean)componentRuntimeMBean).getModuleURI() : ClientContainerUtil.getContainingModuleName();
        }
        if (!StringUtil.isEmpty(string) && string.startsWith("/")) {
            string = string.substring(1);
        }
        return string;
    }

    private PolicySubjectMetadata.ModuleType getModuleType(DeployInfo deployInfo, ComponentRuntimeMBean componentRuntimeMBean) {
        PolicySubjectMetadata.ModuleType moduleType;
        PolicySubjectMetadata.ModuleType moduleType2 = moduleType = KernelStatus.isServer() ? PolicySubjectMetadata.ModuleType.WEB : PolicySubjectMetadata.ModuleType.JSE;
        if (deployInfo instanceof EJBDeployInfo) {
            moduleType = PolicySubjectMetadata.ModuleType.EJB;
        }
        if (componentRuntimeMBean instanceof WebAppComponentRuntimeMBean) {
            moduleType = PolicySubjectMetadata.ModuleType.WEB;
        } else if (componentRuntimeMBean instanceof EJBComponentRuntimeMBean) {
            moduleType = PolicySubjectMetadata.ModuleType.EJB;
        }
        return moduleType;
    }
}

