/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.jaxws.owsm;

import com.sun.istack.NotNull;
import com.sun.istack.Nullable;
import com.sun.xml.ws.api.WSDLLocator;
import com.sun.xml.ws.api.server.ContainerResolver;
import com.sun.xml.ws.api.wsdl.parser.MetaDataResolver;
import com.sun.xml.ws.api.wsdl.parser.MetadataResolverFactory;
import com.sun.xml.ws.api.wsdl.parser.ServiceDescriptor;
import com.sun.xml.ws.resources.ClientMessages;
import com.sun.xml.ws.util.ServiceFinder;
import com.sun.xml.ws.wsdl.parser.InaccessibleWSDLException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.ws.Service;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.WebServiceFeature;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import weblogic.wsee.jaxws.framework.policy.advertisementimpl.AdvertisementHelper;
import weblogic.wsee.jaxws.framework.policy.advertisementimpl.AdvertisementHelperFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WsdlDefinitionFeature
extends WebServiceFeature {
    private static final String ID = WsdlDefinitionFeature.class.getName();
    private Object definition = null;

    public WsdlDefinitionFeature(Object object) {
        this.definition = object;
        this.enabled = true;
    }

    public String getID() {
        return ID;
    }

    public Object getDefinition() {
        return this.definition;
    }

    public static boolean required() {
        AdvertisementHelper advertisementHelper = AdvertisementHelperFactory.getAdvertisementHelper();
        return advertisementHelper != null;
    }

    public static WsdlDefinitionFeature create(Object object, Class<? extends Service> clazz, EntityResolver entityResolver) {
        assert (entityResolver != null);
        if (object != null) {
            return new WsdlDefinitionFeature(object);
        }
        return null;
    }

    public static WsdlDefinitionFeature create(URL uRL, Source source, Class<? extends Service> clazz, EntityResolver entityResolver) throws IOException, SAXException {
        assert (entityResolver != null);
        Object object = null;
        object = WsdlDefinitionFeature.readDefinition(uRL, source, clazz, entityResolver);
        if (object != null) {
            return new WsdlDefinitionFeature(object);
        }
        return null;
    }

    public static Object readDefinition(URL uRL, Source source, Class<? extends Service> clazz, EntityResolver entityResolver) throws IOException, SAXException {
        Object object = null;
        AdvertisementHelper advertisementHelper = AdvertisementHelperFactory.getAdvertisementHelper();
        if (advertisementHelper != null) {
            try {
                InputSource inputSource = WsdlDefinitionFeature.resolveWSDL(uRL, source, clazz, entityResolver);
                if (inputSource.getSystemId() != null) {
                    String string = inputSource.getSystemId();
                    URL uRL2 = new URL(string);
                    object = advertisementHelper.readWSDL(uRL2, inputSource);
                } else {
                    object = advertisementHelper.readWSDL(uRL, inputSource);
                }
            }
            catch (Exception exception) {
                if (uRL == null) {
                    throw new WebServiceException((Throwable)exception);
                }
                InputSource inputSource = WsdlDefinitionFeature.tryWithMex(uRL, entityResolver, exception, clazz);
                object = advertisementHelper.readWSDL(uRL, inputSource);
            }
        }
        return object;
    }

    private static InputSource resolveWSDL(@Nullable URL uRL, @NotNull Source source, Class clazz, EntityResolver entityResolver) throws IOException, SAXException {
        String string;
        URL uRL2;
        Object object;
        String string2 = source.getSystemId();
        InputSource inputSource = entityResolver.resolveEntity(null, string2);
        if (inputSource == null && uRL != null && (inputSource = entityResolver.resolveEntity(null, (String)(object = uRL.toExternalForm()))) == null && clazz != null && (uRL2 = clazz.getResource(".")) != null && ((String)object).startsWith(string = uRL2.toExternalForm())) {
            inputSource = entityResolver.resolveEntity(null, ((String)object).substring(string.length()));
        }
        if (inputSource == null) {
            object = null;
            if (source != null) {
                object = WsdlDefinitionFeature.createReader(source);
            } else if (uRL != null) {
                object = WsdlDefinitionFeature.createReader(uRL, clazz);
            }
            if (object != null) {
                inputSource = new InputSource((InputStream)object);
            }
        }
        return inputSource;
    }

    private static InputStream createReader(@NotNull Source source) throws MalformedURLException, IOException {
        StreamSource streamSource;
        InputStream inputStream = null;
        if (source instanceof StreamSource && (inputStream = (streamSource = (StreamSource)source).getInputStream()) == null) {
            inputStream = new URL(source.getSystemId()).openStream();
        }
        return inputStream;
    }

    private static InputStream createReader(URL uRL, Class<Service> clazz) throws IOException {
        InputStream inputStream = null;
        try {
            inputStream = uRL.openStream();
        }
        catch (IOException iOException) {
            WSDLLocator wSDLLocator;
            if (clazz != null && (wSDLLocator = (WSDLLocator)ContainerResolver.getInstance().getContainer().getSPI(WSDLLocator.class)) != null) {
                String string;
                String string2 = uRL.toExternalForm();
                URL uRL2 = clazz.getResource(".");
                String string3 = uRL.getPath();
                if (uRL2 != null && string2.startsWith(string = uRL2.toExternalForm())) {
                    string3 = string2.substring(string.length());
                }
                if ((uRL = wSDLLocator.locateWSDL(clazz, string3)) != null) {
                    inputStream = uRL.openStream();
                }
            }
            throw iOException;
        }
        return inputStream;
    }

    private static InputSource tryWithMex(@NotNull URL uRL, @NotNull EntityResolver entityResolver, Throwable throwable, Class clazz) {
        ArrayList<Throwable> arrayList = new ArrayList<Throwable>();
        try {
            InputSource inputSource = WsdlDefinitionFeature.parseUsingMex(uRL, entityResolver, clazz);
            if (inputSource == null) {
                throw new WebServiceException(ClientMessages.FAILED_TO_PARSE((Object)uRL.toExternalForm(), (Object)throwable.getMessage()), throwable);
            }
            return inputSource;
        }
        catch (Exception exception) {
            arrayList.add(throwable);
            arrayList.add(exception);
            throw new InaccessibleWSDLException(arrayList);
        }
    }

    private static InputSource parseUsingMex(@NotNull URL uRL, @NotNull EntityResolver entityResolver, Class clazz) throws IOException, SAXException, URISyntaxException {
        Object object;
        MetaDataResolver metaDataResolver = null;
        ServiceDescriptor serviceDescriptor = null;
        InputSource inputSource = null;
        Object object2 = ServiceFinder.find(MetadataResolverFactory.class).iterator();
        while (object2.hasNext() && (serviceDescriptor = (metaDataResolver = (object = (MetadataResolverFactory)object2.next()).metadataResolver(entityResolver)).resolve(uRL.toURI())) == null) {
        }
        if (serviceDescriptor != null) {
            object2 = serviceDescriptor.getWSDLs().iterator();
            while (object2.hasNext() && (inputSource = WsdlDefinitionFeature.resolveWSDL(null, (Source)(object = (Source)object2.next()), null, entityResolver)) == null) {
            }
        }
        if ((metaDataResolver == null || serviceDescriptor == null) && (uRL.getProtocol().equals("http") || uRL.getProtocol().equals("https")) && uRL.getQuery() == null) {
            object2 = uRL.toExternalForm();
            object2 = (String)object2 + "?wsdl";
            uRL = new URL((String)object2);
            inputSource = WsdlDefinitionFeature.resolveWSDL(uRL, new StreamSource(uRL.toExternalForm()), clazz, entityResolver);
        }
        return inputSource;
    }

    public static void writeWSDL(Object object, OutputStream outputStream) throws IOException {
        AdvertisementHelper advertisementHelper = AdvertisementHelperFactory.getAdvertisementHelper();
        if (advertisementHelper != null) {
            advertisementHelper.writeWSDL(object, outputStream);
        }
    }

    public static String getDocumentBaseUriFromWSDL(Object object) {
        AdvertisementHelper advertisementHelper = AdvertisementHelperFactory.getAdvertisementHelper();
        if (advertisementHelper != null) {
            return advertisementHelper.getDocumentBaseUriFromWSDL(object);
        }
        return null;
    }
}

