/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.jaxws.persistence;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import weblogic.jws.jaxws.WLSWebServiceFeature;
import weblogic.jws.jaxws.client.ClientIdentityFeature;

public class ClientInstancePoolFeature
extends WLSWebServiceFeature {
    private static final Logger LOGGER = Logger.getLogger(ClientInstancePoolFeature.class.getName());
    private static String ID = "Durable Client Pool Init Feature";
    private boolean _customized;
    private int _capacity;
    private boolean _durable;
    private ClientIdentityFeature _clientIdentityFeature;
    private List<PropertyChangeListener> _listeners;
    private boolean _disposed;
    private boolean _closedAllDurableClients;

    public ClientInstancePoolFeature() {
        this.enabled = true;
        this._capacity = 10;
        this._durable = false;
        this._listeners = new ArrayList<PropertyChangeListener>();
        this._disposed = false;
        this._closedAllDurableClients = false;
        this.setTubelineImpact(false);
    }

    public String getID() {
        return ID;
    }

    public boolean isCustomized() {
        return this._customized;
    }

    public int getCapacity() {
        return this._capacity;
    }

    public void setCapacity(int n) {
        this._customized = true;
        this._capacity = n;
    }

    public boolean isDurable() {
        return this._durable;
    }

    public void setDurable(boolean bl) {
        this._customized = true;
        this._durable = bl;
    }

    public ClientIdentityFeature getClientIdentityFeature() {
        return this._clientIdentityFeature;
    }

    public void setClientIdentityFeature(ClientIdentityFeature clientIdentityFeature) {
        this._clientIdentityFeature = clientIdentityFeature;
    }

    public void dispose() {
        boolean bl;
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Disposing DurableClientPoolFeature");
        }
        if (!(bl = this._disposed)) {
            this._disposed = true;
            this.firePropertyChangeEvent("Disposed", bl, this._disposed);
        }
    }

    public void closeAllDurableClients() {
        boolean bl = this._closedAllDurableClients;
        if (!bl) {
            this._closedAllDurableClients = true;
        }
        this.firePropertyChangeEvent("ClosedAllDurableClients", bl, this._closedAllDurableClients);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (!this._listeners.contains(propertyChangeListener)) {
            this._listeners.add(propertyChangeListener);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this._listeners.remove(propertyChangeListener);
    }

    private void firePropertyChangeEvent(String string, Object object, Object object2) {
        PropertyChangeListener[] propertyChangeListenerArray;
        if (this.objectsEqual(object, object2)) {
            return;
        }
        PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent((Object)this, string, object, object2);
        for (PropertyChangeListener propertyChangeListener : propertyChangeListenerArray = this._listeners.toArray(new PropertyChangeListener[this._listeners.size()])) {
            try {
                propertyChangeListener.propertyChange(propertyChangeEvent);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private boolean objectsEqual(Object object, Object object2) {
        if (object == null && object2 == null) {
            return true;
        }
        if (object != null) {
            return object.equals(object2);
        }
        return object2.equals(object);
    }
}

