/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.jaxws.persistence;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import weblogic.wsee.jaxws.persistence.ClientInstanceProperties;
import weblogic.wsee.jaxws.spi.ClientInstanceIdentity;
import weblogic.wsee.persistence.StoreConnection;
import weblogic.wsee.persistence.StoreException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientInstancePropertiesStoreConnection
extends StoreConnection<ClientInstanceIdentity, ClientInstanceProperties> {
    private ReentrantReadWriteLock _clientIdMapLock = new ReentrantReadWriteLock(false);
    private Map<String, Map<Serializable, ClientInstanceProperties>> _clientIdMap = new HashMap<String, Map<Serializable, ClientInstanceProperties>>();

    public ClientInstancePropertiesStoreConnection(String string, String string2) throws StoreException {
        super(string, string2);
    }

    @Override
    protected void recoveryStarting() {
    }

    @Override
    protected void recoverValue(ClientInstanceProperties clientInstanceProperties) {
        super.recoverValue(clientInstanceProperties);
        Map<Serializable, ClientInstanceProperties> map = this._clientIdMap.get(clientInstanceProperties.getId().getClientId());
        if (map == null) {
            map = new HashMap<Serializable, ClientInstanceProperties>();
            this._clientIdMap.put(clientInstanceProperties.getId().getClientId(), map);
        }
        map.put(clientInstanceProperties.getId().getExtraId(), clientInstanceProperties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ClientInstanceProperties put(ClientInstanceIdentity clientInstanceIdentity, ClientInstanceProperties clientInstanceProperties) {
        try {
            this._clientIdMapLock.writeLock().lock();
            Map<Serializable, ClientInstanceProperties> map = this._clientIdMap.get(clientInstanceIdentity.getClientId());
            if (map == null) {
                map = new HashMap<Serializable, ClientInstanceProperties>();
                this._clientIdMap.put(clientInstanceIdentity.getClientId(), map);
            }
            map.put(clientInstanceIdentity.getExtraId(), clientInstanceProperties);
            Object var5_4 = null;
            this._clientIdMapLock.writeLock().unlock();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this._clientIdMapLock.writeLock().unlock();
            throw throwable;
        }
        return super.put(clientInstanceIdentity, clientInstanceProperties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Serializable, ClientInstanceProperties> getByClientId(String string) {
        try {
            this._clientIdMapLock.readLock().lock();
            Map<Serializable, ClientInstanceProperties> map = this._clientIdMap.get(string);
            HashMap<Serializable, ClientInstanceProperties> hashMap = map != null ? new HashMap<Serializable, ClientInstanceProperties>(map) : null;
            Object var5_4 = null;
            this._clientIdMapLock.readLock().unlock();
            return hashMap;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this._clientIdMapLock.readLock().unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ClientInstanceProperties remove(Object object) {
        ClientInstanceProperties clientInstanceProperties;
        ClientInstanceIdentity clientInstanceIdentity;
        block5: {
            try {
                clientInstanceIdentity = (ClientInstanceIdentity)object;
                clientInstanceProperties = (ClientInstanceProperties)super.remove(clientInstanceIdentity);
                if (clientInstanceProperties != null) break block5;
                ClientInstanceProperties clientInstanceProperties2 = null;
                Object var7_6 = null;
                this._clientIdMapLock.writeLock().unlock();
                return clientInstanceProperties2;
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                this._clientIdMapLock.writeLock().unlock();
                throw throwable;
            }
        }
        this._clientIdMapLock.writeLock().lock();
        Map<Serializable, ClientInstanceProperties> map = this._clientIdMap.get(clientInstanceIdentity.getClientId());
        if (map != null) {
            map.remove(clientInstanceIdentity.getExtraId());
            if (map.isEmpty()) {
                this._clientIdMap.remove(clientInstanceIdentity.getClientId());
            }
        }
        ClientInstanceProperties clientInstanceProperties3 = clientInstanceProperties;
        Object var7_7 = null;
        this._clientIdMapLock.writeLock().unlock();
        return clientInstanceProperties3;
    }
}

