/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.jaxws.persistence;

import com.sun.istack.Nullable;
import com.sun.xml.ws.api.pipe.ClientTubeAssemblerContext;
import com.sun.xml.ws.api.pipe.ServerTubeAssemblerContext;
import com.sun.xml.ws.client.Stub;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import weblogic.j2ee.descriptor.wl.PersistenceConfigBean;
import weblogic.j2ee.descriptor.wl.PortComponentBean;
import weblogic.j2ee.descriptor.wl.PortInfoBean;
import weblogic.management.configuration.WebServiceLogicalStoreMBean;
import weblogic.management.configuration.WebServiceMBean;
import weblogic.wsee.WseePersistLogger;
import weblogic.wsee.config.WebServiceMBeanFactory;
import weblogic.wsee.jaxws.config.PerClientPropertyAccessor;
import weblogic.wsee.jaxws.config.PerServicePropertyAccessor;
import weblogic.wsee.jaxws.config.Property;
import weblogic.wsee.jaxws.config.PropertyContainer;
import weblogic.wsee.jaxws.config.VmWidePropertyAccessor;
import weblogic.wsee.jaxws.framework.ConfigUtil;
import weblogic.wsee.jaxws.spi.WLSServiceDelegate;
import weblogic.wsee.ws.WsPort;

public class PersistenceConfig {
    public static Client getClientConfig(@Nullable PortInfoBean portInfoBean) {
        Client client = new Client(portInfoBean);
        return client;
    }

    public static Client getClientConfig(@Nullable ClientTubeAssemblerContext clientTubeAssemblerContext) {
        Client client = new Client(clientTubeAssemblerContext);
        return client;
    }

    public static Client getClientConfig(@Nullable Stub stub) {
        Client client = new Client((WLSServiceDelegate)stub.getService(), stub.getPortName().getLocalPart());
        return client;
    }

    public static Service getServiceConfig(@Nullable ServerTubeAssemblerContext serverTubeAssemblerContext) {
        Service service2 = new Service(serverTubeAssemblerContext);
        return service2;
    }

    public static Service getServiceConfig(@Nullable WsPort wsPort) {
        Service service2 = new Service(wsPort);
        return service2;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class Common
    extends PropertyContainer {
        protected Property<String> _logicalStoreName;

        protected PersistenceConfigBean getPersistenceConfigBeanFromWsPort(WsPort wsPort) {
            PersistenceConfigBean persistenceConfigBean = null;
            if (wsPort != null) {
                PortComponentBean portComponentBean = wsPort.getPortComponent();
                persistenceConfigBean = portComponentBean != null ? portComponentBean.getPersistenceConfig() : null;
            }
            return persistenceConfigBean;
        }

        public WebServiceLogicalStoreMBean getLogicalStoreMBean() {
            WebServiceMBean webServiceMBean = WebServiceMBeanFactory.getInstance();
            WebServiceLogicalStoreMBean[] webServiceLogicalStoreMBeanArray = webServiceMBean.getWebServicePersistence().getWebServiceLogicalStores();
            String string = this.getLogicalStoreName();
            for (WebServiceLogicalStoreMBean webServiceLogicalStoreMBean : webServiceLogicalStoreMBeanArray) {
                if (!webServiceLogicalStoreMBean.getName().equals(string)) continue;
                return webServiceLogicalStoreMBean;
            }
            throw new IllegalArgumentException(WseePersistLogger.logLogicalStoreNotFoundLoggable((String)string).getMessage());
        }

        public String getLogicalStoreName() {
            return this._logicalStoreName.getValue();
        }

        @Override
        protected List<Property> getPropertyFields() {
            ArrayList<Property> arrayList = new ArrayList<Property>();
            arrayList.add(this._logicalStoreName);
            return arrayList;
        }
    }

    public static class Service
    extends Common {
        public Service(@Nullable ServerTubeAssemblerContext serverTubeAssemblerContext) {
            PersistenceConfigBean persistenceConfigBean = null;
            if (serverTubeAssemblerContext != null) {
                PortComponentBean portComponentBean = ConfigUtil.getPortComponentBeanForService(serverTubeAssemblerContext);
                persistenceConfigBean = portComponentBean != null ? portComponentBean.getPersistenceConfig() : null;
            }
            this.init(persistenceConfigBean);
        }

        public Service(@Nullable WsPort wsPort) {
            PersistenceConfigBean persistenceConfigBean = this.getPersistenceConfigBeanFromWsPort(wsPort);
            this.init(persistenceConfigBean);
        }

        protected void init(@Nullable PersistenceConfigBean persistenceConfigBean) {
            if (persistenceConfigBean != null && !persistenceConfigBean.isCustomized()) {
                persistenceConfigBean = null;
            }
            WebServiceMBean webServiceMBean = WebServiceMBeanFactory.getInstance();
            this._logicalStoreName = new Property<String>("DefaultLogicalStoreName", String.class, "WseeStore", new PerServicePropertyAccessor(persistenceConfigBean), new VmWidePropertyAccessor(webServiceMBean.getWebServicePersistence()));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Client
    extends Common {
        public static final String LOGICAL_STORE_NAME_PROP = "weblogic.wsee.persistence.DefaultLogicalStoreName";

        public Client(@Nullable ClientTubeAssemblerContext clientTubeAssemblerContext) {
            Map<String, Object> map = null;
            if (clientTubeAssemblerContext != null) {
                map = ConfigUtil.getServiceRefPropsForClient(clientTubeAssemblerContext);
            }
            this.init(map);
        }

        public Client(@Nullable WLSServiceDelegate wLSServiceDelegate, String string) {
            Map<String, Object> map = ConfigUtil.getServiceRefPropsForClient(wLSServiceDelegate, string);
            this.init(map);
        }

        public Client(@Nullable PortInfoBean portInfoBean) {
            Map<String, Object> map = null;
            if (portInfoBean != null) {
                map = ConfigUtil.getServiceRefProps(portInfoBean);
            }
            this.init(map);
        }

        protected void init(@Nullable Map<String, Object> map) {
            WebServiceMBean webServiceMBean = WebServiceMBeanFactory.getInstance();
            this._logicalStoreName = new Property<String>("DefaultLogicalStoreName", String.class, "WseeStore", new PerClientPropertyAccessor(LOGICAL_STORE_NAME_PROP, map), new VmWidePropertyAccessor(webServiceMBean.getWebServicePersistence()));
        }
    }
}

