/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.jaxws.persistence;

import com.sun.istack.NotNull;
import com.sun.istack.Nullable;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.AccessController;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import weblogic.kernel.KernelStatus;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityServiceManager;
import weblogic.security.subject.AbstractSubject;
import weblogic.security.subject.SubjectManager;
import weblogic.wsee.WseeCoreLogger;
import weblogic.wsee.jaxws.persistence.PersistentContextStore;
import weblogic.wsee.persistence.AbstractStorable;
import weblogic.wsee.server.EncryptionUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistentContext
extends AbstractStorable {
    private static final long serialVersionUID = 1L;
    private static final AuthenticatedSubject KERNEL_ID = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private transient ReentrantReadWriteLock _lock;
    private Map<String, Serializable> _propertyMap;
    private Set<String> _propBagClassNames;
    private Map<String, Serializable> _contextPropertyMap;
    private Map<String, Serializable> _invocationPropertyMap;
    private AuthenticatedSubject _subject;
    private State _state;

    public static PersistentContextStore getStoreMap(String string) {
        try {
            return PersistentContextStore.getStore(string);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.toString(), exception);
        }
    }

    private static AuthenticatedSubject getCurrentSubject() {
        AuthenticatedSubject authenticatedSubject = SecurityServiceManager.getCurrentSubject((AuthenticatedSubject)KERNEL_ID);
        return authenticatedSubject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        try {
            this._lock.readLock().lock();
            objectOutputStream.writeObject(this._propertyMap);
            objectOutputStream.writeObject(this._propBagClassNames);
            objectOutputStream.writeObject(this._contextPropertyMap);
            objectOutputStream.writeObject(this._invocationPropertyMap);
            objectOutputStream.writeObject((Object)this._state);
            this.writeSubject(objectOutputStream);
        }
        finally {
            this._lock.readLock().unlock();
        }
    }

    private void writeSubject(ObjectOutputStream objectOutputStream) throws IOException {
        Object object;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream2 = new ObjectOutputStream(byteArrayOutputStream);
        if (SubjectManager.getSubjectManager().isKernelIdentity((AbstractSubject)this._subject)) {
            object = (AuthenticatedSubject)SubjectManager.getSubjectManager().getAnonymousSubject();
            objectOutputStream2.writeObject(object);
        } else {
            objectOutputStream2.writeObject(this._subject);
        }
        objectOutputStream2.flush();
        object = byteArrayOutputStream.toByteArray();
        if (KernelStatus.isServer()) {
            object = EncryptionUtil.encrypt((byte[])object);
        }
        objectOutputStream.writeInt(((AuthenticatedSubject)object).length);
        objectOutputStream.write((byte[])object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.initTransients();
        try {
            this._lock.writeLock().lock();
            this._propertyMap = (Map)objectInputStream.readObject();
            this._propBagClassNames = (Set)objectInputStream.readObject();
            this._contextPropertyMap = (Map)objectInputStream.readObject();
            this._invocationPropertyMap = (Map)objectInputStream.readObject();
            this._state = (State)((Object)objectInputStream.readObject());
            this.readSubject(objectInputStream);
        }
        finally {
            this._lock.writeLock().unlock();
        }
    }

    protected void initTransients() {
        this._lock = new ReentrantReadWriteLock(false);
    }

    private void readSubject(ObjectInputStream objectInputStream) {
        try {
            int n = objectInputStream.readInt();
            byte[] byArray = new byte[n];
            objectInputStream.readFully(byArray);
            if (KernelStatus.isServer()) {
                byArray = EncryptionUtil.decrypt(byArray);
            }
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            ObjectInputStream objectInputStream2 = new ObjectInputStream(byteArrayInputStream);
            this._subject = (AuthenticatedSubject)objectInputStream2.readObject();
        }
        catch (Exception exception) {
            WseeCoreLogger.logUnexpectedException((String)"Couldn't completely read PersistentContext subject", (Throwable)exception);
        }
    }

    PersistentContext(@NotNull String string, @NotNull Map<String, Serializable> map, @NotNull Set<String> set, @Nullable Map<String, Serializable> map2, @NotNull Map<String, Serializable> map3) {
        super((Serializable)((Object)string));
        this._propertyMap = map;
        this._propBagClassNames = set;
        this._contextPropertyMap = map2;
        this._invocationPropertyMap = map3;
        this._state = State.UNUSED;
        AuthenticatedSubject authenticatedSubject = PersistentContext.getCurrentSubject();
        if (SecurityServiceManager.isKernelIdentity((AuthenticatedSubject)authenticatedSubject)) {
            throw new IllegalStateException("Attempt to create PersistentContext using kernel identity. All actions that can create PersistentContext must run as a user principal");
        }
        this._subject = authenticatedSubject;
        this.initTransients();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Map<String, Serializable> getPropertyMap() {
        try {
            this._lock.readLock().lock();
            Map<String, Serializable> map = this._propertyMap;
            return map;
        }
        finally {
            this._lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Set<String> getPropertyBagClassNames() {
        try {
            this._lock.readLock().lock();
            Set<String> set = this._propBagClassNames;
            return set;
        }
        finally {
            this._lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Map<String, Serializable> getContextPropertyMap() {
        try {
            this._lock.readLock().lock();
            Map<String, Serializable> map = this._contextPropertyMap;
            return map;
        }
        finally {
            this._lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Map<String, Serializable> getInvocationPropertyMap() {
        try {
            this._lock.readLock().lock();
            Map<String, Serializable> map = this._invocationPropertyMap;
            return map;
        }
        finally {
            this._lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public State getState() {
        this._lock.readLock().lock();
        try {
            State state = this._state;
            return state;
        }
        finally {
            this._lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setState(State state) {
        this._lock.writeLock().lock();
        try {
            this._state = state;
        }
        finally {
            this._lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public String getSubjectAsString() {
        try {
            this._lock.readLock().lock();
            String string = this._subject.toString();
            return string;
        }
        finally {
            this._lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AuthenticatedSubject getSubject(AuthenticatedSubject authenticatedSubject) {
        if (!SecurityServiceManager.isKernelIdentity((AuthenticatedSubject)authenticatedSubject)) {
            throw new SecurityException("Unauthorized access to PersistentContext.getSubject()");
        }
        try {
            this._lock.readLock().lock();
            AuthenticatedSubject authenticatedSubject2 = this._subject;
            return authenticatedSubject2;
        }
        finally {
            this._lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getMessageId() {
        try {
            this._lock.readLock().lock();
            String string = (String)((Object)this.getObjectId());
            return string;
        }
        finally {
            this._lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasExplicitExpiration() {
        this._lock.readLock().lock();
        try {
            boolean bl = this._state == State.IN_USE;
            return bl;
        }
        finally {
            this._lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isExpired() {
        this._lock.readLock().lock();
        try {
            boolean bl = this._state != State.IN_USE;
            return bl;
        }
        finally {
            this._lock.readLock().unlock();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State {
        UNUSED,
        IN_USE,
        OBSOLETE;

    }
}

