/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.jaxws.persistence;

import com.sun.istack.NotNull;
import com.sun.xml.ws.api.message.Message;
import com.sun.xml.ws.api.message.Messages;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.streaming.XMLStreamReaderFactory;
import com.sun.xml.ws.api.streaming.XMLStreamWriterFactory;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.BitSet;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import weblogic.wsee.jaxws.persistence.PersistentContext;

public class PersistentMessage
implements Serializable {
    private static final long serialVersionUID = 1L;
    private transient Message _message;
    private transient PersistentContext _context;

    public PersistentMessage(@NotNull Message message, @NotNull PersistentContext persistentContext) {
        this._message = message;
        this._context = persistentContext;
    }

    @NotNull
    public Message getMessage() {
        return this._message;
    }

    @NotNull
    public PersistentContext getContext() {
        return this._context;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject("10.3.6");
        if (this._message != null) {
            Object object;
            try {
                object = new ByteArrayOutputStream();
                XMLStreamWriter xMLStreamWriter = XMLStreamWriterFactory.create((OutputStream)object, (String)"UTF-8");
                this._message.writeTo(new Packet(this._message), xMLStreamWriter);
                xMLStreamWriter.flush();
                xMLStreamWriter.close();
                ((OutputStream)object).flush();
                XMLStreamWriterFactory.recycle((XMLStreamWriter)xMLStreamWriter);
                byte[] byArray = ((ByteArrayOutputStream)object).toByteArray();
                objectOutputStream.writeInt(byArray.length);
                objectOutputStream.write(byArray);
            }
            catch (Exception exception) {
                throw new IOException(exception.toString(), exception);
            }
            object = new BitSet(this._message.getHeaders().size());
            for (int i = 0; i < this._message.getHeaders().size(); ++i) {
                if (!this._message.getHeaders().isUnderstood(i)) continue;
                ((BitSet)object).set(i, true);
            }
            objectOutputStream.writeObject(object);
        } else {
            objectOutputStream.writeInt(0);
        }
        objectOutputStream.writeObject(this._context);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.readObject();
        int n = objectInputStream.readInt();
        if (n != 0) {
            Object object;
            try {
                object = new byte[n];
                objectInputStream.readFully((byte[])object);
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream((byte[])object);
                XMLStreamReader xMLStreamReader = XMLStreamReaderFactory.create(null, (InputStream)byteArrayInputStream, (String)"UTF-8", (boolean)false);
                this._message = Messages.create((XMLStreamReader)xMLStreamReader);
            }
            catch (Exception exception) {
                throw new IOException(exception.toString(), exception);
            }
            object = (BitSet)objectInputStream.readObject();
            for (int i = 0; i < ((BitSet)object).length(); ++i) {
                if (!((BitSet)object).get(i)) continue;
                this._message.getHeaders().understood(i);
            }
        } else {
            this._message = null;
        }
        this._context = (PersistentContext)objectInputStream.readObject();
    }
}

