/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.jaxws.persistence;

import com.sun.xml.ws.api.message.Packet;
import java.io.Serializable;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.SecurityServiceManager;
import weblogic.security.subject.AbstractSubject;
import weblogic.security.subject.SubjectManager;
import weblogic.wsee.jaxws.framework.PropertySetUtil;
import weblogic.wsee.jaxws.persistence.PacketPersistencePropertyBag;
import weblogic.wsee.jaxws.persistence.PersistentContext;
import weblogic.wsee.jaxws.persistence.PersistentMessage;
import weblogic.wsee.jaxws.persistence.StandardPersistentPropertyRegister;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistentMessageFactory {
    private static final Logger LOGGER = Logger.getLogger(PersistentMessageFactory.class.getName());
    private static final PersistentMessageFactory _instance = new PersistentMessageFactory();
    private Map<String, PropertySetUtil.PropertySetRetriever<?>> propSetRetrievers = new ConcurrentHashMap();

    public static PersistentMessageFactory getInstance() {
        return _instance;
    }

    public PersistentMessage createMessageFromPacket(String string, Packet packet) {
        PersistentContext persistentContext = this.createContextFromPacket(string, packet);
        return new PersistentMessage(packet.getMessage(), persistentContext);
    }

    public PersistentContext createContextFromPacket(String string, Packet packet) {
        Object object;
        HashMap<String, Serializable> hashMap;
        PacketPersistencePropertyBag packetPersistencePropertyBag = PacketPersistencePropertyBag.propertySetRetriever.getFromPacket(packet);
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.addAll(packetPersistencePropertyBag.getPersistablePropertyBagClassNames());
        HashMap<String, Serializable> hashMap2 = new HashMap<String, Serializable>();
        if (packet.component != null && (hashMap = (StandardPersistentPropertyRegister)packet.component.getSPI(StandardPersistentPropertyRegister.class)) != null) {
            for (String string2 : hashMap.getStandardProperties()) {
                object = this.getPropertyFromPacket(packet, string2);
                hashMap2.put(string2, (Serializable)object);
            }
            hashSet.addAll(hashMap.getStandardPropertyBagClassNames());
        }
        for (String string3 : packetPersistencePropertyBag.getPersistablePropertyNames()) {
            Object object2 = this.getPropertyFromPacket(packet, string3);
            hashMap2.put(string3, (Serializable)object2);
        }
        hashMap = new HashMap<String, Serializable>();
        for (String string4 : packetPersistencePropertyBag.getPersistableInvocationPropertyNames()) {
            if (!packet.invocationProperties.containsKey(string4)) {
                throw new IllegalArgumentException("Packet property '" + string4 + "' was flagged to be persistent, but is not present in the Packet instance being persisted.");
            }
            object = packet.invocationProperties.get(string4);
            if (object != null && !(object instanceof Serializable)) {
                throw new IllegalArgumentException("Packet property '" + string4 + "' was flagged to be persistent, but is not Serializable");
            }
            hashMap.put(string4, (Serializable)object);
        }
        Map map = (Map)packet.get((Object)"weblogic.wsee.jaxws.async.PersistentContext");
        return new PersistentContext(string, hashMap2, hashSet, map, hashMap);
    }

    private Object getPropertyFromPacket(Packet packet, String string) {
        Object object;
        if (packet.supports((Object)string)) {
            object = packet.get((Object)string);
        } else {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Property '" + string + "' was flagged to be persistent but isn't supported (no PropertySet that includes it) by the current Packet. Skipping getting a value for it when saving PeristentContext.");
            }
            object = null;
        }
        if (object != null && !(object instanceof Serializable)) {
            throw new IllegalArgumentException("Packet property '" + string + "' was flagged to be persistent, but is not Serializable");
        }
        return object;
    }

    public void setMessageIntoPacket(PersistentMessage persistentMessage, Packet packet) {
        packet.setMessage(persistentMessage.getMessage());
        this.setContextIntoPacket(persistentMessage.getContext(), packet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setContextIntoPacket(PersistentContext persistentContext, Packet packet) {
        Class<?> clazz;
        Set<String> set = persistentContext.getPropertyBagClassNames();
        for (String map2 : set) {
            try {
                PropertySetUtil.PropertySetRetriever<?> propertySetRetriever = this.propSetRetrievers.get(map2);
                if (propertySetRetriever == null) {
                    Map<String, PropertySetUtil.PropertySetRetriever<?>> map = this.propSetRetrievers;
                    synchronized (map) {
                        propertySetRetriever = this.propSetRetrievers.get(map2);
                        if (propertySetRetriever == null) {
                            clazz = this.getClass().getClassLoader().loadClass(map2);
                            propertySetRetriever = PropertySetUtil.getRetriever(clazz);
                            this.propSetRetrievers.put(map2, propertySetRetriever);
                        }
                    }
                }
                propertySetRetriever.getFromPacket(packet);
            }
            catch (Exception exception) {
                throw new RuntimeException("Error loading satellite property set back into Packet to accept PersistentContext: " + exception.toString(), exception);
            }
        }
        Map<String, Serializable> map3 = persistentContext.getPropertyMap();
        for (PropertySetUtil.PropertySetRetriever<?> propertySetRetriever : map3.keySet()) {
            Object v = map3.get(propertySetRetriever);
            if (packet.supports(propertySetRetriever)) {
                try {
                    packet.put((String)((Object)propertySetRetriever), v);
                    continue;
                }
                catch (Exception exception) {
                    throw new IllegalArgumentException("Error setting property '" + (String)((Object)propertySetRetriever) + "' onto Packet with value: " + v + ". Error was: " + exception.toString(), exception);
                }
            }
            if (!LOGGER.isLoggable(Level.FINE)) continue;
            LOGGER.fine("Property '" + (String)((Object)propertySetRetriever) + "' was flagged stored on a persistent message but isn't supported (no PropertySet that includes it) by the current Packet. Skipping setting the value for it when restoring PeristentContext. Value is: " + v);
        }
        Map<String, Serializable> map = persistentContext.getInvocationPropertyMap();
        for (String string : map.keySet()) {
            clazz = map.get(string);
            packet.invocationProperties.put(string, clazz);
        }
        if (persistentContext.getContextPropertyMap() != null) {
            packet.put("weblogic.wsee.jaxws.async.PersistentContext", persistentContext.getContextPropertyMap());
        }
    }

    public <T> T runActionInContext(PersistentContext persistentContext, AuthenticatedSubject authenticatedSubject, PrivilegedExceptionAction<T> privilegedExceptionAction) throws PrivilegedActionException {
        AuthenticatedSubject authenticatedSubject2 = persistentContext.getSubject(authenticatedSubject);
        if (authenticatedSubject2 != null) {
            if (SubjectManager.getSubjectManager().isKernelIdentity((AbstractSubject)authenticatedSubject2)) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Persistent context contains kernel subject");
                }
                throw new RuntimeException("Kernel identity was retrieved from context");
            }
        } else {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Persistent context does not contain subject, running as anonymous subject");
            }
            authenticatedSubject2 = (AuthenticatedSubject)SubjectManager.getSubjectManager().getAnonymousSubject();
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("PersistentMessageFactory.runActionInContext: running as " + authenticatedSubject2);
        }
        return (T)SecurityServiceManager.runAs((AuthenticatedSubject)authenticatedSubject, (AuthenticatedSubject)authenticatedSubject2, privilegedExceptionAction);
    }
}

