/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.jaxws.persistence;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import weblogic.wsee.jaxws.sslclient.PersistentSSLInfo;
import weblogic.wsee.jaxws.sslclient.SSLClientUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistentRequestContext
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(PersistentRequestContext.class.getName());
    private static final int SSL_PRIORITY = 100;
    private static final int BASE_PRIORITY = 0;
    private static final SortedSet<NonSerializablePropertyHandler> _handlerRegistry = new TreeSet<NonSerializablePropertyHandler>();
    private transient Map<String, Object> _props;
    private boolean _nonSerializableKeys;

    public static void registerNonSerializablePropertyHandler(NonSerializablePropertyHandler nonSerializablePropertyHandler) {
        _handlerRegistry.add(nonSerializablePropertyHandler);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        Map<String, Object> map = this._props;
        if (this._nonSerializableKeys) {
            map = new HashMap<String, Object>(this._props);
            for (NonSerializablePropertyHandler nonSerializablePropertyHandler : _handlerRegistry) {
                nonSerializablePropertyHandler.convertNonSerializable(map);
            }
        }
        objectOutputStream.writeObject("10.3.6");
        objectOutputStream.writeObject(map);
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.readObject();
        this._props = (Map)objectInputStream.readObject();
        objectInputStream.defaultReadObject();
        if (this._nonSerializableKeys) {
            for (NonSerializablePropertyHandler nonSerializablePropertyHandler : _handlerRegistry) {
                nonSerializablePropertyHandler.unconvertNonSerializable(this._props);
            }
        }
    }

    public PersistentRequestContext() {
        this(new HashMap<String, Object>());
    }

    public PersistentRequestContext(Map<String, Object> map) {
        this._props = new HashMap<String, Object>(map.size());
        this._nonSerializableKeys = false;
        for (String string : map.keySet()) {
            Object object = map.get(string);
            this._props.put(string, object);
            if (object == null || object instanceof Serializable) continue;
            this._nonSerializableKeys = true;
        }
    }

    public void loadRequestContext(Map<String, Object> map) {
        for (String string : this._props.keySet()) {
            Object object = this._props.get(string);
            map.put(string, object);
        }
    }

    static {
        PersistentRequestContext.registerNonSerializablePropertyHandler(new SSLNonSerializablePropertyHandler());
        PersistentRequestContext.registerNonSerializablePropertyHandler(new BaseNonSerializablePropertyHandler());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SSLNonSerializablePropertyHandler
    extends AbstractNonSerializablePropertyHandler {
        private SSLNonSerializablePropertyHandler() {
        }

        @Override
        public int getPriority() {
            return 100;
        }

        @Override
        public void convertNonSerializable(Map<String, Object> map) {
            if (map.containsKey("com.sun.xml.ws.transport.https.client.SSLSocketFactory")) {
                if (map.containsKey("weblogic.wsee.jaxws.sslclient.PersistentSSLInfo")) {
                    map.remove("com.sun.xml.ws.transport.https.client.SSLSocketFactory");
                } else {
                    PersistentSSLInfo persistentSSLInfo = SSLClientUtil.getPersistentSSLInfoFromSysProperties();
                    map.put("weblogic.wsee.jaxws.sslclient.PersistentSSLInfo", persistentSSLInfo);
                }
            }
        }

        @Override
        public void unconvertNonSerializable(Map<String, Object> map) {
            if (map.containsKey("weblogic.wsee.jaxws.sslclient.PersistentSSLInfo")) {
                PersistentSSLInfo persistentSSLInfo = (PersistentSSLInfo)map.get("weblogic.wsee.jaxws.sslclient.PersistentSSLInfo");
                map.put("com.sun.xml.ws.transport.https.client.SSLSocketFactory", SSLClientUtil.getSSLSocketFactory(persistentSSLInfo));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BaseNonSerializablePropertyHandler
    extends AbstractNonSerializablePropertyHandler {
        private BaseNonSerializablePropertyHandler() {
        }

        @Override
        public int getPriority() {
            return 0;
        }

        @Override
        public void convertNonSerializable(Map<String, Object> map) {
            for (String string : map.keySet()) {
                Object object = map.get(string);
                if (object == null || object instanceof Serializable) continue;
                map.put(string, new MarkerValue(object));
                if (!LOGGER.isLoggable(Level.FINE)) continue;
                LOGGER.fine("Created MarkerValue for non-serializable PersistentRequestContext property '" + string + "' and value: " + object);
            }
        }

        @Override
        public void unconvertNonSerializable(Map<String, Object> map) {
            for (String string : map.keySet()) {
                Object object = map.get(string);
                if (!(object instanceof MarkerValue) || !LOGGER.isLoggable(Level.FINE)) continue;
                LOGGER.fine("Found MarkerValue serialized in place of non-serializable PersistentRequestContext property '" + string + "' and value: " + object);
            }
        }
    }

    private static abstract class AbstractNonSerializablePropertyHandler
    implements NonSerializablePropertyHandler {
        private AbstractNonSerializablePropertyHandler() {
        }

        public int compareTo(Object object) {
            if (!(object instanceof AbstractNonSerializablePropertyHandler)) {
                return 0;
            }
            AbstractNonSerializablePropertyHandler abstractNonSerializablePropertyHandler = (AbstractNonSerializablePropertyHandler)object;
            return this.getPriority() - abstractNonSerializablePropertyHandler.getPriority();
        }

        public boolean equals(Object object) {
            if (!(object instanceof AbstractNonSerializablePropertyHandler)) {
                return false;
            }
            AbstractNonSerializablePropertyHandler abstractNonSerializablePropertyHandler = (AbstractNonSerializablePropertyHandler)object;
            return abstractNonSerializablePropertyHandler.getPriority() == this.getPriority();
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(super.toString()).append(" - priority=").append(this.getPriority());
            return stringBuffer.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface NonSerializablePropertyHandler
    extends Comparable {
        public int getPriority();

        public void convertNonSerializable(Map<String, Object> var1);

        public void unconvertNonSerializable(Map<String, Object> var1);
    }

    private static class MarkerValue
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private String _className;
        private String _toStringValue;

        public MarkerValue(Object object) {
            this._className = object != null ? object.getClass().getName() : "null";
            this._toStringValue = object != null ? object.toString() : "null";
        }

        public int hashCode() {
            return this._toStringValue.hashCode();
        }

        public boolean equals(Object object) {
            if (!(object instanceof MarkerValue)) {
                return false;
            }
            MarkerValue markerValue = (MarkerValue)object;
            return markerValue._toStringValue.equals(this._toStringValue);
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(super.toString());
            stringBuffer.append(" - ").append(this._className);
            stringBuffer.append(" - ").append(this._toStringValue);
            return stringBuffer.toString();
        }
    }
}

