/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.jaxws.proxy;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLStreamHandler;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Iterator;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.WebServiceFeature;
import weblogic.wsee.connection.transport.TransportInfo;
import weblogic.wsee.connection.transport.https.HttpsTransportInfo;
import weblogic.wsee.jaxws.proxy.ClientProxyFeature;
import weblogic.wsee.util.MimeHeadersUtil;
import weblogic.wsee.util.Verbose;

public class ProxyUtil {
    private static final boolean verbose = Verbose.isVerbose(ProxyUtil.class);

    private static Proxy getProxy(ClientProxyFeature clientProxyFeature) {
        try {
            InetSocketAddress inetSocketAddress = new InetSocketAddress(clientProxyFeature.getProxyHost(), clientProxyFeature.getProxyPort());
            return new Proxy(clientProxyFeature.getType(), inetSocketAddress);
        }
        catch (Throwable throwable) {
            throw new RuntimeException("Bad setting for proxy connection", throwable);
        }
    }

    public static Proxy getProxy(ClientProxyFeature clientProxyFeature, URI uRI) {
        Proxy proxy = null;
        if (clientProxyFeature != null) {
            if (clientProxyFeature.getProxyPort() < 0) {
                return Proxy.NO_PROXY;
            }
            proxy = ProxyUtil.getProxy(clientProxyFeature);
        } else {
            proxy = MimeHeadersUtil.getProxyFromSysProps();
            if (proxy == null && uRI != null) {
                proxy = ProxyUtil.chooseProxy(uRI);
            }
        }
        return proxy;
    }

    private static Proxy chooseProxy(URI uRI) {
        ProxySelector proxySelector = AccessController.doPrivileged(new PrivilegedAction<ProxySelector>(){

            @Override
            public ProxySelector run() {
                return ProxySelector.getDefault();
            }
        });
        if (proxySelector == null) {
            return Proxy.NO_PROXY;
        }
        if (!proxySelector.getClass().getName().equals("sun.net.spi.DefaultProxySelector")) {
            return null;
        }
        Iterator<Proxy> iterator = proxySelector.select(uRI).iterator();
        if (iterator.hasNext()) {
            return iterator.next();
        }
        return Proxy.NO_PROXY;
    }

    public static void setIgnoreSystemNonPorxyHosts(HttpURLConnection httpURLConnection, ClientProxyFeature clientProxyFeature) {
        if (clientProxyFeature != null && httpURLConnection instanceof weblogic.net.http.HttpURLConnection) {
            weblogic.net.http.HttpURLConnection httpURLConnection2 = (weblogic.net.http.HttpURLConnection)httpURLConnection;
            httpURLConnection2.setIgnoreSystemNonPorxyHosts(clientProxyFeature.isIgnoreSystemNonProxyHosts());
        }
    }

    public static void setProxyAuthHeader(HttpURLConnection httpURLConnection, ClientProxyFeature clientProxyFeature) {
        if (httpURLConnection == null) {
            return;
        }
        String string = "";
        string = clientProxyFeature == null ? MimeHeadersUtil.getBasicProxyAuthHeaderValue(null, null) : MimeHeadersUtil.getBasicProxyAuthHeaderValue(clientProxyFeature.getProxyUserName(), clientProxyFeature.getProxyPassword());
        if (string == null) {
            string = "";
        }
        httpURLConnection.addRequestProperty("Proxy-Authorization", string);
    }

    public static HttpURLConnection openConnection(URL uRL, Proxy proxy) throws MalformedURLException, IOException, URISyntaxException {
        URL uRL2 = null;
        uRL2 = Boolean.getBoolean("UseSunHttpHandler") ? uRL : new URL(uRL, uRL.toString(), WLSURLStreamHandlerSet.getHttpURLStreamHandler(uRL.getProtocol()));
        HttpURLConnection httpURLConnection = proxy != null ? (HttpURLConnection)uRL2.openConnection(proxy) : (HttpURLConnection)uRL2.openConnection();
        if (verbose) {
            Verbose.log("got sslConnection:" + httpURLConnection);
        }
        return httpURLConnection;
    }

    public static TransportInfo toTransportInfo(WebServiceFeature ... webServiceFeatureArray) {
        if (webServiceFeatureArray == null) {
            return null;
        }
        HttpsTransportInfo httpsTransportInfo = new HttpsTransportInfo();
        for (WebServiceFeature webServiceFeature : webServiceFeatureArray) {
            if (!(webServiceFeature instanceof ClientProxyFeature)) continue;
            ClientProxyFeature clientProxyFeature = (ClientProxyFeature)webServiceFeature;
            httpsTransportInfo.setProxy(ProxyUtil.getProxy(clientProxyFeature));
            httpsTransportInfo.setProxyUsername(clientProxyFeature.getProxyUserName() == null ? null : clientProxyFeature.getProxyUserName().getBytes());
            httpsTransportInfo.setProxyPassword(clientProxyFeature.getProxyPassword() == null ? null : clientProxyFeature.getProxyPassword().getBytes());
        }
        return httpsTransportInfo;
    }

    private static class WLSURLStreamHandlerSet {
        private static final String WLS_HANDLER_PKG = "weblogic.net";
        private static URLStreamHandler httpURLStreamHandler = null;
        private static URLStreamHandler httpsURLStreamHandler = null;

        private WLSURLStreamHandlerSet() {
        }

        public static synchronized URLStreamHandler getHttpURLStreamHandler(String string) throws MalformedURLException {
            if ("https".equalsIgnoreCase(string)) {
                if (httpsURLStreamHandler == null) {
                    httpsURLStreamHandler = WLSURLStreamHandlerSet.newInstance("https");
                }
                return httpsURLStreamHandler;
            }
            if ("http".equalsIgnoreCase(string)) {
                if (httpURLStreamHandler == null) {
                    httpURLStreamHandler = WLSURLStreamHandlerSet.newInstance("http");
                }
                return httpURLStreamHandler;
            }
            throw new MalformedURLException("Unsupported protocol:" + string);
        }

        private static URLStreamHandler newInstance(String string) throws WebServiceException {
            Class<?> clazz;
            String string2 = "weblogic.net." + string + ".Handler";
            try {
                clazz = Class.forName(string2);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new WebServiceException("Unable to find URLStreamHandler: " + string2);
            }
            try {
                return (URLStreamHandler)clazz.newInstance();
            }
            catch (Exception exception) {
                throw new WebServiceException("Unable to instantiate URLStreamHandler: " + string2, (Throwable)exception);
            }
        }
    }
}

