/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.jaxws.security;

import com.sun.xml.ws.api.SOAPVersion;
import com.sun.xml.ws.api.message.Message;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.model.JavaMethod;
import com.sun.xml.ws.api.model.SEIModel;
import com.sun.xml.ws.api.pipe.Fiber;
import com.sun.xml.ws.api.pipe.NextAction;
import com.sun.xml.ws.api.pipe.ServerTubeAssemblerContext;
import com.sun.xml.ws.api.pipe.Tube;
import com.sun.xml.ws.api.pipe.TubeCloner;
import com.sun.xml.ws.api.pipe.helper.AbstractFilterTubeImpl;
import com.sun.xml.ws.api.pipe.helper.AbstractTubeImpl;
import com.sun.xml.ws.message.saaj.SAAJMessage;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import javax.xml.namespace.QName;
import javax.xml.soap.Detail;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPMessage;
import javax.xml.ws.Provider;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.soap.SOAPFaultException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.AuthorizationManager;
import weblogic.security.service.ContextElement;
import weblogic.security.service.ContextHandler;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityServiceManager;
import weblogic.security.service.WebServiceResource;
import weblogic.security.spi.Resource;
import weblogic.wsee.jaxrpc.soapfault.SOAPFaultUtil;
import weblogic.wsee.jaxws.framework.jaxrpc.EnvironmentFactory;
import weblogic.wsee.jaxws.framework.jaxrpc.JAXRPCEnvironmentFeature;
import weblogic.wsee.security.configuration.WssConfigurationException;
import weblogic.wsee.security.policy.WssPolicyContext;
import weblogic.wsee.security.saml.SAMLAttributeStatementData;
import weblogic.wsee.security.saml.SAMLAttributeStatementDataImpl;
import weblogic.wsee.util.AccessException;
import weblogic.wsee.util.ServerSecurityHelper;
import weblogic.xml.crypto.wss.BinarySecurityTokenHandler;
import weblogic.xml.crypto.wss.SignatureInfo;
import weblogic.xml.crypto.wss.WSSecurityContext;
import weblogic.xml.crypto.wss.WSSecurityException;
import weblogic.xml.crypto.wss.api.BinarySecurityToken;
import weblogic.xml.crypto.wss.provider.SecurityToken;

public class AuthorizationTube
extends AbstractFilterTubeImpl {
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private static final Logger LOGGER = Logger.getLogger(AuthorizationTube.class.getName());
    private static final QName AUTHENTICATION_FAILURE_11 = new QName("http://schemas.xmlsoap.org/soap/envelope/", "Client.Authentication", "env");
    private static final QName AUTHENTICATION_FAILURE_12 = new QName("http://www.w3.org/2003/05/soap-envelope", "Client.Authentication", "env");
    public static final String WSS_SUBJECT_PROPERTY = "weblogic.wsee.wss.subject";
    public static final String OWSM_SUBJECT_PROPERTY = "weblogic.wsee.owsm.subject";
    public static final String TRANSPORT_SUBJECT_PROPERTY = "weblogic.wsee.subject";
    public static final String CURRENT_SUBJECT = "weblogic.wsee.jaxws.security.subject";
    public static final String RESOURCE = "weblogic.wsee.jaxws.security.resource";
    public static final String CONTEXT_HANDLER = "weblogic.wsee.jaxws.security.contexthandler";
    private SEIModel seiModel;
    private SOAPVersion sv;
    private SOAPFactory sf;
    private QName failureQName;
    private Map<JavaMethod, WebServiceResource> resources = new HashMap<JavaMethod, WebServiceResource>();
    private WebServiceResource providerResource = null;
    private AuthorizationManager am;

    public AuthorizationTube(ServerTubeAssemblerContext serverTubeAssemblerContext, Tube tube) {
        super(tube);
        EnvironmentFactory environmentFactory = JAXRPCEnvironmentFeature.getFactory(serverTubeAssemblerContext.getEndpoint());
        String string = environmentFactory.getApplication();
        String string2 = environmentFactory.getContextPath();
        String string3 = environmentFactory.getSecurityRealmName();
        if (string3 == null) {
            string3 = SecurityServiceManager.getDefaultRealmName();
        }
        String string4 = serverTubeAssemblerContext.getWsdlModel() != null ? serverTubeAssemblerContext.getWsdlModel().getName().getLocalPart() : null;
        this.seiModel = serverTubeAssemblerContext.getSEIModel();
        if (this.seiModel != null) {
            for (JavaMethod javaMethod : this.seiModel.getJavaMethods()) {
                Method method = javaMethod.getMethod();
                String string5 = method.getName();
                Class<?>[] classArray = method.getParameterTypes();
                String[] stringArray = new String[classArray.length];
                for (int i = 0; i < classArray.length; ++i) {
                    stringArray[i] = classArray[i].getCanonicalName();
                }
                this.resources.put(javaMethod, new WebServiceResource(string, string2, string4, string5, stringArray));
            }
        } else {
            try {
                Method method = Provider.class.getMethod("invoke", Object.class);
                Class<?>[] classArray = method.getParameterTypes();
                String[] stringArray = new String[classArray.length];
                for (int i = 0; i < classArray.length; ++i) {
                    stringArray[i] = classArray[i].getCanonicalName();
                }
                this.providerResource = new WebServiceResource(string, string2, string4, method.getName(), stringArray);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new RuntimeException(noSuchMethodException);
            }
        }
        this.am = ServerSecurityHelper.getAuthManager(string3);
        this.sv = serverTubeAssemblerContext.getEndpoint().getBinding().getSOAPVersion();
        this.sf = this.sv.getSOAPFactory();
        this.failureQName = this.sv.equals((Object)SOAPVersion.SOAP_11) ? AUTHENTICATION_FAILURE_11 : AUTHENTICATION_FAILURE_12;
    }

    protected AuthorizationTube(AuthorizationTube authorizationTube, TubeCloner tubeCloner) {
        super((AbstractFilterTubeImpl)authorizationTube, tubeCloner);
        this.seiModel = authorizationTube.seiModel;
        this.sv = authorizationTube.sv;
        this.sf = authorizationTube.sf;
        this.failureQName = authorizationTube.failureQName;
        this.resources = authorizationTube.resources;
        this.providerResource = authorizationTube.providerResource;
        this.am = authorizationTube.am;
    }

    public AbstractTubeImpl copy(TubeCloner tubeCloner) {
        return new AuthorizationTube(this, tubeCloner);
    }

    public NextAction processRequest(Packet packet) {
        Object object;
        Message message;
        AuthenticatedSubject authenticatedSubject = AuthorizationTube.setSubject(packet);
        WebServiceResource webServiceResource = null;
        String string = null;
        if (this.seiModel != null) {
            message = packet.getMessage();
            if (message != null && (object = message.getMethod(this.seiModel)) != null) {
                webServiceResource = this.resources.get(object);
                string = object.getOperationName();
            }
        } else {
            webServiceResource = this.providerResource;
        }
        if (webServiceResource != null) {
            message = ServerSecurityHelper.getCurrentSubject();
            object = new WebServiceContextHandler(packet);
            packet.invocationProperties.put(CURRENT_SUBJECT, message);
            packet.invocationProperties.put(RESOURCE, webServiceResource);
            packet.invocationProperties.put(CONTEXT_HANDLER, object);
            if (!this.am.isAccessAllowed((AuthenticatedSubject)message, (Resource)webServiceResource, (ContextHandler)object)) {
                if (LOGGER.isLoggable(Level.FINER)) {
                    LOGGER.finer("** Access denied for subject " + message + " to resource " + webServiceResource);
                }
                try {
                    String string2 = "Access denied to operation " + string;
                    SOAPFault sOAPFault = this.sf.createFault();
                    sOAPFault.setFaultCode(this.failureQName);
                    sOAPFault.setFaultString(string2);
                    Detail detail = sOAPFault.addDetail();
                    SOAPFaultUtil.fillDetail((Throwable)new AccessException(string2), detail, this.sv.equals((Object)SOAPVersion.SOAP_12));
                    throw new SOAPFaultException(sOAPFault);
                }
                catch (SOAPException sOAPException) {
                    throw new WebServiceException((Throwable)sOAPException);
                }
            }
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer("** Access granted for subject " + message + " to resource " + webServiceResource);
            }
        }
        return this.doInvoke((Tube)(authenticatedSubject != null ? new RunAsWrapperTube(authenticatedSubject, this.next) : this.next), packet);
    }

    public NextAction processException(Throwable throwable) {
        Packet packet = Fiber.current().getPacket();
        if (packet != null) {
            AuthorizationTube.resetSubject(packet);
        }
        return super.processException(throwable);
    }

    public NextAction processResponse(Packet packet) {
        AuthorizationTube.resetSubject(packet);
        return super.processResponse(packet);
    }

    protected static AuthenticatedSubject setSubject(Packet packet) {
        Object object;
        AuthenticatedSubject authenticatedSubject = null;
        AuthenticatedSubject authenticatedSubject2 = (AuthenticatedSubject)packet.invocationProperties.get(WSS_SUBJECT_PROPERTY);
        if (authenticatedSubject2 == null && (object = (Subject)packet.invocationProperties.get(OWSM_SUBJECT_PROPERTY)) != null) {
            authenticatedSubject = authenticatedSubject2 = AuthenticatedSubject.getFromSubject((Subject)object);
        }
        if (authenticatedSubject2 != null) {
            object = AuthorizationTube.switchSubject(authenticatedSubject2);
            packet.invocationProperties.put(TRANSPORT_SUBJECT_PROPERTY, object);
        }
        return authenticatedSubject;
    }

    protected static void resetSubject(Packet packet) {
        AuthenticatedSubject authenticatedSubject = (AuthenticatedSubject)packet.invocationProperties.get(TRANSPORT_SUBJECT_PROPERTY);
        if (authenticatedSubject != null) {
            AuthorizationTube.switchSubject(authenticatedSubject);
            packet.invocationProperties.remove(TRANSPORT_SUBJECT_PROPERTY);
        }
    }

    private static AuthenticatedSubject switchSubject(AuthenticatedSubject authenticatedSubject) {
        AuthenticatedSubject authenticatedSubject2 = SecurityServiceManager.getCurrentSubject((AuthenticatedSubject)kernelId);
        SecurityServiceManager.popSubject((AuthenticatedSubject)kernelId);
        SecurityServiceManager.pushSubject((AuthenticatedSubject)kernelId, (AuthenticatedSubject)authenticatedSubject);
        return authenticatedSubject2;
    }

    private static class WebServiceContextHandler
    implements ContextHandler {
        private Map<String, Object> map = new HashMap<String, Object>();

        public WebServiceContextHandler(Packet packet) {
            WSSecurityContext wSSecurityContext = (WSSecurityContext)packet.invocationProperties.get("weblogic.xml.crypto.wss.WSSecurityContext");
            if (wSSecurityContext != null) {
                Object object;
                WssPolicyContext wssPolicyContext = (WssPolicyContext)packet.invocationProperties.get("weblogic.weblogic.wsee.security.policy.WssPolicyCtx");
                if (wssPolicyContext != null && wssPolicyContext.getWssConfiguration().isSignatureACLEnabled()) {
                    try {
                        object = (BinarySecurityTokenHandler)wssPolicyContext.getWssConfiguration().getTokenHandler("x509", "weblogic.xml.crypto.wss.BinarySecurityTokenHandler");
                        List list = wSSecurityContext.getSecurityTokens("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509v3");
                        list.addAll(wSSecurityContext.getSecurityTokens("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509v1"));
                        for (BinarySecurityToken binarySecurityToken : list) {
                            Object object2;
                            Node node = null;
                            List list2 = wSSecurityContext.getSignatures(binarySecurityToken);
                            Object object3 = list2.iterator();
                            while (object3.hasNext() && (node = WebServiceContextHandler.getSignatureNode((SignatureInfo)(object2 = (SignatureInfo)object3.next()), packet)) == null) {
                            }
                            if (node == null) continue;
                            object3 = "{" + node.getNamespaceURI() + "}" + node.getLocalName();
                            object2 = "Integrity{" + (String)object3 + "}";
                            Subject subject = ((BinarySecurityTokenHandler)object).getSubject((SecurityToken)binarySecurityToken, wSSecurityContext);
                            this.map.put((String)object2, subject);
                        }
                    }
                    catch (WssConfigurationException wssConfigurationException) {
                        throw new WebServiceException((Throwable)wssConfigurationException);
                    }
                    catch (WSSecurityException wSSecurityException) {
                        throw new WebServiceException((Throwable)wSSecurityException);
                    }
                }
                if (null != (object = (SAMLAttributeStatementData)wSSecurityContext.getMessageContext().getProperty("weblogic.wsee.security.saml.attributies"))) {
                    this.map.put("weblogic.wsee.security.saml.attributies", object);
                    if (LOGGER.isLoggable(Level.FINER)) {
                        LOGGER.finer("Save SAMLAttributeStatementData object with size =" + object.size());
                    }
                    if (!object.isEmpty()) {
                        this.map.putAll(((SAMLAttributeStatementDataImpl)object).getNameValuePair());
                        if (LOGGER.isLoggable(Level.FINER)) {
                            LOGGER.finer("Added SAML Attributes to the map for XACML" + object.toString());
                        }
                    }
                }
            }
        }

        private static Node getSignatureNode(SignatureInfo signatureInfo, Packet packet) {
            Message message = packet.getMessage();
            Node node = null;
            if (message instanceof SAAJMessage) {
                try {
                    SOAPMessage sOAPMessage = message.readAsSOAPMessage(packet);
                    node = WebServiceContextHandler.getFirstSigNode(signatureInfo, (Node)sOAPMessage.getSOAPBody());
                    if (node == null) {
                        return WebServiceContextHandler.getFirstSigNode(signatureInfo, (Node)sOAPMessage.getSOAPHeader());
                    }
                }
                catch (SOAPException sOAPException) {
                    throw new WebServiceException((Throwable)sOAPException);
                }
            }
            return node;
        }

        private static Node getFirstSigNode(SignatureInfo signatureInfo, Node node) {
            if (signatureInfo.containsNode(node)) {
                return node;
            }
            NodeList nodeList = node.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node2 = nodeList.item(i);
                Node node3 = WebServiceContextHandler.getFirstSigNode(signatureInfo, node2);
                if (node3 == null) continue;
                return node3;
            }
            return null;
        }

        public String[] getNames() {
            return this.map.keySet().toArray(new String[this.map.size()]);
        }

        public Object getValue(String string) {
            return this.map.get(string);
        }

        public ContextElement[] getValues(String[] stringArray) {
            ContextElement[] contextElementArray = new ContextElement[this.map.size()];
            int n = 0;
            for (Map.Entry<String, Object> entry : this.map.entrySet()) {
                contextElementArray[n++] = new ContextElement(entry.getKey(), entry.getValue());
            }
            return contextElementArray;
        }

        public int size() {
            return this.map.size();
        }
    }

    private static class RunAsWrapperTube
    extends AbstractTubeImpl {
        private AuthenticatedSubject subject;
        private Tube inner;

        public RunAsWrapperTube(AuthenticatedSubject authenticatedSubject, Tube tube) {
            this.subject = authenticatedSubject;
            this.inner = tube;
        }

        public RunAsWrapperTube(RunAsWrapperTube runAsWrapperTube, TubeCloner tubeCloner) {
            super((AbstractTubeImpl)runAsWrapperTube, tubeCloner);
            this.subject = runAsWrapperTube.subject;
            this.inner = tubeCloner.copy(runAsWrapperTube.inner);
        }

        public RunAsWrapperTube copy(TubeCloner tubeCloner) {
            return new RunAsWrapperTube(this, tubeCloner);
        }

        public void preDestroy() {
        }

        public NextAction processException(Throwable throwable) {
            return this.doThrow(throwable);
        }

        public NextAction processRequest(final Packet packet) {
            return Subject.doAs(this.subject.getSubject(), new PrivilegedAction<NextAction>(){

                @Override
                public NextAction run() {
                    NextAction nextAction = RunAsWrapperTube.this.inner.processRequest(packet);
                    Tube tube = nextAction.getNext();
                    if (tube != null) {
                        nextAction.setNext((Tube)new RunAsWrapperTube(RunAsWrapperTube.this.subject, tube));
                    }
                    return nextAction;
                }
            });
        }

        public NextAction processResponse(final Packet packet) {
            return Subject.doAs(this.subject.getSubject(), new PrivilegedAction<NextAction>(){

                @Override
                public NextAction run() {
                    return RunAsWrapperTube.this.inner.processResponse(packet);
                }
            });
        }
    }
}

