/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.jaxws.security;

import com.sun.xml.ws.api.message.Header;
import com.sun.xml.ws.api.message.HeaderList;
import com.sun.xml.ws.api.message.Packet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPMessage;
import org.w3c.dom.NodeList;
import weblogic.wsee.jaxws.cluster.spi.RoutingInfo;
import weblogic.wsee.jaxws.cluster.spi.RoutingInfoFinder;
import weblogic.wsee.jaxws.cluster.spi.RoutingInfoFinderRegistry;
import weblogic.wsee.jaxws.framework.WsUtil;
import weblogic.wsee.util.WLMessageFactory;
import weblogic.xml.crypto.wss.WSSConstants;
import weblogic.xml.dom.DOMProcessingException;
import weblogic.xml.dom.DOMUtils;

public class SCTIDRoutingInfoFinder
implements RoutingInfoFinder {
    private static final Logger LOGGER = Logger.getLogger(SCTIDRoutingInfoFinder.class.getName());
    private static boolean _didRegister = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerIfNeeded() {
        Class<SCTIDRoutingInfoFinder> clazz = SCTIDRoutingInfoFinder.class;
        synchronized (SCTIDRoutingInfoFinder.class) {
            if (!_didRegister) {
                _didRegister = true;
                SCTIDRoutingInfoFinder sCTIDRoutingInfoFinder = new SCTIDRoutingInfoFinder();
                RoutingInfoFinderRegistry.getInstance().addFinder(sCTIDRoutingInfoFinder);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public void setUsageMode(RoutingInfoFinder.UsageMode usageMode) {
    }

    public int getFinderPriority() {
        return 100;
    }

    public RoutingInfo findRoutingInfo(HeaderList headerList) throws Exception {
        String string;
        Object object;
        Header header;
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Searching headers for SCT routing info");
        }
        if ((header = headerList.get(WSSConstants.SECURITY_QNAME, false)) == null) {
            return null;
        }
        try {
            object = WLMessageFactory.getInstance().getMessageFactory(false);
            SOAPMessage sOAPMessage = object.createMessage();
            header.writeTo(sOAPMessage);
            SOAPHeader sOAPHeader = sOAPMessage.getSOAPHeader();
            NodeList nodeList = sOAPHeader.getElementsByTagNameNS("http://docs.oasis-open.org/ws-sx/ws-secureconversation/200512", "Identifier");
            if (nodeList.getLength() <= 0) {
                return null;
            }
            string = DOMUtils.getTextData(nodeList.item(0));
        }
        catch (SOAPException sOAPException) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Exception obtaining SCT id" + (Object)((Object)sOAPException));
            }
            throw sOAPException;
        }
        catch (DOMProcessingException dOMProcessingException) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Exception obtaining SCT id" + (Object)((Object)dOMProcessingException));
            }
            throw dOMProcessingException;
        }
        if (string != null && (object = WsUtil.getStoreNameFromRoutableUUID(string)) != null) {
            return new RoutingInfo((String)object, RoutingInfo.Type.PHYSICAL_STORE_NAME);
        }
        return null;
    }

    public RoutingInfo findRoutingInfoFromSoapBody(RoutingInfo routingInfo, Packet packet) throws Exception {
        throw new IllegalArgumentException("Not implemented");
    }
}

