/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.jaxws.spi;

import com.sun.istack.NotNull;
import com.sun.istack.Nullable;
import com.sun.xml.ws.api.WSBinding;
import com.sun.xml.ws.api.WSService;
import com.sun.xml.ws.api.addressing.WSEndpointReference;
import com.sun.xml.ws.api.model.SEIModel;
import com.sun.xml.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.ws.api.pipe.ClientTubeAssemblerContext;
import com.sun.xml.ws.api.pipe.ServerTubeAssemblerContext;
import com.sun.xml.ws.api.server.Container;
import com.sun.xml.ws.binding.WebServiceFeatureList;
import com.sun.xml.ws.client.WSServiceDelegate;
import com.sun.xml.ws.model.wsdl.WSDLServiceImpl;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.WeakHashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.ws.Dispatch;
import javax.xml.ws.Service;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.WebServiceFeature;
import org.xml.sax.Locator;
import weblogic.j2ee.ComponentRuntimeMBeanImpl;
import weblogic.j2ee.descriptor.wl.PortInfoBean;
import weblogic.jws.jaxws.WLSWebServiceFeature;
import weblogic.jws.jaxws.client.ClientIdentityFeature;
import weblogic.jws.jaxws.client.async.AsyncClientTransportFeature;
import weblogic.kernel.KernelStatus;
import weblogic.management.runtime.RuntimeMBean;
import weblogic.management.runtime.ServerRuntimeMBean;
import weblogic.management.runtime.WebAppComponentRuntimeMBean;
import weblogic.management.runtime.WseeClientRuntimeMBean;
import weblogic.management.runtime.WseePortConfigurationRuntimeMBean;
import weblogic.wsee.WseeCoreLogger;
import weblogic.wsee.WseePersistLogger;
import weblogic.wsee.deploy.DeployInfo;
import weblogic.wsee.jaxws.persistence.ClientInstancePoolFeature;
import weblogic.wsee.jaxws.spi.ClientInstanceIdentity;
import weblogic.wsee.jaxws.spi.ClientInstanceIdentityFeature;
import weblogic.wsee.jaxws.spi.ClientInstancePool;
import weblogic.wsee.jaxws.tubeline.standard.ClientContainerUtil;
import weblogic.wsee.monitoring.WseeClientConfigurationRuntimeMBeanImpl;
import weblogic.wsee.monitoring.WseeClientPortRuntimeMBeanImpl;
import weblogic.wsee.monitoring.WseeClientRuntimeMBeanImpl;
import weblogic.wsee.monitoring.WseeRuntimeMBeanManager;
import weblogic.wsee.persistence.StoreException;
import weblogic.wsee.util.Guid;
import weblogic.wsee.util.HashCodeUtil;
import weblogic.wsee.util.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientIdentityRegistry {
    private static ClientIdentityFeatureListener _listener = new ClientIdentityFeatureListener();
    private static ClientInstancePoolFeatureListener _clientInstancePoolListener = new ClientInstancePoolFeatureListener();
    private static final Logger LOGGER = Logger.getLogger(ClientIdentityRegistry.class.getName());
    private static final ReentrantReadWriteLock _clientRegistryInternalLock = new ReentrantReadWriteLock(false);
    private static final Map<String, ClientInfo> _clientRegistryInternal;
    private static final ClientInstanceParentIdCalculator _parentIdCalculator;
    private static final ReentrantReadWriteLock _clientIdListenersLock;
    private static final Map<String, List<Listener>> _clientIdListeners;

    public static ClientIdentityFeature getClientIdentityFeature(String string) {
        ClientInfo clientInfo = ClientIdentityRegistry.getClientInfo(string);
        return clientInfo != null ? clientInfo.getClientIdentityFeature() : null;
    }

    public static WseeClientRuntimeMBeanImpl getClientRuntimeMBean(String string) {
        ClientInfo clientInfo = ClientIdentityRegistry.getClientInfo(string);
        return clientInfo != null ? clientInfo.getClientRuntimeMBean() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ClientInfo getClientInfo(String string) {
        try {
            _clientRegistryInternalLock.readLock().lock();
            if (_clientRegistryInternal.containsKey(string)) {
                ClientInfo clientInfo = _clientRegistryInternal.get(string);
                return clientInfo;
            }
            ClientInfo clientInfo = null;
            return clientInfo;
        }
        finally {
            _clientRegistryInternalLock.readLock().unlock();
        }
    }

    public static ClientInfo getRequiredClientInfo(String string) {
        ClientInfo clientInfo = ClientIdentityRegistry.getClientInfo(string);
        if (clientInfo == null) {
            throw new IllegalStateException("No client with identity '" + string + "' could be found");
        }
        return clientInfo;
    }

    public static <T2> Dispatch<T2> getEquivalentDispatch(String string, Class<T2> clazz, Service.Mode mode, WSService wSService, WSEndpointReference wSEndpointReference, WebServiceFeature ... webServiceFeatureArray) {
        WebServiceFeature[] webServiceFeatureArray2;
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Creating equivalent dispatch for client identity: " + string);
        }
        ClientInfo clientInfo = ClientIdentityRegistry.getRequiredClientInfo(string);
        ClientInfo.Config config = clientInfo.getOriginalConfig();
        WebServiceFeature[] webServiceFeatureArray3 = config.getFeatures().values().toArray(new WebServiceFeature[config.getFeatures().size()]);
        if (webServiceFeatureArray == null || webServiceFeatureArray.length == 0) {
            webServiceFeatureArray2 = webServiceFeatureArray3;
        } else {
            webServiceFeatureArray2 = new WebServiceFeature[webServiceFeatureArray3.length + webServiceFeatureArray.length];
            System.arraycopy(webServiceFeatureArray3, 0, webServiceFeatureArray2, 0, webServiceFeatureArray3.length);
            System.arraycopy(webServiceFeatureArray, 0, webServiceFeatureArray2, webServiceFeatureArray3.length, webServiceFeatureArray.length);
        }
        Dispatch dispatch = wSService.createDispatch(config.getPortName(), config.getWsepr(), clazz, mode, webServiceFeatureArray2);
        if (wSEndpointReference != null) {
            dispatch.getRequestContext().put("javax.xml.ws.service.endpoint.address", wSEndpointReference.getAddress());
        }
        return dispatch;
    }

    public static WseeClientRuntimeMBeanImpl addClientRuntimeMBean(ClientIdentityFeature clientIdentityFeature, ClientTubeAssemblerContext clientTubeAssemblerContext) {
        return ClientIdentityRegistry.internalAddClientRuntimeMBean(clientIdentityFeature, clientTubeAssemblerContext.getBinding(), clientTubeAssemblerContext.getWsdlModel(), clientTubeAssemblerContext.getSEIModel(), clientTubeAssemblerContext.getContainer(), (WseeClientConfigurationRuntimeMBeanImpl)clientTubeAssemblerContext.getService().getSPI(WseeClientConfigurationRuntimeMBeanImpl.class));
    }

    public static WseeClientRuntimeMBeanImpl addClientRuntimeMBean(ClientIdentityFeature clientIdentityFeature, ServerTubeAssemblerContext serverTubeAssemblerContext) {
        return ClientIdentityRegistry.internalAddClientRuntimeMBean(clientIdentityFeature, serverTubeAssemblerContext.getEndpoint().getBinding(), serverTubeAssemblerContext.getWsdlModel(), serverTubeAssemblerContext.getSEIModel(), serverTubeAssemblerContext.getEndpoint().getContainer(), null);
    }

    private static WseeClientRuntimeMBeanImpl internalAddClientRuntimeMBean(ClientIdentityFeature clientIdentityFeature, WSBinding wSBinding, WSDLPort wSDLPort, SEIModel sEIModel, Container container, WseeClientConfigurationRuntimeMBeanImpl wseeClientConfigurationRuntimeMBeanImpl) {
        String string;
        ComponentRuntimeMBeanImpl componentRuntimeMBeanImpl;
        if (!KernelStatus.isServer() || clientIdentityFeature == null) {
            return null;
        }
        QName qName = null;
        if (wSDLPort != null) {
            qName = wSDLPort.getName();
        } else if (sEIModel != null) {
            qName = sEIModel.getPortName();
        }
        ClientInfo clientInfo = ClientIdentityRegistry.getRequiredClientInfo(clientIdentityFeature.getClientId());
        WseeClientRuntimeMBeanImpl wseeClientRuntimeMBeanImpl = clientInfo.getClientRuntimeMBean();
        if (wseeClientRuntimeMBeanImpl != null) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Returning existing WseeClientRuntimeMBean for client=" + clientIdentityFeature.getClientId() + " port=" + qName);
            }
            return wseeClientRuntimeMBeanImpl;
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Didn't find any existing WseeClientRuntimeMBean for client=" + clientIdentityFeature.getClientId() + " port=" + qName);
        }
        if ((componentRuntimeMBeanImpl = ClientContainerUtil.getContainingComponentRuntimeByModuleName(string = container.getSPI(DeployInfo.class) == null ? null : ((DeployInfo)container.getSPI(DeployInfo.class)).getModuleName())) == null) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Cannot create WseeClientRuntimeMBeanImpl for client=" + clientIdentityFeature.getClientId() + " port=" + " because we couldn't find a parent runtime MBean for it");
            }
            return null;
        }
        try {
            clientInfo._lock.writeLock().lock();
            WseeClientRuntimeMBeanImpl wseeClientRuntimeMBeanImpl2 = ClientIdentityRegistry.findWseeClientRuntimeMBeanInComponent(clientIdentityFeature, componentRuntimeMBeanImpl);
            if (wseeClientRuntimeMBeanImpl2 != null) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Re-using already registered WseeClientRuntimeMBeanImpl for client=" + clientIdentityFeature.getClientId() + " port=" + " under parent: " + componentRuntimeMBeanImpl);
                }
                WseeClientRuntimeMBeanImpl wseeClientRuntimeMBeanImpl3 = wseeClientRuntimeMBeanImpl2;
                return wseeClientRuntimeMBeanImpl3;
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Creating WseeClientRuntimeMBeanImpl for client=" + clientIdentityFeature.getClientId() + " port=" + " under parent: " + componentRuntimeMBeanImpl);
            }
            WseePortConfigurationRuntimeMBean wseePortConfigurationRuntimeMBean = ClientIdentityRegistry.getPortConfigRuntime(wseeClientConfigurationRuntimeMBeanImpl, qName);
            WseeClientPortRuntimeMBeanImpl wseeClientPortRuntimeMBeanImpl = WseeRuntimeMBeanManager.createJaxWsClientPort(qName, wSBinding, wSDLPort, string, wseePortConfigurationRuntimeMBean);
            wseeClientRuntimeMBeanImpl2 = new WseeClientRuntimeMBeanImpl(clientIdentityFeature.getRawClientId(), clientIdentityFeature.getClientId(), componentRuntimeMBeanImpl);
            wseeClientRuntimeMBeanImpl2.setPort(wseeClientPortRuntimeMBeanImpl);
            wseeClientRuntimeMBeanImpl2.register();
            clientInfo.mbean = wseeClientRuntimeMBeanImpl2;
            WseeClientRuntimeMBeanImpl wseeClientRuntimeMBeanImpl4 = wseeClientRuntimeMBeanImpl2;
            return wseeClientRuntimeMBeanImpl4;
        }
        catch (Exception exception) {
            if (LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.log(Level.SEVERE, exception.toString(), exception);
            }
            throw new IllegalStateException(exception.toString(), exception);
        }
        finally {
            clientInfo._lock.writeLock().unlock();
        }
    }

    private static WseePortConfigurationRuntimeMBean getPortConfigRuntime(WseeClientConfigurationRuntimeMBeanImpl wseeClientConfigurationRuntimeMBeanImpl, QName qName) {
        WseePortConfigurationRuntimeMBean wseePortConfigurationRuntimeMBean = null;
        if (wseeClientConfigurationRuntimeMBeanImpl != null) {
            for (int i = 0; i < wseeClientConfigurationRuntimeMBeanImpl.getPorts().length; ++i) {
                WseePortConfigurationRuntimeMBean wseePortConfigurationRuntimeMBean2 = wseeClientConfigurationRuntimeMBeanImpl.getPorts()[i];
                if (!wseePortConfigurationRuntimeMBean2.getName().equals(qName.getLocalPart())) continue;
                wseePortConfigurationRuntimeMBean = wseePortConfigurationRuntimeMBean2;
                break;
            }
        }
        return wseePortConfigurationRuntimeMBean;
    }

    private static WseeClientRuntimeMBeanImpl findWseeClientRuntimeMBeanInComponent(ClientIdentityFeature clientIdentityFeature, RuntimeMBean runtimeMBean) {
        WseeClientRuntimeMBean[] wseeClientRuntimeMBeanArray;
        WseeClientRuntimeMBeanImpl wseeClientRuntimeMBeanImpl = null;
        if (runtimeMBean instanceof WebAppComponentRuntimeMBean && (wseeClientRuntimeMBeanArray = ((WebAppComponentRuntimeMBean)runtimeMBean).getWseeClientRuntimes()) != null) {
            for (WseeClientRuntimeMBean wseeClientRuntimeMBean : wseeClientRuntimeMBeanArray) {
                if (!wseeClientRuntimeMBean.getName().equals(clientIdentityFeature.getRawClientId()) && !wseeClientRuntimeMBean.getClientID().equals(clientIdentityFeature.getClientId())) continue;
                wseeClientRuntimeMBeanImpl = (WseeClientRuntimeMBeanImpl)wseeClientRuntimeMBean;
                break;
            }
        }
        return wseeClientRuntimeMBeanImpl;
    }

    public static void removeClientRuntimeMBean(String string) {
        ClientIdentityRegistry.unregisterClientIdentity(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addClientIdentityListener(String string, Listener listener) {
        int n;
        List<Listener> list;
        try {
            _clientIdListenersLock.writeLock().lock();
            list = _clientIdListeners.get(string);
            if (list == null) {
                list = new ArrayList<Listener>();
                _clientIdListeners.put(string, list);
            }
            n = _clientIdListeners.size();
        }
        finally {
            _clientIdListenersLock.writeLock().unlock();
        }
        List<Listener> list2 = list;
        synchronized (list2) {
            if (!list.contains(listener)) {
                list.add(listener);
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("ClientIdentityRegistry added listener " + listener + " for client identity " + string + ". Current listener count for client identity: " + list.size() + " Current client identities with listeners: " + n);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeClientIdentityListener(String string, Listener listener) {
        int n;
        List<Listener> list;
        try {
            _clientIdListenersLock.writeLock().lock();
            list = _clientIdListeners.get(string);
            n = _clientIdListeners.size();
        }
        finally {
            _clientIdListenersLock.writeLock().unlock();
        }
        if (list == null) {
            return;
        }
        List<Listener> list2 = list;
        synchronized (list2) {
            list.remove(listener);
            if (list.size() < 1) {
                Map<String, List<Listener>> map = _clientIdListeners;
                synchronized (map) {
                    _clientIdListeners.remove(string);
                }
                --n;
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("ClientIdentityRegistry removed listener " + listener + " for client identity " + string + ". Remaining listener count for client identity: " + list.size() + " Remaining client identities with listeners: " + n);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void unregisterClientIdentity(String string) {
        Object object;
        ClientInfo clientInfo = ClientIdentityRegistry.getClientInfo(string);
        if (clientInfo == null) {
            return;
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("ClientIdentityRegistry unregistering client identity " + string);
        }
        clientInfo.feature.removePropertyChangeListener((PropertyChangeListener)_listener);
        Listener[] listenerArray = null;
        try {
            _clientIdListenersLock.readLock().lock();
            object = _clientIdListeners.get(string);
            if (object != null && !object.isEmpty()) {
                listenerArray = object.toArray(new Listener[object.size()]);
            }
        }
        finally {
            _clientIdListenersLock.readLock().unlock();
        }
        if (listenerArray != null) {
            for (List<Listener> list : listenerArray) {
                try {
                    list.clientIdentityBeforeUnregister(string);
                }
                catch (Exception exception) {
                    WseeCoreLogger.logUnexpectedException((String)exception.toString(), (Throwable)exception);
                }
            }
        }
        clientInfo.feature.dispose();
        try {
            _clientRegistryInternalLock.writeLock().lock();
            _clientRegistryInternal.remove(string);
        }
        finally {
            _clientRegistryInternalLock.writeLock().unlock();
        }
        object = clientInfo.getClientInstancePoolFeature();
        if (object != null) {
            ((ClientInstancePoolFeature)((Object)object)).removePropertyChangeListener(_clientInstancePoolListener);
        }
        clientInfo.disposeClientInstancePools();
        if (clientInfo.getAsyncResponseEndpointInfo() != null && clientInfo.getAsyncResponseEndpointInfo().getEndpoint() != null) {
            try {
                clientInfo.getAsyncResponseEndpointInfo().getEndpoint().stop();
            }
            catch (Exception exception) {
                if (LOGGER.isLoggable(Level.WARNING)) {
                    LOGGER.log(Level.WARNING, exception.toString(), exception);
                }
                WseeCoreLogger.logUnexpectedException((String)exception.toString(), (Throwable)exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerClientIdentity(@NotNull ClientIdentityFeature clientIdentityFeature) {
        String string = clientIdentityFeature.getClientId();
        ClientInfo clientInfo = ClientIdentityRegistry.getClientInfo(string);
        if (clientInfo != null) {
            return;
        }
        try {
            _clientRegistryInternalLock.writeLock().lock();
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("ClientIdentityRegistry registering client identity " + string);
            }
            clientInfo = new ClientInfo(clientIdentityFeature);
            clientIdentityFeature.addPropertyChangeListener((PropertyChangeListener)_listener);
            _clientRegistryInternal.put(string, clientInfo);
        }
        finally {
            _clientRegistryInternalLock.writeLock().unlock();
        }
        Listener[] listenerArray = null;
        try {
            _clientIdListenersLock.readLock().lock();
            List<Listener> list = _clientIdListeners.get(string);
            if (list != null && !list.isEmpty()) {
                listenerArray = list.toArray(new Listener[list.size()]);
            }
        }
        finally {
            _clientIdListenersLock.readLock().unlock();
        }
        if (listenerArray != null) {
            for (List<Listener> list : listenerArray) {
                try {
                    list.clientIdentityRegistered(string);
                }
                catch (Exception exception) {
                    WseeCoreLogger.logUnexpectedException((String)exception.toString(), (Throwable)exception);
                }
            }
        }
    }

    public static ClientInstancePool initClientIdentity(@NotNull ClientIdentityFeature clientIdentityFeature, @Nullable ClientInstancePoolFeature clientInstancePoolFeature, @Nullable PortInfoBean portInfoBean, @NotNull ClientInstancePool.InstanceFactory instanceFactory, boolean bl, @NotNull Class<?> clazz) throws StoreException {
        ClientInfo clientInfo = ClientIdentityRegistry.getRequiredClientInfo(clientIdentityFeature.getClientId());
        return clientInfo.init(portInfoBean, clientInstancePoolFeature, instanceFactory, bl, clazz);
    }

    public static ClientInstanceIdentity generateSimpleClientInstanceIdentity(String string) {
        return new ClientInstanceIdentity(string, ClientInstanceIdentity.Type.SIMPLE, (Serializable)((Object)Guid.generateGuid()));
    }

    static PoolKey getPoolKey(Class clazz, boolean bl) {
        return new PoolKey(clazz, bl);
    }

    private static String genPortNameID(QName qName) {
        if (qName == null) {
            return null;
        }
        String string = qName.getNamespaceURI();
        string = string == null ? "" : string;
        return string + ":" + qName.getLocalPart();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> ClientIdentityFeature initClientIdentityFeature(QName qName, WSServiceDelegate wSServiceDelegate, WSEndpointReference wSEndpointReference, Class<T> clazz, String string, WebServiceFeatureList webServiceFeatureList) {
        Object object;
        Locator locator;
        WSDLServiceImpl wSDLServiceImpl = wSServiceDelegate.getWsdlService();
        String string2 = null;
        if (wSDLServiceImpl != null) {
            locator = wSDLServiceImpl.getLocation();
            if (locator != null) {
                string2 = locator.getSystemId();
            }
        } else {
            locator = wSServiceDelegate.getEndpointAddress(qName);
            if (locator != null) {
                string2 = locator.toString();
            }
        }
        locator = (ClientIdentityFeature)webServiceFeatureList.get(ClientIdentityFeature.class);
        boolean bl = false;
        boolean bl2 = true;
        if (locator == null) {
            locator = new ClientIdentityFeature();
            bl = true;
        }
        if (locator.getRawClientId() == null) {
            object = string;
            if (object == null) {
                object = ClientIdentityRegistry.genPortNameID(qName);
                if (object == null) {
                    object = wSEndpointReference != null ? wSEndpointReference.getAddress() : null;
                } else if (wSEndpointReference != null) {
                    object = (String)object + ":" + wSEndpointReference.getAddress();
                }
                if (object == null) {
                    object = string2;
                } else if (string2 != null) {
                    object = string2.endsWith("?WSDL") || string2.endsWith("?wsdl") ? (String)object + ":" + string2.substring(0, string2.length() - 5) : (String)object + ":" + string2;
                }
            }
            if (object == null) {
                object = clazz != null ? clazz.getSimpleName() : null;
            }
            boolean bl3 = bl2 = !ClientIdentityRegistry.generateDefaultIdIfNeeded((ClientIdentityFeature)locator, (String)(object = (String)object + ":" + ClientIdentityRegistry.generateRawClientIdFeatureSuffix(webServiceFeatureList)));
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("rawClientId=" + (String)object);
            }
        }
        if (bl) {
            webServiceFeatureList.add((WebServiceFeature)locator);
        }
        if (bl2) {
            ClientIdentityRegistry.registerClientIdentity((ClientIdentityFeature)locator);
        }
        if (webServiceFeatureList.contains(AsyncClientTransportFeature.class)) {
            object = (AsyncClientTransportFeature)webServiceFeatureList.get(AsyncClientTransportFeature.class);
            object.preRegisterForSharedEndpoint((ClientIdentityFeature)locator);
        }
        object = ClientIdentityRegistry.getRequiredClientInfo(locator.getClientId());
        try {
            Object object2;
            ((ClientInfo)object)._lock.writeLock().lock();
            ClientInfo.Config config = ((ClientInfo)object).getOriginalConfig();
            if (config == null) {
                config = new ClientInfo.Config((ClientIdentityFeature)locator, wSServiceDelegate, wSEndpointReference, qName, webServiceFeatureList);
                ((ClientInfo)object).setOriginalConfig(config);
            } else {
                object2 = new ClientInfo.Config((ClientIdentityFeature)locator, wSServiceDelegate, wSEndpointReference, qName, webServiceFeatureList);
                config.verifyAgainst((ClientInfo.Config)object2);
            }
            object2 = locator;
            return object2;
        }
        finally {
            ((ClientInfo)object)._lock.writeLock().unlock();
        }
    }

    private static String generateRawClientIdFeatureSuffix(WebServiceFeatureList webServiceFeatureList) {
        StringBuffer stringBuffer = new StringBuffer();
        TreeSet<String> treeSet = new TreeSet<String>();
        for (WebServiceFeature webServiceFeature : webServiceFeatureList) {
            if (webServiceFeature instanceof WLSWebServiceFeature) {
                treeSet.add(((WLSWebServiceFeature)webServiceFeature).getClientIdComponent());
                continue;
            }
            treeSet.add(webServiceFeature.getClass().getSimpleName());
        }
        Iterator iterator = treeSet.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append((String)iterator.next());
            if (!iterator.hasNext()) continue;
            stringBuffer.append('-');
        }
        return stringBuffer.toString();
    }

    private static boolean generateDefaultIdIfNeeded(ClientIdentityFeature clientIdentityFeature, String string) {
        if (clientIdentityFeature.getClientId() != null) {
            return false;
        }
        if (string == null) {
            string = "UnknownEndpointAddress";
        }
        clientIdentityFeature.setGeneratedRawClientId(string);
        ClientIdentityRegistry.registerClientIdentity(clientIdentityFeature);
        return true;
    }

    public static ClientInstanceIdentityFeature initClientInstanceIdentityFeature(ServerTubeAssemblerContext serverTubeAssemblerContext) {
        return ClientIdentityRegistry.initClientInstanceIdentityFeature(serverTubeAssemblerContext.getEndpoint().getBinding());
    }

    private static ClientInstanceIdentityFeature initClientInstanceIdentityFeature(WSBinding wSBinding) {
        ClientInstanceIdentityFeature clientInstanceIdentityFeature = (ClientInstanceIdentityFeature)wSBinding.getFeature(ClientInstanceIdentityFeature.class);
        if (clientInstanceIdentityFeature == null) {
            ClientIdentityFeature clientIdentityFeature = (ClientIdentityFeature)wSBinding.getFeature(ClientIdentityFeature.class);
            ClientInstanceIdentity clientInstanceIdentity = ClientIdentityRegistry.generateSimpleClientInstanceIdentity(clientIdentityFeature.getClientId());
            clientInstanceIdentityFeature = new ClientInstanceIdentityFeature(clientInstanceIdentity);
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Forcing ClientInstanceIdentityFeature onto client binding: " + clientInstanceIdentity);
            }
            ((WebServiceFeatureList)wSBinding.getFeatures()).add((WebServiceFeature)clientInstanceIdentityFeature);
        }
        return clientInstanceIdentityFeature;
    }

    static {
        _clientIdListenersLock = new ReentrantReadWriteLock(false);
        _parentIdCalculator = new ClientInstanceParentIdCalculator();
        ClientIdentityFeature.setParentIdCalculator((ClientIdentityFeature.ParentIdCalculator)_parentIdCalculator);
        AsyncClientTransportFeature.setAsyncResponseEndpointRegistry((AsyncClientTransportFeature.AsyncResponseEndpointRegistry)new ClientIdentityEndpointRegistry());
        _clientIdListeners = new HashMap<String, List<Listener>>();
        _clientRegistryInternal = new WeakHashMap<String, ClientInfo>();
    }

    private static class ClientInstancePoolFeatureListener
    implements PropertyChangeListener {
        private ClientInstancePoolFeatureListener() {
        }

        private void durableClientPoolFeatureDisposed(ClientInstancePoolFeature clientInstancePoolFeature) {
            String string = clientInstancePoolFeature.getClientIdentityFeature().getClientId();
            ClientInfo clientInfo = ClientIdentityRegistry.getClientInfo(string);
            if (clientInfo != null) {
                clientInfo.disposeClientInstancePools();
            }
        }

        private void allDurableClientsClosed(ClientInstancePoolFeature clientInstancePoolFeature) {
            String string = clientInstancePoolFeature.getClientIdentityFeature().getClientId();
            ClientInfo clientInfo = ClientIdentityRegistry.getClientInfo(string);
            if (clientInfo != null) {
                clientInfo.closeAllInClientInstancePools();
            }
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals("Disposed")) {
                this.durableClientPoolFeatureDisposed((ClientInstancePoolFeature)((Object)propertyChangeEvent.getSource()));
            } else if (propertyChangeEvent.getPropertyName().equals("ClosedAllDurableClients")) {
                this.allDurableClientsClosed((ClientInstancePoolFeature)((Object)propertyChangeEvent.getSource()));
            }
        }
    }

    private static class ClientIdentityFeatureListener
    implements PropertyChangeListener {
        private ClientIdentityFeatureListener() {
        }

        private void clientIdentityFeatureDisposed(ClientIdentityFeature clientIdentityFeature) {
            String string = clientIdentityFeature.getClientId();
            WseeClientRuntimeMBeanImpl wseeClientRuntimeMBeanImpl = ClientIdentityRegistry.getClientRuntimeMBean(string);
            if (wseeClientRuntimeMBeanImpl != null) {
                try {
                    wseeClientRuntimeMBeanImpl.unregister();
                }
                catch (Exception exception) {
                    WseePersistLogger.logUnexpectedException((String)exception.toString(), (Throwable)exception);
                }
            } else {
                ClientIdentityRegistry.unregisterClientIdentity(string);
            }
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals("Disposed")) {
                this.clientIdentityFeatureDisposed((ClientIdentityFeature)propertyChangeEvent.getSource());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PoolMap
    implements Map<PoolKey, ClientInstancePool<?>> {
        private WeakHashMap<Class<?>, Pair<ClientInstancePool<?>, ClientInstancePool<?>>> map = new WeakHashMap();
        private WeakReference<ClientInstancePool<?>> _firstPool;

        private PoolMap() {
        }

        @Override
        public void clear() {
            this.map.clear();
        }

        @Override
        public boolean containsKey(Object object) {
            if (!(object instanceof PoolKey)) {
                return false;
            }
            Pair<ClientInstancePool<?>, ClientInstancePool<?>> pair = this.map.get(((PoolKey)object).aClass);
            return pair != null && (pair.getLeft() != null || pair.getRight() != null);
        }

        @Override
        public boolean containsValue(Object object) {
            if (!(object instanceof ClientInstancePool)) {
                return false;
            }
            for (Pair<ClientInstancePool<?>, ClientInstancePool<?>> pair : this.map.values()) {
                if (!object.equals(pair.getLeft()) && !object.equals(pair.getRight())) continue;
                return true;
            }
            return false;
        }

        @Override
        public Set<Map.Entry<PoolKey, ClientInstancePool<?>>> entrySet() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ClientInstancePool<?> get(Object object) {
            if (!(object instanceof PoolKey)) {
                return null;
            }
            PoolKey poolKey = (PoolKey)object;
            Pair<ClientInstancePool<?>, ClientInstancePool<?>> pair = this.map.get(poolKey.aClass);
            return pair != null ? (poolKey.isDispatch ? pair.getRight() : pair.getLeft()) : null;
        }

        @Override
        public boolean isEmpty() {
            return this.map.isEmpty();
        }

        @Override
        public Set<PoolKey> keySet() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ClientInstancePool<?> put(PoolKey poolKey, ClientInstancePool<?> clientInstancePool) {
            Pair<ClientInstancePool<Object>, ClientInstancePool<Object>> pair;
            if (this._firstPool == null) {
                this._firstPool = new WeakReference(clientInstancePool);
            }
            if ((pair = this.map.get(poolKey.aClass)) == null) {
                if (clientInstancePool == null) {
                    return null;
                }
                pair = new Pair();
                this.map.put(poolKey.aClass, pair);
            }
            if (poolKey.isDispatch) {
                if (clientInstancePool == null && pair.getLeft() == null) {
                    this.map.remove(poolKey.aClass);
                    return pair.getRight();
                }
                ClientInstancePool<Object> clientInstancePool2 = pair.getRight();
                pair.setRight(clientInstancePool);
                return clientInstancePool2;
            }
            if (clientInstancePool == null && pair.getRight() == null) {
                this.map.remove(poolKey.aClass);
                return pair.getLeft();
            }
            ClientInstancePool<Object> clientInstancePool3 = pair.getLeft();
            pair.setLeft(clientInstancePool);
            return clientInstancePool3;
        }

        public ClientInstancePool<?> getFirstPool() {
            if (this._firstPool != null) {
                return (ClientInstancePool)this._firstPool.get();
            }
            if (this.map.isEmpty()) {
                return null;
            }
            return this.values().iterator().next();
        }

        @Override
        public void putAll(Map<? extends PoolKey, ? extends ClientInstancePool<?>> map) {
            for (Map.Entry<PoolKey, ClientInstancePool<?>> entry : map.entrySet()) {
                this.put(entry.getKey(), entry.getValue());
            }
        }

        @Override
        public ClientInstancePool<?> remove(Object object) {
            if (!(object instanceof PoolKey)) {
                return null;
            }
            PoolKey poolKey = (PoolKey)object;
            Pair<ClientInstancePool<?>, ClientInstancePool<?>> pair = this.map.get(poolKey.aClass);
            if (pair == null) {
                return null;
            }
            if (poolKey.isDispatch) {
                if (pair.getLeft() == null) {
                    this.map.remove(poolKey.aClass);
                }
                ClientInstancePool<?> clientInstancePool = pair.getRight();
                pair.setRight(null);
                return clientInstancePool;
            }
            if (pair.getRight() == null) {
                this.map.remove(poolKey.aClass);
            }
            ClientInstancePool<?> clientInstancePool = pair.getLeft();
            pair.setLeft(null);
            return clientInstancePool;
        }

        @Override
        public int size() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Collection<ClientInstancePool<?>> values() {
            return new AbstractCollection<ClientInstancePool<?>>(){

                @Override
                public Iterator<ClientInstancePool<?>> iterator() {
                    final Iterator iterator = PoolMap.this.map.values().iterator();
                    return new Iterator<ClientInstancePool<?>>(){
                        private ClientInstancePool<?> next = null;

                        @Override
                        public boolean hasNext() {
                            return this.next != null || iterator.hasNext();
                        }

                        @Override
                        public ClientInstancePool<?> next() {
                            if (this.next != null) {
                                this.next = null;
                                return this.next;
                            }
                            Pair pair = (Pair)iterator.next();
                            if (pair.getLeft() != null) {
                                this.next = (ClientInstancePool)pair.getRight();
                                return (ClientInstancePool)pair.getLeft();
                            }
                            return (ClientInstancePool)pair.getRight();
                        }

                        @Override
                        public void remove() {
                            throw new UnsupportedOperationException();
                        }
                    };
                }

                @Override
                public int size() {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }

    public static class PoolKey {
        private Class aClass;
        private boolean isDispatch;

        public PoolKey(Class clazz, boolean bl) {
            this.aClass = clazz;
            this.isDispatch = bl;
        }

        public int hashCode() {
            int n = 23;
            n = HashCodeUtil.hash(n, this.aClass);
            n = HashCodeUtil.hash(n, this.isDispatch);
            return n;
        }

        public String toString() {
            return (this.isDispatch ? "Dispatch-" : "Port-") + this.aClass.getName();
        }

        public boolean equals(Object object) {
            if (!(object instanceof PoolKey)) {
                return false;
            }
            PoolKey poolKey = (PoolKey)object;
            return this.aClass == poolKey.aClass && this.isDispatch == poolKey.isDispatch;
        }
    }

    public static interface Listener {
        public void clientIdentityRegistered(String var1);

        public void clientIdentityBeforeUnregister(String var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ClientInfo {
        private final ReentrantReadWriteLock _lock = new ReentrantReadWriteLock(false);
        ClientIdentityFeature feature;
        WseeClientRuntimeMBeanImpl mbean;
        @Nullable
        ClientInstancePoolFeature _clientInstancePoolFeature;
        PoolMap _clientInstancePools;
        @Nullable
        PortInfoBean portInfoBean;
        @Nullable
        AsyncClientTransportFeature.AsyncResponseEndpointRegistry.EndpointInfo _asyncResponseEndpointInfo;
        @Nullable
        Config _originalConfig;
        boolean _initialized;

        public ClientInfo(ClientIdentityFeature clientIdentityFeature) {
            this.feature = clientIdentityFeature;
            this._clientInstancePools = new PoolMap();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isPoolInitialized(Class clazz) {
            try {
                this._lock.readLock().lock();
                PoolKey poolKey = ClientIdentityRegistry.getPoolKey(clazz, false);
                Object object = this._clientInstancePools.get(poolKey);
                boolean bl = object != null && ((ClientInstancePool)object).isInitialized();
                return bl;
            }
            finally {
                this._lock.readLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isDispatchPoolInitialized(Class clazz) {
            try {
                this._lock.readLock().lock();
                PoolKey poolKey = ClientIdentityRegistry.getPoolKey(clazz, true);
                Object object = this._clientInstancePools.get(poolKey);
                boolean bl = object != null && ((ClientInstancePool)object).isInitialized();
                return bl;
            }
            finally {
                this._lock.readLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isInitialized() {
            try {
                this._lock.readLock().lock();
                boolean bl = this._initialized;
                return bl;
            }
            finally {
                this._lock.readLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ClientInstancePool init(@Nullable PortInfoBean portInfoBean, @Nullable ClientInstancePoolFeature clientInstancePoolFeature, @Nullable ClientInstancePool.InstanceFactory instanceFactory, boolean bl, @Nullable Class<?> clazz) throws StoreException {
            ClientInstancePool clientInstancePool;
            if (clazz == null) {
                return null;
            }
            PoolKey poolKey = ClientIdentityRegistry.getPoolKey(clazz, bl);
            try {
                this._lock.readLock().lock();
                clientInstancePool = this._clientInstancePools.get(poolKey);
            }
            finally {
                this._lock.readLock().unlock();
            }
            if (clientInstancePool != null && clientInstancePool.isInitialized()) {
                return clientInstancePool;
            }
            try {
                this._lock.writeLock().lock();
                if (this._clientInstancePools.containsKey(poolKey)) {
                    Object object = this._clientInstancePools.get(poolKey);
                    return object;
                }
                this.portInfoBean = portInfoBean;
                if (clientInstancePoolFeature != null) {
                    clientInstancePoolFeature.addPropertyChangeListener(_clientInstancePoolListener);
                }
                if (clientInstancePoolFeature == null) {
                    clientInstancePoolFeature = new ClientInstancePoolFeature();
                    clientInstancePoolFeature.setClientIdentityFeature(this.feature);
                    clientInstancePoolFeature.setCapacity(0);
                }
                this._clientInstancePoolFeature = clientInstancePoolFeature;
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("ClientIdentityRegistry requesting initialization of client instance pool for client identity " + this.feature.getClientId() + " and instance type: " + clazz.getSimpleName());
                }
                clientInstancePool = new ClientInstancePool(this.feature, portInfoBean, clientInstancePoolFeature, instanceFactory, clazz);
                this._clientInstancePools.put(poolKey, clientInstancePool);
                this._initialized = true;
                ClientInstancePool clientInstancePool2 = clientInstancePool;
                return clientInstancePool2;
            }
            finally {
                this._lock.writeLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ClientIdentityFeature getClientIdentityFeature() {
            try {
                this._lock.readLock().lock();
                ClientIdentityFeature clientIdentityFeature = this.feature;
                return clientIdentityFeature;
            }
            finally {
                this._lock.readLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ClientInstancePoolFeature getClientInstancePoolFeature() {
            try {
                this._lock.readLock().lock();
                ClientInstancePoolFeature clientInstancePoolFeature = this._clientInstancePoolFeature;
                return clientInstancePoolFeature;
            }
            finally {
                this._lock.readLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public WseeClientRuntimeMBeanImpl getClientRuntimeMBean() {
            try {
                this._lock.readLock().lock();
                WseeClientRuntimeMBeanImpl wseeClientRuntimeMBeanImpl = this.mbean;
                return wseeClientRuntimeMBeanImpl;
            }
            finally {
                this._lock.readLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Map<PoolKey, ClientInstancePool<?>> getClientInstancePools() {
            try {
                this._lock.readLock().lock();
                Map<PoolKey, ClientInstancePool<?>> map = Collections.unmodifiableMap(this._clientInstancePools);
                return map;
            }
            finally {
                this._lock.readLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ClientInstancePool<?> getFirstClientInstancePool() {
            try {
                this._lock.readLock().lock();
                ClientInstancePool<?> clientInstancePool = this._clientInstancePools.getFirstPool();
                return clientInstancePool;
            }
            finally {
                this._lock.readLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public AsyncClientTransportFeature.AsyncResponseEndpointRegistry.EndpointInfo getOrCreateAsyncResponseEndpointInfo() {
            boolean bl = false;
            try {
                this._lock.readLock().lock();
                bl = true;
                if (this._asyncResponseEndpointInfo == null) {
                    this._lock.readLock().unlock();
                    bl = false;
                    try {
                        this._lock.writeLock().lock();
                        this._asyncResponseEndpointInfo = new AsyncClientTransportFeature.AsyncResponseEndpointRegistry.EndpointInfo();
                    }
                    finally {
                        this._lock.writeLock().unlock();
                    }
                }
                AsyncClientTransportFeature.AsyncResponseEndpointRegistry.EndpointInfo endpointInfo = this._asyncResponseEndpointInfo;
                return endpointInfo;
            }
            finally {
                if (bl) {
                    this._lock.readLock().unlock();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public AsyncClientTransportFeature.AsyncResponseEndpointRegistry.EndpointInfo getAsyncResponseEndpointInfo() {
            try {
                this._lock.readLock().lock();
                AsyncClientTransportFeature.AsyncResponseEndpointRegistry.EndpointInfo endpointInfo = this._asyncResponseEndpointInfo;
                return endpointInfo;
            }
            finally {
                this._lock.readLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Config getOriginalConfig() {
            try {
                this._lock.readLock().lock();
                Config config = this._originalConfig;
                return config;
            }
            finally {
                this._lock.readLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setOriginalConfig(Config config) {
            try {
                this._lock.writeLock().lock();
                this._originalConfig = config;
            }
            finally {
                this._lock.writeLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void disposeClientInstancePools() {
            try {
                this._lock.readLock().lock();
                for (ClientInstancePool<?> clientInstancePool : this._clientInstancePools.values()) {
                    try {
                        clientInstancePool.dispose();
                    }
                    catch (Exception exception) {
                        if (LOGGER.isLoggable(Level.WARNING)) {
                            LOGGER.log(Level.WARNING, exception.toString(), exception);
                        }
                        WseeCoreLogger.logUnexpectedException((String)exception.toString(), (Throwable)exception);
                    }
                }
            }
            finally {
                this._lock.readLock().unlock();
            }
            try {
                this._lock.writeLock().lock();
                this._clientInstancePools.clear();
            }
            finally {
                this._lock.writeLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void closeAllInClientInstancePools() {
            try {
                this._lock.readLock().lock();
                for (ClientInstancePool<?> clientInstancePool : this._clientInstancePools.values()) {
                    try {
                        clientInstancePool.closeAll();
                    }
                    catch (Exception exception) {
                        if (LOGGER.isLoggable(Level.WARNING)) {
                            LOGGER.log(Level.WARNING, exception.toString(), exception);
                        }
                        WseeCoreLogger.logUnexpectedException((String)exception.toString(), (Throwable)exception);
                    }
                }
            }
            finally {
                this._lock.readLock().unlock();
            }
        }

        public static class Config {
            private String _clientId;
            private boolean _generatedId;
            private boolean _warnedOnce;
            private Throwable _creationContext;
            @Nullable
            private WSServiceDelegate _service;
            @Nullable
            private WSEndpointReference _wsepr;
            @Nullable
            private QName _portName;
            @Nullable
            private WebServiceFeatureList _features;

            public Config(ClientIdentityFeature clientIdentityFeature, WSServiceDelegate wSServiceDelegate, WSEndpointReference wSEndpointReference, QName qName, WebServiceFeatureList webServiceFeatureList) {
                this._clientId = clientIdentityFeature.getClientId();
                this._generatedId = clientIdentityFeature.isGeneratedRawClientId();
                this._service = wSServiceDelegate;
                this._wsepr = wSEndpointReference;
                this._portName = qName;
                this._features = webServiceFeatureList;
                this._creationContext = new Throwable();
                this._creationContext.fillInStackTrace();
            }

            public void verifyAgainst(Config config) {
                try {
                    boolean bl = this.verifyFeatures(config._features);
                    this.verifyService(config._service, bl);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    if (!this._warnedOnce && LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine("Verification of original vs new ClientInfo.Config FAILED for client identity: " + this._clientId);
                        LOGGER.fine("Original Config Created Here...\n");
                        LOGGER.log(Level.FINE, "Original Config for Client " + this._clientId + " Created Here...\n", this._creationContext);
                        LOGGER.fine("New Config Created Here...\n");
                        LOGGER.log(Level.FINE, "New Config Created for Client " + this._clientId + " Here...\n", config._creationContext);
                    }
                    if (this._generatedId) {
                        if (!this._warnedOnce) {
                            WseeCoreLogger.logImplicitClientIdReusedImproperly((String)this._clientId, (String)illegalArgumentException.toString());
                        }
                    } else {
                        throw illegalArgumentException;
                    }
                    this._warnedOnce = true;
                }
            }

            public WSServiceDelegate getService() {
                return this._service;
            }

            public WSEndpointReference getWsepr() {
                return this._wsepr;
            }

            public QName getPortName() {
                return this._portName;
            }

            public WebServiceFeatureList getFeatures() {
                return this._features;
            }

            private void verifyService(WSServiceDelegate wSServiceDelegate, boolean bl) {
                Object object;
                boolean bl2 = false;
                if (this._service == null && wSServiceDelegate == null) {
                    bl2 = true;
                } else if (this._service != null && wSServiceDelegate != null) {
                    object = this._service.getWsdlService();
                    WSDLServiceImpl wSDLServiceImpl = wSServiceDelegate.getWsdlService();
                    if (object == null && wSDLServiceImpl == null || wSDLServiceImpl != null && object != null && wSDLServiceImpl.getName().equals(object.getName())) {
                        bl2 = true;
                    }
                }
                if (!bl2) {
                    object = "Cannot share ClientIdentityFeature for " + this._clientId + " across Services.";
                    if (bl) {
                        throw new WebServiceException((String)object);
                    }
                    throw new IllegalArgumentException((String)object);
                }
            }

            private boolean verifyFeatures(WebServiceFeatureList webServiceFeatureList) {
                StringBuffer stringBuffer = new StringBuffer();
                boolean bl = false;
                if (this._features == null && webServiceFeatureList != null || this._features != null && webServiceFeatureList == null) {
                    stringBuffer.append("One set of features was null and the other was not");
                } else if (this._features != null) {
                    bl = Config.verifyFeatures(this._features, webServiceFeatureList, stringBuffer);
                }
                if (stringBuffer.length() > 0) {
                    String string = "Feature set mismatch detected across client instances for client " + this._clientId + ":\n" + stringBuffer;
                    if (bl) {
                        throw new WebServiceException(string);
                    }
                    throw new IllegalArgumentException(string);
                }
                return bl;
            }

            private static boolean verifyFeatures(WebServiceFeatureList webServiceFeatureList, WebServiceFeatureList webServiceFeatureList2, StringBuffer stringBuffer) {
                boolean bl;
                WebServiceFeature webServiceFeature = webServiceFeatureList.get(AsyncClientTransportFeature.class);
                WebServiceFeature webServiceFeature2 = webServiceFeatureList2.get(AsyncClientTransportFeature.class);
                boolean bl2 = bl = webServiceFeature != null || webServiceFeature2 != null;
                if (webServiceFeature == null && webServiceFeature2 != null || webServiceFeature != null && webServiceFeature2 == null) {
                    stringBuffer.append("AsyncClientTransportFeature used inconsistently across client instances (same have it, some don't)");
                } else if (webServiceFeature != null && !webServiceFeature.equals(webServiceFeature2)) {
                    if (stringBuffer.length() > 0) {
                        stringBuffer.append("\n");
                    }
                    stringBuffer.append("AsyncClientTransportFeature used between client instances differ. Original=[").append(webServiceFeature).append("] New=[").append(webServiceFeature2).append("]");
                }
                Config.areEquivalent(webServiceFeatureList, webServiceFeatureList2, stringBuffer);
                return bl;
            }

            private static boolean areEquivalent(WebServiceFeatureList webServiceFeatureList, WebServiceFeatureList webServiceFeatureList2, StringBuffer stringBuffer) {
                WebServiceFeatureList webServiceFeatureList3 = new WebServiceFeatureList(webServiceFeatureList);
                WebServiceFeatureList webServiceFeatureList4 = new WebServiceFeatureList(webServiceFeatureList2);
                Config.excludeFeaturesFromEquivalenceCheck(webServiceFeatureList3);
                Config.excludeFeaturesFromEquivalenceCheck(webServiceFeatureList4);
                if (!Config.checkMapEquality(webServiceFeatureList3, webServiceFeatureList4)) {
                    if (stringBuffer.length() > 0) {
                        stringBuffer.append("\n");
                    }
                    stringBuffer.append("Original Features=[").append(Config.dumpFeatureMap(webServiceFeatureList3)).append("]");
                    stringBuffer.append("\n");
                    stringBuffer.append("New Features=     [").append(Config.dumpFeatureMap(webServiceFeatureList4)).append("]");
                }
                return stringBuffer.length() == 0;
            }

            private static boolean checkMapEquality(WebServiceFeatureList webServiceFeatureList, WebServiceFeatureList webServiceFeatureList2) {
                if (((Object)webServiceFeatureList.keySet()).equals(webServiceFeatureList2.keySet())) {
                    for (Class clazz : webServiceFeatureList.keySet()) {
                        WebServiceFeature webServiceFeature;
                        WebServiceFeature webServiceFeature2 = webServiceFeatureList.get(clazz);
                        if (WLSWebServiceFeature.featuresAreEqual((WebServiceFeature)webServiceFeature2, (WebServiceFeature)(webServiceFeature = webServiceFeatureList2.get(clazz)))) continue;
                        return false;
                    }
                } else {
                    return false;
                }
                return true;
            }

            private static String dumpFeatureMap(WebServiceFeatureList webServiceFeatureList) {
                StringBuffer stringBuffer = new StringBuffer();
                for (Class clazz : webServiceFeatureList.keySet()) {
                    stringBuffer.append(webServiceFeatureList.get(clazz)).append(", ");
                }
                return stringBuffer.toString();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private static void excludeFeaturesFromEquivalenceCheck(WebServiceFeatureList webServiceFeatureList) {
                WebServiceFeatureList webServiceFeatureList2 = webServiceFeatureList;
                synchronized (webServiceFeatureList2) {
                    Iterator iterator = webServiceFeatureList.keySet().iterator();
                    while (iterator.hasNext()) {
                        Class clazz = (Class)iterator.next();
                        WebServiceFeature webServiceFeature = webServiceFeatureList.get(clazz);
                        if (webServiceFeature instanceof ClientIdentityFeature || webServiceFeature instanceof AsyncClientTransportFeature) {
                            iterator.remove();
                            continue;
                        }
                        if (WLSWebServiceFeature.isKnownTubelineImpactingFeature(webServiceFeature.getClass()) || WLSWebServiceFeature.class.isAssignableFrom(webServiceFeature.getClass()) && ((WLSWebServiceFeature)webServiceFeature).isTubelineImpact()) continue;
                        iterator.remove();
                    }
                }
            }
        }
    }

    private static class ClientInstanceParentIdCalculator
    implements ClientIdentityFeature.ParentIdCalculator {
        private ClientInstanceParentIdCalculator() {
        }

        public String calculateParentId(ClientIdentityFeature clientIdentityFeature) {
            return this.calculateParentId();
        }

        public String calculateParentId() {
            String string = null;
            if (KernelStatus.isServer()) {
                try {
                    RuntimeMBean runtimeMBean = ClientContainerUtil.getContainingComponentRuntime();
                    if (runtimeMBean == null) {
                        runtimeMBean = ClientContainerUtil.getContainingApplicationRuntime();
                    }
                    if (runtimeMBean != null) {
                        string = "";
                        for (RuntimeMBean runtimeMBean2 = runtimeMBean; runtimeMBean2 != null && !(runtimeMBean2 instanceof ServerRuntimeMBean); runtimeMBean2 = runtimeMBean2.getParent()) {
                            int n;
                            String string2 = runtimeMBean2.getName();
                            if (runtimeMBean2 instanceof WebAppComponentRuntimeMBean && (n = string2.indexOf("_/")) >= 0) {
                                string2 = string2.substring(n + 2, string2.length());
                            }
                            string = string.length() > 0 ? string2 + ":" + string : string2;
                        }
                    }
                }
                catch (Exception exception) {
                    if (LOGGER.isLoggable(Level.SEVERE)) {
                        LOGGER.log(Level.SEVERE, exception.toString(), exception);
                    }
                    string = null;
                }
            }
            return string;
        }
    }

    private static class ClientIdentityEndpointRegistry
    implements AsyncClientTransportFeature.AsyncResponseEndpointRegistry {
        private ClientIdentityEndpointRegistry() {
        }

        public AsyncClientTransportFeature.AsyncResponseEndpointRegistry.EndpointInfo getAsyncResponseEndpoint(ClientIdentityFeature clientIdentityFeature) {
            ClientInfo clientInfo = ClientIdentityRegistry.getRequiredClientInfo(clientIdentityFeature.getClientId());
            return clientInfo.getOrCreateAsyncResponseEndpointInfo();
        }
    }
}

