/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.jaxws.spi;

import com.sun.xml.ws.Closeable;
import com.sun.xml.ws.api.addressing.WSEndpointReference;
import com.sun.xml.ws.binding.WebServiceFeatureList;
import com.sun.xml.ws.developer.WSBindingProvider;
import java.io.Serializable;
import java.lang.ref.PhantomReference;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.namespace.QName;
import javax.xml.ws.Dispatch;
import javax.xml.ws.Service;
import javax.xml.ws.WebServiceException;
import weblogic.wsee.jaxws.persistence.ClientInstanceProperties;
import weblogic.wsee.jaxws.spi.ClientInstanceIdentity;
import weblogic.wsee.jaxws.spi.ClientInstanceInvocationHandler;
import weblogic.wsee.jaxws.spi.ClientInstanceProxy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientInstance<T> {
    private static final Logger LOGGER = Logger.getLogger(ClientInstance.class.getName());
    private ClientInstanceIdentity _id;
    private CreationInfo _creationInfo;
    private boolean _durable;
    private T _instance;
    private boolean _active;
    private Map<String, Serializable> _props;
    private String _logicalStoreName;
    private Collection<Listener> _listeners = null;
    private PhantomReference<?> _ref;
    private InstanceReleaser _releaser;

    public ClientInstance(ClientInstanceIdentity clientInstanceIdentity, InstanceReleaser instanceReleaser, CreationInfo creationInfo, T t) {
        if (t instanceof ClientInstanceProxy) {
            throw new IllegalArgumentException("Error, constructed a ClientInstance using the proxy, instead of the underlying client instance (Port/Dispatch instance)");
        }
        this._id = clientInstanceIdentity;
        this._creationInfo = creationInfo;
        this._instance = t;
        this._active = false;
        this._durable = false;
        this._ref = null;
        this._releaser = instanceReleaser;
    }

    public boolean isDurable() {
        return this._durable;
    }

    public void setDurable(boolean bl, String string) {
        this._durable = bl;
        this._logicalStoreName = string;
    }

    public Map<String, Serializable> getProps() {
        if (this._props == null) {
            this._props = new HashMap<String, Serializable>();
        }
        return this._props;
    }

    public void setProps(Map<String, Serializable> map) {
        if (map == null) {
            throw new IllegalArgumentException("Props cannot be null");
        }
        this._props = map;
    }

    public void saveProps() {
        if (!this._durable) {
            return;
        }
        ClientInstanceProperties clientInstanceProperties = (ClientInstanceProperties)ClientInstanceProperties.getStoreMap(this._logicalStoreName).get(this.getId());
        if (clientInstanceProperties == null) {
            clientInstanceProperties = new ClientInstanceProperties(this.getId());
        }
        if (clientInstanceProperties.getPropertyMap() != this._props) {
            clientInstanceProperties.getPropertyMap().putAll(this._props);
        }
        ClientInstanceProperties.getStoreMap(this._logicalStoreName).put(this.getId(), clientInstanceProperties);
    }

    public T createProxyInstance(ReferenceHolderFactory referenceHolderFactory) {
        InstanceCloseable instanceCloseable = new InstanceCloseable(this);
        ClientInstanceInvocationHandler clientInstanceInvocationHandler = new ClientInstanceInvocationHandler(this, instanceCloseable);
        this._ref = referenceHolderFactory.create(clientInstanceInvocationHandler, instanceCloseable);
        return (T)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{this._creationInfo.getMode() != null ? Dispatch.class : this._creationInfo.getInstanceType(), WSBindingProvider.class, Closeable.class, ClientInstanceProxy.class}, clientInstanceInvocationHandler);
    }

    public synchronized void addClientInstanceListener(Listener<T> listener) {
        if (this._listeners == null) {
            this._listeners = new ArrayList<Listener>();
        }
        if (!this._listeners.contains(listener)) {
            this._listeners.add(listener);
        }
    }

    public synchronized void removeClientInstanceListener(Listener<T> listener) {
        if (this._listeners == null) {
            return;
        }
        this._listeners.remove(listener);
    }

    public boolean isActive() {
        return this._active;
    }

    public void activate() {
        if (this._active) {
            throw new IllegalStateException("ClientInstance already active, can't activate again: " + this._id);
        }
        this._active = true;
    }

    public void deactivate() {
        if (!this._active) {
            return;
        }
        this._active = false;
    }

    public ClientInstanceIdentity getId() {
        return this._id;
    }

    public CreationInfo getCreationInfo() {
        return this._creationInfo;
    }

    public T getInstance() {
        return this._instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close() {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Closing client instance: " + this);
        }
        this._ref = null;
        ClientInstance clientInstance = this;
        synchronized (clientInstance) {
            if (this._listeners != null) {
                ArrayList<Listener> arrayList = new ArrayList<Listener>(this._listeners);
                for (Listener listener : arrayList) {
                    listener.clientInstanceClosing(this);
                }
                if (this.getId().getType() == ClientInstanceIdentity.Type.POOLED) {
                    for (Listener listener : arrayList) {
                        listener.clientInstanceRecycled(this);
                    }
                }
                this._listeners = null;
            }
        }
        this._releaser.release(this);
    }

    public int hashCode() {
        return this._id.hashCode();
    }

    public boolean equals(Object object) {
        return object instanceof ClientInstance && this._id.equals(((ClientInstance)object)._id);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this._id.toString());
        stringBuffer.append(" - ").append(this._instance.toString());
        return stringBuffer.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface InstanceReleaser<T> {
        public void release(ClientInstance<T> var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Listener<T> {
        public void clientInstanceClosing(ClientInstance<T> var1);

        public void clientInstanceRecycled(ClientInstance<T> var1);
    }

    public static class CreationInfo {
        private QName _portName;
        private WSEndpointReference _wsepr;
        private Class _aClass;
        private JAXBContext _jaxbContext;
        private Service.Mode _mode;
        private WebServiceFeatureList _features;

        public CreationInfo(QName qName, WSEndpointReference wSEndpointReference, Class clazz, JAXBContext jAXBContext, Service.Mode mode, WebServiceFeatureList webServiceFeatureList) {
            this._portName = qName;
            this._wsepr = wSEndpointReference;
            this._aClass = clazz;
            this._jaxbContext = jAXBContext;
            this._mode = mode;
            this._features = new WebServiceFeatureList(webServiceFeatureList);
        }

        public CreationInfo(CreationInfo creationInfo, Class clazz, Service.Mode mode, WebServiceFeatureList webServiceFeatureList) {
            this._portName = creationInfo._portName;
            this._wsepr = creationInfo._wsepr;
            this._aClass = clazz;
            this._jaxbContext = creationInfo._jaxbContext;
            this._mode = mode;
            this._features = new WebServiceFeatureList(webServiceFeatureList);
        }

        public boolean isPortInstance() {
            return this._mode == null;
        }

        public boolean isDispatchInstance() {
            return this._mode != null;
        }

        public QName getPortName() {
            return this._portName;
        }

        public WSEndpointReference getWsepr() {
            return this._wsepr;
        }

        public Class getInstanceType() {
            return this._aClass;
        }

        public JAXBContext getJaxbContext() {
            return this._jaxbContext;
        }

        public Service.Mode getMode() {
            return this._mode;
        }

        public WebServiceFeatureList getFeatures() {
            return new WebServiceFeatureList(this._features);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface ReferenceHolderFactory {
        public PhantomReference<?> create(Object var1, Closeable var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class InstanceCloseable
    implements Closeable {
        private ClientInstance<?> instance;

        public InstanceCloseable(ClientInstance<?> clientInstance) {
            this.instance = clientInstance;
        }

        public synchronized void close() throws WebServiceException {
            if (this.instance != null) {
                ClientInstance<?> clientInstance = this.instance;
                this.instance = null;
                clientInstance.close();
            }
        }
    }
}

