/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.jaxws.spi;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.logging.Logger;

public class ClientInstanceIdentity
implements Serializable {
    private static final Logger LOGGER = Logger.getLogger(ClientInstanceIdentity.class.getName());
    private static final long serialVersionUID = 1L;
    private String _clientId;
    private Type _type;
    private Serializable _extraId;
    private String _id;

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject("10.3.6");
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.readObject();
        objectInputStream.defaultReadObject();
    }

    protected ClientInstanceIdentity(String string, Type type, Serializable serializable) {
        this._clientId = string;
        this._type = type;
        this._extraId = serializable;
        this.calculateId();
    }

    private void calculateId() {
        switch (this._type) {
            case SIMPLE: {
                this._id = this._clientId + "::" + this._extraId;
                break;
            }
            case POOLED: {
                this._id = this._clientId + "-" + this._extraId;
                break;
            }
            case CONVERSATIONAL: {
                this._id = this._clientId + "|" + this._extraId;
            }
        }
    }

    protected ClientInstanceIdentity(ClientInstanceIdentity clientInstanceIdentity, Serializable serializable) {
        this._clientId = clientInstanceIdentity._clientId;
        this._type = clientInstanceIdentity._type;
        this._extraId = serializable;
        this.calculateId();
    }

    public Serializable getExtraId() {
        return this._extraId;
    }

    public String getClientId() {
        return this._clientId;
    }

    public Type getType() {
        return this._type;
    }

    public String getId() {
        return this._id;
    }

    public int hashCode() {
        return this._id.hashCode();
    }

    public boolean equals(Object object) {
        return object instanceof ClientInstanceIdentity && ((ClientInstanceIdentity)object)._id.equals(this._id);
    }

    public String toString() {
        return this._id;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        SIMPLE,
        POOLED,
        CONVERSATIONAL;

    }
}

