/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.jaxws.spi;

import com.sun.xml.ws.binding.WebServiceFeatureList;
import java.io.Closeable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.ws.AsyncHandler;
import javax.xml.ws.WebServiceFeature;
import weblogic.jws.jaxws.client.async.AsyncClientHandlerFeature;
import weblogic.wsee.jaxws.spi.AsyncHandlerAllowedInternalFeature;
import weblogic.wsee.jaxws.spi.ClientInstance;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ClientInstanceInvocationHandler<T>
implements InvocationHandler {
    private static final Logger LOGGER = Logger.getLogger(ClientInstanceInvocationHandler.class.getName());
    private ClientInstance<T> _instance;
    private com.sun.xml.ws.Closeable c;

    ClientInstanceInvocationHandler(ClientInstance<T> clientInstance, com.sun.xml.ws.Closeable closeable) {
        if (clientInstance == null) {
            throw new IllegalArgumentException("Null instance");
        }
        this._instance = clientInstance;
        this.c = closeable;
    }

    @Override
    public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
        Class<?> clazz = method.getDeclaringClass();
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Invoking method " + method.getName() + " from declaring class " + clazz.getSimpleName() + " on proxy for client instance: " + this._instance);
        }
        if (this._instance == null) {
            if ((clazz == com.sun.xml.ws.Closeable.class || clazz == Closeable.class) && method.getName().equals("close") || clazz == Object.class && method.getName().equals("finalize")) {
                return null;
            }
            throw new IllegalStateException("Attempt to use a client instance (Port/Dispatch) that has been closed or finalized");
        }
        if ((clazz == com.sun.xml.ws.Closeable.class || clazz == Closeable.class) && method.getName().equals("close")) {
            this.closeInstance();
            return null;
        }
        if (clazz == Object.class && method.getName().equals("finalize")) {
            this.closeInstance();
            return null;
        }
        WebServiceFeatureList webServiceFeatureList = this._instance.getCreationInfo().getFeatures();
        if (this.isAsyncHandlerSupplied(objectArray) && webServiceFeatureList.containsKey(AsyncClientHandlerFeature.class) && !webServiceFeatureList.containsKey(AsyncHandlerAllowedInternalFeature.class)) {
            throw new IllegalArgumentException("Non-null javax.xml.ws.AsyncHandler cannot be used when a client instance (Port/Dispatch) already has AsyncClientHandlerFeature configured.");
        }
        try {
            return method.invoke(this._instance.getInstance(), objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw invocationTargetException.getCause();
        }
    }

    private void closeInstance() {
        this.c.close();
    }

    private boolean isAsyncHandlerSupplied(Object[] objectArray) {
        boolean bl = false;
        if (objectArray != null) {
            for (Object object : objectArray) {
                if (object == null || !(object instanceof AsyncHandler)) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    private Map<Class, WebServiceFeature> getFeatureMap(WebServiceFeature ... webServiceFeatureArray) {
        HashMap<Class, WebServiceFeature> hashMap = new HashMap<Class, WebServiceFeature>();
        for (WebServiceFeature webServiceFeature : webServiceFeatureArray) {
            hashMap.put(webServiceFeature.getClass(), webServiceFeature);
        }
        return hashMap;
    }
}

