/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.jaxws.spi;

import com.sun.istack.NotNull;
import com.sun.istack.Nullable;
import com.sun.xml.ws.client.Stub;
import java.io.Closeable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.WebServiceFeature;
import weblogic.j2ee.descriptor.wl.PortInfoBean;
import weblogic.jws.jaxws.client.ClientIdentityFeature;
import weblogic.wsee.WseeCoreLogger;
import weblogic.wsee.jaxws.persistence.ClientInstancePoolFeature;
import weblogic.wsee.jaxws.persistence.ClientInstanceProperties;
import weblogic.wsee.jaxws.persistence.ClientInstancePropertiesStore;
import weblogic.wsee.jaxws.persistence.PersistenceConfig;
import weblogic.wsee.jaxws.spi.ClientIdentityRegistry;
import weblogic.wsee.jaxws.spi.ClientInstance;
import weblogic.wsee.jaxws.spi.ClientInstanceIdentity;
import weblogic.wsee.persistence.StoreException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientInstancePool<T>
implements ClientInstance.InstanceReleaser<T> {
    private static final Logger LOGGER = Logger.getLogger(ClientInstancePool.class.getName());
    private ClientIdentityFeature _parentFeature;
    private boolean _durable;
    private boolean _initialized;
    private PortInfoBean _portInfoBean;
    private InstanceFactory _factory;
    private Class<T> _instanceType;
    private ClientInstancePoolFeature _poolFeature;
    private int _capacity;
    private ReentrantReadWriteLock _poolLock = new ReentrantReadWriteLock(false);
    private Condition _poolWriteLockFreeClientsCondition;
    private int _pooledClientTakeCount;
    private int _conversationalClientTakeCount;
    private int _simpleClientCreateCount;
    private List<ClientInstance<T>> _freeClients;
    private List<ClientInstance<T>> _takenClients;
    private Map<ClientInstanceIdentity, ClientInstanceProperties> _nonDurableConvClients;
    private ClientInstancePropertiesStore _durableConvClients;

    public ClientInstancePool(ClientIdentityFeature clientIdentityFeature, @Nullable PortInfoBean portInfoBean, @NotNull ClientInstancePoolFeature clientInstancePoolFeature, @NotNull InstanceFactory instanceFactory, @NotNull Class<T> clazz) throws StoreException {
        this._parentFeature = clientIdentityFeature;
        this._initialized = false;
        this._portInfoBean = portInfoBean;
        this._poolFeature = clientInstancePoolFeature;
        this._factory = instanceFactory;
        this._instanceType = clazz;
        this._poolWriteLockFreeClientsCondition = this._poolLock.writeLock().newCondition();
        this.initialize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize() throws StoreException {
        try {
            this._poolLock.writeLock().lock();
            if (this._initialized) {
                return;
            }
            if (this._factory == null || this._instanceType == null || this._poolFeature == null) {
                throw new IllegalArgumentException("Missing required args (factory, instanceType or poolFeature");
            }
            this._capacity = this._poolFeature.getCapacity();
            this._durable = this._poolFeature.isDurable();
            if (this._durable) {
                PersistenceConfig.Client client = PersistenceConfig.getClientConfig(this._portInfoBean);
                String string = client.getLogicalStoreName();
                if (string == null) {
                    return;
                }
                this._durableConvClients = ClientInstancePropertiesStore.getStore(string);
            } else {
                this._nonDurableConvClients = new HashMap<ClientInstanceIdentity, ClientInstanceProperties>();
            }
            this._freeClients = new ArrayList<ClientInstance<T>>(this._capacity);
            this._takenClients = new ArrayList<ClientInstance<T>>(this._capacity);
            this.fillPool();
            this._initialized = true;
        }
        finally {
            this._poolLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fillPool() {
        try {
            this._poolLock.writeLock().lock();
            if (this._factory == null) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("DurableClient pool not initialized because it is not yet required. Client ID: " + this._parentFeature.getClientId());
                }
                return;
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Client instance pool is being initialized (capacity=" + this._capacity + "). Client ID: " + this._parentFeature.getClientId());
            }
            while (this._freeClients.size() + this._takenClients.size() < this._capacity) {
                int n = this._freeClients.size() + this._takenClients.size() + 1;
                ClientInstanceIdentity clientInstanceIdentity = new ClientInstanceIdentity(this._parentFeature.getClientId(), ClientInstanceIdentity.Type.POOLED, Integer.valueOf(n));
                ClientInstance<T> clientInstance = this._factory.createClientInstance(clientInstanceIdentity, this._instanceType, this);
                this._freeClients.add(clientInstance);
            }
        }
        finally {
            this._poolLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInitialized() {
        try {
            this._poolLock.readLock().lock();
            boolean bl = this._initialized;
            return bl;
        }
        finally {
            this._poolLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PoolStats getStats() {
        try {
            this._poolLock.readLock().lock();
            PoolStats poolStats = new PoolStats();
            poolStats._capacity = this._capacity;
            poolStats._freeCount = this._freeClients.size();
            poolStats._takenCount = this._takenClients.size();
            poolStats._pooledClientTakeCount = this._pooledClientTakeCount;
            poolStats._conversationalClientTakeCount = this._conversationalClientTakeCount;
            poolStats._simpleClientCreateCount = this._simpleClientCreateCount;
            PoolStats poolStats2 = poolStats;
            return poolStats2;
        }
        finally {
            this._poolLock.readLock().unlock();
        }
    }

    static Map<Class, WebServiceFeature> getFeatureMap(WebServiceFeature ... webServiceFeatureArray) {
        HashMap<Class, WebServiceFeature> hashMap = new HashMap<Class, WebServiceFeature>();
        for (WebServiceFeature webServiceFeature : webServiceFeatureArray) {
            hashMap.put(webServiceFeature.getClass(), webServiceFeature);
        }
        return hashMap;
    }

    static WebServiceFeature[] getFeatureArray(Map<Class, WebServiceFeature> map) {
        return map.values().toArray(new WebServiceFeature[map.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClientInstance take(@Nullable ClientInstanceIdentity clientInstanceIdentity, ClientInstance.CreationInfo creationInfo) {
        ClientInstance clientInstance;
        if (clientInstanceIdentity != null && clientInstanceIdentity.getType() == ClientInstanceIdentity.Type.CONVERSATIONAL) {
            clientInstance = this.takeConversationalClientInstance(clientInstanceIdentity, creationInfo);
        } else {
            boolean bl;
            try {
                this._poolLock.readLock().lock();
                bl = this._capacity > 0;
            }
            finally {
                this._poolLock.readLock().unlock();
            }
            clientInstance = bl ? this.takePooledClientInstance() : this.takeSimpleClientInstance(clientInstanceIdentity, creationInfo);
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Took ClientInstance of type " + (Object)((Object)clientInstance.getId().getType()) + ": " + clientInstance);
        }
        return clientInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClientInstance takePooledClientInstance() {
        try {
            ClientInstance<T> clientInstance;
            this._poolLock.writeLock().lock();
            boolean bl = false;
            while (this._freeClients.isEmpty()) {
                bl = true;
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("ClientIdentityFeature pool (" + this._parentFeature.getClientId() + ") ran out of durable clients instances. Waiting as one of " + this._poolLock.getWaitQueueLength(this._poolWriteLockFreeClientsCondition) + " waiting threads");
                }
                try {
                    this._poolWriteLockFreeClientsCondition.await(30000L, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException interruptedException) {}
            }
            if (bl) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("ClientIdentityFeature pool (" + this._parentFeature.getClientId() + ") has a newly available pooled client instance. Waking up to use newly available instance. Available clients=" + this._freeClients.size() + " numWaiters=" + this._poolLock.getWaitQueueLength(this._poolWriteLockFreeClientsCondition));
                }
            } else if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("ClientIdentityFeature pool (" + this._parentFeature.getClientId() + ") had an available pooled client instance. Available clients=" + this._freeClients.size() + " takenClients=" + this._takenClients.size());
            }
            ClientInstance<T> clientInstance2 = clientInstance = this._freeClients.remove(0);
            synchronized (clientInstance2) {
                clientInstance.activate();
            }
            this._takenClients.add(clientInstance);
            ++this._pooledClientTakeCount;
            clientInstance2 = clientInstance;
            return clientInstance2;
        }
        finally {
            this._poolLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClientInstance takeConversationalClientInstance(@NotNull ClientInstanceIdentity clientInstanceIdentity, ClientInstance.CreationInfo creationInfo) {
        try {
            Object object;
            this._poolLock.writeLock().lock();
            ClientInstanceProperties clientInstanceProperties = null;
            if (this._durable) {
                object = this._durableConvClients.getByClientId(clientInstanceIdentity.getClientId());
                if (object != null) {
                    clientInstanceProperties = object.get(clientInstanceIdentity.getExtraId());
                }
                if (clientInstanceProperties == null) {
                    clientInstanceProperties = new ClientInstanceProperties(clientInstanceIdentity);
                    this._durableConvClients.put(clientInstanceIdentity, clientInstanceProperties);
                }
            } else {
                clientInstanceProperties = this._nonDurableConvClients.get(clientInstanceIdentity);
                if (clientInstanceProperties == null) {
                    clientInstanceProperties = new ClientInstanceProperties(clientInstanceIdentity);
                    this._nonDurableConvClients.put(clientInstanceIdentity, clientInstanceProperties);
                }
            }
            object = clientInstanceProperties.getClientInstance();
            if (object != null) {
                ClientInstance clientInstance = object;
                synchronized (clientInstance) {
                    if (!((ClientInstance)object).isActive()) {
                        ((ClientInstance)object).activate();
                    }
                }
                ++this._conversationalClientTakeCount;
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Took conversational client instance '" + clientInstanceIdentity + "' from pool");
                }
                clientInstance = object;
                return clientInstance;
            }
            ClientInstanceIdentity clientInstanceIdentity2 = new ClientInstanceIdentity(this._parentFeature.getClientId(), ClientInstanceIdentity.Type.CONVERSATIONAL, clientInstanceIdentity.getExtraId());
            object = this._factory.createClientInstance(clientInstanceIdentity2, creationInfo.getInstanceType(), this, creationInfo);
            ((ClientInstance)object).setDurable(this._durable, this._durable ? this._durableConvClients.getName() : null);
            ((ClientInstance)object).setProps(clientInstanceProperties.getPropertyMap());
            clientInstanceProperties.setClientInstance((ClientInstance<?>)object);
            ((ClientInstance)object).activate();
            ++this._conversationalClientTakeCount;
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Took (and created) conversational client instance '" + clientInstanceIdentity + "' from pool");
            }
            ClientInstance clientInstance = object;
            return clientInstance;
        }
        finally {
            this._poolLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClientInstance takeSimpleClientInstance(@Nullable ClientInstanceIdentity clientInstanceIdentity, ClientInstance.CreationInfo creationInfo) {
        if (clientInstanceIdentity == null) {
            clientInstanceIdentity = ClientIdentityRegistry.generateSimpleClientInstanceIdentity(this._parentFeature.getClientId());
        }
        ClientInstance clientInstance = this._factory.createClientInstance(clientInstanceIdentity, creationInfo.getInstanceType(), this, creationInfo);
        clientInstance.activate();
        try {
            this._poolLock.writeLock().lock();
            ++this._simpleClientCreateCount;
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Took simple client instance '" + clientInstanceIdentity + "' from pool: " + this);
            }
            ClientInstance clientInstance2 = clientInstance;
            return clientInstance2;
        }
        finally {
            this._poolLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release(ClientInstance<T> clientInstance) {
        if (clientInstance == null) {
            return;
        }
        ClientInstance<T> clientInstance2 = clientInstance;
        synchronized (clientInstance2) {
            if (!clientInstance.isActive()) {
                return;
            }
        }
        try {
            this._poolLock.writeLock().lock();
            clientInstance2 = clientInstance;
            synchronized (clientInstance2) {
                clientInstance.deactivate();
                BindingProvider bindingProvider = (BindingProvider)clientInstance.getInstance();
                Stub stub = this.getStubFromProvider(bindingProvider);
                stub.resetRequestContext();
                stub.setResponseContext(null);
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("ClientIdentityFeature pool (" + this._parentFeature.getClientId() + ") releasing client instance " + clientInstance.getId() + " Available pooled clients=" + this._freeClients.size() + " numWaiters=" + this._poolLock.getWaitQueueLength(this._poolWriteLockFreeClientsCondition) + " Current conv client count: " + (this._durable ? this._durableConvClients.size() : this._nonDurableConvClients.size()));
            }
            if (clientInstance.getId().getType() == ClientInstanceIdentity.Type.CONVERSATIONAL) {
                if (this._durable) {
                    this._durableConvClients.remove(clientInstance.getId());
                } else {
                    this._nonDurableConvClients.remove(clientInstance.getId());
                }
                this.closeCloseableInstance(clientInstance.getInstance());
            } else if (clientInstance.getId().getType() == ClientInstanceIdentity.Type.POOLED) {
                this._takenClients.remove(clientInstance);
                this._freeClients.add(clientInstance);
                this._poolWriteLockFreeClientsCondition.signal();
            } else {
                this.closeCloseableInstance(clientInstance.getInstance());
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("ClientIdentityFeature pool (" + this._parentFeature.getClientId() + ") RELEASED client instance " + clientInstance.getId() + " Available pooled clients=" + this._freeClients.size() + " numWaiters=" + this._poolLock.getWaitQueueLength(this._poolWriteLockFreeClientsCondition) + " Current conv client count: " + (this._durable ? this._durableConvClients.size() : this._nonDurableConvClients.size()));
            }
        }
        finally {
            this._poolLock.writeLock().unlock();
        }
    }

    private Stub getStubFromProvider(BindingProvider bindingProvider) {
        if (Proxy.isProxyClass(bindingProvider.getClass())) {
            return this.getStubFromProxy(Proxy.getInvocationHandler(bindingProvider));
        }
        return (Stub)bindingProvider;
    }

    private Stub getStubFromProxy(InvocationHandler invocationHandler) {
        if (Proxy.isProxyClass(invocationHandler.getClass())) {
            return this.getStubFromProxy(Proxy.getInvocationHandler(invocationHandler));
        }
        return (Stub)invocationHandler;
    }

    private void closeCloseableInstance(Object object) {
        try {
            if (object instanceof com.sun.xml.ws.Closeable) {
                ((com.sun.xml.ws.Closeable)object).close();
            } else if (object instanceof Closeable) {
                ((Closeable)object).close();
            }
        }
        catch (Exception exception) {
            if (LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.log(Level.SEVERE, exception.toString(), exception);
            }
            WseeCoreLogger.logUnexpectedException((String)exception.toString(), (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCapacity() {
        try {
            this._poolLock.readLock().lock();
            int n = this._capacity;
            return n;
        }
        finally {
            this._poolLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getFreeSize() {
        try {
            this._poolLock.readLock().lock();
            int n = this._freeClients.size();
            return n;
        }
        finally {
            this._poolLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTakenSize() {
        try {
            this._poolLock.readLock().lock();
            int n = this._freeClients.size();
            return n;
        }
        finally {
            this._poolLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void expand(int n) {
        try {
            this._poolLock.writeLock().lock();
            if (n <= this._capacity) {
                return;
            }
            this._capacity = n;
            this.fillPool();
        }
        finally {
            this._poolLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        try {
            this._poolLock.writeLock().lock();
            if (!this._initialized) {
                return;
            }
        }
        finally {
            this._poolLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeAll() {
        try {
            ClientInstance[] clientInstanceArray;
            this._poolLock.writeLock().lock();
            if (!this._initialized) {
                return;
            }
            for (ClientInstance clientInstance : clientInstanceArray = this._freeClients.toArray(new ClientInstance[this._freeClients.size()])) {
                clientInstance.close();
            }
        }
        finally {
            this._poolLock.writeLock().unlock();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface InstanceFactory {
        public <T2> ClientInstance<T2> createClientInstance(ClientInstanceIdentity var1, Class<T2> var2, ClientInstance.InstanceReleaser<T2> var3);

        public <T2> ClientInstance<T2> createClientInstance(ClientInstanceIdentity var1, Class<T2> var2, ClientInstance.InstanceReleaser<T2> var3, ClientInstance.CreationInfo var4);
    }

    public static class PoolStats {
        private int _capacity;
        private int _freeCount;
        private int _takenCount;
        private int _pooledClientTakeCount;
        private int _conversationalClientTakeCount;
        private int _simpleClientCreateCount;

        public int getCapacity() {
            return this._capacity;
        }

        public int getFreeCount() {
            return this._freeCount;
        }

        public int getTakenCount() {
            return this._takenCount;
        }

        public int getPooledClientTakeCount() {
            return this._pooledClientTakeCount;
        }

        public int getConversationalClientTakeCount() {
            return this._conversationalClientTakeCount;
        }

        public int getSimpleClientCreateCount() {
            return this._simpleClientCreateCount;
        }
    }
}

