/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.jaxws.spi;

import com.sun.xml.ws.api.pipe.Fiber;
import com.sun.xml.ws.api.pipe.FiberContextSwitchInterceptor;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.xml.ws.WebServiceException;
import weblogic.kernel.KernelStatus;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityServiceManager;
import weblogic.security.subject.AbstractSubject;
import weblogic.security.subject.SubjectManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FiberContextSwitchInterceptorImpl
implements FiberContextSwitchInterceptor {
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private static boolean isOnServer = KernelStatus.isServer();
    private final AuthenticatedSubject currentSubject = (AuthenticatedSubject)SubjectManager.getSubjectManager().getCurrentSubject((AbstractSubject)kernelId);

    public <R, P> R execute(Fiber fiber, final P p, final FiberContextSwitchInterceptor.Work<R, P> work) {
        if (!isOnServer) {
            return (R)work.execute(p);
        }
        try {
            return (R)SecurityServiceManager.runAs((AuthenticatedSubject)kernelId, (AuthenticatedSubject)this.currentSubject, (PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                public Object run() {
                    return work.execute(p);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            if (exception instanceof WebServiceException) {
                throw (WebServiceException)((Object)exception);
            }
            throw new WebServiceException((Throwable)exception);
        }
    }
}

