/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.jaxws.spi;

import com.sun.istack.NotNull;
import com.sun.istack.Nullable;
import com.sun.xml.stream.buffer.XMLStreamBuffer;
import com.sun.xml.stream.buffer.XMLStreamBufferResult;
import com.sun.xml.ws.api.BindingID;
import com.sun.xml.ws.api.WSBinding;
import com.sun.xml.ws.api.server.Container;
import com.sun.xml.ws.api.server.ContainerResolver;
import com.sun.xml.ws.api.server.InstanceResolver;
import com.sun.xml.ws.api.server.Invoker;
import com.sun.xml.ws.api.server.SDDocumentSource;
import com.sun.xml.ws.api.server.WSEndpoint;
import com.sun.xml.ws.binding.BindingImpl;
import com.sun.xml.ws.binding.ImpliesWebServiceFeature;
import com.sun.xml.ws.binding.WebServiceFeatureList;
import com.sun.xml.ws.developer.MemberSubmissionAddressingFeature;
import com.sun.xml.ws.server.EndpointFactory;
import com.sun.xml.ws.server.ServerRtException;
import com.sun.xml.ws.server.WSEndpointImpl;
import com.sun.xml.ws.util.xml.XmlUtil;
import java.io.IOException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.Permission;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import javax.xml.namespace.QName;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.ws.Binding;
import javax.xml.ws.Endpoint;
import javax.xml.ws.EndpointReference;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.WebServiceFeature;
import javax.xml.ws.WebServicePermission;
import javax.xml.ws.soap.AddressingFeature;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import org.w3c.dom.Element;
import weblogic.application.ApplicationAccess;
import weblogic.application.ApplicationContext;
import weblogic.application.ApplicationException;
import weblogic.application.ApplicationLifecycleEvent;
import weblogic.application.ApplicationLifecycleListener;
import weblogic.application.ModuleException;
import weblogic.application.UpdateListener;
import weblogic.deploy.api.shared.WebLogicModuleType;
import weblogic.descriptor.DescriptorBean;
import weblogic.descriptor.DescriptorManager;
import weblogic.j2ee.descriptor.ServletBean;
import weblogic.j2ee.descriptor.ServletMappingBean;
import weblogic.j2ee.descriptor.WebAppBean;
import weblogic.j2ee.descriptor.wl.DeploymentPlanBean;
import weblogic.jws.jaxws.client.async.AsyncClientFeatureListFeature;
import weblogic.kernel.KernelStatus;
import weblogic.management.configuration.ServerMBean;
import weblogic.management.provider.ManagementService;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.servlet.ReferencedAttribute;
import weblogic.servlet.internal.HttpServer;
import weblogic.servlet.internal.ServletContextManager;
import weblogic.servlet.internal.WarSource;
import weblogic.servlet.internal.WebAppModule;
import weblogic.servlet.internal.WebAppParser;
import weblogic.servlet.internal.WebAppServletContext;
import weblogic.servlet.internal.WebService;
import weblogic.utils.classloaders.GenericClassLoader;
import weblogic.utils.collections.ConcurrentHashMap;
import weblogic.utils.jars.VirtualJarFile;
import weblogic.wsee.WseeCoreLogger;
import weblogic.wsee.deploy.WseeWebappParser;
import weblogic.wsee.jaxws.JAXWSPublishServlet;
import weblogic.wsee.jaxws.WLSContainer;
import weblogic.wsee.jaxws.spi.WLSProvider;
import weblogic.wsee.server.ServerUtil;
import weblogic.wsee.util.Guid;
import weblogic.wsee.wstx.wsat.config.DDHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WLSEndpoint
extends Endpoint {
    private static final Logger LOGGER = Logger.getLogger(WLSEndpoint.class.getName());
    private static final WebServicePermission ENDPOINT_PUBLISH_PERMISSION = new WebServicePermission("publishEndpoint");
    private static final AuthenticatedSubject KERNEL_ID = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private final BindingImpl binding;
    private final Object implementor;
    private List<Source> metadata;
    private Executor executor;
    private Map<String, Object> properties = Collections.emptyMap();
    private boolean published;
    private boolean stopped;
    private WLSProvider provider;
    private Endpoint proxy = null;
    private WSEndpoint wse;
    private String address;
    private String publicAddress;
    private String mapping;
    private PublishWseeModule module;
    private List<Listener> _listeners = new ArrayList<Listener>();
    private ReentrantReadWriteLock _listenersLock = new ReentrantReadWriteLock(false);

    public WLSEndpoint(@NotNull WLSProvider wLSProvider, @NotNull BindingID bindingID, @NotNull Object object, Executor executor) {
        this.provider = wLSProvider;
        WebServiceFeatureList webServiceFeatureList = new WebServiceFeatureList(object.getClass());
        WLSProvider.parseAnnotations(webServiceFeatureList, object.getClass(), true);
        DDHelper.updateFeatureFromJWS(null, object.getClass(), webServiceFeatureList);
        if (object instanceof ImpliesWebServiceFeature) {
            ((ImpliesWebServiceFeature)object).implyFeatures((Map)webServiceFeatureList);
        }
        this.binding = BindingImpl.create((BindingID)bindingID, (WebServiceFeature[])webServiceFeatureList.toArray());
        this.implementor = object;
        this.executor = executor;
    }

    public void addFeature(WebServiceFeature webServiceFeature) {
        this.binding.addFeature(webServiceFeature);
    }

    public void addFeatures(WebServiceFeature[] webServiceFeatureArray) {
        for (WebServiceFeature webServiceFeature : webServiceFeatureArray) {
            this.addFeature(webServiceFeature);
        }
    }

    public WSEndpoint getWSEndpoint() {
        return this.wse;
    }

    public Binding getBinding() {
        if (this.proxy != null) {
            return this.proxy.getBinding();
        }
        return this.binding;
    }

    public Object getImplementor() {
        return this.implementor;
    }

    public void publish(String string) {
        URL uRL;
        this.canPublish();
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            throw new IllegalArgumentException("Cannot create URL for this address " + string);
        }
        if (!uRL.getProtocol().equals("http") && !uRL.getProtocol().equals("https")) {
            throw new IllegalArgumentException(uRL.getProtocol() + " protocol based address is not supported");
        }
        if (!uRL.getPath().startsWith("/")) {
            throw new IllegalArgumentException("Incorrect WebService address=" + string + ". The address's path should start with /");
        }
        this.address = string;
        this.publicAddress = WLSEndpoint.calculatePublicAddressFromEndpointAddress(uRL);
        this.createAndPublishEndpoint(uRL);
    }

    public void publish(Object object) {
        this.canPublish();
        if (!WebAppServletContext.class.isAssignableFrom(object.getClass())) {
            throw new IllegalArgumentException(object.getClass() + " is not a supported context.");
        }
        WebAppServletContext webAppServletContext = (WebAppServletContext)object;
        String string = WLSContainer.calculateEndpointId((WSBinding)this.getBinding(), false);
        if (string == null) {
            string = Guid.generateGuid();
        }
        String string2 = "/" + string;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(WLSEndpoint.getServerAddress());
        stringBuffer.append(webAppServletContext.getContextPath());
        stringBuffer.append(string2);
        this.address = stringBuffer.toString();
        this.publicAddress = WLSEndpoint.calculatePublicAddressFromEndpointAddress(this.address);
        this.createAndPublishEndpoint(webAppServletContext.getServer(), webAppServletContext, string2);
    }

    public static String getServerAddress() {
        return WLSEndpoint.getServerAddress("http");
    }

    public static String getServerAddressForSSL() {
        return WLSEndpoint.getServerAddress("https");
    }

    public static String getServerAddress(String string) {
        Object object;
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("Bad protocol: " + string);
        }
        ServerMBean serverMBean = ManagementService.getRuntimeAccess(KERNEL_ID).getServer();
        String string2 = serverMBean.getListenAddress();
        if (string2 == null || string2.equals("")) {
            try {
                string2 = InetAddress.getLocalHost().getCanonicalHostName();
            }
            catch (UnknownHostException unknownHostException) {
                throw new WebServiceException((Throwable)unknownHostException);
            }
        }
        int n = -1;
        if (string.equalsIgnoreCase("https")) {
            if (serverMBean.getSSL() != null && (object = serverMBean.getSSL()).isEnabled()) {
                n = object.getListenPort();
            }
        } else if (serverMBean.isListenPortEnabled()) {
            n = serverMBean.getListenPort();
        }
        if (n == -1 && (object = serverMBean.getNetworkAccessPoints()) != null) {
            for (Object object2 : object) {
                if (!string.equalsIgnoreCase(object2.getProtocol())) continue;
                n = object2.getListenPort();
                if (object2.getListenAddress() == null) continue;
                string2 = object2.getListenAddress();
            }
        }
        object = new StringBuffer();
        ((StringBuffer)object).append(string + "://");
        ((StringBuffer)object).append(string2);
        if (n != -1) {
            ((StringBuffer)object).append(':');
            ((StringBuffer)object).append(n);
        }
        return ((StringBuffer)object).toString();
    }

    private static String calculatePublicAddressFromEndpointAddress(String string) {
        URL uRL;
        if (!KernelStatus.isServer()) {
            return string;
        }
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            throw new IllegalArgumentException("Cannot create URL for this address " + string);
        }
        return WLSEndpoint.calculatePublicAddressFromEndpointAddress(uRL);
    }

    private static String calculatePublicAddressFromEndpointAddress(URL uRL) {
        if (!KernelStatus.isServer()) {
            return uRL.toExternalForm();
        }
        String string = ServerUtil.getServerURL(uRL.getProtocol());
        string = string + uRL.getPath();
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(Listener listener) {
        try {
            this._listenersLock.writeLock().lock();
            if (!this._listeners.contains(listener)) {
                this._listeners.add(listener);
            }
        }
        finally {
            this._listenersLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(Listener listener) {
        try {
            this._listenersLock.writeLock().lock();
            this._listeners.remove(listener);
        }
        finally {
            this._listenersLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Listener[] getListeners() {
        try {
            this._listenersLock.readLock().lock();
            Listener[] listenerArray = this._listeners.toArray(new Listener[this._listeners.size()]);
            return listenerArray;
        }
        finally {
            this._listenersLock.readLock().unlock();
        }
    }

    public void stop() {
        Listener[] listenerArray;
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Stopping endpoint: " + this.toString());
        }
        for (Listener listener : listenerArray = this.getListeners()) {
            try {
                listener.endpointStopping(this);
            }
            catch (Exception exception) {
                WseeCoreLogger.logUnexpectedException((String)exception.toString(), (Throwable)exception);
            }
        }
        if (this.proxy != null) {
            this.proxy.stop();
        } else if (this.isPublished()) {
            if (this.module != null) {
                try {
                    this.module.deactivate();
                    this.module.unprepare();
                }
                catch (ModuleException moduleException) {
                    throw new WebServiceException((Throwable)((Object)moduleException));
                }
                finally {
                    this.module = null;
                }
            }
            ((JAXWSPublishServlet.Configuration)((Map)((ServletContext)this.wse.getContainer().getSPI(ServletContext.class)).getAttribute((String)"CONFIGURATION_KEY")).get((Object)this.mapping)).stopped = true;
            this.wse.dispose();
            this.published = false;
        }
        this.stopped = true;
    }

    public boolean isPublished() {
        if (this.proxy != null) {
            return this.proxy.isPublished();
        }
        return this.published;
    }

    public List<Source> getMetadata() {
        if (this.proxy != null) {
            return this.proxy.getMetadata();
        }
        return this.metadata;
    }

    public void setMetadata(List<Source> list) {
        if (this.proxy != null) {
            this.proxy.setMetadata(list);
        } else if (this.isPublished()) {
            throw new IllegalStateException("Cannot set Metadata. Endpoint is already published");
        }
        this.metadata = list;
    }

    public Executor getExecutor() {
        if (this.proxy != null) {
            return this.proxy.getExecutor();
        }
        return this.executor;
    }

    public void setExecutor(Executor executor) {
        if (this.proxy != null) {
            this.proxy.setExecutor(executor);
        }
        this.executor = executor;
    }

    public Map<String, Object> getProperties() {
        if (this.proxy != null) {
            return this.proxy.getProperties();
        }
        return new HashMap<String, Object>(this.properties);
    }

    public void setProperties(Map<String, Object> map) {
        if (this.proxy != null) {
            this.proxy.setProperties(map);
        }
        this.properties = new HashMap<String, Object>(map);
    }

    private Endpoint initializeProxy(URL uRL) {
        Endpoint endpoint = this.provider.createEndpointInternal(this.binding.getBindingId(), this.implementor);
        endpoint.setExecutor(this.executor);
        endpoint.setMetadata(this.metadata);
        endpoint.setProperties(this.properties);
        endpoint.publish(uRL.toExternalForm());
        return endpoint;
    }

    private void createAndPublishEndpoint(URL uRL) {
        this.addFeaturesFromClientBinding();
        HttpServer httpServer = this.findServer(uRL);
        if (httpServer != null) {
            String string;
            WebAppServletContext webAppServletContext;
            ServletContextManager servletContextManager = httpServer.getServletContextManager();
            String string2 = uRL.getPath() != null ? uRL.getPath() : "/";
            String string3 = string2;
            int n = string3.lastIndexOf(47);
            if (n > 0) {
                string3 = string3.substring(0, n);
            }
            if ((webAppServletContext = servletContextManager.getContext(string3)) != null) {
                string = string2.substring(webAppServletContext.getContextPath().length());
            } else {
                string = string2.substring(string3.length());
                if (string.length() == 0) {
                    string = "/*";
                }
                this.createModule(string3, string);
            }
            this.createAndPublishEndpoint(httpServer, webAppServletContext, string);
        }
        if (!this.published) {
            this.proxy = this.initializeProxy(uRL);
        }
    }

    private void createModule(String string, String string2) {
        Object object;
        Object object2;
        Container container = ContainerResolver.getInstance().getContainer();
        String string3 = "";
        if (container != null && (object2 = (WebAppServletContext)container.getSPI(ServletContext.class)) != null && (object = ((WebAppServletContext)object2).getWebAppModule()) != null) {
            string3 = ((WebAppModule)object).getModuleURI();
        }
        object2 = ApplicationAccess.getApplicationAccess().getCurrentApplicationContext();
        object = object2.getAppClassLoader();
        this.module = new PublishWseeModule(string3, string, string2);
        try {
            this.module.initUsingLoader((ApplicationContext)object2, (GenericClassLoader)object, UpdateListener.Registration.NOOP);
            this.module.prepare();
        }
        catch (ModuleException moduleException) {
            throw new WebServiceException((Throwable)((Object)moduleException));
        }
    }

    private HttpServer findServer(URL uRL) {
        HttpServer httpServer = WebService.getVirtualHost(uRL.getHost());
        if (httpServer == null) {
            httpServer = WebService.defaultHttpServer();
        }
        return httpServer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createAndPublishEndpoint(HttpServer httpServer, WebAppServletContext hashMap, String string) {
        block20: {
            QName qName;
            Object object;
            Object object2;
            this.addFeaturesFromClientBinding();
            if (this.module != null) {
                object2 = this.module.getAllContexts();
                while (object2.hasNext()) {
                    object = (WebAppServletContext)object2.next();
                    if (!((WebAppServletContext)object).getServer().equals(httpServer)) continue;
                    hashMap = object;
                    break;
                }
            }
            if ((object2 = System.getSecurityManager()) != null) {
                ((SecurityManager)object2).checkPermission((Permission)ENDPOINT_PUBLISH_PERMISSION);
            }
            object = new WLSContainer((ServletContext)hashMap, null);
            QName qName2 = this.getProperty(QName.class, "javax.xml.ws.wsdl.service");
            if (qName2 == null) {
                qName2 = WSEndpoint.getDefaultServiceName(this.implementor.getClass());
            }
            if ((qName = this.getProperty(QName.class, "javax.xml.ws.wsdl.port")) == null) {
                qName = WSEndpoint.getDefaultPortName((QName)qName2, this.implementor.getClass());
            }
            ((WLSContainer)((Object)object)).registerPendingBoundEndpoint(qName2, qName, string);
            ((WLSContainer)((Object)object)).setCurrent();
            try {
                Object object3;
                this.wse = WSEndpoint.create(this.implementor.getClass(), (boolean)true, (Invoker)InstanceResolver.createSingleton((Object)this.implementor).createInvoker(), (QName)qName2, (QName)qName, (Container)object, (WSBinding)this.binding, (SDDocumentSource)this.getPrimaryWsdl((WebAppServletContext)((Object)hashMap)), this.buildDocList(), (URL)null);
                this.wse.setExecutor(this.executor);
                this.mapping = string;
                ((WebAppServletContext)((Object)hashMap)).getApplicationContext().addApplicationListener(new ApplicationLifecycleListener(){

                    public void preStop(ApplicationLifecycleEvent applicationLifecycleEvent) throws ApplicationException {
                        WLSEndpoint.this.stop();
                    }
                });
                JAXWSPublishServlet.Configuration configuration = new JAXWSPublishServlet.Configuration((WLSContainer)((Object)object), this.wse);
                HashMap<String, String> hashMap2 = hashMap;
                synchronized (hashMap2) {
                    object3 = (Map)((WebAppServletContext)((Object)hashMap)).getAttribute("CONFIGURATION_KEY");
                    if (object3 == null) {
                        object3 = new ReferencedConcurrentHashMap();
                        ((WebAppServletContext)((Object)hashMap)).setAttribute("CONFIGURATION_KEY", object3);
                    }
                    object3.put(string, configuration);
                }
                if (this.module == null) {
                    try {
                        hashMap2 = new HashMap<String, String>();
                        hashMap2.put("SERVICEURI_KEY", string);
                        object3 = this.implementor.getClass().getSimpleName() + ":" + string;
                        if (((WebAppServletContext)((Object)hashMap)).getNamedDispatcher((String)object3) == null) {
                            ((WebAppServletContext)((Object)hashMap)).registerServlet((String)object3, JAXWSPublishServlet.class.getName(), new String[]{string}, hashMap2, 0);
                        } else {
                            ((WebAppServletContext)((Object)hashMap)).swapServlet((String)object3, JAXWSPublishServlet.class.getName(), hashMap2);
                        }
                        break block20;
                    }
                    catch (Exception exception) {
                        throw new WebServiceException((Throwable)exception);
                    }
                }
                try {
                    ((WebAppServletContext)((Object)hashMap)).setAttribute("SERVICEURI_KEY", string);
                    this.module.activate();
                    this.module.start();
                }
                catch (ModuleException moduleException) {
                    throw new WebServiceException((Throwable)((Object)moduleException));
                }
            }
            finally {
                ((WLSContainer)((Object)object)).resetCurrent();
            }
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Published endpoint: " + this.toString());
        }
        this.published = true;
    }

    private void addFeaturesFromClientBinding() {
        if (this.binding.isFeatureEnabled(AsyncClientFeatureListFeature.class)) {
            AsyncClientFeatureListFeature asyncClientFeatureListFeature = (AsyncClientFeatureListFeature)this.binding.getFeature(AsyncClientFeatureListFeature.class);
            if (asyncClientFeatureListFeature.getClientFeatures().isEnabled(AddressingFeature.class)) {
                this.binding.addFeature(asyncClientFeatureListFeature.getClientFeatures().get(AddressingFeature.class));
            }
            if (asyncClientFeatureListFeature.getClientFeatures().isEnabled(MemberSubmissionAddressingFeature.class)) {
                this.binding.addFeature(asyncClientFeatureListFeature.getClientFeatures().get(MemberSubmissionAddressingFeature.class));
            }
        }
    }

    private <T> T getProperty(Class<T> clazz, String string) {
        Object object = this.properties.get(string);
        if (object == null) {
            return null;
        }
        if (clazz.isInstance(object)) {
            return clazz.cast(object);
        }
        throw new IllegalArgumentException("Property " + string + " has to be of type " + clazz);
    }

    private List<SDDocumentSource> buildDocList() {
        ArrayList<SDDocumentSource> arrayList = new ArrayList<SDDocumentSource>();
        if (this.metadata != null) {
            Transformer transformer = XmlUtil.newTransformer();
            for (Source source : this.metadata) {
                arrayList.add(this.convert(transformer, source));
            }
        }
        return arrayList;
    }

    private SDDocumentSource convert(Source source) {
        Transformer transformer = XmlUtil.newTransformer();
        return this.convert(transformer, source);
    }

    private SDDocumentSource convert(Transformer transformer, Source source) {
        try {
            XMLStreamBufferResult xMLStreamBufferResult = new XMLStreamBufferResult();
            transformer.transform(source, (Result)xMLStreamBufferResult);
            String string = source.getSystemId();
            return SDDocumentSource.create((URL)new URL(string), (XMLStreamBuffer)xMLStreamBufferResult.getXMLStreamBuffer());
        }
        catch (TransformerException transformerException) {
            throw new ServerRtException("server.rt.err", new Object[]{transformerException});
        }
        catch (IOException iOException) {
            throw new ServerRtException("server.rt.err", new Object[]{iOException});
        }
    }

    @Nullable
    private SDDocumentSource getPrimaryWsdl(WebAppServletContext webAppServletContext) {
        Class<?> clazz = this.implementor.getClass();
        String string = EndpointFactory.getWsdlLocation(clazz);
        if (string != null) {
            ClassLoader classLoader = clazz.getClassLoader();
            URL uRL = classLoader.getResource(string);
            if (uRL != null) {
                return SDDocumentSource.create((URL)uRL);
            }
            WarSource warSource = webAppServletContext.getResourceAsSource(string);
            if (warSource != null) {
                return SDDocumentSource.create((URL)warSource.getURL());
            }
            throw new ServerRtException("cannot.load.wsdl", new Object[]{string});
        }
        return null;
    }

    private void canPublish() {
        if (this.isPublished()) {
            throw new IllegalStateException("Cannot publish endpoint (" + this.toString() + "). Endpoint has been already published.");
        }
        if (this.stopped) {
            throw new IllegalStateException("Cannot publish this endpoint (" + this.toString() + "). Endpoint has been already stopped.");
        }
    }

    public EndpointReference getEndpointReference(Element ... elementArray) {
        if (this.proxy != null) {
            return this.proxy.getEndpointReference(elementArray);
        }
        return this.getEndpointReference(W3CEndpointReference.class, elementArray);
    }

    public <T extends EndpointReference> T getEndpointReference(Class<T> clazz, Element ... elementArray) {
        if (this.proxy != null) {
            return (T)this.proxy.getEndpointReference(clazz, elementArray);
        }
        if (!this.isPublished()) {
            throw new WebServiceException("Endpoint is not published yet");
        }
        WSEndpointImpl wSEndpointImpl = (WSEndpointImpl)this.wse;
        return (T)((EndpointReference)clazz.cast(wSEndpointImpl.getEndpointReference(clazz, this.publicAddress, this.publicAddress + "?WSDL", elementArray)));
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString());
        stringBuffer.append(" - Endpoint ID: ").append(this.wse != null ? this.wse.getEndpointId() : null);
        stringBuffer.append(" - address: ").append(this.address);
        stringBuffer.append(" - public address: ").append(this.publicAddress);
        return stringBuffer.toString();
    }

    private static class ReferencedConcurrentHashMap
    extends ConcurrentHashMap
    implements ReferencedAttribute {
    }

    private class PublishWseeModule
    extends WebAppModule {
        private WebAppParser parser;
        private ServletBean servletBean;

        public PublishWseeModule(String string, String string2, String string3) {
            super(string, string2);
            this.parser = this.createWebDD(string3);
        }

        public String getType() {
            return WebLogicModuleType.MODULETYPE_WSEE;
        }

        protected WebAppParser getWebAppParser(VirtualJarFile virtualJarFile, DeploymentPlanBean deploymentPlanBean) throws ModuleException {
            return this.parser;
        }

        public ServletBean getServletBean() {
            return this.servletBean;
        }

        private WebAppParser createWebDD(String string) {
            String string2 = WLSEndpoint.this.implementor.getClass().getSimpleName() + "Servlethttp";
            DescriptorBean descriptorBean = new DescriptorManager().createDescriptorRoot(WebAppBean.class).getRootBean();
            WebAppBean webAppBean = (WebAppBean)descriptorBean;
            this.servletBean = webAppBean.createServlet();
            this.servletBean.setServletName(string2);
            this.servletBean.setServletClass(JAXWSPublishServlet.class.getName());
            this.servletBean.setLoadOnStartup("1");
            ServletMappingBean servletMappingBean = webAppBean.createServletMapping();
            servletMappingBean.setServletName(string2);
            servletMappingBean.setUrlPatterns(new String[]{string});
            if (!"/".equals(string)) {
                servletMappingBean = webAppBean.createServletMapping();
                servletMappingBean.setServletName(string2);
                servletMappingBean.setUrlPatterns(new String[]{"/"});
            }
            return new WseeWebappParser(webAppBean, null);
        }
    }

    public static interface Listener {
        public void endpointStopping(WLSEndpoint var1);
    }
}

