/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.jaxws.spi;

import com.sun.xml.ws.api.WSService;
import com.sun.xml.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.ws.binding.WebServiceFeatureList;
import com.sun.xml.ws.client.WSServiceDelegate;
import com.sun.xml.ws.model.wsdl.WSDLServiceImpl;
import com.sun.xml.ws.util.JAXWSUtils;
import com.sun.xml.ws.util.ServiceFinder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.ws.Binding;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.Service;
import javax.xml.ws.WebServiceClient;
import javax.xml.ws.WebServiceFeature;
import javax.xml.ws.soap.SOAPBinding;
import org.xml.sax.EntityResolver;
import weblogic.descriptor.DescriptorBean;
import weblogic.j2ee.descriptor.PortComponentRefBean;
import weblogic.j2ee.descriptor.ServiceRefBean;
import weblogic.j2ee.descriptor.SessionBeanBean;
import weblogic.j2ee.descriptor.wl.PortInfoBean;
import weblogic.j2ee.descriptor.wl.PropertyNamevalueBean;
import weblogic.j2ee.descriptor.wl.ServiceReferenceDescriptionBean;
import weblogic.kernel.KernelStatus;
import weblogic.management.ManagementException;
import weblogic.wsee.jaxws.owsm.WsdlDefinitionFeature;
import weblogic.wsee.jaxws.persistence.StandardPersistentPropertyRegister;
import weblogic.wsee.jaxws.tubeline.ServiceInitialization;
import weblogic.wsee.jaxws.tubeline.TubelineDeploymentListener;
import weblogic.wsee.jaxws.tubeline.TubelineDeploymentListenerRepository;
import weblogic.wsee.monitoring.WseeClientConfigurationRuntimeMBeanImpl;
import weblogic.wsee.monitoring.WseePortConfigurationRuntimeMBeanImpl;
import weblogic.wsee.monitoring.WseeRuntimeMBeanManager;
import weblogic.wsee.runtime.owsm.PolicySubjectUtil;
import weblogic.wsee.tools.xcatalog.XCatalogUtil;
import weblogic.wsee.util.StringUtil;
import weblogic.wsee.util.Verbose;
import weblogic.wsee.wstx.wsat.TransactionalFeature;
import weblogic.wsee.wstx.wsat.config.DDHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class WLSServiceDelegate
extends WSServiceDelegate {
    private static final boolean verbose = Verbose.isVerbose(WLSServiceDelegate.class);
    public static ThreadLocal<ServiceRefBean> serviceRefLocal = new ThreadLocal();
    public static ThreadLocal<ServiceReferenceDescriptionBean> serviceReferenceDescriptionLocal = new ThreadLocal();
    public static ThreadLocal<WebServiceFeatureList> featuresLocal = new ThreadLocal();
    public static final String SPECIAL_PORTNAME = ":";
    private ServiceRefBean serviceRef = null;
    private ServiceReferenceDescriptionBean serviceReferenceDescription = null;
    private Map<String, PortComponentRefBean> portMap = new HashMap<String, PortComponentRefBean>();
    private WseeClientConfigurationRuntimeMBeanImpl serviceRefMBean = null;
    private Set<String> portConfigurationSet = new HashSet<String>();
    private final TubelineDeploymentListenerRepository tdlr;
    protected WebServiceFeatureList features;
    private WLSStandardPersistentPropertyRegister sppr = new WLSStandardPersistentPropertyRegister();
    private static final Logger logger = Logger.getLogger(WLSServiceDelegate.class.getName());

    public WLSServiceDelegate(URL uRL, QName qName, Class<? extends Service> clazz) {
        super(uRL, qName, clazz);
        this.init();
        this.tdlr = new WLSTubelineDeploymentListenerRepository((WSService)this, clazz);
        this.addWsdlDefinitionFeature(uRL, null, qName, clazz);
    }

    public WLSServiceDelegate(Source source, WSDLServiceImpl wSDLServiceImpl, QName qName, Class<? extends Service> clazz) {
        super(source, wSDLServiceImpl, qName, clazz);
        this.init();
        this.tdlr = new WLSTubelineDeploymentListenerRepository((WSService)this, clazz);
        this.addWsdlDefinitionFeature(null, source, qName, clazz);
    }

    public WLSServiceDelegate(Object object, QName qName, Class<? extends Service> clazz) {
        super(WLSServiceDelegate.convertWsdlDefinitionToSource(object), qName, clazz);
        this.init();
        this.tdlr = new WLSTubelineDeploymentListenerRepository((WSService)this, clazz);
        this.addWsdlDefinitionFeature(object, qName, clazz);
    }

    private void init() {
        WebServiceFeatureList webServiceFeatureList = featuresLocal.get();
        this.features = webServiceFeatureList != null ? new WebServiceFeatureList(webServiceFeatureList.toArray()) : new WebServiceFeatureList();
        this.serviceRef = serviceRefLocal.get();
        if (this.serviceRef != null) {
            this.portMap = this.processComponentLinks(this.serviceRef.getPortComponentRefs());
        }
        this.serviceReferenceDescription = serviceReferenceDescriptionLocal.get();
        this.setupClientConfigurationRuntimeMBean();
    }

    private static Source convertWsdlDefinitionToSource(Object object) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            WsdlDefinitionFeature.writeWSDL(object, byteArrayOutputStream);
        }
        catch (IOException iOException) {
            return null;
        }
        StreamSource streamSource = new StreamSource(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()), WsdlDefinitionFeature.getDocumentBaseUriFromWSDL(object));
        return streamSource;
    }

    private void addWsdlDefinitionFeature(Object object, QName qName, Class<? extends Service> clazz) {
        WsdlDefinitionFeature wsdlDefinitionFeature = WsdlDefinitionFeature.create(object, clazz, this.createCatalogResolver());
        if (wsdlDefinitionFeature != null) {
            if (this.features == null) {
                this.features = new WebServiceFeatureList();
            }
            this.features.add((WebServiceFeature)wsdlDefinitionFeature);
        }
    }

    private void addWsdlDefinitionFeature(URL uRL, Source source, QName qName, final Class<? extends Service> clazz) {
        Object object;
        URL uRL2;
        Source source2 = source;
        if (source2 == null && uRL != null) {
            source2 = new StreamSource(uRL.toExternalForm());
        }
        if (source2 == null && clazz != Service.class) {
            uRL2 = AccessController.doPrivileged(new PrivilegedAction<WebServiceClient>(){

                @Override
                public WebServiceClient run() {
                    return clazz.getAnnotation(WebServiceClient.class);
                }
            });
            object = uRL2.wsdlLocation();
            object = JAXWSUtils.absolutize((String)JAXWSUtils.getFileOrURLName((String)object));
            source2 = new StreamSource((String)object);
        }
        if (source2 != null) {
            try {
                uRL2 = source2.getSystemId() == null ? null : JAXWSUtils.getEncodedURL((String)source2.getSystemId());
                object = WsdlDefinitionFeature.create(uRL2, source2, clazz, this.createCatalogResolver());
                if (object != null) {
                    if (this.features == null) {
                        this.features = new WebServiceFeatureList();
                    }
                    this.features.add((WebServiceFeature)object);
                }
            }
            catch (Exception exception) {
                logger.severe("Failed to create WsdlDefinitionFeature for wsdl location: " + source2.getSystemId() + ", error: " + exception.getClass().getName() + ", message: " + exception.getMessage());
            }
        }
    }

    protected EntityResolver createCatalogResolver() {
        return WLSServiceDelegate.staticCreateCatalogResolver();
    }

    protected static EntityResolver staticCreateCatalogResolver() {
        return XCatalogUtil.createRuntimeCatalogResolver(2);
    }

    public ServiceReferenceDescriptionBean getServiceReferenceDescription() {
        return this.serviceReferenceDescription;
    }

    private Map<String, PortComponentRefBean> processComponentLinks(PortComponentRefBean[] portComponentRefBeanArray) {
        HashMap<String, PortComponentRefBean> hashMap = new HashMap<String, PortComponentRefBean>();
        if (portComponentRefBeanArray != null) {
            for (PortComponentRefBean portComponentRefBean : portComponentRefBeanArray) {
                String string = portComponentRefBean.getServiceEndpointInterface();
                if (StringUtil.isEmpty(string)) continue;
                hashMap.put(string, portComponentRefBean);
            }
        }
        return hashMap;
    }

    protected <S> void updatePort(QName qName, Object object, Class<S> clazz) {
        Map map;
        Binding binding;
        BindingProvider bindingProvider;
        if (!(object instanceof BindingProvider)) {
            return;
        }
        if (this.serviceRef != null && (bindingProvider = this.portMap.get(clazz.getName())) != null && bindingProvider.isEnableMtom() && object instanceof BindingProvider && (binding = (map = (BindingProvider)object).getBinding()) instanceof SOAPBinding) {
            ((SOAPBinding)binding).setMTOMEnabled(true);
        }
        if (this.serviceReferenceDescription != null) {
            bindingProvider = (BindingProvider)object;
            map = bindingProvider.getRequestContext();
            for (Binding binding2 : this.serviceReferenceDescription.getPortInfos()) {
                for (PropertyNamevalueBean propertyNamevalueBean : binding2.getStubProperties()) {
                    if (qName != null && !qName.getLocalPart().equals(binding2.getPortName())) continue;
                    map.put(propertyNamevalueBean.getName(), propertyNamevalueBean.getValue());
                }
            }
        }
    }

    protected String getServiceReferenceName() {
        if (this.serviceRefMBean != null) {
            String string = this.serviceRefMBean.getServiceReferenceName();
            DescriptorBean descriptorBean = ((DescriptorBean)this.serviceRef).getParentBean();
            if (descriptorBean instanceof SessionBeanBean) {
                string = ((SessionBeanBean)descriptorBean).getEjbName() + "/" + string;
            }
            return string;
        }
        return this.serviceRef != null ? this.serviceRef.getServiceRefName() : null;
    }

    protected String getServiceRefUniqueKey() {
        String string = this.getServiceReferenceName();
        if (string != null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(string);
            if (this.serviceRef != null) {
                String string2;
                String string3 = this.serviceRef.getMappedName();
                if (string3 != null && string3.length() > 0) {
                    stringBuffer.append(':');
                    stringBuffer.append(string3);
                }
                if ((string2 = this.serviceRef.getWsdlFile()) != null && string2.length() > 0) {
                    stringBuffer.append(':');
                    stringBuffer.append(string2);
                }
            }
            return stringBuffer.toString();
        }
        return null;
    }

    protected void addFeatures(QName qName, WebServiceFeatureList webServiceFeatureList) {
        if (this.serviceReferenceDescription != null) {
            for (PortInfoBean portInfoBean : this.serviceReferenceDescription.getPortInfos()) {
                if (qName == null || !qName.getLocalPart().equals(portInfoBean.getPortName()) || !this.addTransactionalFeature(webServiceFeatureList, portInfoBean)) continue;
                return;
            }
            PortInfoBean portInfoBean = this.serviceReferenceDescription.lookupPortInfo(SPECIAL_PORTNAME);
            this.addTransactionalFeature(webServiceFeatureList, portInfoBean);
        }
    }

    private boolean addTransactionalFeature(WebServiceFeatureList webServiceFeatureList, PortInfoBean portInfoBean) {
        TransactionalFeature transactionalFeature = DDHelper.buildFeatureFromServiceRefDD(portInfoBean);
        if (transactionalFeature != null) {
            webServiceFeatureList.add((WebServiceFeature)transactionalFeature);
            return true;
        }
        return false;
    }

    private void setupClientConfigurationRuntimeMBean() {
        block4: {
            if (this.serviceRef != null && KernelStatus.isServer()) {
                try {
                    this.serviceRefMBean = WseeRuntimeMBeanManager.createClientConfigurationMBean(this.serviceRef.getServiceRefName());
                    this.serviceRefMBean.register();
                    String string = this.getServiceReferenceName();
                    Iterator iterator = super.getPorts();
                    while (iterator.hasNext()) {
                        QName qName = (QName)iterator.next();
                        String string2 = PolicySubjectUtil.formatReferencedPortResourcePattern(qName.getLocalPart(), string);
                        if (this.portConfigurationSet.contains(string2)) continue;
                        WseePortConfigurationRuntimeMBeanImpl wseePortConfigurationRuntimeMBeanImpl = WseeRuntimeMBeanManager.createPortConfigurationMBean((WSDLPort)this.getWsdlService().get(qName), string2, this.serviceRefMBean);
                        this.portConfigurationSet.add(string2);
                    }
                }
                catch (ManagementException managementException) {
                    if (!verbose) break block4;
                    Verbose.logException(managementException);
                }
            }
        }
    }

    public <T> T getSPI(Class<T> clazz) {
        if (clazz == TubelineDeploymentListenerRepository.class) {
            return clazz.cast(this.tdlr);
        }
        if (clazz == StandardPersistentPropertyRegister.class) {
            return clazz.cast(this.sppr);
        }
        if (clazz == WseeClientConfigurationRuntimeMBeanImpl.class) {
            return clazz.cast(this.serviceRefMBean);
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class WLSStandardPersistentPropertyRegister
    implements StandardPersistentPropertyRegister {
        private Set<String> props = new HashSet<String>();
        private Set<String> classNames = new HashSet<String>();

        private WLSStandardPersistentPropertyRegister() {
        }

        @Override
        public Set<String> getStandardProperties() {
            return this.props;
        }

        @Override
        public Set<String> getStandardPropertyBagClassNames() {
            return this.classNames;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class WLSTubelineDeploymentListenerRepository
    implements TubelineDeploymentListenerRepository {
        private final Collection<TubelineDeploymentListener> listeners = new ArrayList<TubelineDeploymentListener>();

        public WLSTubelineDeploymentListenerRepository(WSService wSService, Class<? extends Service> clazz) {
            for (TubelineDeploymentListener tubelineDeploymentListener : ServiceFinder.find(TubelineDeploymentListener.class, (ClassLoader)wSService.getClass().getClassLoader())) {
                if (tubelineDeploymentListener instanceof ServiceInitialization) {
                    ((ServiceInitialization)((Object)tubelineDeploymentListener)).init(wSService, clazz);
                }
                this.listeners.add(tubelineDeploymentListener);
            }
        }

        @Override
        public Collection<TubelineDeploymentListener> getListeners() {
            return this.listeners;
        }
    }
}

