/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.jaxws.sslclient;

import java.io.FileInputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import javax.xml.ws.WebServiceException;
import weblogic.wsee.jaxws.sslclient.PersistentSSLInfo;
import weblogic.wsee.util.Verbose;

public final class SSLClientUtil {
    private static boolean verbose = Verbose.isVerbose(SSLClientUtil.class);
    private static final String KEYSTORE_PASSWORD_PROPERTY = "javax.net.ssl.keyStorePassword";
    private static final String KEYSTORE_PROPERTY = "javax.net.ssl.keyStore";
    private static final String TRUST_KEYSTORE_PROPERTY = "javax.net.ssl.trustStore";
    public static final String RELAXED_CHECKING_DEFAULT = "weblogic.wsee.client.ssl.relaxedtrustmanager";
    private static final TrustManager[] RELAXED_MANAGERS = new TrustManager[]{new RelaxedX509TrustManager()};

    private SSLClientUtil() {
    }

    public static SSLSocketFactory getSSLSocketFactoryFromSysProperties() {
        TrustManager[] trustManagerArray = null;
        KeyManager[] keyManagerArray = null;
        try {
            String string = System.getProperty(KEYSTORE_PROPERTY);
            String string2 = System.getProperty(KEYSTORE_PASSWORD_PROPERTY);
            keyManagerArray = SSLClientUtil.getKeyManagers(string, string2, null, null, null);
            if ("true".equalsIgnoreCase(System.getProperty(RELAXED_CHECKING_DEFAULT))) {
                trustManagerArray = RELAXED_MANAGERS;
            } else {
                String string3 = System.getProperty(TRUST_KEYSTORE_PROPERTY, null);
                trustManagerArray = SSLClientUtil.getTrustManagers(string3, null, null, null, null);
            }
            return SSLClientUtil.getSSLSocketFactory(keyManagerArray, trustManagerArray);
        }
        catch (Exception exception) {
            if (verbose) {
                exception.printStackTrace();
            }
            throw new WebServiceException((Throwable)exception);
        }
    }

    public static PersistentSSLInfo getPersistentSSLInfoFromSysProperties() {
        PersistentSSLInfo persistentSSLInfo = new PersistentSSLInfo();
        try {
            String string = System.getProperty(KEYSTORE_PROPERTY);
            String string2 = System.getProperty(KEYSTORE_PASSWORD_PROPERTY);
            if (!"true".equalsIgnoreCase(System.getProperty(RELAXED_CHECKING_DEFAULT))) {
                String string3 = System.getProperty(TRUST_KEYSTORE_PROPERTY, null);
                persistentSSLInfo.setTrustKeystore(string3);
            }
            persistentSSLInfo.setKeystore(string);
            persistentSSLInfo.setKeystorePassword(string2);
            return persistentSSLInfo;
        }
        catch (Exception exception) {
            if (verbose) {
                exception.printStackTrace();
            }
            throw new WebServiceException((Throwable)exception);
        }
    }

    public static SSLSocketFactory getSSLSocketFactory(KeyManager[] keyManagerArray, TrustManager[] trustManagerArray) {
        try {
            SSLContext sSLContext = SSLContext.getInstance("SSL");
            if ("true".equalsIgnoreCase(System.getProperty(RELAXED_CHECKING_DEFAULT))) {
                trustManagerArray = RELAXED_MANAGERS;
            }
            sSLContext.init(keyManagerArray, trustManagerArray, new SecureRandom());
            SSLSocketFactory sSLSocketFactory = sSLContext.getSocketFactory();
            return sSLSocketFactory;
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new WebServiceException("Get SSLSocketFactory failed:" + generalSecurityException.getMessage());
        }
    }

    public static SSLSocketFactory getSSLSocketFactory(PersistentSSLInfo persistentSSLInfo) {
        if (verbose) {
            Verbose.log("sslInfo=" + persistentSSLInfo.toString());
        }
        KeyManager[] keyManagerArray = SSLClientUtil.getKeyManagers(persistentSSLInfo.getKeystore(), persistentSSLInfo.getKeystorePassword(), persistentSSLInfo.getKeystoreType(), persistentSSLInfo.getKeyAlias(), persistentSSLInfo.getKeyPassword());
        TrustManager[] trustManagerArray = SSLClientUtil.getTrustManagers(persistentSSLInfo.getTrustKeystore(), persistentSSLInfo.getTrustKeystorePassword(), persistentSSLInfo.getTrustKeystoreType(), persistentSSLInfo.getTrustKeystoreAlgorithm(), persistentSSLInfo.getTrustKeystoreProvider());
        return SSLClientUtil.getSSLSocketFactory(keyManagerArray, trustManagerArray);
    }

    private static KeyManager[] getKeyManagers(String string, String string2, String string3, String string4, String string5) {
        try {
            String string6 = KeyManagerFactory.getDefaultAlgorithm();
            if (string5 == null) {
                string5 = string2;
            }
            KeyStore keyStore = SSLClientUtil.getKeystore(string, string2, string3);
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(string6);
            if (string4 == null) {
                keyManagerFactory.init(keyStore, string5 == null ? null : string5.toCharArray());
            } else {
                Certificate[] certificateArray = keyStore.getCertificateChain(string4);
                if (certificateArray == null) {
                    throw new SecurityException("No such key with alias '" + string4 + "' in key-store '" + string + "'");
                }
                Key key = keyStore.getKey(string4, string5 == null ? null : string5.toCharArray());
                KeyStore keyStore2 = KeyStore.getInstance(string3);
                keyStore2.load(null, string2 == null ? null : string2.toCharArray());
                keyStore2.setKeyEntry(string4, key, string5 == null ? null : string5.toCharArray(), certificateArray);
                keyManagerFactory.init(keyStore2, string5 == null ? null : string5.toCharArray());
            }
            return keyManagerFactory.getKeyManagers();
        }
        catch (Exception exception) {
            if (verbose) {
                exception.printStackTrace();
            }
            throw new WebServiceException("Get KeyManager[] failed:" + exception.getMessage());
        }
    }

    private static TrustManager[] getTrustManagers(String string, String string2, String string3, String string4, String string5) {
        if (string == null) {
            return null;
        }
        if (verbose) {
            Verbose.log("trustKeystore=" + string);
        }
        try {
            if (string4 == null) {
                string4 = TrustManagerFactory.getDefaultAlgorithm();
            }
            if (string3 == null) {
                string3 = "JKS";
            }
            TrustManagerFactory trustManagerFactory = null;
            trustManagerFactory = string5 == null ? TrustManagerFactory.getInstance(string4) : TrustManagerFactory.getInstance(string4, string5);
            KeyStore keyStore = SSLClientUtil.getKeystore(string, string2, string3);
            trustManagerFactory.init(keyStore);
            TrustManager[] trustManagerArray = trustManagerFactory.getTrustManagers();
            if (verbose) {
                Verbose.say("Loaded trust managers");
            }
            return trustManagerArray;
        }
        catch (Exception exception) {
            if (verbose) {
                exception.printStackTrace();
            }
            throw new WebServiceException("Get TrustManager[] failed:" + exception.getMessage());
        }
    }

    /*
     * Loose catch block
     */
    private static KeyStore getKeystore(String string, String string2, String string3) {
        KeyStore keyStore;
        block11: {
            if (string == null) {
                return null;
            }
            if (verbose) {
                Verbose.log("loading keystore from: " + string);
            }
            FileInputStream fileInputStream = null;
            keyStore = null;
            fileInputStream = new FileInputStream(string);
            keyStore = KeyStore.getInstance(string3 == null ? "JKS" : string3);
            keyStore.load(fileInputStream, string2 != null ? string2.toCharArray() : null);
            Object var7_5 = null;
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
                break block11;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            break block11;
            {
                catch (Exception exception) {
                    throw new IllegalStateException("Unable to load keystore", exception);
                }
            }
            catch (Throwable throwable) {
                Object var7_6 = null;
                try {
                    if (fileInputStream != null) {
                        fileInputStream.close();
                    }
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                throw throwable;
            }
        }
        return keyStore;
    }

    private static class RelaxedX509TrustManager
    implements X509TrustManager {
        private RelaxedX509TrustManager() {
        }

        public boolean isClientTrusted(X509Certificate[] x509CertificateArray) {
            return true;
        }

        public boolean isServerTrusted(X509Certificate[] x509CertificateArray) {
            return true;
        }

        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }

        public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        }

        public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        }
    }
}

