/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.jaxws.tools.processor.generator;

import com.sun.codemodel.ClassType;
import com.sun.codemodel.JAnnotatable;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JClassAlreadyExistsException;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JDocComment;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import com.sun.tools.ws.processor.generator.Generator;
import com.sun.tools.ws.processor.generator.GeneratorUtil;
import com.sun.tools.ws.processor.generator.Names;
import com.sun.tools.ws.processor.model.AsyncOperation;
import com.sun.tools.ws.processor.model.AsyncOperationType;
import com.sun.tools.ws.processor.model.Model;
import com.sun.tools.ws.processor.model.ModelVisitor;
import com.sun.tools.ws.processor.model.Port;
import com.sun.tools.ws.processor.model.Service;
import com.sun.tools.ws.processor.model.java.JavaInterface;
import com.sun.tools.ws.processor.model.java.JavaMethod;
import com.sun.tools.ws.processor.model.java.JavaParameter;
import com.sun.tools.ws.processor.model.jaxb.JAXBTypeAndAnnotation;
import com.sun.tools.ws.wscompile.Options;
import com.sun.tools.ws.wsdl.document.PortType;
import java.util.List;
import java.util.Locale;
import javax.xml.namespace.QName;
import javax.xml.ws.Response;
import org.xml.sax.Locator;

public class AsyncHandlerGenerator
extends Generator {
    private void write(Port port) {
        JavaInterface javaInterface = port.getJavaInterface();
        String string = Names.customJavaTypeClassName((JavaInterface)javaInterface) + "AsyncHandler";
        if (this.donotOverride && GeneratorUtil.classExists((Options)this.options, (String)string)) {
            this.log("Class " + string + " exists. Not overriding.");
            return;
        }
        JDefinedClass jDefinedClass = null;
        try {
            jDefinedClass = this.getClass(string, ClassType.INTERFACE);
        }
        catch (JClassAlreadyExistsException jClassAlreadyExistsException) {
            PortType portType;
            QName qName = (QName)port.getProperty("com.sun.xml.ws.processor.model.WSDLPortTypeName");
            Locator locator = null;
            if (qName != null && (portType = (PortType)port.portTypes.get(qName)) != null) {
                locator = portType.getLocator();
            }
            this.receiver.error(locator, "");
            return;
        }
        if (!jDefinedClass.methods().isEmpty()) {
            return;
        }
        JDocComment jDocComment = jDefinedClass.javadoc();
        String string2 = javaInterface.getJavaDoc();
        if (string2 != null) {
            jDocComment.add((Object)string2);
            jDocComment.add((Object)"\n\n");
        }
        for (String string3 : this.getJAXWSClassComment()) {
            jDocComment.add((Object)string3);
        }
        for (String string3 : port.getOperations()) {
            List list;
            AsyncOperation asyncOperation;
            if (!(string3 instanceof AsyncOperation) || !AsyncOperationType.CALLBACK.equals((asyncOperation = (AsyncOperation)string3).getAsyncType())) continue;
            JavaMethod javaMethod = asyncOperation.getJavaMethod();
            String string4 = string3.getJavaDoc();
            String string5 = "on" + javaMethod.getName().substring(0, 1).toUpperCase(Locale.ENGLISH) + javaMethod.getName().substring(1, javaMethod.getName().length() - 5) + "Response";
            JMethod jMethod = jDefinedClass.method(1, Void.TYPE, string5);
            JDocComment jDocComment2 = jMethod.javadoc();
            if (string4 != null) {
                jDocComment2.add((Object)string4);
            }
            if ((list = javaMethod.getParametersList()).isEmpty()) continue;
            JAXBTypeAndAnnotation jAXBTypeAndAnnotation = ((JavaParameter)list.get(list.size() - 1)).getType().getType();
            JClass jClass = this.cm.ref(Response.class);
            JVar jVar = jMethod.param((JType)jClass.narrow((JClass)((JClass)jAXBTypeAndAnnotation.getType().unboxify()).getTypeParameters().get(0)), "response");
            jAXBTypeAndAnnotation.annotate((JAnnotatable)jVar);
            jDocComment2.addParam(jVar);
        }
    }

    public void visit(Model model) throws Exception {
        for (Service service2 : model.getServices()) {
            service2.accept((ModelVisitor)this);
        }
    }

    public void visit(Service service2) throws Exception {
        for (Port port : service2.getPorts()) {
            this.visitPort(service2, port);
        }
    }

    private void visitPort(Service service2, Port port) {
        if (port.isProvider()) {
            return;
        }
        this.write(port);
    }
}

