/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.jaxws.transport.http.client;

import com.sun.xml.ws.api.EndpointAddress;
import com.sun.xml.ws.api.message.Packet;
import java.io.IOException;
import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.soap.MTOMFeature;
import weblogic.kernel.KernelStatus;
import weblogic.security.SSL.HostnameVerifier;
import weblogic.security.utils.KeyStoreConfigurationHelper;
import weblogic.security.utils.KeyStoreInfo;
import weblogic.security.utils.MBeanKeyStoreConfiguration;
import weblogic.wsee.jaxws.proxy.ClientProxyFeature;
import weblogic.wsee.jaxws.proxy.ProxyUtil;
import weblogic.wsee.jaxws.sslclient.PersistentSSLInfo;
import weblogic.wsee.jaxws.sslclient.SSLClientUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpClientTransport
extends com.sun.xml.ws.transport.http.client.HttpClientTransport {
    public static final String JAXWS_TRANSPORT_STREAMING = "jaxws.transport.streaming";
    Packet context = null;
    private static final Logger LOGGER = Logger.getLogger(HttpClientTransport.class.getName());
    private static final HostnameVerifierAdapter byPassAllHostnameVerifierAdapter = new HostnameVerifierAdapter(new HttpClientVerifier());
    private static final boolean excludeProxyAuthHeader = Boolean.getBoolean("weblogic.wsee.jaxws.client.excludeProxyAuthHeader");

    public HttpClientTransport(Packet packet, Map<String, List<String>> map) {
        super(packet, map);
    }

    public static void forcePersistentSSLInfoOntoOutgoingMessageIfNotPresent(Map<String, Object> map) {
        KeyStoreConfigurationHelper keyStoreConfigurationHelper;
        KeyStoreInfo keyStoreInfo;
        if (!KernelStatus.isServer() || map.containsKey("weblogic.wsee.jaxws.sslclient.PersistentSSLInfo")) {
            return;
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("HttpClientTransport forcing PersistentSSLInfo onto outgoing Packet to handle an HTTPS connection for delivering a message");
        }
        if ((keyStoreInfo = (keyStoreConfigurationHelper = new KeyStoreConfigurationHelper(MBeanKeyStoreConfiguration.getInstance())).getIdentityKeyStore()) == null) {
            throw new WebServiceException("Couldn't get KeyStoreConfigurationHelper");
        }
        String string = keyStoreInfo.getFileName();
        if (string == null || string.length() == 0) {
            throw new WebServiceException("KeyStoreFilename not supplied");
        }
        String string2 = keyStoreInfo.getType();
        char[] cArray = keyStoreInfo.getPassPhrase();
        String string3 = keyStoreConfigurationHelper.getIdentityAlias();
        char[] cArray2 = keyStoreConfigurationHelper.getIdentityPrivateKeyPassPhrase();
        if (string3 == null || string3.length() == 0) {
            throw new WebServiceException("Server Certificate Alias not supplied");
        }
        if (cArray2 == null) {
            throw new WebServiceException("Server Certificate PassPhrase not supplied");
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("KeyStore File:  " + string);
            LOGGER.fine("KeyStore Type:  " + string2);
            LOGGER.fine("KeyStore Alias: " + string3);
        }
        PersistentSSLInfo persistentSSLInfo = new PersistentSSLInfo();
        persistentSSLInfo.setKeyAlias(string3);
        persistentSSLInfo.setKeyPassword(new String(cArray2));
        persistentSSLInfo.setKeystore(string);
        persistentSSLInfo.setKeystorePassword(new String(cArray));
        persistentSSLInfo.setKeystoreType(string2);
        map.put("weblogic.wsee.jaxws.sslclient.PersistentSSLInfo", persistentSSLInfo);
    }

    protected HttpURLConnection openConnection(Packet packet) {
        javax.net.ssl.HostnameVerifier hostnameVerifier;
        weblogic.net.http.HttpsURLConnection httpsURLConnection;
        Serializable serializable;
        this.context = packet;
        Object v = packet.invocationProperties.get("weblogic.wsee.jaxws.sslclient.PersistentSSLInfo");
        SSLSocketFactory sSLSocketFactory = null;
        if (v instanceof PersistentSSLInfo) {
            serializable = (PersistentSSLInfo)v;
            sSLSocketFactory = SSLClientUtil.getSSLSocketFactory((PersistentSSLInfo)serializable);
            packet.invocationProperties.put("com.sun.xml.ws.transport.https.client.SSLSocketFactory", sSLSocketFactory);
        }
        v = packet.invocationProperties.get("weblogic.wsee.jaxws.proxy.PersistentProxyInfo");
        serializable = null;
        if (v instanceof ClientProxyFeature) {
            serializable = (ClientProxyFeature)v;
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("host=" + ((ClientProxyFeature)serializable).getProxyHost());
                LOGGER.fine("port=" + ((ClientProxyFeature)serializable).getProxyPort());
            }
        }
        HttpURLConnection httpURLConnection = null;
        try {
            httpURLConnection = this.openConnection(packet.endpointAddress, (ClientProxyFeature)serializable);
        }
        catch (Exception exception) {
            return null;
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("ignore=" + Boolean.getBoolean("weblogic.security.SSL.ignoreHostnameVerification"));
            LOGGER.fine("vp=" + packet.invocationProperties.get("com.sun.xml.ws.client.http.HostnameVerificationProperty"));
        }
        if (httpURLConnection instanceof HttpsURLConnection || httpURLConnection instanceof weblogic.net.http.HttpsURLConnection) {
            if (Boolean.getBoolean("weblogic.security.SSL.ignoreHostnameVerification")) {
                packet.invocationProperties.put("com.sun.xml.ws.client.http.HostnameVerificationProperty", "true");
            }
            if (httpURLConnection instanceof weblogic.net.http.HttpsURLConnection) {
                httpsURLConnection = (weblogic.net.http.HttpsURLConnection)httpURLConnection;
                hostnameVerifier = (javax.net.ssl.HostnameVerifier)this.context.invocationProperties.get("com.sun.xml.ws.transport.https.client.hostname.verifier");
                if (hostnameVerifier != null) {
                    httpsURLConnection.setHostnameVerifier(new HostnameVerifierAdapter(hostnameVerifier));
                } else {
                    boolean bl = false;
                    String string = (String)this.context.invocationProperties.get("com.sun.xml.ws.client.http.HostnameVerificationProperty");
                    if (string != null && string.equalsIgnoreCase("true")) {
                        bl = true;
                    }
                    if (bl) {
                        httpsURLConnection.setHostnameVerifier(byPassAllHostnameVerifierAdapter);
                    }
                }
                sSLSocketFactory = (SSLSocketFactory)this.context.invocationProperties.get("com.sun.xml.ws.transport.https.client.SSLSocketFactory");
                if (sSLSocketFactory != null && sSLSocketFactory instanceof SSLSocketFactory) {
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine("set (jdk) ssl socketfactory to wls socketfactory");
                    }
                    httpsURLConnection.setSSLSocketFactory(new MySSLSocketFactory(sSLSocketFactory));
                }
            }
        }
        if (Boolean.parseBoolean(System.getProperty(JAXWS_TRANSPORT_STREAMING)) && (httpsURLConnection = packet.getBinding()) != null && (hostnameVerifier = (MTOMFeature)httpsURLConnection.getFeature(MTOMFeature.class)) != null && hostnameVerifier.isEnabled()) {
            httpURLConnection.setChunkedStreamingMode(8192);
        }
        return httpURLConnection;
    }

    private HttpURLConnection openConnection(EndpointAddress endpointAddress, ClientProxyFeature clientProxyFeature) throws MalformedURLException, IOException, URISyntaxException {
        HttpURLConnection httpURLConnection;
        Proxy proxy = ProxyUtil.getProxy(clientProxyFeature, endpointAddress.getURI());
        if (proxy != null && proxy != Proxy.NO_PROXY) {
            httpURLConnection = ProxyUtil.openConnection(endpointAddress.getURL(), proxy);
            if (!excludeProxyAuthHeader) {
                ProxyUtil.setProxyAuthHeader(httpURLConnection, clientProxyFeature);
            }
            ProxyUtil.setIgnoreSystemNonPorxyHosts(httpURLConnection, clientProxyFeature);
        } else {
            httpURLConnection = (HttpURLConnection)endpointAddress.getURL().openConnection();
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("got http connection:" + httpURLConnection + "");
        }
        return httpURLConnection;
    }

    static class MySSLSocketFactory
    extends weblogic.security.SSL.SSLSocketFactory {
        public MySSLSocketFactory(SSLSocketFactory sSLSocketFactory) {
            super(sSLSocketFactory);
        }
    }

    static class HostnameVerifierAdapter
    implements HostnameVerifier {
        javax.net.ssl.HostnameVerifier jsseHostNameVerifer;

        public HostnameVerifierAdapter(javax.net.ssl.HostnameVerifier hostnameVerifier) {
            this.jsseHostNameVerifer = hostnameVerifier;
        }

        public boolean verify(String string, SSLSession sSLSession) {
            if (this.jsseHostNameVerifer == null) {
                return false;
            }
            return this.jsseHostNameVerifer.verify(string, sSLSession);
        }
    }

    private static class HttpClientVerifier
    implements javax.net.ssl.HostnameVerifier {
        private HttpClientVerifier() {
        }

        public boolean verify(String string, SSLSession sSLSession) {
            return true;
        }
    }
}

