/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.jaxws.tubeline;

import com.sun.xml.ws.api.WSService;
import com.sun.xml.ws.api.pipe.ClientTubeAssemblerContext;
import com.sun.xml.ws.api.pipe.ServerTubeAssemblerContext;
import com.sun.xml.ws.util.ServiceFinder;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.ws.Service;
import javax.xml.ws.WebServiceException;
import weblogic.wsee.jaxws.tubeline.ServiceInitialization;
import weblogic.wsee.jaxws.tubeline.TubeFactory;
import weblogic.wsee.jaxws.tubeline.TubeFactoryCreator;
import weblogic.wsee.jaxws.tubeline.TubelineAssemblerItem;
import weblogic.wsee.jaxws.tubeline.TubelineDeploymentListener;
import weblogic.wsee.jaxws.tubeline.TubelineDeploymentListenerCreator;
import weblogic.wsee.jaxws.tubeline.config.AssemblerItem;
import weblogic.wsee.jaxws.tubeline.config.Config;
import weblogic.wsee.jaxws.tubeline.config.DeploymentListeners;
import weblogic.wsee.jaxws.tubeline.config.Listener;
import weblogic.wsee.jaxws.tubeline.config.Listeners;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigReaderTubelineDeploymentListener
implements TubelineDeploymentListener,
ServiceInitialization {
    private Collection<Config> clientConfig = null;

    @Override
    public void init(WSService wSService, Class<? extends Service> clazz) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        this.clientConfig = this.readConfigFile(classLoader);
    }

    @Override
    public void createClient(ClientTubeAssemblerContext clientTubeAssemblerContext, Set<TubelineAssemblerItem> set) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        Collection<Config> collection = this.clientConfig != null ? this.clientConfig : this.readConfigFile(classLoader);
        for (Config config : collection) {
            Listeners listeners;
            DeploymentListeners deploymentListeners = config.getDeploymentListeners();
            if (deploymentListeners == null || (listeners = deploymentListeners.getClient()) == null) continue;
            List<Listener> list = listeners.getListener();
            if (list != null) {
                for (Listener listener : list) {
                    this.load(listener, classLoader).createClient(clientTubeAssemblerContext, set);
                }
            }
            this.createItems(set, listeners.getAssemblerItem(), classLoader);
        }
    }

    @Override
    public void createServer(ServerTubeAssemblerContext serverTubeAssemblerContext, Set<TubelineAssemblerItem> set) {
        ClassLoader classLoader = serverTubeAssemblerContext.getEndpoint().getImplementationClass().getClassLoader();
        Collection<Config> collection = this.readConfigFile(classLoader);
        for (Config config : collection) {
            Listeners listeners;
            DeploymentListeners deploymentListeners = config.getDeploymentListeners();
            if (deploymentListeners == null || (listeners = deploymentListeners.getServer()) == null) continue;
            List<Listener> list = listeners.getListener();
            if (list != null) {
                for (Listener listener : list) {
                    this.load(listener, classLoader).createServer(serverTubeAssemblerContext, set);
                }
            }
            this.createItems(set, listeners.getAssemblerItem(), classLoader);
        }
    }

    private TubelineDeploymentListener load(Listener listener, ClassLoader classLoader) {
        try {
            Class<?> clazz = Class.forName(listener.getClazz(), true, classLoader);
            for (TubelineDeploymentListenerCreator tubelineDeploymentListenerCreator : ServiceFinder.find(TubelineDeploymentListenerCreator.class, (ClassLoader)classLoader)) {
                TubelineDeploymentListener tubelineDeploymentListener = tubelineDeploymentListenerCreator.create(clazz);
                if (tubelineDeploymentListener == null) continue;
                return tubelineDeploymentListener;
            }
            return (TubelineDeploymentListener)clazz.newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new WebServiceException((Throwable)classNotFoundException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new WebServiceException((Throwable)illegalAccessException);
        }
        catch (InstantiationException instantiationException) {
            throw new WebServiceException((Throwable)instantiationException);
        }
    }

    private void createItems(Set<TubelineAssemblerItem> set, List<AssemblerItem> list, ClassLoader classLoader) {
        if (list != null) {
            for (AssemblerItem assemblerItem : list) {
                HashSet<String> hashSet = assemblerItem.getAfter() != null ? new HashSet<String>(assemblerItem.getAfter().getItem()) : null;
                HashSet<String> hashSet2 = assemblerItem.getBefore() != null ? new HashSet<String>(assemblerItem.getBefore().getItem()) : null;
                HashSet<String> hashSet3 = assemblerItem.getRequired() != null ? new HashSet<String>(assemblerItem.getRequired().getItem()) : null;
                String string = assemblerItem.getClazz();
                String string2 = assemblerItem.getName() != null ? assemblerItem.getName() : string;
                set.add(new TubelineAssemblerItem(string2, this.loadTubeFactory(string, classLoader), hashSet2, hashSet, hashSet3));
            }
        }
    }

    private TubeFactory loadTubeFactory(String string, ClassLoader classLoader) {
        try {
            Class<?> clazz = Class.forName(string, true, classLoader);
            for (TubeFactoryCreator tubeFactoryCreator : ServiceFinder.find(TubeFactoryCreator.class, (ClassLoader)classLoader)) {
                TubeFactory tubeFactory = tubeFactoryCreator.create(clazz);
                if (tubeFactory == null) continue;
                return tubeFactory;
            }
            return (TubeFactory)clazz.newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new WebServiceException((Throwable)classNotFoundException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new WebServiceException((Throwable)illegalAccessException);
        }
        catch (InstantiationException instantiationException) {
            throw new WebServiceException((Throwable)instantiationException);
        }
    }

    private Collection<Config> readConfigFile(ClassLoader classLoader) {
        try {
            ArrayList<Config> arrayList = new ArrayList<Config>();
            HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
            hashMap.put("supressAccessorWarnings", Boolean.TRUE);
            JAXBContext jAXBContext = JAXBContext.newInstance((String)"weblogic.wsee.jaxws.tubeline.config", (ClassLoader)classLoader, hashMap);
            Unmarshaller unmarshaller = jAXBContext.createUnmarshaller();
            Enumeration<URL> enumeration = classLoader.getResources("META-INF/tube-config.xml");
            if (enumeration != null) {
                while (enumeration.hasMoreElements()) {
                    arrayList.add((Config)unmarshaller.unmarshal(enumeration.nextElement()));
                }
            }
            return arrayList;
        }
        catch (IOException iOException) {
            throw new WebServiceException((Throwable)iOException);
        }
        catch (JAXBException jAXBException) {
            throw new WebServiceException((Throwable)jAXBException);
        }
    }
}

