/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.jaxws.tubeline;

import com.sun.xml.ws.api.pipe.ClientTubeAssemblerContext;
import com.sun.xml.ws.api.pipe.ServerTubeAssemblerContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import weblogic.wsee.jaxws.tubeline.TubelineAssemblerItem;
import weblogic.wsee.jaxws.tubeline.TubelineDeploymentListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DelegateTubelineDeploymentListener
implements TubelineDeploymentListener {
    private static ThreadLocal<List<TubelineDeploymentListener>> clientDelegates = new ThreadLocal();
    private static ThreadLocal<List<TubelineDeploymentListener>> serverDelegates = new ThreadLocal();

    public static void registerClientDeployementListener(TubelineDeploymentListener tubelineDeploymentListener) {
        List<TubelineDeploymentListener> list = clientDelegates.get();
        if (list == null) {
            list = new ArrayList<TubelineDeploymentListener>();
            clientDelegates.set(list);
        }
        list.add(tubelineDeploymentListener);
    }

    public static void registerServerDeploymentListener(TubelineDeploymentListener tubelineDeploymentListener) {
        List<TubelineDeploymentListener> list = serverDelegates.get();
        if (list == null) {
            list = new ArrayList<TubelineDeploymentListener>();
            serverDelegates.set(list);
        }
        list.add(tubelineDeploymentListener);
    }

    @Override
    public void createClient(ClientTubeAssemblerContext clientTubeAssemblerContext, Set<TubelineAssemblerItem> set) {
        List<TubelineDeploymentListener> list = clientDelegates.get();
        if (list == null || list.isEmpty()) {
            return;
        }
        for (TubelineDeploymentListener tubelineDeploymentListener : list) {
            tubelineDeploymentListener.createClient(clientTubeAssemblerContext, set);
        }
    }

    @Override
    public void createServer(ServerTubeAssemblerContext serverTubeAssemblerContext, Set<TubelineAssemblerItem> set) {
        List<TubelineDeploymentListener> list = serverDelegates.get();
        if (list == null || list.isEmpty()) {
            return;
        }
        for (TubelineDeploymentListener tubelineDeploymentListener : list) {
            tubelineDeploymentListener.createServer(serverTubeAssemblerContext, set);
        }
    }
}

