/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.jaxws.tubeline;

import com.sun.xml.ws.api.Component;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.pipe.ContinuationCloner;
import com.sun.xml.ws.api.pipe.Fiber;
import com.sun.xml.ws.api.pipe.NextAction;
import com.sun.xml.ws.api.pipe.Tube;
import com.sun.xml.ws.api.pipe.TubeCloner;
import com.sun.xml.ws.api.pipe.helper.AbstractTubeImpl;
import java.util.Map;
import weblogic.wsee.jaxws.tubeline.FlowControl;
import weblogic.wsee.jaxws.tubeline.FlowControlAware;
import weblogic.wsee.jaxws.tubeline.FlowControlProtected;

public class FlowControlTube
extends AbstractTubeImpl {
    private Tube inner;
    private boolean prot = false;

    public FlowControlTube(Tube tube) {
        this.inner = tube;
        this.prot = !(tube instanceof FlowControlAware) || tube.getClass().getAnnotation(FlowControlProtected.class) != null;
    }

    protected FlowControlTube(FlowControlTube flowControlTube, TubeCloner tubeCloner) {
        super((AbstractTubeImpl)flowControlTube, tubeCloner);
        if (tubeCloner instanceof ContinuationCloner) {
            ((ContinuationCloner)tubeCloner).setContinuationObserver(new ContinuationCloner.ContinuationObserver(){

                public Tube notify(Tube tube) {
                    return new FlowControlTube(tube);
                }
            });
        }
        this.inner = tubeCloner.copy(flowControlTube.inner);
        this.prot = flowControlTube.prot;
    }

    public FlowControlTube copy(TubeCloner tubeCloner) {
        return new FlowControlTube(this, tubeCloner);
    }

    public void preDestroy() {
        this.inner.preDestroy();
    }

    public NextAction processException(Throwable throwable) {
        FlowControlImpl flowControlImpl = this.initialize();
        if (!this.prot && flowControlImpl.isSkip) {
            return this.doThrow(throwable);
        }
        NextAction nextAction = this.inner.processException(throwable);
        Tube tube = nextAction.getNext();
        if (tube != null) {
            nextAction.setNext((Tube)new FlowControlTube(tube));
        }
        return nextAction;
    }

    public NextAction processRequest(Packet packet) {
        this.initialize();
        NextAction nextAction = this.inner.processRequest(packet);
        Tube tube = nextAction.getNext();
        if (tube != null) {
            nextAction.setNext((Tube)new FlowControlTube(tube));
        }
        return nextAction;
    }

    public NextAction processResponse(Packet packet) {
        FlowControlImpl flowControlImpl = this.initialize();
        if (!this.prot && flowControlImpl.isSkip) {
            return this.doReturnWith(packet);
        }
        NextAction nextAction = this.inner.processResponse(packet);
        Tube tube = nextAction.getNext();
        if (tube != null) {
            nextAction.setNext((Tube)new FlowControlTube(tube));
        }
        return nextAction;
    }

    public String toString() {
        return this.inner.toString();
    }

    private FlowControlImpl initialize() {
        Map map = Fiber.current().getComponentRegistry();
        FlowControlComponent flowControlComponent = (FlowControlComponent)map.get(FlowControlComponent.class);
        if (flowControlComponent == null) {
            flowControlComponent = new FlowControlComponent();
            map.put(FlowControlComponent.class, flowControlComponent);
        }
        return flowControlComponent.control;
    }

    private static class FlowControlImpl
    implements FlowControl {
        private boolean isSkip = false;

        private FlowControlImpl() {
        }

        public void doSkip() {
            this.isSkip = true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FlowControlComponent
    implements Component {
        private final FlowControlImpl control = new FlowControlImpl();

        private FlowControlComponent() {
        }

        public <T> T getSPI(Class<T> clazz) {
            if (clazz == FlowControl.class) {
                return clazz.cast(this.control);
            }
            return null;
        }
    }
}

