/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.jaxws.tubeline.standard;

import com.sun.xml.ws.api.Component;
import com.sun.xml.ws.api.WSBinding;
import com.sun.xml.ws.api.pipe.ClientTubeAssemblerContext;
import com.sun.xml.ws.api.pipe.ServerTubeAssemblerContext;
import com.sun.xml.ws.api.pipe.Tube;
import com.sun.xml.ws.util.pipe.StandaloneTubeAssembler;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;
import weblogic.jws.jaxws.client.async.AsyncClientHandlerFeature;
import weblogic.kernel.KernelStatus;
import weblogic.wsee.jaxws.ClientLateInitTube;
import weblogic.wsee.jaxws.MonitoringPipe;
import weblogic.wsee.jaxws.ServerLateInitTube;
import weblogic.wsee.jaxws.WLSContainer;
import weblogic.wsee.jaxws.client.async.HandlerInvokerTube;
import weblogic.wsee.jaxws.security.AuthorizationTube;
import weblogic.wsee.jaxws.tubeline.AbstractTubeFactory;
import weblogic.wsee.jaxws.tubeline.TubelineAssemblerItem;
import weblogic.wsee.jaxws.tubeline.TubelineDeploymentListener;
import weblogic.wsee.jaxws.tubeline.standard.WseeClientTube;
import weblogic.wsee.jaxws.tubeline.standard.WseeServerTube;
import weblogic.wsee.jaxws.workcontext.WorkContextClientTube;
import weblogic.wsee.jaxws.workcontext.WorkContextServerTube;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StandardTubelineDeploymentListener
implements TubelineDeploymentListener {
    private static final Logger LOGGER = Logger.getLogger(StandardTubelineDeploymentListener.class.getName());
    private static final boolean dump;

    @Override
    public void createClient(ClientTubeAssemblerContext clientTubeAssemblerContext, Set<TubelineAssemblerItem> set) {
        LOGGER.fine("Creating client tubeline items for " + clientTubeAssemblerContext.getService().getServiceName());
        set.add(new TubelineAssemblerItem("client", new AbstractTubeFactory(){

            public Tube createClient(Tube object, ClientTubeAssemblerContext clientTubeAssemblerContext) {
                object = new WseeClientTube(clientTubeAssemblerContext, (Tube)object);
                return object;
            }
        }, null, Collections.singleton("monitoring"), null));
        set.add(new TubelineAssemblerItem("async_handler", new AbstractTubeFactory(){

            public Tube createClient(Tube tube, ClientTubeAssemblerContext clientTubeAssemblerContext) {
                WSBinding wSBinding = clientTubeAssemblerContext.getBinding();
                AsyncClientHandlerFeature asyncClientHandlerFeature = (AsyncClientHandlerFeature)wSBinding.getFeature(AsyncClientHandlerFeature.class);
                if (asyncClientHandlerFeature != null) {
                    return new HandlerInvokerTube(tube, asyncClientHandlerFeature, wSBinding);
                }
                return tube;
            }
        }));
        set.add(new TubelineAssemblerItem("monitoring", new AbstractTubeFactory(){

            public Tube createClient(Tube tube, ClientTubeAssemblerContext clientTubeAssemblerContext) {
                if (KernelStatus.isServer()) {
                    return new MonitoringPipe(clientTubeAssemblerContext.getWsdlModel(), tube, clientTubeAssemblerContext.getBinding(), (Component)clientTubeAssemblerContext.getService(), true);
                }
                return tube;
            }
        }));
        set.add(new TubelineAssemblerItem("handler", new AbstractTubeFactory(){

            public Tube createClient(Tube tube, ClientTubeAssemblerContext clientTubeAssemblerContext) {
                return clientTubeAssemblerContext.createHandlerTube(tube);
            }
        }, null, Collections.singleton("async_handler"), null));
        set.add(new TubelineAssemblerItem("validation", new AbstractTubeFactory(){

            public Tube createClient(Tube tube, ClientTubeAssemblerContext clientTubeAssemblerContext) {
                return clientTubeAssemblerContext.createValidationTube(tube);
            }
        }, null, Collections.singleton("handler"), null));
        set.add(new TubelineAssemblerItem("workcontext", new AbstractTubeFactory(){

            public Tube createClient(Tube tube, ClientTubeAssemblerContext clientTubeAssemblerContext) {
                return new WorkContextClientTube(tube);
            }
        }, null, Collections.singleton("validation"), null));
        set.add(new TubelineAssemblerItem("mu", new AbstractTubeFactory(){

            public Tube createClient(Tube tube, ClientTubeAssemblerContext clientTubeAssemblerContext) {
                return clientTubeAssemblerContext.createClientMUTube(tube);
            }
        }, null, Collections.singleton("workcontext"), null));
        set.add(new TubelineAssemblerItem("ADDRESSING_HANDLER", new AbstractTubeFactory(){

            public Tube createClient(Tube tube, ClientTubeAssemblerContext clientTubeAssemblerContext) {
                return new ClientLateInitTube(tube, clientTubeAssemblerContext, new AbstractTubeFactory(){

                    public Tube createClient(Tube tube, ClientTubeAssemblerContext clientTubeAssemblerContext) {
                        return clientTubeAssemblerContext.createWsaTube(tube);
                    }
                });
            }
        }, Collections.singleton("PRE_WS_SECURITY_POLICY_1.2"), Collections.singleton("mu"), null));
        if (dump) {
            set.add(new TubelineAssemblerItem("dump", new AbstractTubeFactory(){

                public Tube createClient(Tube tube, ClientTubeAssemblerContext clientTubeAssemblerContext) {
                    return clientTubeAssemblerContext.createDumpTube("client", System.out, tube);
                }
            }, null, new HashSet<String>(Arrays.asList("ADDRESSING_HANDLER", "POST_WS_SECURITY_POLICY_1.2", "OWSM_SECURITY_POLICY_HANDLER")), null));
        }
    }

    @Override
    public void createServer(ServerTubeAssemblerContext serverTubeAssemblerContext, Set<TubelineAssemblerItem> set) {
        LOGGER.fine("Creating server tubeline items for service " + serverTubeAssemblerContext.getEndpoint().getServiceName() + " with ID " + serverTubeAssemblerContext.getEndpoint().getEndpointId());
        set.add(new TubelineAssemblerItem("WseeServer", new AbstractTubeFactory(){

            public Tube createServer(Tube tube, ServerTubeAssemblerContext serverTubeAssemblerContext) {
                return new WseeServerTube(serverTubeAssemblerContext, tube);
            }
        }));
        if (serverTubeAssemblerContext.getEndpoint().getContainer() instanceof WLSContainer) {
            set.add(new TubelineAssemblerItem("monitoring", new AbstractTubeFactory(){

                public Tube createServer(Tube tube, ServerTubeAssemblerContext serverTubeAssemblerContext) {
                    return new MonitoringPipe(serverTubeAssemblerContext.getEndpoint().getPort(), tube, serverTubeAssemblerContext.getEndpoint().getBinding(), (Component)serverTubeAssemblerContext.getEndpoint(), false);
                }
            }));
        }
        set.add(new TubelineAssemblerItem("ADDRESSING_HANDLER", new AbstractTubeFactory(){

            public Tube createServer(Tube tube, ServerTubeAssemblerContext serverTubeAssemblerContext) {
                return new ServerLateInitTube(tube, serverTubeAssemblerContext, new AbstractTubeFactory(){

                    public Tube createServer(Tube tube, ServerTubeAssemblerContext serverTubeAssemblerContext) {
                        return serverTubeAssemblerContext.createWsaTube(tube);
                    }
                });
            }
        }, Collections.singleton("PRE_WS_SECURITY_POLICY_1.2"), Collections.singleton("monitoring"), null));
        set.add(new TubelineAssemblerItem("mu", new AbstractTubeFactory(){

            public Tube createServer(Tube tube, ServerTubeAssemblerContext serverTubeAssemblerContext) {
                return new ServerLateInitTube(tube, serverTubeAssemblerContext, new AbstractTubeFactory(){

                    public Tube createServer(Tube tube, ServerTubeAssemblerContext serverTubeAssemblerContext) {
                        return serverTubeAssemblerContext.createServerMUTube(tube);
                    }
                });
            }
        }, new HashSet<String>(Arrays.asList("WS_SECURITY_1.1", "POST_WS_SECURITY_POLICY_1.2", "OWSM_SECURITY_POLICY_HANDLER")), new HashSet<String>(Arrays.asList("ADDRESSING_HANDLER", "PRE_WS_SECURITY_POLICY_1.2")), null));
        if (KernelStatus.isServer()) {
            set.add(new TubelineAssemblerItem("AUTHORIZATION_HANDLER", new AbstractTubeFactory(){

                public Tube createServer(Tube tube, ServerTubeAssemblerContext serverTubeAssemblerContext) {
                    return new AuthorizationTube(serverTubeAssemblerContext, tube);
                }
            }, null, new HashSet<String>(Arrays.asList("mu", "PRE_WS_SECURITY_POLICY_1.2", "WS_SECURITY_1.1", "POST_WS_SECURITY_POLICY_1.2", "OWSM_SECURITY_POLICY_HANDLER")), null));
        }
        set.add(new TubelineAssemblerItem("workcontext", new AbstractTubeFactory(){

            public Tube createServer(Tube tube, ServerTubeAssemblerContext serverTubeAssemblerContext) {
                return new WorkContextServerTube(tube);
            }
        }, null, new HashSet<String>(Arrays.asList("mu", "AUTHORIZATION_HANDLER")), null));
        set.add(new TubelineAssemblerItem("handler", new AbstractTubeFactory(){

            public Tube createServer(Tube tube, ServerTubeAssemblerContext serverTubeAssemblerContext) {
                return serverTubeAssemblerContext.createHandlerTube(tube);
            }
        }, null, Collections.singleton("workcontext"), null));
        set.add(new TubelineAssemblerItem("validation", new AbstractTubeFactory(){

            public Tube createServer(Tube tube, ServerTubeAssemblerContext serverTubeAssemblerContext) {
                return serverTubeAssemblerContext.createValidationTube(tube);
            }
        }, null, Collections.singleton("handler"), null));
    }

    static {
        boolean bl = false;
        try {
            bl = Boolean.getBoolean(StandaloneTubeAssembler.class.getName() + ".dump") || Boolean.getBoolean(StandardTubelineDeploymentListener.class.getName() + ".dump");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        dump = bl;
    }
}

