/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.jaxws.tubeline.standard;

import com.sun.istack.NotNull;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.pipe.ClientTubeAssemblerContext;
import com.sun.xml.ws.api.pipe.NextAction;
import com.sun.xml.ws.api.pipe.Tube;
import com.sun.xml.ws.api.pipe.TubeCloner;
import com.sun.xml.ws.api.pipe.helper.AbstractFilterTubeImpl;
import com.sun.xml.ws.api.pipe.helper.AbstractTubeImpl;
import java.util.logging.Level;
import java.util.logging.Logger;
import weblogic.jws.jaxws.client.ClientIdentityFeature;
import weblogic.wsee.jaxws.WLSContainer;
import weblogic.wsee.jaxws.spi.ClientIdentityRegistry;
import weblogic.wsee.jaxws.spi.ClientInstanceIdentityFeature;

public class WseeClientTube
extends AbstractFilterTubeImpl {
    private static final Logger LOGGER = Logger.getLogger(WseeClientTube.class.getName());
    private static boolean _loadedVerboseConfigOnce = false;
    private ClientIdentityFeature _feature;
    private ClientInstanceIdentityFeature _instanceIdFeature;
    private ClientTubeAssemblerContext _context;

    public WseeClientTube(ClientTubeAssemblerContext clientTubeAssemblerContext, Tube tube) {
        super(tube);
        if (!_loadedVerboseConfigOnce) {
            WLSContainer.setupLogging();
        }
        this._feature = (ClientIdentityFeature)clientTubeAssemblerContext.getBinding().getFeature(ClientIdentityFeature.class);
        this._instanceIdFeature = (ClientInstanceIdentityFeature)clientTubeAssemblerContext.getBinding().getFeature(ClientInstanceIdentityFeature.class);
        this._context = clientTubeAssemblerContext;
        this.register();
    }

    public WseeClientTube(WseeClientTube wseeClientTube, TubeCloner tubeCloner) {
        super((AbstractFilterTubeImpl)wseeClientTube, tubeCloner);
        this._feature = wseeClientTube._feature;
        this._instanceIdFeature = wseeClientTube._instanceIdFeature;
        this._context = wseeClientTube._context;
        this.register();
    }

    public AbstractTubeImpl copy(TubeCloner tubeCloner) {
        return new WseeClientTube(this, tubeCloner);
    }

    private void register() {
        ClientIdentityRegistry.addClientRuntimeMBean(this._feature, this._context);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("WseeClientTube " + (Object)((Object)this) + " set client instance id: " + (this._instanceIdFeature != null ? this._instanceIdFeature.getClientInstanceId() : null));
        }
    }

    public void preDestroy() {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Destroying WseeClientTube " + (Object)((Object)this) + " with client instance ID: " + (this._instanceIdFeature != null ? this._instanceIdFeature.getClientInstanceId() : null));
        }
        if (this._instanceIdFeature != null) {
            this._instanceIdFeature.dispose();
        }
        if (this.next != null) {
            this.next.preDestroy();
        }
    }

    @NotNull
    public NextAction processRequest(Packet packet) {
        return this.doInvoke(this.next, packet);
    }

    @NotNull
    public NextAction processResponse(Packet packet) {
        return this.doReturnWith(packet);
    }
}

