/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.jaxws.tubeline.standard;

import com.sun.istack.NotNull;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.pipe.NextAction;
import com.sun.xml.ws.api.pipe.ServerTubeAssemblerContext;
import com.sun.xml.ws.api.pipe.Tube;
import com.sun.xml.ws.api.pipe.TubeCloner;
import com.sun.xml.ws.api.pipe.helper.AbstractFilterTubeImpl;
import com.sun.xml.ws.api.pipe.helper.AbstractTubeImpl;
import com.sun.xml.ws.binding.WebServiceFeatureList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.ws.WebServiceFeature;
import weblogic.jws.jaxws.client.ClientIdentityFeature;
import weblogic.jws.jaxws.client.async.AsyncClientFeatureListFeature;
import weblogic.wsee.jaxws.WLSContainer;
import weblogic.wsee.jaxws.spi.ClientIdentityRegistry;

public class WseeServerTube
extends AbstractFilterTubeImpl {
    private static final Logger LOGGER = Logger.getLogger(WseeServerTube.class.getName());
    private static boolean _loadedVerboseConfigOnce = false;
    private ClientIdentityFeature _feature;
    private ServerTubeAssemblerContext _context;

    public WseeServerTube(ServerTubeAssemblerContext serverTubeAssemblerContext, Tube tube) {
        super(tube);
        ClientIdentityFeature clientIdentityFeature;
        if (!_loadedVerboseConfigOnce) {
            WLSContainer.setupLogging();
        }
        if ((clientIdentityFeature = (ClientIdentityFeature)serverTubeAssemblerContext.getEndpoint().getBinding().getFeature(ClientIdentityFeature.class)) == null) {
            String string;
            Object object;
            AsyncClientFeatureListFeature asyncClientFeatureListFeature = (AsyncClientFeatureListFeature)serverTubeAssemblerContext.getEndpoint().getBinding().getFeature(AsyncClientFeatureListFeature.class);
            if (asyncClientFeatureListFeature != null && (object = (ClientIdentityFeature)asyncClientFeatureListFeature.getClientFeatures().get(ClientIdentityFeature.class)) != null) {
                string = object.getRawClientId() + "-SystemClient";
                clientIdentityFeature = new ClientIdentityFeature();
                clientIdentityFeature.setClientId(string, true);
                ((WebServiceFeatureList)serverTubeAssemblerContext.getEndpoint().getBinding().getFeatures()).add((WebServiceFeature)clientIdentityFeature);
            }
            if (clientIdentityFeature == null) {
                object = serverTubeAssemblerContext.getEndpoint().getEndpointId();
                string = (String)object + "-SystemClient";
                clientIdentityFeature = new ClientIdentityFeature();
                clientIdentityFeature.setClientId(string, false);
                ((WebServiceFeatureList)serverTubeAssemblerContext.getEndpoint().getBinding().getFeatures()).add((WebServiceFeature)clientIdentityFeature);
            }
            clientIdentityFeature.setType(ClientIdentityFeature.Type.SYSTEM);
        }
        ClientIdentityRegistry.initClientInstanceIdentityFeature(serverTubeAssemblerContext);
        this._feature = clientIdentityFeature;
        this._context = serverTubeAssemblerContext;
        this.register();
    }

    public WseeServerTube(WseeServerTube wseeServerTube, TubeCloner tubeCloner) {
        super((AbstractFilterTubeImpl)wseeServerTube, tubeCloner);
        this._feature = wseeServerTube._feature;
        this._context = wseeServerTube._context;
        this.register();
    }

    public AbstractTubeImpl copy(TubeCloner tubeCloner) {
        return new WseeServerTube(this, tubeCloner);
    }

    private void register() {
        ClientIdentityRegistry.registerClientIdentity(this._feature);
        ClientIdentityRegistry.addClientRuntimeMBean(this._feature, this._context);
    }

    public void preDestroy() {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Destroying WseeServerTube with system client ID: " + (this._feature != null ? this._feature.getClientId() : null));
        }
        if (this._feature != null) {
            this._feature.dispose();
            this._feature = null;
        }
        if (this.next != null) {
            this.next.preDestroy();
        }
    }

    @NotNull
    public NextAction processRequest(Packet packet) {
        return this.doInvoke(this.next, packet);
    }

    @NotNull
    public NextAction processResponse(Packet packet) {
        return this.doReturnWith(packet);
    }
}

