/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.jws;

import com.bea.util.jam.JAnnotation;
import com.bea.util.jam.JClass;
import com.bea.util.jam.JElement;
import java.io.File;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jws.HandlerChain;
import javax.jws.soap.SOAPMessageHandlers;
import weblogic.j2ee.descriptor.EnvEntryBean;
import weblogic.j2ee.descriptor.PortComponentBean;
import weblogic.wsee.jws.HandlerException;
import weblogic.wsee.tools.jws.JwsLogEvent;
import weblogic.wsee.tools.logging.EventLevel;
import weblogic.wsee.util.JamUtil;
import weblogic.wsee.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class HandlerChainDecl<T> {
    private T[] handlerChains;
    protected Map<EventLevel, List<JwsLogEvent>> logEvents = new HashMap<EventLevel, List<JwsLogEvent>>();

    public HandlerChainDecl(JClass jClass, JClass jClass2, ClassLoader classLoader) {
        this.handlerChains = this.buildHandlerChains(jClass2, null);
        if (this.handlerChains == null && jClass != null && jClass != jClass2) {
            this.handlerChains = this.buildHandlerChains(jClass, classLoader);
        }
    }

    public HandlerChainDecl(JClass jClass, JClass jClass2) {
        this(jClass, jClass2, null);
    }

    private T[] buildHandlerChains(JClass jClass, ClassLoader classLoader) {
        T[] TArray = null;
        JAnnotation jAnnotation = jClass.getAnnotation(HandlerChain.class);
        if (jAnnotation != null) {
            URL uRL;
            String string = JamUtil.getAnnotationStringValue(jAnnotation, "file");
            String string2 = JamUtil.getAnnotationStringValue(jAnnotation, "name");
            if (!StringUtil.isEmpty(string) && (uRL = this.getURL(string, jClass, classLoader)) != null) {
                TArray = this.processHandlerChain(jClass, uRL, string2);
            }
        } else {
            JAnnotation jAnnotation2 = jClass.getAnnotation(SOAPMessageHandlers.class.getName());
            if (jAnnotation2 != null) {
                TArray = this.processSOAPMessageHandlers(jClass, jAnnotation2);
            }
        }
        return TArray;
    }

    public boolean isRelativeUrl(String string) {
        if (string.indexOf(58) > 0) {
            return false;
        }
        return !string.startsWith("/");
    }

    private URL getURL(String string, JClass jClass, ClassLoader classLoader) {
        URL uRL = null;
        try {
            uRL = this.isRelativeUrl(string) ? this.getAbsoluteURL(jClass, string, classLoader) : new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            this.addLogEvent(EventLevel.ERROR, new JwsLogEvent((JElement)jClass, "type.handlerChain.malformedUrl", uRL, malformedURLException.getMessage()));
        }
        return uRL;
    }

    private URL getAbsoluteURL(JClass jClass, String string, ClassLoader classLoader) throws MalformedURLException {
        URL uRL = null;
        if (jClass.getArtifact() instanceof Class) {
            Class clazz = (Class)jClass.getArtifact();
            uRL = clazz.getResource(string);
        } else {
            Serializable serializable;
            Object object;
            if (classLoader != null) {
                object = jClass.getQualifiedName();
                try {
                    serializable = classLoader.loadClass((String)object);
                    uRL = ((Class)serializable).getResource(string);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (uRL != null) {
                    return uRL;
                }
            }
            object = new File(jClass.getSourcePosition().getSourceURI());
            serializable = new File(((File)object).getParentFile(), string.trim());
            uRL = ((File)serializable).toURL();
        }
        return uRL;
    }

    protected abstract T[] processSOAPMessageHandlers(JClass var1, JAnnotation var2);

    protected abstract T[] processHandlerChain(JClass var1, URL var2, String var3);

    protected T[] getHandlerChains() {
        return this.handlerChains;
    }

    public Map<EventLevel, List<JwsLogEvent>> getLogEvents() {
        return this.logEvents;
    }

    protected void addLogEvent(EventLevel eventLevel, JwsLogEvent jwsLogEvent) {
        List<JwsLogEvent> list = this.logEvents.get((Object)eventLevel);
        if (list == null) {
            list = new ArrayList<JwsLogEvent>();
            this.logEvents.put(eventLevel, list);
        }
        list.add(jwsLogEvent);
    }

    public void populatePort(PortComponentBean portComponentBean) throws HandlerException {
        this.populatePort(portComponentBean, null);
    }

    public abstract void populatePort(PortComponentBean var1, EnvEntryBean[] var2) throws HandlerException;

    public abstract String[] getHandlerClassNames();
}

