/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.jws;

import java.io.ObjectStreamException;
import java.io.Serializable;
import weblogic.wsee.jws.ServiceHandleImpl;

public class Protocol
implements Serializable {
    public static final int ID_JAVA = 0;
    public static final int ID_HTTP_GET = 1;
    public static final int ID_HTTP_POST = 2;
    public static final int ID_HTTP_SOAP = 3;
    public static final int ID_HTTP_SOAP12 = 4;
    public static final int ID_HTTP_XML = 5;
    public static final int ID_JMS_SOAP = 6;
    public static final int ID_JMS_SOAP12 = 7;
    public static final int ID_JMS_XML = 8;
    public static final Protocol JAVA = new Protocol(0, "java-call");
    public static final Protocol HTTP_GET = new Protocol(1, "form-get");
    public static final Protocol HTTP_POST = new Protocol(2, "form-post");
    public static final Protocol HTTP_SOAP = new Protocol(3, "http-soap");
    public static final Protocol HTTP_SOAP12 = new Protocol(4, "http-soap12");
    public static final Protocol HTTP_XML = new Protocol(5, "http-xml");
    public static final Protocol JMS_SOAP = new Protocol(6, "jms-soap");
    public static final Protocol JMS_SOAP12 = new Protocol(7, "jms-soap12");
    public static final Protocol JMS_XML = new Protocol(8, "jms-xml");
    private static final Protocol[] _BINDINGS = new Protocol[]{JAVA, HTTP_GET, HTTP_POST, HTTP_SOAP, HTTP_SOAP12, HTTP_XML, JMS_SOAP, JMS_SOAP12, JMS_XML};
    public static final int SCHEME_JAVA = 0;
    public static final int SCHEME_HTTP = 1;
    public static final int SCHEME_JMS = 2;
    private static final int[] _SCHEMES = new int[]{0, 1, 1, 1, 1, 1, 2, 2, 2};
    private int _id;
    private transient String _name;
    static final long serialVersionUID = 1L;

    private Protocol(int n, String string) {
        this._id = n;
        this._name = string;
    }

    public int getID() {
        return this._id;
    }

    public String getName() {
        return this._name;
    }

    public static Protocol getProtocolByID(int n) {
        if (n < 0 || n >= _BINDINGS.length) {
            throw new IllegalArgumentException("Invalid protocol id");
        }
        return _BINDINGS[n];
    }

    public static Protocol getProtocolByName(String string) {
        for (int i = 0; i < _BINDINGS.length; ++i) {
            if (!_BINDINGS[i].getName().equals(string)) continue;
            return _BINDINGS[i];
        }
        throw new IllegalArgumentException("Invalid protocol name: " + string);
    }

    public static boolean isSoap(Protocol protocol) {
        return HTTP_SOAP == protocol || HTTP_SOAP12 == protocol || JMS_SOAP == protocol || JMS_SOAP12 == protocol;
    }

    public static boolean isSoap11(Protocol protocol) {
        return HTTP_SOAP == protocol || JMS_SOAP == protocol;
    }

    public static boolean isSoap12(Protocol protocol) {
        return HTTP_SOAP12 == protocol || JMS_SOAP12 == protocol;
    }

    public String toString() {
        return this._name;
    }

    public static int getSchemeForProtocol(Protocol protocol) {
        int n = protocol.getID();
        return _SCHEMES[n];
    }

    public static Protocol getProtocol(boolean bl, String string) {
        if (bl) {
            switch (ServiceHandleImpl.getScheme(string)) {
                case 1: {
                    return HTTP_SOAP12;
                }
                case 2: {
                    return JMS_SOAP12;
                }
            }
            return HTTP_SOAP12;
        }
        switch (ServiceHandleImpl.getScheme(string)) {
            case 1: {
                return HTTP_SOAP;
            }
            case 2: {
                return JMS_SOAP;
            }
        }
        return HTTP_SOAP;
    }

    private Object readResolve() throws ObjectStreamException {
        return _BINDINGS[this._id];
    }
}

