/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.jws;

import java.net.MalformedURLException;
import java.net.URL;
import weblogic.wsee.jws.ServiceHandle;

public class ServiceHandleImpl
implements ServiceHandle {
    static final long serialVersionUID = 2535609712500935143L;
    private final String _addr;
    private final String _uri;
    private final String _conversationID;
    private final String _contextPath;
    private String jndiName = null;
    private URL url = null;

    public ServiceHandleImpl(String string, String string2, String string3, String string4) {
        this._addr = string;
        this._contextPath = string2;
        this._uri = string3;
        this._conversationID = string4;
    }

    public int getScheme() {
        return ServiceHandleImpl.getScheme(this._addr.substring(0, this._addr.indexOf(58)));
    }

    public static int getScheme(String string) {
        if (string.equals("http")) {
            return 1;
        }
        if (string.equals("jms")) {
            return 2;
        }
        if (string.equals("smtp")) {
            return 3;
        }
        if (string.equals("ftp")) {
            return 4;
        }
        if (string.equals("file")) {
            return 5;
        }
        return 0;
    }

    public String getJNDIBaseName() {
        if (this.jndiName == null) {
            this.jndiName = ServiceHandleImpl.getJNDIBaseName(this.getURI());
        }
        return this.jndiName;
    }

    public String getURI() {
        return this._uri;
    }

    public String getContextURI() {
        return this._contextPath;
    }

    public URL getURL(int n) {
        try {
            return new URL(ServiceHandleImpl.scheme(n) + this._addr.substring(this._addr.indexOf(58)));
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
            return null;
        }
    }

    private static String scheme(int n) {
        switch (n) {
            case 0: 
            case 1: {
                return "http";
            }
            case 2: {
                return "jms";
            }
            case 5: {
                return "file";
            }
            case 3: {
                return "smtp";
            }
        }
        return null;
    }

    public URL getURL() {
        if (this.url == null) {
            try {
                this.url = new URL(this._addr);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return this.url;
    }

    public String getConversationID() {
        return this._conversationID;
    }

    public String getControlID() {
        return null;
    }

    private static String getJNDIBaseName(String string) {
        int n;
        StringBuffer stringBuffer = new StringBuffer(string);
        int n2 = stringBuffer.length();
        for (n = 0; n < n2; ++n) {
            char c = stringBuffer.charAt(n);
            if (c != '/' && c != '\\') continue;
            stringBuffer.setCharAt(n, '.');
        }
        n = string.lastIndexOf(46);
        if (n > 0) {
            return stringBuffer.substring(1, n);
        }
        if (stringBuffer.length() > 0) {
            return stringBuffer.substring(1);
        }
        return stringBuffer.toString();
    }
}

