/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.jws;

import com.bea.util.jam.JAnnotation;
import com.bea.util.jam.JClass;
import com.bea.util.jam.JMethod;
import com.bea.util.jam.internal.elements.UnresolvedClassImpl;
import java.net.URL;
import javax.xml.namespace.QName;
import javax.xml.ws.BindingType;
import javax.xml.ws.Provider;
import weblogic.jws.Conversation;
import weblogic.jws.Conversational;
import weblogic.wsee.WebServiceType;
import weblogic.wsee.jws.HandlerChainDecl;
import weblogic.wsee.jws.HandlerChainDeclFactory;
import weblogic.wsee.tools.jws.decl.WebServiceDecl;
import weblogic.wsee.util.ClassUtil;
import weblogic.wsee.util.JamUtil;
import weblogic.wsee.util.StringUtil;

public class WebServiceRuntimeDecl {
    protected final JClass sbClass;
    protected JClass eiClass;
    private final String name;
    protected final String serviceName;
    protected final WebServiceDecl parentWebServiceDecl;
    protected String targetNamespace = null;
    protected String wsdlLocation;
    private final String endPointInterface;
    private final String className;
    private final String simpleName;
    private final String packageName;
    private final QName portQName;
    private boolean conversational = false;
    protected String portTypeNamespaceURI = null;
    private final WebServiceType webServiceType;
    protected HandlerChainDecl handlerChainDecl;
    private String protocolBinding;
    private boolean mtomEnabled = false;
    private boolean providerBasedEndpoint = false;

    public WebServiceRuntimeDecl(WebServiceType webServiceType, Class clazz) {
        this(webServiceType, JamUtil.loadJClass(clazz.getName(), new DelegatingLoader(clazz.getClassLoader(), Thread.currentThread().getContextClassLoader())), null);
    }

    protected WebServiceRuntimeDecl(WebServiceType webServiceType, JClass jClass, WebServiceDecl webServiceDecl) {
        this(webServiceType, jClass, webServiceDecl, true);
    }

    protected WebServiceRuntimeDecl(WebServiceType webServiceType, JClass jClass, WebServiceDecl webServiceDecl, boolean bl) {
        this.webServiceType = webServiceType;
        this.eiClass = this.sbClass = jClass;
        this.parentWebServiceDecl = webServiceDecl;
        this.providerBasedEndpoint = WebServiceRuntimeDecl.isProviderBasedEndpoint(jClass);
        JAnnotation jAnnotation = ClassUtil.getWebServiceAnnotation(this.sbClass);
        this.endPointInterface = JamUtil.getAnnotationStringValue(jAnnotation, "endpointInterface");
        if (!StringUtil.isEmpty(this.endPointInterface)) {
            this.eiClass = this.sbClass.getClassLoader().loadClass(this.endPointInterface);
            if (this.eiClass instanceof UnresolvedClassImpl) {
                this.eiClass = this.sbClass;
            }
        }
        JAnnotation jAnnotation2 = ClassUtil.getWebServiceAnnotation(this.eiClass);
        this.className = this.sbClass.getQualifiedName();
        this.simpleName = StringUtil.getSimpleClassName(this.className);
        this.packageName = StringUtil.getPackage(this.className);
        this.name = this.getPortTypeName(jAnnotation2);
        this.initNamespaces(jAnnotation, jAnnotation2);
        this.serviceName = this.buildServiceName(this.sbClass, jAnnotation);
        this.wsdlLocation = JamUtil.getAnnotationStringValue(jAnnotation2, "wsdlLocation");
        if (this.wsdlLocation == null) {
            this.wsdlLocation = JamUtil.getAnnotationStringValue(jAnnotation, "wsdlLocation");
        }
        this.setConversationalFlag(this.sbClass);
        String string = this.buildPortName(jAnnotation);
        this.portQName = new QName(this.targetNamespace, string);
        if (bl) {
            this.handlerChainDecl = HandlerChainDeclFactory.newInstance(this.eiClass, this.sbClass, this.getType());
        }
        JAnnotation jAnnotation3 = this.sbClass.getAnnotation(BindingType.class);
        this.protocolBinding = JamUtil.getAnnotationStringValue(jAnnotation3, "value");
        if (StringUtil.isEmpty(this.protocolBinding)) {
            this.protocolBinding = "http://schemas.xmlsoap.org/wsdl/soap/http";
        }
        this.mtomEnabled = "http://schemas.xmlsoap.org/wsdl/soap/http?mtom=true".equals(this.protocolBinding) || "http://www.w3.org/2003/05/soap/bindings/HTTP/?mtom=true".equals(this.protocolBinding);
    }

    private static boolean isProviderBasedEndpoint(JClass jClass) {
        JClass jClass2 = jClass.forName(Provider.class.getName());
        return jClass2.isAssignableFrom(jClass);
    }

    private String buildServiceName(JClass jClass, JAnnotation jAnnotation) {
        String string = JamUtil.getAnnotationStringValue(jAnnotation, "serviceName");
        if (!StringUtil.isEmpty(string)) {
            return string;
        }
        if (this.getType() == WebServiceType.JAXWS) {
            return this.simpleName + "Service";
        }
        return ClassUtil.getServiceName(jClass, this.getParentServiceName());
    }

    private String buildPortName(JAnnotation jAnnotation) {
        String string = JamUtil.getAnnotationStringValue(jAnnotation, "portName");
        if (!StringUtil.isEmpty(string)) {
            return string;
        }
        if (this.getType() == WebServiceType.JAXWS) {
            String string2 = JamUtil.getAnnotationStringValue(jAnnotation, "name");
            if (!StringUtil.isEmpty(string2)) {
                return string2 + "Port";
            }
            if (StringUtil.isEmpty(this.endPointInterface)) {
                return this.getPortType().trim() + "Port";
            }
            return this.simpleName + "Port";
        }
        return this.getPortType().trim() + "SoapPort";
    }

    public HandlerChainDecl getHandlerChainDecl() {
        return this.handlerChainDecl;
    }

    public String getName() {
        return this.name;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public QName getServiceQName() {
        return new QName(this.targetNamespace, this.serviceName);
    }

    public String getEndPointInterface() {
        return this.endPointInterface;
    }

    public String getPortComponentName() {
        if (this.providerBasedEndpoint) {
            return this.getClassName();
        }
        if (StringUtil.isEmpty(this.endPointInterface)) {
            return this.getPortType();
        }
        return this.getSimpleName();
    }

    private void setConversationalFlag(JClass jClass) {
        this.conversational = jClass.getAnnotation(Conversational.class) != null;
        JMethod[] jMethodArray = jClass.getMethods();
        for (int i = 0; !this.conversational && i < jMethodArray.length; ++i) {
            this.conversational = jMethodArray[i].getAnnotation(Conversation.class) != null;
        }
    }

    public String getPortType() {
        return this.name;
    }

    public String getPortTypeNamespaceURI() {
        return this.portTypeNamespaceURI;
    }

    public String getTargetNamespace() {
        return this.targetNamespace;
    }

    public String getWsdlLocation() {
        return this.wsdlLocation;
    }

    public String getClassName() {
        return this.className;
    }

    public String getSimpleName() {
        return this.simpleName;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public QName getPortTypeQName() {
        return new QName(this.getPortTypeNamespaceURI(), this.getPortType());
    }

    public JClass getJClass() {
        return this.sbClass;
    }

    public JClass getEIClass() {
        return this.eiClass;
    }

    private String getParentServiceName() {
        return this.parentWebServiceDecl == null ? null : this.parentWebServiceDecl.getServiceQName().getLocalPart();
    }

    protected void initNamespaces(JAnnotation jAnnotation, JAnnotation jAnnotation2) {
        this.portTypeNamespaceURI = JamUtil.getAnnotationStringValue(jAnnotation2, "targetNamespace");
        this.targetNamespace = JamUtil.getAnnotationStringValue(jAnnotation, "targetNamespace");
        if (StringUtil.isEmpty(this.targetNamespace)) {
            this.targetNamespace = StringUtil.isEmpty(this.portTypeNamespaceURI) || this.getType() == WebServiceType.JAXWS ? ClassUtil.getNamespaceFromClass(this.webServiceType, this.eiClass) : this.portTypeNamespaceURI;
        }
        if (StringUtil.isEmpty(this.portTypeNamespaceURI)) {
            this.portTypeNamespaceURI = this.targetNamespace;
        }
    }

    public boolean isConversational() {
        return this.conversational;
    }

    public QName getPortQName() {
        return this.portQName;
    }

    public String getPortName() {
        return this.portQName.getLocalPart();
    }

    public String getProtocolBinding() {
        return this.protocolBinding;
    }

    public boolean isMtomEnabled() {
        return this.mtomEnabled;
    }

    private String getPortTypeName(JAnnotation jAnnotation) {
        String string = JamUtil.getAnnotationStringValue(jAnnotation, "name");
        if (StringUtil.isEmpty(string)) {
            string = ClassUtil.getDefaultName(this.eiClass, this.getParentServiceName());
        }
        return ClassUtil.normalizeClassName(string);
    }

    public WebServiceType getType() {
        return this.webServiceType;
    }

    private static final class DelegatingLoader
    extends ClassLoader {
        private final ClassLoader loader;

        DelegatingLoader(ClassLoader classLoader, ClassLoader classLoader2) {
            super(classLoader2);
            this.loader = classLoader;
        }

        protected Class findClass(String string) throws ClassNotFoundException {
            return this.loader.loadClass(string);
        }

        protected URL findResource(String string) {
            return this.loader.getResource(string);
        }
    }
}

