/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.jws.container;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.security.Principal;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.rpc.ServiceException;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.rpc.server.ServiceLifecycle;
import javax.xml.rpc.server.ServletEndpointContext;
import org.w3c.dom.Element;
import weblogic.jws.Callback;
import weblogic.jws.Context;
import weblogic.jws.ServiceClient;
import weblogic.utils.collections.WeakConcurrentHashMap;
import weblogic.wsee.conversation.ConversationUtils;
import weblogic.wsee.jws.JwsContext;
import weblogic.wsee.jws.Protocol;
import weblogic.wsee.jws.ServiceHandle;
import weblogic.wsee.jws.ServiceHandleImpl;
import weblogic.wsee.jws.container.CallbackEventListener;
import weblogic.wsee.jws.container.CompositeListener;
import weblogic.wsee.jws.container.ContainerListener;
import weblogic.wsee.jws.container.ContainerMarker;
import weblogic.wsee.jws.container.ContextEventListener;
import weblogic.wsee.jws.container.FieldHelper;
import weblogic.wsee.jws.container.InvokeException;
import weblogic.wsee.jws.container.JwsInitializer;
import weblogic.wsee.jws.context.JwsSecurityContext;
import weblogic.wsee.jws.context.WebSecurityContext;
import weblogic.wsee.jws.util.ApplicationLogger;
import weblogic.wsee.jws.util.Logger;
import weblogic.wsee.message.FilteredMessageContext;
import weblogic.wsee.message.WlMessageContext;
import weblogic.wsee.message.soap.SoapMessageContext;
import weblogic.wsee.util.ControlAPIUtil;
import weblogic.wsee.util.HeaderUtil;
import weblogic.wsee.util.Verbose;
import weblogic.wsee.ws.WsPort;
import weblogic.wsee.ws.dispatch.server.ServletEndpointContextImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Container
implements JwsContext,
ContainerMarker {
    private static final long serialVersionUID = 557998558456986952L;
    private static final String CONTROL_ANNOTATION = "org.apache.beehive.controls.api.bean.Control";
    private static final String CONTEXT_ANNOTATION = "weblogic.controls.jws.Common.Context";
    private static Set<String> complexAnnotationSet = null;
    private static Map<Class, WeakReference<Class>> controlClientInitClassCache = new WeakConcurrentHashMap();
    private static final String UNDERSTOOD_HEADERS = "weblogic.wsee.addressing.UnderstoodHeaders";
    private Object _targetJWS;
    private CompositeListener listeners = new CompositeListener();
    transient WlMessageContext messageContext = null;
    private transient JwsSecurityContext jwsSecurityContext = null;
    private boolean _understoodInputHeaders = false;
    private Map<String, Object> properties = new HashMap<String, Object>();
    private transient ServiceHandleImpl serviceHandle = null;
    private static final boolean verbose;

    protected Container(Object object, WlMessageContext wlMessageContext) {
        this.setMessageContext(wlMessageContext);
        this.init(object);
    }

    @Override
    public void setMessageContext(WlMessageContext wlMessageContext) {
        this.messageContext = wlMessageContext;
        wlMessageContext.setProperty("weblogic.wsee.jws.container", this);
    }

    public void setServletContext(ServletEndpointContext servletEndpointContext) {
        if (this._targetJWS instanceof ServiceLifecycle) {
            ServiceLifecycle serviceLifecycle = (ServiceLifecycle)this._targetJWS;
            try {
                serviceLifecycle.init((Object)servletEndpointContext);
            }
            catch (ServiceException serviceException) {
                if (verbose) {
                    Verbose.logException(serviceException);
                }
                throw new InvokeException(serviceException.getMessage(), serviceException);
            }
            if (servletEndpointContext != null) {
                ServletEndpointContextImpl servletEndpointContextImpl = (ServletEndpointContextImpl)servletEndpointContext;
                servletEndpointContextImpl.setMessageContext(this.messageContext);
                servletEndpointContextImpl.setSecurityContext((WebSecurityContext)this.getSecurityContext());
            }
        }
    }

    private void init(Object object) {
        try {
            this._targetJWS = object;
            this.registerListeners();
            JwsInitializer jwsInitializer = new JwsInitializer(this._targetJWS, this.messageContext, this);
            jwsInitializer.initialize();
            this.initializeContextFields();
            this.listeners.onCreate();
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new InvokeException("Unable to Load JWS", invocationTargetException.getTargetException());
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new InvokeException("Unable to Load JWS", exception);
        }
    }

    private static Field[] getAllVisibleFieldsInClass(Class clazz) {
        if (clazz == null) {
            return new Field[0];
        }
        Field[] fieldArray = clazz.getDeclaredFields();
        Class clazz2 = clazz.getSuperclass();
        if (clazz2 == null) {
            return fieldArray;
        }
        HashSet<Field> hashSet = new HashSet<Field>();
        for (Field field : fieldArray) {
            hashSet.add(field);
        }
        Field[] fieldArray2 = null;
        while (clazz2 != null) {
            for (Field field : fieldArray2 = clazz2.getDeclaredFields()) {
                if (!Modifier.isProtected(field.getModifiers()) && !Modifier.isPublic(field.getModifiers())) continue;
                hashSet.add(field);
            }
            clazz2 = clazz2.getSuperclass();
        }
        return hashSet.toArray(new Field[hashSet.size()]);
    }

    private void initializeContextFields() {
        for (Field field : Container.getAllVisibleFieldsInClass(this._targetJWS.getClass())) {
            if (!FieldHelper.isContext(field)) continue;
            FieldHelper.setFieldValue(field, this._targetJWS, this);
        }
    }

    private ContainerListener getControlListener() throws Exception {
        if (this.getControlClientInitClass() != null) {
            Class<?> clazz = this.getContextClassLoader().loadClass("weblogic.controls.jws.ControlListener");
            Constructor<?> constructor = clazz.getConstructor(Container.class);
            return (ContainerListener)constructor.newInstance(this);
        }
        return null;
    }

    private Class getControlClientInitClass() throws Exception {
        Class<?> clazz = null;
        Class<?> clazz2 = this._targetJWS.getClass();
        try {
            WeakReference<Class> weakReference = controlClientInitClassCache.get(clazz2);
            if (weakReference != null && (clazz = (Class<?>)weakReference.get()) != null) {
                return clazz != Void.class ? clazz : null;
            }
            String string = clazz2.getName() + "ClientInitializer";
            clazz = clazz2.getClassLoader().loadClass(string);
            controlClientInitClassCache.put(clazz2, new WeakReference(clazz != null ? clazz : Void.class));
        }
        catch (ClassNotFoundException classNotFoundException) {
            controlClientInitClassCache.put(clazz2, new WeakReference<Class<Void>>(Void.class));
        }
        return clazz;
    }

    private ContainerListener getContextCallbackListener() {
        if (this._targetJWS instanceof JwsContext.Callback) {
            return new CallbackEventListener((JwsContext.Callback)this._targetJWS);
        }
        return null;
    }

    private void registerListeners() throws Exception {
        ContainerListener containerListener;
        ContainerListener containerListener2 = this.getControlListener();
        if (containerListener2 != null) {
            this.listeners.addListener(containerListener2);
        }
        if ((containerListener = this.getContextCallbackListener()) != null) {
            this.listeners.addListener(containerListener);
        }
        for (Field field : Container.getAllVisibleFieldsInClass(this._targetJWS.getClass())) {
            if (!FieldHelper.isContext(field)) continue;
            this.listeners.addListener(new ContextEventListener(field.getName(), this._targetJWS));
        }
    }

    private void failNotConversational(String string) throws IllegalStateException {
        throw new IllegalStateException(string + "\nOperation requires a conversational service.");
    }

    @Override
    public MessageContext getMessageContext() {
        return new FilteredMessageContext(this.messageContext);
    }

    @Override
    public WlMessageContext getUnfilteredMessageContext() {
        return this.messageContext;
    }

    @Override
    public Element[] getInputHeaders() {
        MessageContext messageContext = (MessageContext)this.messageContext.getProperty("weblogic.wsee.local.transport.prior.context");
        if (messageContext != null) {
            return ControlAPIUtil.getInputHeaders(messageContext);
        }
        return ControlAPIUtil.getInputHeaders(this.messageContext);
    }

    @Override
    public void setUnderstoodInputHeaders(boolean bl) {
        this._understoodInputHeaders = bl;
        this.messageContext.setProperty(UNDERSTOOD_HEADERS, new Boolean(this._understoodInputHeaders));
        if (!bl) {
            HeaderUtil.throwMustUnderstand(this.messageContext);
        }
    }

    @Override
    public boolean getUnderstoodInputHeaders() {
        return this._understoodInputHeaders;
    }

    @Override
    public void setOutputHeaders(Element[] elementArray) {
        MessageContext messageContext = (MessageContext)this.messageContext.getProperty("weblogic.wsee.local.transport.prior.context");
        if (messageContext != null) {
            ControlAPIUtil.setOutputHeaders(messageContext, elementArray);
        } else {
            ControlAPIUtil.setOutputHeaders(this.messageContext, elementArray);
        }
    }

    @Override
    public Protocol getProtocol() {
        String string = this.getEndpointAddress();
        String string2 = "jms";
        int n = string.indexOf(58);
        if (n > 0) {
            string2 = string.substring(0, n);
        }
        boolean bl = false;
        if (this.messageContext instanceof SoapMessageContext) {
            bl = ((SoapMessageContext)this.messageContext).isSoap12();
        }
        return Protocol.getProtocol(bl, string2);
    }

    @Override
    public boolean isFinished() {
        return false;
    }

    @Override
    public void finishConversation() {
        this.failNotConversational("Cannot finish conversation.");
    }

    @Override
    public void setMaxAge(Date date) throws IllegalStateException, IllegalArgumentException {
        this.failNotConversational("Cannot set maximum age.");
    }

    @Override
    public void setMaxAge(String string) throws IllegalStateException, IllegalArgumentException {
        this.failNotConversational("Cannot set maximum age.");
    }

    @Override
    public long getMaxAge() throws IllegalStateException {
        return 0L;
    }

    @Override
    public long getCurrentAge() throws IllegalStateException {
        return 0L;
    }

    @Override
    public void resetIdleTime() throws IllegalStateException {
        this.failNotConversational("Cannot reset idle time.");
    }

    @Override
    public void setMaxIdleTime(long l) throws IllegalStateException, IllegalArgumentException {
        this.failNotConversational("Cannot set maxium idle time.");
    }

    @Override
    public void setMaxIdleTime(String string) throws IllegalStateException, IllegalArgumentException {
        this.failNotConversational("Cannot set maxium idle time.");
    }

    @Override
    public long getMaxIdleTime() throws IllegalStateException {
        return 0L;
    }

    @Override
    public long getCurrentIdleTime() throws IllegalStateException {
        return 0L;
    }

    @Override
    public Principal getCallerPrincipal() {
        return this.getSecurityContext().getCallerPrincipal();
    }

    @Override
    public boolean isCallerInRole(String string) {
        return this.getSecurityContext().isCallerInRole(string);
    }

    @Override
    public ServiceHandle getService() {
        if (this.serviceHandle == null) {
            this.serviceHandle = new ServiceHandleImpl(this.getEndpointAddress(), this.getContextPath(), this.getURI(), null);
        }
        return this.serviceHandle;
    }

    @Override
    public Logger getLogger(String string) {
        return new ApplicationLogger(string);
    }

    private ClassLoader getContextClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeUTF("9.0");
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        String string = objectInputStream.readUTF();
        if (!string.equals("9.0")) {
            throw new IOException("Wrong version, expected: 9.0 actual: " + string);
        }
        objectInputStream.defaultReadObject();
    }

    CompositeListener getListeners() {
        return this.listeners;
    }

    String getEndpointAddress() {
        return (String)this.messageContext.getProperty("weblogic.wsee.connection.end_point_address");
    }

    String getContextPath() {
        return (String)this.messageContext.getProperty("weblogic.wsee.context_path");
    }

    String getURI() {
        String string = ControlAPIUtil.getURI(this.messageContext);
        if (string != null) {
            return string;
        }
        return this.messageContext.getDispatcher().getConnection().getTransport().getServiceURI();
    }

    public static boolean isContainerRequired(WsPort wsPort) {
        return Container.isComplexFieldsPresent(wsPort.getEndpoint().getJwsClass()) || ConversationUtils.isConversational(wsPort);
    }

    private static boolean isComplexFieldsPresent(Class clazz) {
        Field[] fieldArray;
        for (Field field : fieldArray = Container.getAllVisibleFieldsInClass(clazz)) {
            Annotation[] annotationArray;
            field.setAccessible(true);
            for (Annotation annotation : annotationArray = field.getAnnotations()) {
                if (!complexAnnotationSet.contains(annotation.annotationType().getName())) continue;
                return true;
            }
        }
        return false;
    }

    public <V extends Serializable> V setProperty(String string, V v) {
        return (V)((Serializable)this.properties.put(string, v));
    }

    public <V extends Serializable> V getProperty(String string) {
        return (V)((Serializable)this.properties.get(string));
    }

    public <V extends Serializable> V removeProperty(String string) {
        return (V)((Serializable)this.properties.remove(string));
    }

    @Override
    public Object getTargetJWS() {
        return this._targetJWS;
    }

    private JwsSecurityContext getSecurityContext() {
        if (this.jwsSecurityContext == null) {
            this.jwsSecurityContext = new WebSecurityContext(this.messageContext, this._targetJWS.getClass());
        }
        return this.jwsSecurityContext;
    }

    @Override
    public void destroy() {
        if (ServiceLifecycle.class.isInstance(this._targetJWS)) {
            ServiceLifecycle serviceLifecycle = (ServiceLifecycle)this._targetJWS;
            serviceLifecycle.destroy();
        }
    }

    @Override
    public String getId() {
        return null;
    }

    static {
        complexAnnotationSet = new HashSet<String>();
        complexAnnotationSet.add(CONTEXT_ANNOTATION);
        complexAnnotationSet.add(CONTROL_ANNOTATION);
        complexAnnotationSet.add(Context.class.getName());
        complexAnnotationSet.add(Callback.class.getName());
        complexAnnotationSet.add(ServiceClient.class.getName());
        verbose = Verbose.isVerbose(Container.class);
    }
}

