/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.jws.container;

import java.util.HashMap;
import java.util.Iterator;
import javax.xml.rpc.handler.HandlerInfo;
import weblogic.wsee.handler.HandlerException;
import weblogic.wsee.jws.container.Container;
import weblogic.wsee.jws.container.ContainerHandler;
import weblogic.wsee.util.Verbose;
import weblogic.wsee.ws.WsPort;
import weblogic.wsee.ws.init.WsDeploymentContext;
import weblogic.wsee.ws.init.WsDeploymentException;
import weblogic.wsee.ws.init.WsDeploymentListener;

public class ContainerDeploymentListener
implements WsDeploymentListener {
    private static final boolean verbose = Verbose.isVerbose(ContainerDeploymentListener.class);

    public void process(WsDeploymentContext wsDeploymentContext) throws WsDeploymentException {
        if (verbose) {
            Verbose.log("ContainerDeploymentListener firing");
        }
        Iterator<WsPort> iterator = wsDeploymentContext.getWsService().getPorts();
        while (iterator.hasNext()) {
            WsPort wsPort = iterator.next();
            if (!Container.isContainerRequired(wsPort)) continue;
            if (verbose) {
                Verbose.log("Adding " + this.getClass().getName() + " for " + wsDeploymentContext.getServiceURIs()[0]);
            }
            try {
                HandlerInfo handlerInfo = new HandlerInfo(ContainerHandler.class, new HashMap(), null);
                wsPort.getInternalHandlerList().insert("CONTAINER_HANDLER", wsPort.getInternalHandlerList().size() - 1, handlerInfo);
            }
            catch (HandlerException handlerException) {
                throw new WsDeploymentException("Unable to register handler", handlerException);
            }
        }
    }
}

